/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.api;

import android.content.Context;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.NetworkUtils;
import com.google.gson.Gson;
import java.io.IOException;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class ListCallback<T extends BaseObj>
implements Callback<T> {
    public static final String TAG = ListCallback.class.getSimpleName();

    public void onResponse(Call<T> call, Response<T> response) {
        if (!response.isSuccessful() && response.errorBody() != null) {
            String errorMessage = null;
            try {
                Gson gson = new Gson();
                errorMessage = response.errorBody().string();
                BaseObj apiErrorObj = (BaseObj)gson.fromJson(errorMessage, BaseObj.class);
                apiErrorObj.setStatus(response.code());
                this.onError(call, apiErrorObj);
            }
            catch (IOException e) {
                BaseObj apiErrorObj = new BaseObj();
                apiErrorObj.setStatus(response.code());
                this.onError(call, apiErrorObj);
                e.printStackTrace();
            }
            catch (Exception e) {
                BaseObj apiErrorObj = new BaseObj();
                apiErrorObj.setStatus(response.code());
                if (response.code() >= 500) {
                    BaseObj.createError("server error", "unexpected error from server");
                    this.onError(call, apiErrorObj);
                } else {
                    BaseObj.createError("server error", apiErrorObj.getStatus() + "=> " + errorMessage);
                    this.onError(call, apiErrorObj);
                }
                e.printStackTrace();
            }
            return;
        }
        BaseObj t = (BaseObj)response.body();
        if (t == null) {
            BaseObj apiErrorObj = new BaseObj();
            apiErrorObj.setStatus(response.code());
            BaseObj.createError("null", "No data");
            this.onError(call, apiErrorObj);
            return;
        }
        LogUtils.d(TAG, "response : " + response.body());
        this.onSuccess(call, response);
    }

    public void onFailure(Call<T> call, Throwable t) {
        if (!NetworkUtils.isConnect((Context)GameSdk.getInstance().getApplication())) {
            BaseObj apiErrorObj = BaseObj.createError("", "No Connect");
            apiErrorObj.setStatus(-100);
            this.onError(call, apiErrorObj);
        } else {
            BaseObj apiErrorObj = BaseObj.createError("", t.getMessage());
            this.onError(call, apiErrorObj);
        }
    }

    public abstract void onSuccess(Call<T> var1, Response<T> var2);

    public abstract void onError(Call<T> var1, Object var2);
}

