/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.view.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.game.sdk.comon.game.GameSdk;
import com.mobgame.R;
import com.mobgame.model.ItemMenuDashboard;
import java.util.List;

public class DashboardMenuAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final String TAG = DashboardMenuAdapter.class.getSimpleName();
    private List<ItemMenuDashboard> listItemMenuDashboard;
    private Context activity;
    private boolean isLandscape;
    private boolean isTabletSize;

    public DashboardMenuAdapter(List<ItemMenuDashboard> listItemMenuDashboards, @NonNull Context activity, boolean isLandscape, boolean isTabletSize) {
        this.listItemMenuDashboard = listItemMenuDashboards;
        this.activity = activity;
        this.isLandscape = isLandscape;
        this.isTabletSize = isTabletSize;
        if (this.activity == null) {
            this.activity = GameSdk.getInstance().getApplication();
        }
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = null;
        itemView = this.isTabletSize ? LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_menu_dashboard_tablet, parent, false) : LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_menu_dashboard, parent, false);
        return new ViewHolder(itemView);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        ItemMenuDashboard itemMenuDashboard = this.listItemMenuDashboard.get(position);
        if (this.isLandscape || this.isTabletSize) {
            holder.tvTitle.setVisibility(0);
        } else {
            holder.tvTitle.setVisibility(8);
        }
        if (itemMenuDashboard.isClick()) {
            holder.tvTitle.setTextColor(this.activity.getResources().getColor(R.color.active_text));
            Glide.with((Context)this.activity).load(itemMenuDashboard.getUrlIconActive()).into((ImageView)holder.btnImageCenter);
        } else {
            holder.tvTitle.setTextColor(this.activity.getResources().getColor(R.color.deactive_text));
            Glide.with((Context)this.activity).load(itemMenuDashboard.getUrlIcon()).into((ImageView)holder.btnImageCenter);
        }
        holder.tvTitle.setText((CharSequence)itemMenuDashboard.getTitle_menu());
        if (itemMenuDashboard.isHasNtf()) {
            holder.hasNotiView.setVisibility(0);
        } else {
            holder.hasNotiView.setVisibility(8);
        }
    }

    public int getItemCount() {
        return this.listItemMenuDashboard.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageButton btnImageCenter;
        private TextView tvTitle;
        private View hasNotiView;

        public ViewHolder(View itemView) {
            super(itemView);
            this.btnImageCenter = (ImageButton)itemView.findViewById(R.id.btn_image_center);
            this.tvTitle = (TextView)itemView.findViewById(R.id.tv_title);
            this.hasNotiView = itemView.findViewById(R.id.ic_ntf);
        }
    }
}

