/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.ui.login;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.request.RequestOptions;
import com.facebook.FacebookException;
import com.facebook.login.LoginResult;
import com.game.sdk.comon.api.ApiUtils;
import com.game.sdk.comon.api.RetrofitClient;
import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.constants.Constants;
import com.game.sdk.comon.game.BaseDialogFragment;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.listener.IAuthentFBListener;
import com.game.sdk.comon.listener.IAuthentGoogleListener;
import com.game.sdk.comon.listener.ILoginListener;
import com.game.sdk.comon.login.FacebookManager;
import com.game.sdk.comon.login.GoogleManager;
import com.game.sdk.comon.object.AuthenConfigObj;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.UserObj;
import com.game.sdk.comon.object.err.AuthenConfigErrObj;
import com.game.sdk.comon.object.err.LoginEmailErrObj;
import com.game.sdk.comon.object.err.LoginFacebookErrObj;
import com.game.sdk.comon.object.err.LoginGGErrObj;
import com.game.sdk.comon.object.err.LoginPlayNowErrObj;
import com.game.sdk.comon.object.err.SdkConfigErrObj;
import com.game.sdk.comon.object.response.AuthenConfigResponseObj;
import com.game.sdk.comon.object.response.LoginByRegisterObj;
import com.game.sdk.comon.object.response.LoginEmailResponseObj;
import com.game.sdk.comon.object.response.LoginFacebookResponseObj;
import com.game.sdk.comon.object.response.LoginGoogleResponseObj;
import com.game.sdk.comon.object.response.LoginPlayNowResponseObj;
import com.game.sdk.comon.object.response.SdkConfigResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.tracking.TrackingUtil;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.DialogUtils;
import com.game.sdk.comon.utils.KeyboardHeightObserver;
import com.game.sdk.comon.utils.KeyboardHeightProvider;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.NetworkUtils;
import com.game.sdk.comon.utils.StringUtils;
import com.game.sdk.ui.login.ILoginPresenter;
import com.game.sdk.ui.login.LoginPresenterImpl;
import com.game.sdk.ui.login.term.TermDialogFragment;
import com.game.sdk.ui.register.RegistryFragmentV2;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.material.textfield.TextInputEditText;
import com.mobgame.MobGameSDK;
import com.mobgame.R;

public class AccountFragment
extends BaseDialogFragment
implements View.OnClickListener,
BaseView,
IAuthentFBListener,
IAuthentGoogleListener,
KeyboardHeightObserver {
    LinearLayout btnFaceBook;
    LinearLayout btnPlayNow;
    LinearLayout btnGoogle;
    TextInputEditText edtLoginPassword;
    TextInputEditText edtLoginAccount;
    ImageButton btnClose;
    TextView btnLogin;
    TextView tvTerm;
    TextView tvPlayTimeNoti;
    TextView tvRegister;
    ImageView iv18Plus;
    ILoginPresenter loginPresenter;
    LinearLayout termContent;
    LinearLayout leftContent;
    LinearLayout rightContent;
    LinearLayout contentIv18;
    ILoginListener listener;
    TextView tvErrUser;
    TextView tvErrPass;
    TextView tvForgotPass;
    TextView tvHeaderLoginSocial;
    Handler mHandler;
    Runnable mRunable;
    Constants.RTF_STATUS status;
    LinearLayout layoutKeyboardSpace;
    private KeyboardHeightProvider keyboardProvider;
    int errEmailCount;
    CardView contentPanel;
    DialogFragment newFragment;
    ILoginListener registerListener = new ILoginListener(){

        @Override
        public void onLoginSuccess() {
        }

        @Override
        public void onRegisterSuccess(String param) {
            AccountFragment.this.newFragment.dismiss();
            AccountFragment.this.newFragment = null;
            try {
                LoginByRegisterObj obj = LoginByRegisterObj.parse(param);
                obj.getData().setLoginType("Email");
                obj.getData().setLoginOrRegister(obj.getIsRegister());
                AccountFragment.this.onLoginSuccess(obj.getData(), obj.getAccessToken());
                AccountFragment.this.loginPresenter.getSdkConfig();
                if (AccountFragment.this.listener != null) {
                    AccountFragment.this.listener.onRegisterSuccess(param);
                }
            }
            catch (Exception e) {
                DialogUtils.showErrorDialog(AccountFragment.this.mActivity, AccountFragment.this.getString(R.string.err_422));
            }
        }
    };
    private BroadcastReceiver networkChangeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (AuthenConfigs.getInstance().getAuthenConfigObj() == null) {
                AccountFragment.this.loginPresenter.getAuthenConfig();
            }
        }
    };

    public static AccountFragment newInstance(ILoginListener listener) {
        AccountFragment frag = new AccountFragment();
        frag.setListener(listener);
        Bundle bulde = new Bundle();
        frag.setArguments(bulde);
        return frag;
    }

    public void onStart() {
        super.onStart();
        Dialog d = this.getDialog();
        if (d != null) {
            int width = -1;
            int height = -1;
            d.getWindow().setLayout(width, height);
        }
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.fragment_account_container;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
    }

    public void onPause() {
        super.onPause();
        this.keyboardProvider.setKeyboardHeightObserver(null);
        this.mActivity.unregisterReceiver(this.networkChangeReceiver);
    }

    @Override
    public void onResume() {
        super.onResume();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mActivity.registerReceiver(this.networkChangeReceiver, intentFilter);
        this.getDialog().getWindow().clearFlags(8);
        this.loginPresenter.getAuthenConfig();
        this.keyboardProvider.setKeyboardHeightObserver(this);
    }

    public void onDetach() {
        super.onDetach();
        this.keyboardProvider.close();
    }

    public void initView(View v) {
        this.mHandler = new Handler();
        this.loginPresenter = new LoginPresenterImpl(this);
        this.iv18Plus = (ImageView)v.findViewById(R.id.iv18Plus);
        this.layoutKeyboardSpace = (LinearLayout)v.findViewById(R.id.layout_keyboard_space);
        this.edtLoginAccount = (TextInputEditText)v.findViewById(R.id.edtLoginAccount);
        this.edtLoginPassword = (TextInputEditText)v.findViewById(R.id.edtLoginPassword);
        this.tvTerm = (TextView)v.findViewById(R.id.tvTerm);
        this.tvPlayTimeNoti = (TextView)v.findViewById(R.id.tvPlayTimeNoti);
        this.rightContent = (LinearLayout)v.findViewById(R.id.rightContent);
        this.leftContent = (LinearLayout)v.findViewById(R.id.leftContent);
        this.termContent = (LinearLayout)v.findViewById(R.id.termContent);
        this.contentIv18 = (LinearLayout)v.findViewById(R.id.contentIv18);
        this.btnFaceBook = (LinearLayout)v.findViewById(R.id.btnFacebook);
        this.btnGoogle = (LinearLayout)v.findViewById(R.id.btnGoogle);
        this.btnLogin = (TextView)v.findViewById(R.id.btnLogin);
        this.tvRegister = (TextView)v.findViewById(R.id.tvRegister);
        this.btnPlayNow = (LinearLayout)v.findViewById(R.id.btnPlayNow);
        this.btnClose = (ImageButton)v.findViewById(R.id.btnClose);
        this.tvErrUser = (TextView)v.findViewById(R.id.tvErrUser);
        this.tvErrPass = (TextView)v.findViewById(R.id.tvErrPass);
        this.tvForgotPass = (TextView)v.findViewById(R.id.tvForgotPass);
        this.tvHeaderLoginSocial = (TextView)v.findViewById(R.id.tvHeaderLoginSocial);
        this.contentPanel = (CardView)v.findViewById(R.id.contentPanel);
        this.tvTerm.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.lbl_term)));
        this.edtLoginAccount.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                AccountFragment.this.edtLoginAccount.setBackground(AccountFragment.this.mActivity.getResources().getDrawable(R.drawable.slt_input_text_login_land));
                AccountFragment.this.tvErrUser.setVisibility(8);
            }
        });
        this.edtLoginPassword.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                AccountFragment.this.edtLoginPassword.setBackground(AccountFragment.this.mActivity.getResources().getDrawable(R.drawable.slt_input_text_login_land));
                AccountFragment.this.tvErrPass.setVisibility(8);
            }
        });
        this.edtLoginPassword.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                boolean handled = false;
                if (actionId == 4) {
                    DeviceUtils.hideKeyboardFrom((Context)AccountFragment.this.mActivity, (View)v);
                    AccountFragment.this.onLoginEmail();
                    handled = true;
                }
                return handled;
            }
        });
        this.btnFaceBook.setOnClickListener((View.OnClickListener)this);
        this.btnPlayNow.setOnClickListener((View.OnClickListener)this);
        this.btnLogin.setOnClickListener((View.OnClickListener)this);
        this.btnClose.setOnClickListener((View.OnClickListener)this);
        this.btnGoogle.setOnClickListener((View.OnClickListener)this);
        this.tvTerm.setOnClickListener((View.OnClickListener)this);
        this.tvRegister.setOnClickListener((View.OnClickListener)this);
        this.tvForgotPass.setOnClickListener((View.OnClickListener)this);
        this.errEmailCount = 0;
        this.keyboardProvider = new KeyboardHeightProvider(this.mActivity);
        this.keyboardProvider.start();
    }

    public void showRegisterDialog() {
        this.newFragment = (DialogFragment)this.mActivity.getFragmentManager().findFragmentByTag(RegistryFragmentV2.class.getSimpleName());
        if (this.newFragment == null) {
            this.newFragment = RegistryFragmentV2.newInstance(this.registerListener);
        }
        this.newFragment.setCancelable(true);
        if (this.newFragment.getDialog() != null && this.newFragment.getDialog().isShowing()) {
            return;
        }
        this.newFragment.show(this.mActivity.getFragmentManager(), RegistryFragmentV2.class.getSimpleName());
    }

    public void showTermDialog() {
        DialogFragment newFragment = (DialogFragment)this.mActivity.getFragmentManager().findFragmentByTag(TermDialogFragment.class.getSimpleName());
        if (newFragment == null) {
            newFragment = TermDialogFragment.newInstance(ApiUtils.getUrlTerm((Context)this.mActivity));
        }
        newFragment.setCancelable(true);
        if (newFragment.getDialog() != null && newFragment.getDialog().isShowing()) {
            return;
        }
        newFragment.show(this.mActivity.getFragmentManager(), TermDialogFragment.class.getSimpleName());
    }

    private void onLoginEmail() {
        if (!NetworkUtils.checkNetwork(this.mActivity)) {
            DialogUtils.showErrorDialog(this.mActivity, this.mActivity.getString(R.string.error_network));
            return;
        }
        if (GameConfigs.getInstance().isLogin()) {
            return;
        }
        if (this.errEmailCount >= 5) {
            DialogUtils.showErrorInputDialog(this.mActivity, this.mActivity.getString(R.string.err_input_more_than_5), new DialogUtils.DlgCloseListener(){

                @Override
                public void onClose() {
                    AccountFragment.this.errEmailCount = 0;
                    AccountFragment.this.onLoginPlayNow();
                }
            }, new DialogUtils.DlgCloseListener(){

                @Override
                public void onClose() {
                    AccountFragment.this.errEmailCount = 0;
                }
            });
            return;
        }
        TrackingUtil.getInstance().trackClickLoginEmailButton();
        String user = this.edtLoginAccount.getText().toString();
        String pass = this.edtLoginPassword.getText().toString();
        String checkUser = StringUtils.validateUser((Context)this.mActivity, user);
        if (!checkUser.isEmpty()) {
            TrackingUtil.getInstance().trackLoginEmailInputError(1, checkUser);
            this.tvErrUser.setVisibility(0);
            this.tvErrUser.setText((CharSequence)checkUser);
            this.edtLoginAccount.setBackground(this.mActivity.getResources().getDrawable(R.drawable.slt_input_text_login_err));
            this.edtLoginAccount.requestFocus();
            ++this.errEmailCount;
            return;
        }
        String checkPass = StringUtils.validatePassword((Context)this.mActivity, pass);
        if (!checkPass.isEmpty()) {
            TrackingUtil.getInstance().trackLoginEmailInputError(2, checkPass);
            this.tvErrPass.setVisibility(0);
            this.tvErrPass.setText((CharSequence)checkPass);
            this.edtLoginPassword.setBackground(this.mActivity.getResources().getDrawable(R.drawable.slt_input_text_login_err));
            this.edtLoginPassword.requestFocus();
            ++this.errEmailCount;
            return;
        }
        TrackingUtil.getInstance().trackLoginEmailCallApi();
        this.loginPresenter.loginEmail(user, pass);
    }

    private void onLoginPlayNow() {
        if (!NetworkUtils.checkNetwork(this.mActivity)) {
            DialogUtils.showErrorDialog(this.mActivity, this.mActivity.getString(R.string.error_network));
            return;
        }
        if (GameConfigs.getInstance().isLogin()) {
            return;
        }
        TrackingUtil.getInstance().trackLoginPlayNowCallApi();
        this.loginPresenter.loginPlayNow();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 9700: {
                GoogleManager.getInstance((Context)this.mActivity).onAuthGoogleResult(data, resultCode);
                break;
            }
            case 64206: {
                FacebookManager.getInstance((Context)this.mActivity).onAuthResult(requestCode, resultCode, data);
                break;
            }
        }
    }

    public void onClick(final View v) {
        if (this.mHandler != null && this.mRunable != null) {
            this.mHandler.removeCallbacks(this.mRunable);
        }
        this.mRunable = new Runnable(){

            @Override
            public void run() {
                try {
                    DeviceUtils.hideKeyboardFrom((Context)AccountFragment.this.mActivity, v);
                    if (v.getId() == R.id.btnFacebook) {
                        if (AccountFragment.this.status == Constants.RTF_STATUS.AUTHENING) {
                            return;
                        }
                        AccountFragment.this.status = Constants.RTF_STATUS.AUTHENING;
                        AccountFragment.this.authenFacebook();
                    } else if (v.getId() == R.id.btnGoogle) {
                        if (AccountFragment.this.status == Constants.RTF_STATUS.AUTHENING) {
                            return;
                        }
                        AccountFragment.this.status = Constants.RTF_STATUS.AUTHENING;
                        AccountFragment.this.authenGooogle();
                    } else if (v.getId() == R.id.btnLogin) {
                        AccountFragment.this.onLoginEmail();
                    } else if (v.getId() == R.id.btnClose) {
                        TrackingUtil.getInstance().trackLoginScreenClose((View)AccountFragment.this.contentPanel, (View)AccountFragment.this.edtLoginAccount, (View)AccountFragment.this.btnLogin);
                        AccountFragment.this.dismiss();
                    } else if (v.getId() == R.id.btnPlayNow) {
                        AccountFragment.this.onLoginPlayNow();
                    } else if (v.getId() == R.id.tvTerm) {
                        AccountFragment.this.showTermDialog();
                    } else if (v.getId() == R.id.tvRegister) {
                        TrackingUtil.getInstance().trackClickBtnRegister();
                        AccountFragment.this.showRegisterDialog();
                    } else if (v.getId() == R.id.tvForgotPass) {
                        DialogUtils.showInfoDialog(AccountFragment.this.mActivity, AccountFragment.this.getString(R.string.notice), AccountFragment.this.getString(R.string.info_forget_pass));
                        TrackingUtil.getInstance().trackForgotPassword();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    AccountFragment.this.mHandler = null;
                    AccountFragment.this.mRunable = null;
                }
            }
        };
        if (this.mHandler == null) {
            this.mHandler = new Handler();
        }
        this.mHandler.postDelayed(this.mRunable, 150L);
    }

    private void authenFacebook() {
        if (!NetworkUtils.checkNetwork(this.mActivity)) {
            DialogUtils.showErrorDialog(this.mActivity, this.mActivity.getString(R.string.error_network));
            return;
        }
        TrackingUtil.getInstance().trackClickLoginFacebookButton();
        if (this.isAdded()) {
            FacebookManager.getInstance((Context)this.mActivity).startAuth((Fragment)this, this);
        }
    }

    private void authenGooogle() {
        if (!NetworkUtils.checkNetwork(this.mActivity)) {
            DialogUtils.showErrorDialog(this.mActivity, this.mActivity.getString(R.string.error_network));
            return;
        }
        TrackingUtil.getInstance().trackClickLoginGoogleButton();
        if (this.isAdded()) {
            GoogleManager.getInstance((Context)this.mActivity).startAuthForResult(this, (IAuthentGoogleListener)this);
        }
    }

    public void show(FragmentManager manager, String tag) {
        super.show(manager, tag);
        TrackingUtil.getInstance().trackLoginScreenOpen();
    }

    public void applyConfig(@NonNull AuthenConfigObj obj) {
        AuthenConfigObj.LoginConfig cf = obj.getLoginConfig();
        if (cf == null) {
            return;
        }
        if (cf.getLogin_google() == 0 & cf.getLogin_facebook() == 0 && cf.getPlay_now() == 0 && cf.getLogin_email() == 0) {
            this.getView().setVisibility(8);
            this.onLoginPlayNow();
        }
        if (cf.getLogin_email() == 0) {
            this.leftContent.setVisibility(8);
            this.tvHeaderLoginSocial.setText((CharSequence)this.getString(R.string.lbl_login_to_your_account));
            this.tvHeaderLoginSocial.setTypeface(Typeface.defaultFromStyle((int)1));
        }
        this.tvRegister.setVisibility(obj != null && obj.getRegisterConfig() == 1 ? 0 : 8);
        if (cf.getLogin_google() == 0 & cf.getLogin_facebook() == 0 && cf.getPlay_now() == 0) {
            this.rightContent.setVisibility(8);
        } else {
            int orientation = this.getResources().getConfiguration().orientation;
            if (orientation == 2) {
                this.termContent.setBackgroundColor(ContextCompat.getColor((Context)this.mActivity, (int)R.color.bg_null));
            } else {
                this.termContent.setBackgroundColor(ContextCompat.getColor((Context)this.mActivity, (int)R.color.bg_login_social));
            }
        }
        this.btnFaceBook.setVisibility(cf.getLogin_facebook() == 0 ? 8 : 0);
        this.btnGoogle.setVisibility(cf.getLogin_google() == 0 ? 8 : 0);
        this.btnPlayNow.setVisibility(cf.getPlay_now() == 0 ? 8 : 0);
        if (obj.getLogoOlder() == null || obj.getLogoOlder().getUrl() == null && obj.getLogoOlder().getText() == null) {
            this.contentIv18.setVisibility(8);
        }
        if (obj.getLogoOlder() != null && obj.getLogoOlder().getUrl() != null) {
            RequestOptions options = new RequestOptions().centerInside().placeholder(R.drawable.logotuoi).error(R.drawable.logotuoi).priority(Priority.HIGH);
            Glide.with((Activity)this.mActivity).load(obj.getLogoOlder().getUrl()).apply(options).into(this.iv18Plus);
        } else {
            this.iv18Plus.setVisibility(4);
        }
        if (obj.getLogoOlder() != null && obj.getLogoOlder().getText() != null) {
            this.tvPlayTimeNoti.setText((CharSequence)obj.getLogoOlder().getText());
        }
    }

    @Override
    public void showProgress(String mess) {
        this.showPregressDialog(true, mess);
    }

    @Override
    public void hideProgress() {
        this.showPregressDialog(false, "");
    }

    public void success(Object x) {
        if (x instanceof AuthenConfigResponseObj) {
            AuthenConfigObj obj = ((AuthenConfigResponseObj)x).getData();
            AuthenConfigs.getInstance().setAuthenConfigObj(obj);
            this.applyConfig(obj);
            TrackingUtil.getInstance().trackCallAuthenConfigSuccess();
        } else if (x instanceof LoginPlayNowResponseObj) {
            TrackingUtil.getInstance().trackLoginPlayNowCallApiSuccess();
            LoginPlayNowResponseObj obj = (LoginPlayNowResponseObj)x;
            obj.getData().setLoginType("PlayNow");
            obj.getData().setLoginOrRegister(obj.getIsRegister());
            this.onLoginSuccess(obj.getData(), obj.getAccessToken());
            this.loginPresenter.getSdkConfig();
        } else if (x instanceof LoginEmailResponseObj) {
            TrackingUtil.getInstance().trackLoginEmailCallApiSuccess();
            LoginEmailResponseObj obj = (LoginEmailResponseObj)x;
            obj.getData().setLoginType("Email");
            obj.getData().setLoginOrRegister(obj.getIsRegister());
            this.onLoginSuccess(obj.getData(), obj.getAccessToken());
            this.loginPresenter.getSdkConfig();
        } else if (x instanceof LoginFacebookResponseObj) {
            TrackingUtil.getInstance().trackLoginFacebookCallApiSuccess();
            LoginFacebookResponseObj obj = (LoginFacebookResponseObj)x;
            obj.getData().setLoginType("Facebook");
            obj.getData().setLoginOrRegister(obj.getIsRegister());
            this.onLoginSuccess(obj.getData(), obj.getAccessToken());
            this.loginPresenter.getSdkConfig();
        } else if (x instanceof LoginGoogleResponseObj) {
            TrackingUtil.getInstance().trackLoginGoogleCallApiSuccess();
            LoginGoogleResponseObj obj = (LoginGoogleResponseObj)x;
            obj.getData().setLoginType("Google");
            obj.getData().setLoginOrRegister(obj.getIsRegister());
            this.onLoginSuccess(obj.getData(), obj.getAccessToken());
            this.loginPresenter.getSdkConfig();
        } else if (x instanceof SdkConfigResponseObj) {
            TrackingUtil.getInstance().trackGetSdkConfigSuccess();
            SdkConfigResponseObj obj = (SdkConfigResponseObj)x;
            GameConfigs.getInstance().setSdkConfig(obj.getData());
            LogUtils.d("LifeCycleActivity", "get game info success");
            if (obj != null && obj.getData() != null && obj.getData().getMaintenance() != null && !TextUtils.isEmpty((CharSequence)obj.getData().getMaintenance().getUrl())) {
                MobGameSDK.getInstance().getQueuePopups().add("pop_link");
                MobGameSDK.getInstance().showPopup();
            } else {
                GameSdk.getInstance().onLoginSuccess(this.mActivity, "login");
                if (this.listener != null) {
                    this.listener.onLoginSuccess();
                }
            }
            this.dismiss();
        }
    }

    public void onLoginSuccess(UserObj obj, String token) {
        GameConfigs.getInstance().setUser(obj);
        AuthenConfigs.getInstance().setAccessToken(token);
        RetrofitClient.clearInstant();
        TrackingUtil.getInstance().trackLoginSuccess(GameConfigs.getInstance().getUser().getId(), GameConfigs.getInstance().getUser().getLoginOrRegister(), GameConfigs.getInstance().getUser().getLoginType());
    }

    public void error(Object o) {
        BaseObj apiErrorObj = (BaseObj)o;
        if (apiErrorObj.getStatus() == -100) {
            DialogUtils.showErrorDialog(this.mActivity, this.mActivity.getString(R.string.error_network));
            return;
        }
        if (o instanceof LoginPlayNowErrObj) {
            LoginPlayNowErrObj obj = (LoginPlayNowErrObj)o;
            TrackingUtil.getInstance().trackLoginPlayNowCallApiFail(obj.getStatus(), obj.getMessage());
            DialogUtils.showErrorDialog(this.mActivity, obj.getMessage());
        } else if (o instanceof LoginEmailErrObj) {
            LoginEmailErrObj obj = (LoginEmailErrObj)o;
            TrackingUtil.getInstance().trackLoginEmailCallApiFail(obj.getStatus(), obj.getMessage());
            DialogUtils.showErrorDialog(this.mActivity, obj.getMessage());
        } else if (o instanceof LoginFacebookErrObj) {
            LoginFacebookErrObj obj = (LoginFacebookErrObj)o;
            TrackingUtil.getInstance().trackLoginFacebookCallApiFail(obj.getStatus(), obj.getMessage());
            DialogUtils.showErrorDialog(this.mActivity, obj.getMessage());
        } else if (o instanceof LoginGGErrObj) {
            LoginGGErrObj obj = (LoginGGErrObj)o;
            TrackingUtil.getInstance().trackLoginGoogleCallApiFail(obj.getStatus(), obj.getMessage());
            DialogUtils.showErrorDialog(this.mActivity, obj.getMessage());
        } else if (o instanceof AuthenConfigErrObj) {
            AuthenConfigObj obj = new AuthenConfigObj();
            AuthenConfigObj.LoginConfig loginConfig = new AuthenConfigObj.LoginConfig();
            obj.setRegisterConfig(1);
            loginConfig.setLogin_apple(1);
            loginConfig.setLogin_email(1);
            loginConfig.setLogin_facebook(0);
            loginConfig.setPlay_now(1);
            loginConfig.setLogin_google(0);
            obj.setLoginConfig(loginConfig);
            this.applyConfig(obj);
            TrackingUtil.getInstance().trackCallAuthenConfigFailed();
        } else if (o instanceof SdkConfigErrObj) {
            SdkConfigErrObj obj = (SdkConfigErrObj)o;
            TrackingUtil.getInstance().trackGetSdkConfigFailed(obj.getStatus());
            if (obj.getStatus() == 401) {
                DialogUtils.showExpireDialog(this.mActivity);
            } else {
                DialogUtils.showRetryDialog(this.mActivity, obj.getMessage(), new DialogUtils.Listener(){

                    @Override
                    public void onRetry() {
                        AccountFragment.this.loginPresenter.getSdkConfig();
                    }
                });
            }
        }
    }

    @Override
    public void onAuthFBSuccess(LoginResult loginResult) {
        this.status = Constants.RTF_STATUS.DONE;
        LogUtils.d("mobgame_token", "facebook token : " + loginResult.getAccessToken().getToken());
        TrackingUtil.getInstance().trackLoginFacebookCallApi();
        if (GameConfigs.getInstance().isLogin()) {
            return;
        }
        this.loginPresenter.loginFtFacebook(loginResult.getAccessToken().getToken());
    }

    @Override
    public void onAuthFBFailed(FacebookException error) {
        this.status = Constants.RTF_STATUS.DONE;
        DialogUtils.showErrorDialog(this.mActivity, "Auth FB failed : " + error.getMessage());
        if (error != null && error.getMessage() != null) {
            TrackingUtil.getInstance().trackLoginFacebookSdkErr(error.getMessage());
        }
    }

    @Override
    public void onAuthFBCancel() {
        this.status = Constants.RTF_STATUS.DONE;
        LogUtils.d("Login Facebook", " Auth FB cancel");
        TrackingUtil.getInstance().trackCancelLoginFacebook();
    }

    @Override
    public void onAuthGGSuccess(GoogleSignInAccount account, String mToken) {
        this.status = Constants.RTF_STATUS.DONE;
        LogUtils.d("mobgame_token", "google token : " + mToken);
        if (GameConfigs.getInstance().isLogin()) {
            return;
        }
        TrackingUtil.getInstance().trackLoginGoogleCallApi();
        this.loginPresenter.loginFtGoogle(mToken);
    }

    @Override
    public void onAuthGGFailed(int code, String mess) {
        if (code == 12502) {
            GoogleManager.getInstance((Context)this.mActivity).startAuthForResult(this, (IAuthentGoogleListener)this);
        } else {
            this.status = Constants.RTF_STATUS.DONE;
            DialogUtils.showErrorDialog(this.mActivity, "Auth GG failed : " + mess);
        }
    }

    @Override
    public void onAuthGGCancel() {
        this.status = Constants.RTF_STATUS.DONE;
        LogUtils.d("Login Google", " Auth GG cancel");
        TrackingUtil.getInstance().trackCancelLoginGoogle();
    }

    public void setListener(ILoginListener listener) {
        this.listener = listener;
    }

    @Override
    public void onKeyboardHeightChanged(int height, int orientation) {
        this.changeKeyboardHeight(height);
    }

    private void changeKeyboardHeight(int height) {
        try {
            if (height > 100) {
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, height);
                this.layoutKeyboardSpace.setLayoutParams((ViewGroup.LayoutParams)params);
                this.layoutKeyboardSpace.setVisibility(0);
                return;
            }
            this.layoutKeyboardSpace.setVisibility(8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

