/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.mobgame.R;

public class CustomToast
extends Toast {
    private Context mContext;

    public CustomToast(Context context) {
        super(context);
        this.mContext = context;
    }

    public CustomToast(Context context, int type, String message) {
        super(context);
        this.mContext = context;
        this.initView(message, type);
    }

    public CustomToast(Context context, int type, String message, int gravity) {
        super(context);
        this.mContext = context;
        this.initView(message, type);
    }

    public void initView(String message, int type) {
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        View view = inflater.inflate(R.layout.toast_notify, null);
        TextView tvMessage = (TextView)view.findViewById(R.id.tvDescription);
        ImageView ivToast = (ImageView)view.findViewById(R.id.ivToast);
        LinearLayout layoutToast = (LinearLayout)view.findViewById(R.id.layoutToast);
        ivToast.setVisibility(8);
        tvMessage.setText((CharSequence)message);
        switch (type) {
            case 0: {
                this.setGravity(87, 0, 0);
                break;
            }
            case 1: {
                layoutToast.setBackground(this.mContext.getResources().getDrawable(R.drawable.bg_toast_warning));
                ivToast.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.ic_warning));
                this.setGravity(87, 0, 0);
                break;
            }
            case 2: {
                layoutToast.setBackground(this.mContext.getResources().getDrawable(R.drawable.bg_toast_err));
                ivToast.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.ic_toast_err));
                this.setGravity(87, 0, 0);
                break;
            }
            case 3: {
                ivToast.setVisibility(0);
                break;
            }
            case 4: {
                break;
            }
        }
        this.setDuration(0);
        this.setView(view);
    }

    public static interface TOAST_TYPE {
        public static final int INFO = 0;
        public static final int WARNING = 1;
        public static final int ERR = 2;
        public static final int HELLO = 3;
        public static final int TODO = 4;
    }
}

