/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.game;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public abstract class BaseFragment
extends Fragment {
    protected boolean isRefresh = false;
    protected Activity mActivity;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(this.getLayoutResource(), container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    public void onResume() {
        super.onResume();
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mActivity = activity;
    }

    public void onStop() {
        super.onStop();
    }

    public void addFragment(int frameId, Fragment fragment, boolean addToBackStack, String tag) {
        FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
        Fragment oldFrag = this.getChildFragmentManager().findFragmentByTag(tag);
        if (oldFrag != null) {
            this.getChildFragmentManager().beginTransaction().remove(oldFrag).commit();
        }
        if (addToBackStack) {
            transaction.addToBackStack(tag);
        }
        transaction.add(frameId, fragment, tag);
        transaction.commit();
        this.getChildFragmentManager().executePendingTransactions();
    }

    public void replaceFragment(int frameId, Fragment fragment, boolean addToBackStack, String tag) {
        FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
        if (addToBackStack) {
            transaction.addToBackStack(tag);
        }
        transaction.replace(frameId, fragment, tag);
        transaction.commit();
        this.getChildFragmentManager().executePendingTransactions();
    }

    public void startActivity(Class<?> c) {
        Intent intent = new Intent((Context)this.getActivity(), c);
        this.startActivity(intent);
    }

    @LayoutRes
    protected abstract int getLayoutResource();
}

