/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.game;

import android.app.Activity;
import android.app.Application;
import android.app.DialogFragment;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.appsflyer.AppsFlyerLib;
import com.facebook.login.widget.ProfilePictureView;
import com.game.sdk.comon.api.ApiUtils;
import com.game.sdk.comon.api.RetrofitClient;
import com.game.sdk.comon.cmd.CmdPaymentV3;
import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.game.IMobSdk;
import com.game.sdk.comon.listener.ILoginListener;
import com.game.sdk.comon.listener.IMesssageListener;
import com.game.sdk.comon.listener.IPaymentListener;
import com.game.sdk.comon.listener.ISaveCharactorListener;
import com.game.sdk.comon.login.FacebookManager;
import com.game.sdk.comon.login.GoogleManager;
import com.game.sdk.comon.object.AuthenConfigObj;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.MessInGameObj;
import com.game.sdk.comon.object.PurchaseHistoryObj;
import com.game.sdk.comon.object.SdkConfigObj;
import com.game.sdk.comon.object.response.AuthenConfigResponseObj;
import com.game.sdk.comon.object.response.MessInGameResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.tracking.TrackingUtil;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.ToastUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.ui.login.AccountFragment;
import com.game.sdk.ui.login.LoginPresenterImpl;
import com.game.sdk.ui.notification.MobFirebaseMessagingService;
import com.game.sdk.ui.other.GamePresenterImpl;
import com.game.sdk.ui.payment.PaymentFragment;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.mobgame.MobGameHelper;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import java.util.ArrayList;

public class GameSdk
implements IMobSdk {
    private static Application sApp;
    private static GameSdk gameSdk;
    private static MobGameSDK mobGameSDK;
    Handler mHandler;
    Runnable mRunable;
    DialogFragment paymentFragment;

    @Override
    public Application getApplication() {
        return sApp;
    }

    public static GameSdk getInstance() {
        if (gameSdk == null) {
            gameSdk = new GameSdk();
            mobGameSDK = MobGameSDK.getInstance();
        }
        return gameSdk;
    }

    public void initSdk(Activity activity) {
        mobGameSDK.init(activity);
    }

    @Override
    public void init(@NonNull Application application, String appkey, String facebookId) {
        sApp = application;
        TrackingUtil.getInstance().init(sApp);
        TrackingUtil.getInstance().trackAppLaunch();
        TrackingUtil.getInstance().trackLastSession((Context)sApp);
        GameConfigs.getInstance().setAppKey(appkey);
        GameConfigs.getInstance().initFacebook(facebookId);
        this.mHandler = new Handler();
    }

    @Override
    public void loginNative(final Activity activity, final ILoginListener listener) {
        if (GameConfigs.getInstance().isLogin()) {
            String mess = sApp.getResources().getString(R.string.lbl_already_login);
            ToastUtils.showErrToast((Context)activity, mess);
            return;
        }
        LoginPresenterImpl pr = new LoginPresenterImpl(new BaseView(){

            @Override
            public void showProgress(String message) {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Utils.showLoading(activity, true);
                    }
                });
            }

            @Override
            public void hideProgress() {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Utils.showLoading(activity, false);
                    }
                });
            }

            public void success(Object x) {
                if (x instanceof AuthenConfigResponseObj) {
                    AuthenConfigObj obj = ((AuthenConfigResponseObj)x).getData();
                    AuthenConfigs.getInstance().setAuthenConfigObj(obj);
                }
                GameSdk.this.showLoginForm(activity, new ILoginListener(){

                    @Override
                    public void onLoginSuccess() {
                        AppsFlyerLib.getInstance().setCustomerUserId(GameConfigs.getInstance().getUser().getId() + "");
                        GameSdk.this.saveFCM(activity);
                        if (listener != null) {
                            listener.onLoginSuccess();
                        }
                    }

                    @Override
                    public void onRegisterSuccess(String param) {
                    }
                });
            }

            public void error(Object o) {
                GameSdk.this.showLoginForm(activity, listener);
            }
        });
        pr.getAuthenConfig();
    }

    @Override
    public void showLoginForm(final Activity activity, final ILoginListener listener) {
        if (this.mHandler != null && this.mRunable != null) {
            this.mHandler.removeCallbacks(this.mRunable);
        }
        this.mRunable = new Runnable(){

            @Override
            public void run() {
                DialogFragment newFragment = (DialogFragment)activity.getFragmentManager().findFragmentByTag(AccountFragment.class.getSimpleName());
                if (newFragment == null) {
                    newFragment = AccountFragment.newInstance(listener);
                }
                newFragment.setCancelable(false);
                if (newFragment.getDialog() != null && newFragment.getDialog().isShowing()) {
                    return;
                }
                newFragment.show(activity.getFragmentManager(), AccountFragment.class.getSimpleName());
            }
        };
        this.mHandler.postDelayed(this.mRunable, 200L);
    }

    @Override
    public void logOut(Activity activity) {
        mobGameSDK.logout();
        if (GameConfigs.getInstance().getUser() != null || GameConfigs.getInstance().isLogin()) {
            if (GameConfigs.getInstance().getUser() != null) {
                TrackingUtil.getInstance().trackLogoutSuccess(GameConfigs.getInstance().getUser().getId());
            }
            RetrofitClient.clearInstant();
            GameConfigs.clearInstance();
            GoogleManager.getInstance((Context)sApp).logout();
            FacebookManager.getInstance((Context)sApp).logout();
            PrefManager.saveBoolean((Context)sApp, "SAVE_FCM_NON_TOKEN" + AuthenConfigs.getInstance().getAccessToken(), false);
            PrefManager.saveSetting((Context)sApp, "MOB_ROLE_ID", "");
            PrefManager.saveSetting((Context)sApp, "MOB_AREA_ID", "");
            PrefManager.saveAccessToken((Context)sApp, "");
            AppsFlyerLib.getInstance().setCustomerUserId("");
            MobGameHelper.hideNotiFloatButton();
            MobGameSDK.getInstance().logout();
            String mess = sApp.getResources().getString(R.string.lbl_log_out_success);
            ToastUtils.showHello(activity, 3000L, mess);
        } else {
            String mess = sApp.getResources().getString(R.string.lbl_not_login);
            ToastUtils.showErrToast((Context)activity, mess);
        }
    }

    @Override
    public void onLoginSuccess(Activity activity, String tab) {
        String name = GameConfigs.getInstance().getUser().getName();
        name = TextUtils.isEmpty((CharSequence)name) ? "" : ", " + name;
        String mess = sApp.getResources().getString(R.string.hello) + name;
        if (GameConfigs.getInstance().getSdkConfig() != null) {
            MobGameHelper.showNotiFloatButton(GameConfigs.getInstance().getSdkConfig().getEx());
        }
        ToastUtils.showHello(activity, 3000L, mess);
    }

    @Override
    public void getMessInGame(final Activity activity, final IMesssageListener messsageListener) {
        if (!GameConfigs.getInstance().isLogin()) {
            String mess = sApp.getResources().getString(R.string.lbl_not_login);
            ToastUtils.showErrToast((Context)activity, mess);
            return;
        }
        GamePresenterImpl gamePresenter = new GamePresenterImpl(new BaseView(){

            @Override
            public void showProgress(String mess) {
                Utils.showLoading(activity, true);
            }

            @Override
            public void hideProgress() {
                Utils.showLoading(activity, false);
            }

            public void success(Object x) {
                ArrayList<MessInGameObj> obj;
                if (x instanceof MessInGameResponseObj && messsageListener != null && (obj = ((MessInGameResponseObj)x).getData()) != null && obj.size() > 0) {
                    messsageListener.onSuccess(obj);
                }
            }

            public void error(Object o) {
                BaseObj baseObj = (BaseObj)o;
                ToastUtils.showErrToast((Context)activity, baseObj.getMessage());
            }
        });
        gamePresenter.getMessInGame();
    }

    @Override
    public void saveCharactor(final Activity activity, final String roleId, final String areaId, final ISaveCharactorListener listener) {
        if (!GameConfigs.getInstance().isLogin()) {
            String mess = sApp.getResources().getString(R.string.lbl_not_login);
            ToastUtils.showErrToast((Context)activity, mess);
            return;
        }
        PrefManager.saveSetting((Context)activity, "MOB_ROLE_ID", roleId);
        PrefManager.saveSetting((Context)activity, "MOB_AREA_ID", areaId);
        LogUtils.d(ProfilePictureView.TAG, "ROLE_ID :" + roleId);
        LogUtils.d(ProfilePictureView.TAG, "AREA_ID :" + roleId);
        GamePresenterImpl gamePresenter = new GamePresenterImpl(new BaseView(){

            @Override
            public void showProgress(String mess) {
                Utils.showLoading(activity, true);
            }

            @Override
            public void hideProgress() {
                Utils.showLoading(activity, false);
            }

            public void success(Object x) {
                if (x instanceof BaseObj && listener != null) {
                    TrackingUtil.getInstance().trackCharactorCreatedSuccess(GameConfigs.getInstance().getUser().getId(), roleId, areaId);
                    SdkConfigObj.Pop pop = GameConfigs.getInstance().getMobPopup();
                    if (pop != null && !TextUtils.isEmpty((CharSequence)pop.getUrl())) {
                        MobGameSDK.getInstance().getQueuePopups().add("pop_link");
                        MobGameSDK.getInstance().showPopup();
                    }
                    listener.onSuccess();
                }
            }

            public void error(Object o) {
                BaseObj baseObj = (BaseObj)o;
                ToastUtils.showErrToast((Context)activity, baseObj.getMessage());
                TrackingUtil.getInstance().trackCharactorCreatedFailed(GameConfigs.getInstance().getUser().getId(), roleId, areaId);
            }
        });
        TrackingUtil.getInstance().trackCharactorCreated(GameConfigs.getInstance().getUser().getId(), roleId, areaId);
        try {
            gamePresenter.saveCharactor(roleId, areaId);
        }
        catch (Exception e) {
            LogUtils.d(ProfilePictureView.TAG, e.getMessage());
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (mobGameSDK != null) {
            mobGameSDK.onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void onDestroy() {
        if (mobGameSDK != null) {
            mobGameSDK.onDestroySDK();
        }
    }

    @Override
    public void shareImageFacebook(Activity activity, Bitmap image) {
        if (mobGameSDK != null) {
            mobGameSDK.shareImageFacebook(activity, image);
        }
    }

    @Override
    public void dashboardNew() {
        if (mobGameSDK != null) {
            mobGameSDK.dashboardNew();
        }
    }

    @Override
    public void showTextScroll(ArrayList<MessInGameObj> listNoti) {
        if (mobGameSDK != null) {
            mobGameSDK.showTextScroll(listNoti);
        }
    }

    @Override
    public void onRequestPermissionsResult(Activity gameActivity, int requestCode, String[] permissions, int[] grantResults) {
        if (mobGameSDK != null) {
            mobGameSDK.onRequestPermissionsResult(gameActivity, requestCode, permissions, grantResults);
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        if (mobGameSDK != null) {
            mobGameSDK.onWindowFocusChanged(hasFocus);
        }
    }

    @Override
    public void onBackPressed() {
        mobGameSDK.onBackPressed();
    }

    @Override
    public void payment(final Activity activity, final String state, final IPaymentListener listener) {
        if (this.mHandler != null && this.mRunable != null) {
            this.mHandler.removeCallbacks(this.mRunable);
        }
        this.mRunable = new Runnable(){

            @Override
            public void run() {
                try {
                    Log.i((String)ProfilePictureView.TAG, (String)("payment:" + state));
                    if (!GameConfigs.getInstance().isLogin()) {
                        String mess = activity.getResources().getString(R.string.lbl_not_login);
                        ToastUtils.showErrToast((Context)activity, mess);
                    } else {
                        String role_id = PrefManager.getString((Context)activity, "MOB_ROLE_ID", "");
                        String area_id = PrefManager.getString((Context)activity, "MOB_AREA_ID", "");
                        if (TextUtils.isEmpty((CharSequence)role_id) || TextUtils.isEmpty((CharSequence)area_id)) {
                            ToastUtils.showErrToast((Context)activity, activity.getString(R.string.err_empty_charactor));
                            return;
                        }
                        GameSdk.this.paymentFragment = (DialogFragment)activity.getFragmentManager().findFragmentByTag(PaymentFragment.class.getSimpleName());
                        if (GameSdk.this.paymentFragment == null) {
                            GameSdk.this.paymentFragment = PaymentFragment.newInstance(ApiUtils.getUrlWvPayment((Context)activity, state), new PaymentFragment.PaymentGGSuccess(){

                                @Override
                                public void onPaymentGGSuccess(PurchaseHistoryObj obj) {
                                    CmdPaymentV3.getInstance().verifyPayment(activity, obj, listener);
                                }
                            });
                        }
                        if (GameSdk.this.paymentFragment.getDialog() != null && GameSdk.this.paymentFragment.getDialog().isShowing()) {
                            return;
                        }
                        GameSdk.this.paymentFragment.show(activity.getFragmentManager(), PaymentFragment.class.getSimpleName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.mHandler.postDelayed(this.mRunable, 200L);
    }

    public void saveFCM(final Activity activity) {
        if (GameConfigs.getInstance().isLogin() && !PrefManager.getBoolean((Context)sApp, "SAVE_FCM_NON_TOKEN" + AuthenConfigs.getInstance().getAccessToken(), false)) {
            FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<InstanceIdResult>(){

                public void onSuccess(InstanceIdResult instanceIdResult) {
                    String firebaseToken = instanceIdResult.getToken();
                    LogUtils.d(ProfilePictureView.TAG, "Firebase Token/regId: " + firebaseToken);
                    if (GameConfigs.getInstance().getAppKey() != null && GameConfigs.getInstance().getUser() != null) {
                        int userId = GameConfigs.getInstance().getUser().getId();
                        MobFirebaseMessagingService.getInstance().sendRegistrationToServer(activity, String.valueOf(userId), firebaseToken);
                    }
                }
            });
        } else if (!PrefManager.getBoolean((Context)sApp, "SAVE_FCM_NON_TOKEN", false)) {
            FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<InstanceIdResult>(){

                public void onSuccess(InstanceIdResult instanceIdResult) {
                    String firebaseToken = instanceIdResult.getToken();
                    LogUtils.d(ProfilePictureView.TAG, "Firebase Token/regId: " + firebaseToken);
                    if (GameConfigs.getInstance().getAppKey() != null) {
                        MobFirebaseMessagingService.getInstance().sendRegistrationToServer(activity, "", firebaseToken);
                    }
                }
            });
        }
    }
}

