/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.utils.iab;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.android.vending.billing.IInAppBillingService;
import com.game.sdk.comon.utils.LogUtils;
import com.mobgame.utils.iab.IabException;
import com.mobgame.utils.iab.IabResult;
import com.mobgame.utils.iab.Inventory;
import com.mobgame.utils.iab.Purchase;
import com.mobgame.utils.iab.SkuDetails;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

public class IabHelper {
    boolean mDebugLog = false;
    String mDebugTag = "IabHelper";
    boolean mSetupDone = false;
    boolean mDisposed = false;
    boolean mSubscriptionsSupported = false;
    boolean mAsyncInProgress = false;
    String mAsyncOperation = "";
    Activity mActivity;
    Context mContext;
    IInAppBillingService mService;
    ServiceConnection mServiceConn;
    int mRequestCode;
    String mPurchasingItemType;
    public static final int BILLING_RESPONSE_RESULT_OK = 0;
    public static final int BILLING_RESPONSE_RESULT_USER_CANCELED = 1;
    public static final int BILLING_RESPONSE_RESULT_BILLING_UNAVAILABLE = 3;
    public static final int BILLING_RESPONSE_RESULT_ITEM_UNAVAILABLE = 4;
    public static final int BILLING_RESPONSE_RESULT_DEVELOPER_ERROR = 5;
    public static final int BILLING_RESPONSE_RESULT_ERROR = 6;
    public static final int BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED = 7;
    public static final int BILLING_RESPONSE_RESULT_ITEM_NOT_OWNED = 8;
    public static final int IABHELPER_ERROR_BASE = -1000;
    public static final int IABHELPER_REMOTE_EXCEPTION = -1001;
    public static final int IABHELPER_BAD_RESPONSE = -1002;
    public static final int IABHELPER_VERIFICATION_FAILED = -1003;
    public static final int IABHELPER_SEND_INTENT_FAILED = -1004;
    public static final int IABHELPER_USER_CANCELLED = -1005;
    public static final int IABHELPER_UNKNOWN_PURCHASE_RESPONSE = -1006;
    public static final int IABHELPER_MISSING_TOKEN = -1007;
    public static final int IABHELPER_UNKNOWN_ERROR = -1008;
    public static final int IABHELPER_SUBSCRIPTIONS_NOT_AVAILABLE = -1009;
    public static final int IABHELPER_INVALID_CONSUMPTION = -1010;
    public static final String RESPONSE_CODE = "RESPONSE_CODE";
    public static final String RESPONSE_GET_SKU_DETAILS_LIST = "DETAILS_LIST";
    public static final String RESPONSE_BUY_INTENT = "BUY_INTENT";
    public static final String RESPONSE_INAPP_PURCHASE_DATA = "INAPP_PURCHASE_DATA";
    public static final String RESPONSE_INAPP_SIGNATURE = "INAPP_DATA_SIGNATURE";
    public static final String RESPONSE_INAPP_ITEM_LIST = "INAPP_PURCHASE_ITEM_LIST";
    public static final String RESPONSE_INAPP_PURCHASE_DATA_LIST = "INAPP_PURCHASE_DATA_LIST";
    public static final String RESPONSE_INAPP_SIGNATURE_LIST = "INAPP_DATA_SIGNATURE_LIST";
    public static final String INAPP_CONTINUATION_TOKEN = "INAPP_CONTINUATION_TOKEN";
    public static final String ITEM_TYPE_INAPP = "inapp";
    public static final String ITEM_TYPE_SUBS = "subs";
    public static final String GET_SKU_DETAILS_ITEM_LIST = "ITEM_ID_LIST";
    public static final String GET_SKU_DETAILS_ITEM_TYPE_LIST = "ITEM_TYPE_LIST";
    OnIabPurchaseFinishedListener mPurchaseListener;

    public IabHelper(Activity act) {
        this.mActivity = act;
        this.mContext = act.getApplicationContext();
        this.logDebug("IAB helper created.");
    }

    public void enableDebugLogging(boolean enable, String tag) {
        this.checkNotDisposed();
        this.mDebugLog = enable;
        this.mDebugTag = tag;
    }

    public void enableDebugLogging(boolean enable) {
        this.checkNotDisposed();
        this.mDebugLog = enable;
    }

    public void startSetup(final OnIabSetupFinishedListener listener) {
        this.checkNotDisposed();
        if (this.mSetupDone) {
            throw new IllegalStateException("IAB helper is already set up.");
        }
        this.logDebug("Starting in-app billing setup.");
        this.mServiceConn = new ServiceConnection(){

            public void onServiceDisconnected(ComponentName name) {
                IabHelper.this.logDebug("Billing service disconnected.");
                IabHelper.this.mService = null;
            }

            public void onServiceConnected(ComponentName name, IBinder service) {
                if (IabHelper.this.mDisposed) {
                    return;
                }
                IabHelper.this.logDebug("Billing service connected.");
                IabHelper.this.mService = IInAppBillingService.Stub.asInterface(service);
                String packageName = IabHelper.this.mContext.getPackageName();
                try {
                    IabHelper.this.logDebug("Checking for in-app billing 3 support.");
                    int response = IabHelper.this.mService.isBillingSupported(3, packageName, IabHelper.ITEM_TYPE_INAPP);
                    if (response != 0) {
                        if (listener != null) {
                            listener.onIabSetupFinished(new IabResult(response, "Error checking for billing v3 support."));
                        }
                        IabHelper.this.mSubscriptionsSupported = false;
                        return;
                    }
                    IabHelper.this.logDebug("In-app billing version 3 supported for " + packageName);
                    response = IabHelper.this.mService.isBillingSupported(3, packageName, IabHelper.ITEM_TYPE_SUBS);
                    if (response == 0) {
                        IabHelper.this.logDebug("Subscriptions AVAILABLE.");
                        IabHelper.this.mSubscriptionsSupported = true;
                    } else {
                        IabHelper.this.logDebug("Subscriptions NOT AVAILABLE. ForceLogoutResponse: " + response);
                    }
                    IabHelper.this.mSetupDone = true;
                }
                catch (RemoteException e) {
                    if (listener != null) {
                        listener.onIabSetupFinished(new IabResult(-1001, "RemoteException while setting up in-app billing."));
                    }
                    e.printStackTrace();
                    return;
                }
                if (listener != null) {
                    listener.onIabSetupFinished(new IabResult(0, "Setup successful."));
                }
            }
        };
        Intent serviceIntent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
        serviceIntent.setPackage("com.android.vending");
        if (!this.mContext.getPackageManager().queryIntentServices(serviceIntent, 0).isEmpty()) {
            this.mContext.bindService(serviceIntent, this.mServiceConn, 1);
        } else if (listener != null) {
            listener.onIabSetupFinished(new IabResult(3, "Billing service unavailable on device."));
        }
    }

    public void dispose() {
        this.logDebug("Disposing.");
        this.mSetupDone = false;
        if (this.mServiceConn != null) {
            this.logDebug("Unbinding from service.");
            if (this.mContext != null) {
                this.mContext.unbindService(this.mServiceConn);
            }
        }
        this.mDisposed = true;
        this.mContext = null;
        this.mServiceConn = null;
        this.mService = null;
        this.mPurchaseListener = null;
    }

    private void checkNotDisposed() {
        if (this.mDisposed) {
            throw new IllegalStateException("IabHelper was disposed of, so it cannot be used.");
        }
    }

    public boolean subscriptionsSupported() {
        this.checkNotDisposed();
        return this.mSubscriptionsSupported;
    }

    public void launchPurchaseFlow(String sku, int requestCode, OnIabPurchaseFinishedListener listener) {
        this.launchPurchaseFlow(sku, requestCode, listener, "");
    }

    public void launchPurchaseFlow(String sku, int requestCode, OnIabPurchaseFinishedListener listener, String extraData) {
        this.launchPurchaseFlow(sku, ITEM_TYPE_INAPP, requestCode, listener, extraData);
    }

    public void launchPurchaseFlowWithRetry(String sku, int requestCode, OnIabPurchaseFinishedListener listener) {
        Log.i((String)"IabHelper", (String)"launchPurchaseFlowWithRetry 1");
        this.launchPurchaseFlowWithRetry(sku, requestCode, listener, "", 3);
    }

    public void launchPurchaseFlowWithRetry(String sku, int requestCode, OnIabPurchaseFinishedListener listener, int maxRetry) {
        this.launchPurchaseFlowWithRetry(sku, requestCode, listener, "", maxRetry);
    }

    public void launchPurchaseFlowWithRetry(String sku, int requestCode, OnIabPurchaseFinishedListener listener, String extraData, int maxRetry) {
        this.launchPurchaseFlowWithRetry(sku, ITEM_TYPE_INAPP, requestCode, listener, extraData, maxRetry, 0);
        Log.i((String)"IabHelper", (String)"launchPurchaseFlowWithRetry 2");
    }

    public void launchSubscriptionPurchaseFlow(String sku, int requestCode, OnIabPurchaseFinishedListener listener) {
        this.launchSubscriptionPurchaseFlow(sku, requestCode, listener, "");
    }

    public void launchSubscriptionPurchaseFlow(String sku, int requestCode, OnIabPurchaseFinishedListener listener, String extraData) {
        this.launchPurchaseFlow(sku, ITEM_TYPE_SUBS, requestCode, listener, extraData);
    }

    public void launchPurchaseFlow(String sku, String itemType, int requestCode, OnIabPurchaseFinishedListener listener, String extraData) {
        block8: {
            this.checkNotDisposed();
            this.checkSetupDone("launchPurchaseFlow");
            this.flagStartAsync("launchPurchaseFlow");
            Log.i((String)"IabHelper", (String)"launchPurchaseFlow 4");
            if (itemType.equals(ITEM_TYPE_SUBS) && !this.mSubscriptionsSupported) {
                IabResult r = new IabResult(-1009, "Subscriptions are not available.");
                this.flagEndAsync();
                if (listener != null) {
                    listener.onIabPurchaseFinished(r, null);
                }
                return;
            }
            try {
                Log.i((String)"IabHelper", (String)"launchPurchaseFlow 5");
                this.logDebug("Constructing buy intent for " + sku + ", item type: " + itemType);
                Bundle buyIntentBundle = this.mService.getBuyIntent(3, this.mContext.getPackageName(), sku, itemType, extraData);
                int response = this.getResponseCodeFromBundle(buyIntentBundle);
                if (response != 0) {
                    this.logError("Unable to buy item, Error response: " + IabHelper.getResponseDesc(response));
                    this.flagEndAsync();
                    IabResult result = new IabResult(response, "Unable to buy item");
                    if (listener != null) {
                        listener.onIabPurchaseFinished(result, null);
                    }
                    return;
                }
                PendingIntent pendingIntent = (PendingIntent)buyIntentBundle.getParcelable(RESPONSE_BUY_INTENT);
                this.logDebug("Launching buy intent for " + sku + ". Request code: " + requestCode);
                this.mRequestCode = requestCode;
                this.mPurchaseListener = listener;
                this.mPurchasingItemType = itemType;
                this.mActivity.startIntentSenderForResult(pendingIntent.getIntentSender(), requestCode, new Intent(), Integer.valueOf(0).intValue(), Integer.valueOf(0).intValue(), Integer.valueOf(0).intValue());
                Log.i((String)"IabHelper", (String)("launchPurchaseFlow 6 " + pendingIntent.getIntentSender() + requestCode + Integer.valueOf(0)));
            }
            catch (IntentSender.SendIntentException e) {
                this.logError("SendIntentException while launching purchase flow for sku " + sku);
                e.printStackTrace();
                this.flagEndAsync();
                IabResult result = new IabResult(-1004, "Failed to send intent.");
                if (listener != null) {
                    listener.onIabPurchaseFinished(result, null);
                }
            }
            catch (RemoteException e) {
                this.logError("RemoteException while launching purchase flow for sku " + sku);
                e.printStackTrace();
                this.flagEndAsync();
                IabResult result = new IabResult(-1001, "Remote exception while starting purchase flow");
                if (listener == null) break block8;
                listener.onIabPurchaseFinished(result, null);
            }
        }
    }

    public void launchPurchaseFlowWithRetry(final String sku, final String itemType, final int requestCode, final OnIabPurchaseFinishedListener listener, final String extraData, final int maxTries, final int countTry) {
        try {
            Log.i((String)"IabHelper", (String)"launchPurchaseFlow 1");
            this.launchPurchaseFlow(sku, itemType, requestCode, listener, extraData);
        }
        catch (IllegalStateException e) {
            if (countTry < maxTries) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        IabHelper.this.launchPurchaseFlowWithRetry(sku, itemType, requestCode, listener, extraData, maxTries, countTry + 1);
                        Log.i((String)"IabHelper", (String)"launchPurchaseFlow 2");
                    }
                }, 1000L);
            }
            Log.i((String)"IabHelper", (String)"launchPurchaseFlow 3");
        }
    }

    public boolean handleActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode != this.mRequestCode) {
            return false;
        }
        this.checkNotDisposed();
        this.checkSetupDone("handleActivityResult");
        this.flagEndAsync();
        if (data == null) {
            this.logError("Null data in IAB activity result.");
            IabResult result = new IabResult(-1002, "Null data in IAB result");
            if (this.mPurchaseListener != null) {
                this.mPurchaseListener.onIabPurchaseFinished(result, null);
            }
            return true;
        }
        int responseCode = this.getResponseCodeFromIntent(data);
        String purchaseData = data.getStringExtra(RESPONSE_INAPP_PURCHASE_DATA);
        String dataSignature = data.getStringExtra(RESPONSE_INAPP_SIGNATURE);
        if (resultCode == -1 && responseCode == 0) {
            this.logDebug("Successful resultcode from purchase activity.");
            this.logDebug("Purchase data: " + purchaseData);
            this.logDebug("Data signature: " + dataSignature);
            this.logDebug("Extras: " + data.getExtras());
            this.logDebug("Expected item type: " + this.mPurchasingItemType);
            if (purchaseData == null || dataSignature == null) {
                this.logError("BUG: either purchaseData or dataSignature is null.");
                this.logDebug("Extras: " + data.getExtras().toString());
                IabResult result = new IabResult(-1008, "IAB returned null purchaseData or dataSignature");
                if (this.mPurchaseListener != null) {
                    this.mPurchaseListener.onIabPurchaseFinished(result, null);
                }
                return true;
            }
            Purchase purchase = null;
            try {
                purchase = new Purchase(this.mPurchasingItemType, purchaseData, dataSignature);
                this.logDebug("Purchase signature successfully verified.");
            }
            catch (JSONException e) {
                this.logError("Failed to parse purchase data.");
                e.printStackTrace();
                IabResult result = new IabResult(-1002, "Failed to parse purchase data.");
                if (this.mPurchaseListener != null) {
                    this.mPurchaseListener.onIabPurchaseFinished(result, null);
                }
                return true;
            }
            if (this.mPurchaseListener != null) {
                this.mPurchaseListener.onIabPurchaseFinished(new IabResult(0, "Success"), purchase);
            }
        } else if (resultCode == -1) {
            this.logDebug("Result code was OK but in-app billing response was not OK: " + IabHelper.getResponseDesc(responseCode));
            if (this.mPurchaseListener != null) {
                IabResult result = new IabResult(responseCode, "Problem purchashing item.");
                this.mPurchaseListener.onIabPurchaseFinished(result, null);
            }
        } else if (resultCode == 0) {
            this.logDebug("Purchase canceled - ForceLogoutResponse: " + IabHelper.getResponseDesc(responseCode));
            IabResult result = new IabResult(-1005, "User canceled.");
            if (this.mPurchaseListener != null) {
                this.mPurchaseListener.onIabPurchaseFinished(result, null);
            }
        } else {
            this.logError("Purchase failed. Result code: " + Integer.toString(resultCode) + ". ForceLogoutResponse: " + IabHelper.getResponseDesc(responseCode));
            IabResult result = new IabResult(-1006, "Unknown purchase response.");
            if (this.mPurchaseListener != null) {
                this.mPurchaseListener.onIabPurchaseFinished(result, null);
            }
        }
        return true;
    }

    public Inventory queryInventory(boolean querySkuDetails, List<String> moreSkus) throws IabException {
        return this.queryInventory(querySkuDetails, moreSkus, null);
    }

    public Inventory queryInventory(boolean querySkuDetails, List<String> moreItemSkus, List<String> moreSubsSkus) throws IabException {
        this.checkNotDisposed();
        this.checkSetupDone("queryInventory");
        try {
            Inventory inv = new Inventory();
            int r = this.queryPurchases(inv, ITEM_TYPE_INAPP);
            if (r != 0) {
                throw new IabException(r, "Error refreshing inventory (querying owned items).");
            }
            if (querySkuDetails && (r = this.querySkuDetails(ITEM_TYPE_INAPP, inv, moreItemSkus)) != 0) {
                throw new IabException(r, "Error refreshing inventory (querying prices of items).");
            }
            if (this.mSubscriptionsSupported) {
                r = this.queryPurchases(inv, ITEM_TYPE_SUBS);
                if (r != 0) {
                    throw new IabException(r, "Error refreshing inventory (querying owned subscriptions).");
                }
                if (querySkuDetails && (r = this.querySkuDetails(ITEM_TYPE_SUBS, inv, moreItemSkus)) != 0) {
                    throw new IabException(r, "Error refreshing inventory (querying prices of subscriptions).");
                }
            }
            return inv;
        }
        catch (RemoteException e) {
            throw new IabException(-1001, "Remote exception while refreshing inventory.", (Exception)((Object)e));
        }
        catch (JSONException e) {
            throw new IabException(-1002, "Error parsing JSON response while refreshing inventory.", (Exception)((Object)e));
        }
    }

    public void queryInventoryAsync(final boolean querySkuDetails, final List<String> moreSkus, final QueryInventoryFinishedListener listener) {
        final Handler handler = new Handler();
        this.checkNotDisposed();
        this.checkSetupDone("queryInventory");
        try {
            this.flagStartAsync("refresh inventory");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                IabResult result = new IabResult(0, "Inventory refresh successful.");
                Inventory inv = null;
                try {
                    inv = IabHelper.this.queryInventory(querySkuDetails, moreSkus);
                }
                catch (IabException ex) {
                    result = ex.getResult();
                }
                IabHelper.this.flagEndAsync();
                final IabResult result_f = result;
                final Inventory inv_f = inv;
                if (!IabHelper.this.mDisposed && listener != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onQueryInventoryFinished(result_f, inv_f);
                        }
                    });
                }
            }
        }).start();
    }

    public void queryInventoryAsync(QueryInventoryFinishedListener listener) {
        this.queryInventoryAsync(true, null, listener);
    }

    public void queryInventoryAsync(boolean querySkuDetails, QueryInventoryFinishedListener listener) {
        this.queryInventoryAsync(querySkuDetails, null, listener);
    }

    void consume(Purchase itemInfo) throws IabException {
        this.checkNotDisposed();
        this.checkSetupDone("consume");
        if (!itemInfo.mItemType.equals(ITEM_TYPE_INAPP)) {
            throw new IabException(-1010, "Items of type '" + itemInfo.mItemType + "' can't be consumed.");
        }
        try {
            String token = itemInfo.getToken();
            String sku = itemInfo.getSku();
            if (token == null || token.equals("")) {
                this.logError("Can't consume " + sku + ". No token.");
                throw new IabException(-1007, "PurchaseInfo is missing token for sku: " + sku + " " + itemInfo);
            }
            this.logDebug("Consuming sku: " + sku + ", token: " + token);
            int response = this.mService.consumePurchase(3, this.mContext.getPackageName(), token);
            if (response != 0) {
                this.logDebug("Error consuming consuming sku " + sku + ". " + IabHelper.getResponseDesc(response));
                throw new IabException(response, "Error consuming sku " + sku);
            }
            this.logDebug("Successfully consumed sku: " + sku);
        }
        catch (RemoteException e) {
            throw new IabException(-1001, "Remote exception while consuming. PurchaseInfo: " + itemInfo, (Exception)((Object)e));
        }
    }

    public void consumeAsync(Purchase purchase, OnConsumeFinishedListener listener) {
        this.checkNotDisposed();
        this.checkSetupDone("consume");
        ArrayList<Purchase> purchases = new ArrayList<Purchase>();
        purchases.add(purchase);
        this.consumeAsyncInternal(purchases, listener, null);
    }

    public void consumeAsync(List<Purchase> purchases, OnConsumeMultiFinishedListener listener) {
        this.checkNotDisposed();
        this.checkSetupDone("consume");
        this.consumeAsyncInternal(purchases, null, listener);
    }

    public static String getResponseDesc(int code) {
        String[] iab_msgs = "0:OK/1:User Canceled/2:Unknown/3:Billing Unavailable/4:Item unavailable/5:Developer Error/6:Error/7:Item Already Owned/8:Item not owned".split("/");
        String[] iabhelper_msgs = "0:OK/-1001:Remote exception during initialization/-1002:Bad response received/-1003:Purchase signature verification failed/-1004:Send intent failed/-1005:User cancelled/-1006:Unknown purchase response/-1007:Missing token/-1008:Unknown error/-1009:Subscriptions not available/-1010:Invalid consumption attempt".split("/");
        if (code <= -1000) {
            int index = -1000 - code;
            if (index >= 0 && index < iabhelper_msgs.length) {
                return iabhelper_msgs[index];
            }
            return String.valueOf(code) + ":Unknown IAB Helper Error";
        }
        if (code < 0 || code >= iab_msgs.length) {
            return String.valueOf(code) + ":Unknown";
        }
        return iab_msgs[code];
    }

    public boolean isSetupDone() {
        return this.mSetupDone;
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public Context getContext() {
        return this.mContext;
    }

    void checkSetupDone(String operation) {
        if (!this.mSetupDone) {
            this.logError("Illegal state for operation (" + operation + "): IAB helper is not set up.");
            throw new IllegalStateException("IAB helper is not set up. Can't perform operation: " + operation);
        }
    }

    int getResponseCodeFromBundle(Bundle b) {
        Object o = b.get(RESPONSE_CODE);
        if (o == null) {
            this.logDebug("Bundle with null response code, assuming OK (known issue)");
            return 0;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        this.logError("Unexpected type for bundle response code.");
        this.logError(o.getClass().getName());
        throw new RuntimeException("Unexpected type for bundle response code: " + o.getClass().getName());
    }

    int getResponseCodeFromIntent(Intent i) {
        Object o = i.getExtras().get(RESPONSE_CODE);
        if (o == null) {
            this.logError("Intent with no response code, assuming OK (known issue)");
            return 0;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        this.logError("Unexpected type for intent response code.");
        this.logError(o.getClass().getName());
        throw new RuntimeException("Unexpected type for intent response code: " + o.getClass().getName());
    }

    void flagStartAsync(String operation) {
        if (this.mAsyncInProgress) {
            throw new IllegalStateException("Can't start async operation (" + operation + ") because another async operation(" + this.mAsyncOperation + ") is in progress.");
        }
        this.mAsyncOperation = operation;
        this.mAsyncInProgress = true;
        this.logDebug("Starting async operation: " + operation);
    }

    void flagEndAsync() {
        this.logDebug("Ending async operation: " + this.mAsyncOperation);
        this.mAsyncOperation = "";
        this.mAsyncInProgress = false;
    }

    int queryPurchases(Inventory inv, String itemType) throws JSONException, RemoteException {
        this.logDebug("Querying owned items, item type: " + itemType);
        this.logDebug("Package name: " + this.mContext.getPackageName());
        boolean verificationFailed = false;
        String continueToken = null;
        do {
            this.logDebug("Calling getPurchases with continuation token: " + continueToken);
            if (this.mService == null || this.mContext == null) {
                this.logError("Our service and/or our context are null.  Exiting.");
                return -1008;
            }
            Bundle ownedItems = this.mService.getPurchases(3, this.mContext.getPackageName(), itemType, continueToken);
            int response = this.getResponseCodeFromBundle(ownedItems);
            this.logDebug("Owned items response: " + String.valueOf(response));
            if (response != 0) {
                this.logDebug("getPurchases() failed: " + IabHelper.getResponseDesc(response));
                return response;
            }
            if (!(ownedItems.containsKey(RESPONSE_INAPP_ITEM_LIST) && ownedItems.containsKey(RESPONSE_INAPP_PURCHASE_DATA_LIST) && ownedItems.containsKey(RESPONSE_INAPP_SIGNATURE_LIST))) {
                this.logError("Bundle returned from getPurchases() doesn't contain required fields.");
                return -1002;
            }
            ArrayList ownedSkus = ownedItems.getStringArrayList(RESPONSE_INAPP_ITEM_LIST);
            ArrayList purchaseDataList = ownedItems.getStringArrayList(RESPONSE_INAPP_PURCHASE_DATA_LIST);
            ArrayList signatureList = ownedItems.getStringArrayList(RESPONSE_INAPP_SIGNATURE_LIST);
            for (int i = 0; i < purchaseDataList.size(); ++i) {
                String signature;
                String purchaseData = (String)purchaseDataList.get(i);
                Purchase purchase = new Purchase(itemType, purchaseData, signature = (String)signatureList.get(i));
                if (TextUtils.isEmpty((CharSequence)purchase.getToken())) {
                    this.logWarn("BUG: empty/null token!");
                    this.logDebug("Purchase data: " + purchaseData);
                }
                inv.addPurchase(purchase);
            }
            continueToken = ownedItems.getString(INAPP_CONTINUATION_TOKEN);
            this.logDebug("Continuation token: " + continueToken);
        } while (!TextUtils.isEmpty((CharSequence)continueToken));
        return verificationFailed ? -1003 : 0;
    }

    int querySkuDetails(String itemType, Inventory inv, List<String> moreSkus) throws RemoteException, JSONException {
        this.logDebug("Querying SKU details.");
        ArrayList<String> skuList = new ArrayList<String>();
        skuList.addAll(inv.getAllOwnedSkus(itemType));
        if (moreSkus != null) {
            for (String sku : moreSkus) {
                if (skuList.contains(sku)) continue;
                skuList.add(sku);
            }
        }
        if (skuList.size() == 0) {
            this.logDebug("queryPrices: nothing to do because there are no SKUs.");
            return 0;
        }
        Bundle querySkus = new Bundle();
        querySkus.putStringArrayList(GET_SKU_DETAILS_ITEM_LIST, skuList);
        Bundle skuDetails = this.mService.getSkuDetails(3, this.mContext.getPackageName(), itemType, querySkus);
        if (!skuDetails.containsKey(RESPONSE_GET_SKU_DETAILS_LIST)) {
            int response = this.getResponseCodeFromBundle(skuDetails);
            if (response != 0) {
                this.logDebug("getSkuDetails() failed: " + IabHelper.getResponseDesc(response));
                return response;
            }
            this.logError("getSkuDetails() returned a bundle with neither an error nor a detail list.");
            return -1002;
        }
        ArrayList responseList = skuDetails.getStringArrayList(RESPONSE_GET_SKU_DETAILS_LIST);
        for (String thisResponse : responseList) {
            SkuDetails d = new SkuDetails(itemType, thisResponse);
            this.logDebug("Got sku details: " + d);
            inv.addSkuDetails(d);
        }
        return 0;
    }

    void consumeAsyncInternal(final List<Purchase> purchases, final OnConsumeFinishedListener singleListener, final OnConsumeMultiFinishedListener multiListener) {
        final Handler handler = new Handler();
        try {
            this.flagStartAsync("consume");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                final ArrayList<IabResult> results = new ArrayList<IabResult>();
                for (Purchase purchase : purchases) {
                    try {
                        IabHelper.this.consume(purchase);
                        results.add(new IabResult(0, "Successful consume of sku " + purchase.getSku()));
                    }
                    catch (IabException ex) {
                        results.add(ex.getResult());
                    }
                }
                IabHelper.this.flagEndAsync();
                if (!IabHelper.this.mDisposed && singleListener != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            singleListener.onConsumeFinished((Purchase)purchases.get(0), (IabResult)results.get(0));
                        }
                    });
                }
                if (!IabHelper.this.mDisposed && multiListener != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            multiListener.onConsumeMultiFinished(purchases, results);
                        }
                    });
                }
            }
        }).start();
    }

    void logDebug(String msg) {
        if (this.mDebugLog) {
            LogUtils.d(this.mDebugTag, msg);
        }
    }

    void logError(String msg) {
        LogUtils.e(this.mDebugTag, "In-app billing error: " + msg);
    }

    void logWarn(String msg) {
        LogUtils.w(this.mDebugTag, "In-app billing warning: " + msg);
    }

    public static interface OnConsumeMultiFinishedListener {
        public void onConsumeMultiFinished(List<Purchase> var1, List<IabResult> var2);
    }

    public static interface OnConsumeFinishedListener {
        public void onConsumeFinished(Purchase var1, IabResult var2);
    }

    public static interface QueryInventoryFinishedListener {
        public void onQueryInventoryFinished(IabResult var1, Inventory var2);
    }

    public static interface OnIabPurchaseFinishedListener {
        public void onIabPurchaseFinished(IabResult var1, Purchase var2);
    }

    public static interface OnIabSetupFinishedListener {
        public void onIabSetupFinished(IabResult var1);
    }
}

