package com.mobgame.gui;

import android.app.Dialog;
import android.app.DialogFragment;
import android.app.FragmentTransaction;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;

import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.mobgame.MobGameHelper;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.dialog.MobGameDialogWebviewFragment;
import com.mobgame.model.Game;
import com.mobgame.utils.Constants;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Utils;

public class BannerDialogFragment extends DialogFragment {
    private ImageView imgBanner;
    private ImageButton imgClose;
    private DialogInterface.OnDismissListener mOnDismissListener;
    public static BannerDialogFragment newInstance(String urlBanner, String urlDeeplink, String typelink) {
        MobGameHelper.hideNotiFloatButton();
        Bundle args = new Bundle();
        args.putString("url_banner", urlBanner);
        args.putString("url_deep_link", urlDeeplink);
        args.putString("type_link", typelink);
        BannerDialogFragment fragment = new BannerDialogFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        final RelativeLayout root = new RelativeLayout(getActivity());
        root.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

        // creating the fullscreen dialog
        final Dialog dialog = new Dialog(getActivity());
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(root);
        dialog.getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        return dialog;
    }
    @Override
    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (mOnDismissListener != null) {
            mOnDismissListener.onDismiss(dialog);
        }
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        mOnDismissListener = onDismissListener;
    }
    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.dialog_banner, container);
        imgBanner = view.findViewById(R.id.img_banner);
        imgClose = view.findViewById(R.id.btn_close);
        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        Glide.with(view.getContext())
                .load(getArguments().getString("url_banner"))
                .apply(new RequestOptions().override(900,400))
                .into(imgBanner);
        imgBanner.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Game.Ex ex = GameConfigManager.getInstance().getGameConfig().getEx();
                MobGameHelper.showNotiFloatButton(ex);

                if (TextUtils.equals(getArguments().getString("type_link"), Constants.DEEP_LINK_BROWSER)) {
                    startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(getArguments().getString("url_deep_link"))));
                } else {
                    MobGameSDK.getInstance().customUrl( getArguments().getString("url_deep_link"));
                }
                dismiss();

            }
        });

        imgClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Game.Ex ex = GameConfigManager.getInstance().getGameConfig().getEx();
                MobGameHelper.showNotiFloatButton(ex);
                dismiss();
            }
        });
    }
}
