package com.mobgame.api;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;

import com.mobgame.MobGameSDK;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.CharacterInfo;
import com.mobgame.utils.FunTrackingUtil;

import org.jetbrains.annotations.NotNull;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class SaveCharacterTask extends AsyncTask<Void, Void, Void> {
	
	private String roleId;
	private String areaId;
	private String roleName;
	private String areaName;

	public SaveCharacterTask(String areaId, String areaName, String roleId,  String roleName) {
		this.roleId = roleId;
		this.areaId = areaId;
		this.roleName = roleName;
		this.areaName = areaName;
	}

	@Override
	protected Void doInBackground(Void... params) {
		try {
			Context c = MobGameSDK.getApplicationContext();
			CharacterInfo charInfo = new CharacterInfo();
			charInfo.setAreaId(areaId);
			charInfo.setAreaName(areaName);
			charInfo.setRoleId(roleId);
			charInfo.setRoleName(roleName);
			GameConfigManager.getInstance().setCharacterInfo(charInfo);
			
			if (!TextUtils.isEmpty(areaId) && !TextUtils.isEmpty(roleId)) {
				RestfulApi.removeInstance();
				FunTrackingUtil.getInstance().trackCreateCharacterRequest(c , "call");
				RestfulApi api = RestfulApi.getInstance();
				Call<ResponseBody> call = api.saveCharacter(roleId, areaId, roleName, areaName);
				call.enqueue(new Callback<ResponseBody>() {
					@Override
					public void onResponse(@NotNull Call<ResponseBody> call, @NotNull Response<ResponseBody> response) {
						if(response.isSuccessful()){
							FunTrackingUtil.getInstance().trackCreateCharacterRequest(c , "success");
						}
					}

					@Override
					public void onFailure(@NotNull Call<ResponseBody> call, @NotNull Throwable t) {
						FunTrackingUtil.getInstance().trackCreateCharacterRequest(c , "fail");
					}
				});
//				call.execute();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
}