/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.urlimageviewhelper;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import android.widget.ImageView;
import com.koushikdutta.urlimageviewhelper.AssetUrlDownloader;
import com.koushikdutta.urlimageviewhelper.ContactContentUrlDownloader;
import com.koushikdutta.urlimageviewhelper.ContentUrlDownloader;
import com.koushikdutta.urlimageviewhelper.DrawableCache;
import com.koushikdutta.urlimageviewhelper.FileUrlDownloader;
import com.koushikdutta.urlimageviewhelper.HttpUrlDownloader;
import com.koushikdutta.urlimageviewhelper.LruBitmapCache;
import com.koushikdutta.urlimageviewhelper.UrlDownloader;
import com.koushikdutta.urlimageviewhelper.UrlImageViewCallback;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.http.NameValuePair;

public final class UrlImageViewHelper {
    static Resources mResources;
    static DisplayMetrics mMetrics;
    private static boolean mUseBitmapScaling;
    public static final int CACHE_DURATION_INFINITE = Integer.MAX_VALUE;
    public static final int CACHE_DURATION_ONE_DAY = 86400000;
    public static final int CACHE_DURATION_TWO_DAYS = 172800000;
    public static final int CACHE_DURATION_THREE_DAYS = 259200000;
    public static final int CACHE_DURATION_FOUR_DAYS = 345600000;
    public static final int CACHE_DURATION_FIVE_DAYS = 432000000;
    public static final int CACHE_DURATION_SIX_DAYS = 518400000;
    public static final int CACHE_DURATION_ONE_WEEK = 604800000;
    private static boolean mHasCleaned;
    private static HttpUrlDownloader mHttpDownloader;
    private static ContentUrlDownloader mContentDownloader;
    private static ContactContentUrlDownloader mContactDownloader;
    private static AssetUrlDownloader mAssetDownloader;
    private static FileUrlDownloader mFileDownloader;
    private static ArrayList<UrlDownloader> mDownloaders;
    private static RequestPropertiesCallback mRequestPropertiesCallback;
    private static DrawableCache mLiveCache;
    private static LruBitmapCache mDeadCache;
    private static HashSet<Bitmap> mAllCache;
    private static Hashtable<ImageView, String> mPendingViews;
    private static Hashtable<String, ArrayList<ImageView>> mPendingDownloads;

    static void clog(String format, Object ... args) {
        if (args.length == 0) {
            String log = format;
        } else {
            String log = String.format(format, args);
        }
    }

    public static int copyStream(InputStream input, OutputStream output) throws IOException {
        int read;
        byte[] stuff = new byte[8192];
        int total = 0;
        while ((read = input.read(stuff)) != -1) {
            output.write(stuff, 0, read);
            total += read;
        }
        return total;
    }

    private static void prepareResources(Context context) {
        if (mMetrics != null) {
            return;
        }
        mMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(mMetrics);
        AssetManager mgr = context.getAssets();
        mResources = new Resources(mgr, mMetrics, context.getResources().getConfiguration());
    }

    public static void setUseBitmapScaling(boolean useBitmapScaling) {
        mUseBitmapScaling = useBitmapScaling;
    }

    public static boolean getUseBitmapScaling() {
        return mUseBitmapScaling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap loadBitmapFromStream(Context context, String url, String filename, int targetWidth, int targetHeight) {
        UrlImageViewHelper.prepareResources(context);
        InputStream stream = null;
        UrlImageViewHelper.clog("Decoding: " + url + " " + filename, new Object[0]);
        try {
            BitmapFactory.Options o = null;
            if (mUseBitmapScaling) {
                o = new BitmapFactory.Options();
                o.inJustDecodeBounds = true;
                stream = new BufferedInputStream(new FileInputStream(filename), 8192);
                BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)o);
                stream.close();
                int scale = 0;
                while (o.outWidth >> scale > targetWidth || o.outHeight >> scale > targetHeight) {
                    ++scale;
                }
                o = new BitmapFactory.Options();
                o.inSampleSize = 1 << scale;
            }
            stream = new BufferedInputStream(new FileInputStream(filename), 8192);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)o);
            UrlImageViewHelper.clog(String.format("Loaded bitmap (%dx%d).", bitmap.getWidth(), bitmap.getHeight()), new Object[0]);
            Bitmap bitmap2 = bitmap;
            return bitmap2;
        }
        catch (IOException e) {
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Log.w((String)"UrlImageViewHelper", (String)"Failed to close FileInputStream", (Throwable)e);
                }
            }
        }
    }

    public static void setUrlDrawable(ImageView imageView, String url, int defaultResource) {
        UrlImageViewHelper.setUrlDrawable(imageView.getContext(), imageView, url, defaultResource, 259200000L);
    }

    public static void setUrlDrawable(ImageView imageView, String url) {
        UrlImageViewHelper.setUrlDrawable(imageView.getContext(), imageView, url, null, 259200000L, null);
    }

    public static void loadUrlDrawable(Context context, String url) {
        UrlImageViewHelper.setUrlDrawable(context, null, url, null, 259200000L, null);
    }

    public static void setUrlDrawable(ImageView imageView, String url, Drawable defaultDrawable) {
        UrlImageViewHelper.setUrlDrawable(imageView.getContext(), imageView, url, defaultDrawable, 259200000L, null);
    }

    public static void setUrlDrawable(ImageView imageView, String url, int defaultResource, long cacheDurationMs) {
        UrlImageViewHelper.setUrlDrawable(imageView.getContext(), imageView, url, defaultResource, cacheDurationMs);
    }

    public static void loadUrlDrawable(Context context, String url, long cacheDurationMs) {
        UrlImageViewHelper.setUrlDrawable(context, null, url, null, cacheDurationMs, null);
    }

    public static void setUrlDrawable(ImageView imageView, String url, Drawable defaultDrawable, long cacheDurationMs) {
        UrlImageViewHelper.setUrlDrawable(imageView.getContext(), imageView, url, defaultDrawable, cacheDurationMs, null);
    }

    private static void setUrlDrawable(Context context, ImageView imageView, String url, int defaultResource, long cacheDurationMs) {
        Drawable d = null;
        if (defaultResource != 0) {
            d = imageView.getResources().getDrawable(defaultResource);
        }
        UrlImageViewHelper.setUrlDrawable(context, imageView, url, d, cacheDurationMs, null);
    }

    public static void setUrlDrawable(ImageView imageView, String url, int defaultResource, UrlImageViewCallback callback) {
        UrlImageViewHelper.setUrlDrawable(imageView.getContext(), imageView, url, defaultResource, 259200000L, callback);
    }

    public static void setUrlDrawable(ImageView imageView, String url, UrlImageViewCallback callback) {
        UrlImageViewHelper.setUrlDrawable(imageView.getContext(), imageView, url, null, 259200000L, callback);
    }

    public static void loadUrlDrawable(Context context, String url, UrlImageViewCallback callback) {
        UrlImageViewHelper.setUrlDrawable(context, null, url, null, 259200000L, callback);
    }

    public static void setUrlDrawable(ImageView imageView, String url, Drawable defaultDrawable, UrlImageViewCallback callback) {
        UrlImageViewHelper.setUrlDrawable(imageView.getContext(), imageView, url, defaultDrawable, 259200000L, callback);
    }

    public static void setUrlDrawable(ImageView imageView, String url, int defaultResource, long cacheDurationMs, UrlImageViewCallback callback) {
        UrlImageViewHelper.setUrlDrawable(imageView.getContext(), imageView, url, defaultResource, cacheDurationMs, callback);
    }

    public static void loadUrlDrawable(Context context, String url, long cacheDurationMs, UrlImageViewCallback callback) {
        UrlImageViewHelper.setUrlDrawable(context, null, url, null, cacheDurationMs, callback);
    }

    public static void setUrlDrawable(ImageView imageView, String url, Drawable defaultDrawable, long cacheDurationMs, UrlImageViewCallback callback) {
        UrlImageViewHelper.setUrlDrawable(imageView.getContext(), imageView, url, defaultDrawable, cacheDurationMs, callback);
    }

    private static void setUrlDrawable(Context context, ImageView imageView, String url, int defaultResource, long cacheDurationMs, UrlImageViewCallback callback) {
        Drawable d = null;
        if (defaultResource != 0) {
            d = imageView.getResources().getDrawable(defaultResource);
        }
        UrlImageViewHelper.setUrlDrawable(context, imageView, url, d, cacheDurationMs, callback);
    }

    private static boolean isNullOrEmpty(CharSequence s) {
        return s == null || s.equals("") || s.equals("null") || s.equals("NULL");
    }

    public static String getFilenameForUrl(String url) {
        return url.hashCode() + ".urlimage";
    }

    public static void cleanup(Context context, long age) {
        if (mHasCleaned) {
            return;
        }
        mHasCleaned = true;
        try {
            String[] files = context.getFilesDir().list();
            if (files == null) {
                return;
            }
            for (String file : files) {
                if (!file.endsWith(".urlimage")) continue;
                File f = new File(context.getFilesDir().getAbsolutePath() + '/' + file);
                if (System.currentTimeMillis() <= f.lastModified() + age) continue;
                f.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void cleanup(Context context) {
        UrlImageViewHelper.cleanup(context, 604800000L);
    }

    private static boolean checkCacheDuration(File file, long cacheDurationMs) {
        return cacheDurationMs == Integer.MAX_VALUE || System.currentTimeMillis() < file.lastModified() + cacheDurationMs;
    }

    public static Bitmap getCachedBitmap(String url) {
        Drawable drawable;
        if (url == null) {
            return null;
        }
        Bitmap ret = null;
        if (mDeadCache != null) {
            ret = (Bitmap)mDeadCache.get(url);
        }
        if (ret != null) {
            return ret;
        }
        if (mLiveCache != null && (drawable = (Drawable)mLiveCache.get(url)) instanceof ZombieDrawable) {
            return ((ZombieDrawable)drawable).getBitmap();
        }
        return null;
    }

    private static void setUrlDrawable(final Context context, final ImageView imageView, final String url, final Drawable defaultDrawable, long cacheDurationMs, final UrlImageViewCallback callback) {
        ArrayList<ImageView> currentDownload;
        assert (Looper.getMainLooper().getThread() == Thread.currentThread()) : "setUrlDrawable and loadUrlDrawable should only be called from the main thread.";
        UrlImageViewHelper.cleanup(context);
        if (UrlImageViewHelper.isNullOrEmpty(url)) {
            if (imageView != null) {
                mPendingViews.remove(imageView);
                imageView.setImageDrawable(defaultDrawable);
            }
            return;
        }
        if (mMetrics == null) {
            UrlImageViewHelper.prepareResources(context);
        }
        int tw = UrlImageViewHelper.mMetrics.widthPixels;
        int th = UrlImageViewHelper.mMetrics.heightPixels;
        final String filename = context.getFileStreamPath(UrlImageViewHelper.getFilenameForUrl(url)).getAbsolutePath();
        File file = new File(filename);
        if (mDeadCache == null) {
            mDeadCache = new LruBitmapCache(UrlImageViewHelper.getHeapSize(context) / 8);
        }
        Object drawable = null;
        Bitmap bitmap = (Bitmap)mDeadCache.remove(url);
        if (bitmap != null) {
            UrlImageViewHelper.clog("zombie load: " + url, new Object[0]);
        } else {
            drawable = (Drawable)mLiveCache.get(url);
        }
        if (drawable != null || bitmap != null) {
            UrlImageViewHelper.clog("Cache hit on: " + url, new Object[0]);
            if (file.exists() && !UrlImageViewHelper.checkCacheDuration(file, cacheDurationMs)) {
                UrlImageViewHelper.clog("Cache hit, but file is stale. Forcing reload: " + url, new Object[0]);
                if (drawable != null && drawable instanceof ZombieDrawable) {
                    ((ZombieDrawable)((Object)drawable)).headshot();
                }
                drawable = null;
                bitmap = null;
            } else {
                UrlImageViewHelper.clog("Using cached: " + url, new Object[0]);
            }
        }
        if (drawable != null || bitmap != null) {
            if (imageView != null) {
                mPendingViews.remove(imageView);
                if (drawable instanceof ZombieDrawable) {
                    drawable = ((ZombieDrawable)((Object)drawable)).clone(mResources);
                } else if (bitmap != null) {
                    drawable = new ZombieDrawable(url, mResources, bitmap);
                }
                imageView.setImageDrawable(drawable);
            }
            if (callback != null) {
                if (bitmap == null && drawable instanceof ZombieDrawable) {
                    bitmap = ((ZombieDrawable)((Object)drawable)).getBitmap();
                }
                callback.onLoaded(imageView, bitmap, url, true);
            }
            return;
        }
        UrlImageViewHelper.clog("Waiting for " + url + " " + imageView, new Object[0]);
        if (imageView != null) {
            imageView.setImageDrawable(defaultDrawable);
            mPendingViews.put(imageView, url);
        }
        if ((currentDownload = mPendingDownloads.get(url)) != null) {
            if (imageView != null) {
                currentDownload.add(imageView);
            }
            return;
        }
        final ArrayList<ImageView> downloads = new ArrayList<ImageView>();
        if (imageView != null) {
            downloads.add(imageView);
        }
        mPendingDownloads.put(url, downloads);
        final int targetWidth = tw <= 0 ? Integer.MAX_VALUE : tw;
        final int targetHeight = th <= 0 ? Integer.MAX_VALUE : th;
        final Loader loader = new Loader(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDownloadComplete(UrlDownloader downloader, InputStream in, String existingFilename) {
                try {
                    assert (in == null || existingFilename == null);
                    if (in == null && existingFilename == null) {
                        return;
                    }
                    String targetFilename = filename;
                    if (in != null) {
                        in = new BufferedInputStream(in, 8192);
                        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(filename), 8192);
                        UrlImageViewHelper.copyStream(in, fout);
                        ((OutputStream)fout).close();
                    } else {
                        targetFilename = existingFilename;
                    }
                    this.result = UrlImageViewHelper.loadBitmapFromStream(context, url, targetFilename, targetWidth, targetHeight);
                }
                catch (Exception ex) {
                    new File(filename).delete();
                }
                finally {
                    if (downloader != null && !downloader.allowCache()) {
                        new File(filename).delete();
                    }
                }
            }
        };
        final Runnable completion = new Runnable(){

            @Override
            public void run() {
                assert (Looper.myLooper().equals(Looper.getMainLooper()));
                Bitmap bitmap = loader.result;
                ZombieDrawable usableResult = null;
                if (bitmap != null) {
                    usableResult = new ZombieDrawable(url, mResources, bitmap);
                }
                if (usableResult == null) {
                    UrlImageViewHelper.clog("No usable result, defaulting " + url, new Object[0]);
                    usableResult = defaultDrawable;
                    mLiveCache.put(url, usableResult);
                }
                mPendingDownloads.remove(url);
                if (callback != null && imageView == null) {
                    callback.onLoaded(null, loader.result, url, false);
                }
                int waitingCount = 0;
                for (ImageView iv : downloads) {
                    String pendingUrl = (String)mPendingViews.get(iv);
                    if (!url.equals(pendingUrl)) {
                        UrlImageViewHelper.clog("Ignoring out of date request to update view for " + url + " " + pendingUrl + " " + iv, new Object[0]);
                        continue;
                    }
                    ++waitingCount;
                    mPendingViews.remove(iv);
                    if (usableResult != null) {
                        iv.setImageDrawable((Drawable)usableResult);
                    }
                    if (callback == null || iv != imageView) continue;
                    callback.onLoaded(iv, loader.result, url, false);
                }
                UrlImageViewHelper.clog("Populated: " + waitingCount, new Object[0]);
            }
        };
        if (file.exists()) {
            try {
                if (UrlImageViewHelper.checkCacheDuration(file, cacheDurationMs)) {
                    UrlImageViewHelper.clog("File Cache hit on: " + url + ". " + (System.currentTimeMillis() - file.lastModified()) + "ms old.", new Object[0]);
                    AsyncTask<Void, Void, Void> fileloader = new AsyncTask<Void, Void, Void>(){

                        protected Void doInBackground(Void ... params) {
                            loader.onDownloadComplete(null, null, filename);
                            return null;
                        }

                        protected void onPostExecute(Void result) {
                            completion.run();
                        }
                    };
                    UrlImageViewHelper.executeTask(fileloader);
                    return;
                }
                UrlImageViewHelper.clog("File cache has expired. Refreshing.", new Object[0]);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        for (UrlDownloader downloader : mDownloaders) {
            if (!downloader.canDownloadUrl(url)) continue;
            downloader.download(context, url, filename, loader, completion);
            return;
        }
        imageView.setImageDrawable(defaultDrawable);
    }

    public static ArrayList<UrlDownloader> getDownloaders() {
        return mDownloaders;
    }

    public static RequestPropertiesCallback getRequestPropertiesCallback() {
        return mRequestPropertiesCallback;
    }

    public static void setRequestPropertiesCallback(RequestPropertiesCallback callback) {
        mRequestPropertiesCallback = callback;
    }

    private static int getHeapSize(Context context) {
        return ((ActivityManager)context.getSystemService("activity")).getMemoryClass() * 1024 * 1024;
    }

    public static Bitmap remove(String url) {
        new File(UrlImageViewHelper.getFilenameForUrl(url)).delete();
        Drawable drawable = (Drawable)mLiveCache.remove(url);
        if (drawable instanceof ZombieDrawable) {
            ZombieDrawable zombie = (ZombieDrawable)drawable;
            Bitmap ret = zombie.getBitmap();
            zombie.headshot();
            return ret;
        }
        return null;
    }

    static void executeTask(AsyncTask<Void, Void, Void> task) {
        if (Build.VERSION.SDK_INT < 11) {
            task.execute((Object[])new Void[0]);
        } else {
            UrlImageViewHelper.executeTaskHoneycomb(task);
        }
    }

    @TargetApi(value=11)
    private static void executeTaskHoneycomb(AsyncTask<Void, Void, Void> task) {
        task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public static int getPendingDownloads() {
        return mPendingDownloads.size();
    }

    static {
        mUseBitmapScaling = true;
        mHasCleaned = false;
        mHttpDownloader = new HttpUrlDownloader();
        mContentDownloader = new ContentUrlDownloader();
        mContactDownloader = new ContactContentUrlDownloader();
        mAssetDownloader = new AssetUrlDownloader();
        mFileDownloader = new FileUrlDownloader();
        mDownloaders = new ArrayList();
        mDownloaders.add(mHttpDownloader);
        mDownloaders.add(mContactDownloader);
        mDownloaders.add(mContentDownloader);
        mDownloaders.add(mAssetDownloader);
        mDownloaders.add(mFileDownloader);
        mLiveCache = DrawableCache.getInstance();
        mAllCache = new HashSet();
        mPendingViews = new Hashtable();
        mPendingDownloads = new Hashtable();
    }

    private static class ZombieDrawable
    extends BitmapDrawable {
        Brains mBrains;
        String mUrl;

        public ZombieDrawable(String url, Resources resources, Bitmap bitmap) {
            this(url, resources, bitmap, new Brains());
        }

        private ZombieDrawable(String url, Resources resources, Bitmap bitmap, Brains brains) {
            super(resources, bitmap);
            this.mUrl = url;
            this.mBrains = brains;
            mAllCache.add(bitmap);
            mDeadCache.remove(url);
            mLiveCache.put(url, this);
            ++this.mBrains.mRefCounter;
        }

        public ZombieDrawable clone(Resources resources) {
            return new ZombieDrawable(this.mUrl, resources, this.getBitmap(), this.mBrains);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            --this.mBrains.mRefCounter;
            if (this.mBrains.mRefCounter == 0) {
                if (!this.mBrains.mHeadshot) {
                    mDeadCache.put(this.mUrl, this.getBitmap());
                }
                mAllCache.remove(this.getBitmap());
                mLiveCache.remove(this.mUrl);
                UrlImageViewHelper.clog("Zombie GC event " + this.mUrl, new Object[0]);
            }
        }

        public void headshot() {
            UrlImageViewHelper.clog("BOOM! Headshot: " + this.mUrl, new Object[0]);
            this.mBrains.mHeadshot = true;
            mLiveCache.remove(this.mUrl);
            mAllCache.remove(this.getBitmap());
        }

        private static class Brains {
            int mRefCounter;
            boolean mHeadshot;

            private Brains() {
            }
        }
    }

    public static interface RequestPropertiesCallback {
        public ArrayList<NameValuePair> getHeadersForRequest(Context var1, String var2);
    }

    private static abstract class Loader
    implements UrlDownloader.UrlDownloaderCallback {
        Bitmap result;

        private Loader() {
        }
    }
}

