/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.ArrayAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.facebook.FacebookSdk;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.component.EventClientManager;
import com.mobgame.gui.MobGamePagerFragment2;
import com.mobgame.gui.MobGameWebFragment2;
import com.mobgame.gui.MobGameWebView2;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MobGameLoginActivity
extends AppCompatActivity {
    private static String TAG = MobGameLoginActivity.class.getSimpleName();
    public static String KEY_DATA = "data";
    public static String KEY_ENABLE_AUTOHIDE_HEADER_BAR = "autohide_header_bar";
    public static String KEY_ENABLE_SIDE_MENU = "enable_side_menu";
    public static String KEY_ENABLE_TITLE = "enable_title";
    public static String KEY_IS_PAYMENT_FORM = "is_payment_form";
    public static String KEY_IS_LOGIN_FORM = "is_login_form";
    public static String KEY_IS_DASHBOARD_FORM = "is_dashboard_form";
    public static boolean shouldReload = false;
    private RelativeLayout layoutRoot;
    private View layoutMain;
    private View layoutContent;
    private ImageButton btnBack;
    private ImageButton btnClose;
    private SideMenuAdapter lvAdapter;
    private MobGamePagerFragment2 fragContent;
    private MobPagerAdapter adapter;
    private float density;
    private int currentPage;
    private boolean isEnableAutohideHeaderBar = false;
    private boolean isEnableSideMenu = true;
    private boolean isEnableTitle = true;
    private boolean isScrollAnimating;
    private boolean isLockingHeaderBar;
    private boolean isLoginForm = false;
    private boolean isDashboardForm = false;
    private boolean isPaymentForm = false;
    private String TAG_FRAGMENT = "fragment_web";
    private ViewPager.SimpleOnPageChangeListener mOnPageChangeListener = new ViewPager.SimpleOnPageChangeListener(){

        public void onPageSelected(int position) {
            try {
                int itemId;
                if (position != MobGameLoginActivity.this.currentPage) {
                    MobGameLoginActivity.this.currentPage = position;
                    MobGameLoginActivity.this.updateHeaderBar(position);
                    MobGameWebFragment2 fragWeb = MobGameLoginActivity.this.adapter.getItem(MobGameLoginActivity.this.currentPage);
                    MobGameLoginActivity.this.mWebEventListener.onScrollChanged(fragWeb.getWebView(), fragWeb.getScrollX(), fragWeb.getScrollY(), fragWeb.getScrollX(), fragWeb.getScrollY());
                }
                if (NotificationUtils.hasNtf((Context)MobGameLoginActivity.this, itemId = (int)MobGameLoginActivity.this.adapter.getItemId(position))) {
                    NotificationUtils.removeNtf((Context)MobGameLoginActivity.this, itemId);
                    MobGameLoginActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MobGameLoginActivity.this.fragContent.notifyTabsChanged();
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private MobGameWebFragment2.EventListener mWebEventListener = new MobGameWebFragment2.EventListener(){

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            try {
                MobGameLoginActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MobGameWebFragment2 fragWeb = MobGameLoginActivity.this.adapter.getItem(MobGameLoginActivity.this.currentPage);
                        if (MobGameLoginActivity.this.fragContent.countTabs() > 1 && !fragWeb.canGoBack()) {
                            MobGameLoginActivity.this.fragContent.showTabs(true);
                            MobGameLoginActivity.this.isEnableAutohideHeaderBar = true;
                        } else {
                            MobGameLoginActivity.this.fragContent.hideTabs(true);
                            MobGameLoginActivity.this.isEnableAutohideHeaderBar = false;
                        }
                    }
                });
                view.addJavascriptInterface((Object)MobGameLoginActivity.this, "android");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onProgressChanged(WebView view, int progress) {
            try {
                int pos = Integer.parseInt((String)view.getTag());
                if (pos == MobGameLoginActivity.this.currentPage) {
                    MobGameLoginActivity.this.updateHeaderBar(pos);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            try {
                int pos = Integer.parseInt((String)view.getTag());
                if (pos == MobGameLoginActivity.this.currentPage) {
                    MobGameLoginActivity.this.updateHeaderBar(pos);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onScrollChanged(WebView view, int l, int t, int oldl, int oldt) {
            try {
                if (!MobGameLoginActivity.this.isEnableAutohideHeaderBar) {
                    return;
                }
                if (MobGameLoginActivity.this.isLockingHeaderBar) {
                    return;
                }
                MobGameWebView2 webView = (MobGameWebView2)view;
                int n = webView.computeVerticalScrollRange();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onSizeChanged(WebView view, int w, int h, int oldw, int oldh) {
        }
    };
    private Animator.AnimatorListener mHeaderAnimatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animator) {
            try {
                MobGameLoginActivity.this.isScrollAnimating = true;
                MobGameLoginActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ((ViewGroup)MobGameLoginActivity.this.layoutMain).updateViewLayout(MobGameLoginActivity.this.layoutContent, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, MobGameLoginActivity.this.layoutMain.getHeight()));
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onAnimationRepeat(Animator animator) {
        }

        public void onAnimationEnd(Animator animator) {
            try {
                MobGameLoginActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ((ViewGroup)MobGameLoginActivity.this.layoutMain).updateViewLayout(MobGameLoginActivity.this.layoutContent, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, MobGameLoginActivity.this.layoutMain.getHeight()));
                        MobGameLoginActivity.this.fragContent.updateTabs();
                        MobGameLoginActivity.this.isScrollAnimating = false;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onAnimationCancel(Animator animator) {
        }
    };
    private boolean isShowingOfferWall;
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            block17: {
                try {
                    String category = intent.getStringExtra("category");
                    Log.d((String)TAG, (String)("mBroadcastReceiver category: " + category));
                    if ("mobOpenOfferWall".equalsIgnoreCase(category)) {
                        MobGameLoginActivity.this.isShowingOfferWall = true;
                    } else if (!"float_button".equalsIgnoreCase(category)) {
                        MobGameLoginActivity.this.isShowingOfferWall = false;
                    }
                    if ("gcm".equalsIgnoreCase(category)) {
                        String strId = intent.getStringExtra("id");
                        if (strId != null) {
                            MobGameLoginActivity.this.fragContent.notifyTabsChanged();
                        }
                        break block17;
                    }
                    if ("dashboard".equalsIgnoreCase(category)) {
                        try {
                            MobGameLoginActivity.this.fragContent.hideTabs(false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            String strUrls = intent.getStringExtra("urls");
                            JSONArray urls = new JSONArray(strUrls);
                            MobGameLoginActivity.this.loadUrls(urls);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block17;
                    }
                    if ("finish_facebook_upgrade".equalsIgnoreCase(category)) {
                        MobGameLoginActivity.this.finish();
                    } else if ("dashboard_close".equalsIgnoreCase(category)) {
                        MobGameLoginActivity.this.finish();
                    } else if ("reload".equalsIgnoreCase(category)) {
                        MobGameLoginActivity.this.reload();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    };
    private boolean isOfferWallOpened = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_mobile);
        FacebookSdk.sdkInitialize((Context)this.getApplicationContext());
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            this.isEnableAutohideHeaderBar = bundle.getBoolean(KEY_ENABLE_AUTOHIDE_HEADER_BAR, true);
            this.isEnableSideMenu = bundle.getBoolean(KEY_ENABLE_SIDE_MENU, true);
            this.isEnableTitle = bundle.getBoolean(KEY_ENABLE_SIDE_MENU, true);
            this.isLoginForm = bundle.getBoolean(KEY_IS_LOGIN_FORM);
            this.isDashboardForm = bundle.getBoolean(KEY_IS_DASHBOARD_FORM);
            this.isPaymentForm = bundle.getBoolean(KEY_IS_PAYMENT_FORM);
        }
        this.layoutRoot = (RelativeLayout)this.findViewById(R.id.layout_root);
        this.layoutMain = this.findViewById(R.id.layout_main);
        this.layoutContent = this.findViewById(R.id.layout_content);
        this.btnBack = (ImageButton)this.findViewById(R.id.btn_back);
        this.btnClose = (ImageButton)this.findViewById(R.id.btn_close);
        try {
            this.density = DeviceUtils.getDensity((Context)this);
            this.initHeaderBar();
            this.fragContent = new MobGamePagerFragment2((Activity)this);
            this.fragContent.addOnPageChangeListener(this.mOnPageChangeListener);
            this.fragContent.setWebEventListener(this.mWebEventListener);
            FragmentManager fm = this.getSupportFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            ft.add(this.layoutContent.getId(), (Fragment)this.fragContent, this.TAG_FRAGMENT);
            ft.commit();
            String data = "";
            try {
                data = this.getIntent().getExtras().getString(KEY_DATA);
                JSONArray items = new JSONArray(data);
                this.loadUrls(items);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onResume() {
        super.onResume();
        try {
            LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mBroadcastReceiver, new IntentFilter("com.mobgame.broadcast"));
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "float_button");
            intent.putExtra("message", "hide");
            LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
            if (shouldReload) {
                this.reload();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onPause() {
        try {
            LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mBroadcastReceiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onPause();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            MobGameSDK.getInstance().onActivityResult(requestCode, resultCode, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        try {
            Log.i((String)TAG, (String)("onBackPressed:" + this.currentPage));
            MobGameWebFragment2 fragWeb = this.adapter.getItem(this.currentPage);
            if (fragWeb.canGoBack()) {
                fragWeb.goBack();
            } else {
                MobGameSDK.getInstance().close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadUrls(JSONArray items) {
        try {
            JSONObject item;
            int i;
            if (this.adapter == null) {
                this.adapter = new MobPagerAdapter(this.getSupportFragmentManager());
            }
            this.currentPage = 0;
            JSONArray revItems = new JSONArray();
            for (i = items.length() - 1; i >= 0; --i) {
                try {
                    item = items.getJSONObject(i);
                    revItems.put((Object)item);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (i = revItems.length() - 1; i >= 0; --i) {
                try {
                    item = revItems.getJSONObject(i);
                    if (!item.has("id") || !NotificationUtils.hasNtf((Context)this, item.getInt("id"))) continue;
                    this.currentPage = i;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                this.adapter.setItems(revItems);
                this.fragContent.setAdapter(this.adapter, this.currentPage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reload() {
        try {
            shouldReload = false;
            for (int i = 0; i < this.adapter.getCount(); ++i) {
                MobGameWebFragment2 frag = this.adapter.getItem(i);
                frag.reload();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initHeaderBar() {
        try {
            this.btnBack.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MobGameLoginActivity.this.onBackPressed();
                }
            });
            this.btnClose.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        if (MobGameLoginActivity.this.isLoginForm) {
                            FunTrackingUtil.getInstance().trackEvent(MobGameLoginActivity.this.getApplicationContext(), "ft_login_closed", null);
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    EventClientManager.getInstance((Context)MobGameLoginActivity.this).saveEventClient("normal", "ft_login_closed", null);
                                }
                            }).start();
                            MobGameLoginActivity.this.isLoginForm = false;
                        } else if (MobGameLoginActivity.this.isPaymentForm) {
                            FunTrackingUtil.getInstance().trackEvent(MobGameLoginActivity.this.getApplicationContext(), "ft_payment_closed", null);
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    EventClientManager.getInstance((Context)MobGameLoginActivity.this).saveEventClient("normal", "ft_payment_closed", null);
                                }
                            }).start();
                            MobGameLoginActivity.this.isPaymentForm = false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        MobGameLoginActivity.this.isDashboardForm = false;
                        MobGameLoginActivity.this.isLoginForm = false;
                        MobGameLoginActivity.this.isPaymentForm = false;
                    }
                    MobGameSDK.getInstance().close();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateHeaderBar(int pos) {
        try {
            final MobGameWebFragment2 fragWeb = this.adapter.getItem(pos);
            if (fragWeb != null && fragWeb.isAdded()) {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        String title = fragWeb.getTitle();
                        if (title.contains(Constants.DOMAIN_NAME) || title.equalsIgnoreCase("about:blank") || title.equalsIgnoreCase("website not available") || title.contains("data:text/html") || title.startsWith("http://") || title.startsWith("https://")) {
                            title = "";
                        }
                        if (!Utils.isOnline(MobGameLoginActivity.this.getApplicationContext())) {
                            title = "Website not available";
                        }
                        if (fragWeb.canGoBack()) {
                            MobGameLoginActivity.this.btnBack.setVisibility(0);
                        } else {
                            MobGameLoginActivity.this.btnBack.setVisibility(8);
                        }
                    }
                });
                String inject = "if (typeof getShareUrl === 'function') {\t\t\t\t\t\t\t\ttry {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twindow.android.onGetShareUrl(getShareUrl());\t\t\t\t\t} catch (err) {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twindow.android.onGetShareUrl('');\t\t\t\t\t\t\t\t\tconsole.log(err);\t\t\t\t\t\t\t\t\t\t\t\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t} else {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twindow.android.onGetShareUrl('');\t\t\t\t\t\t\t\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
                fragWeb.invokeJavascript(inject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showProgressBar() {
        try {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void onGetShareUrl(String value) {
        try {
            JSONObject obj = new JSONObject(value);
            String shareUrl = obj.getString("url");
            String shareTitle = obj.getString("title");
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private class MobPagerAdapter
    extends FragmentPagerAdapter {
        private ArrayList<MobGameWebFragment2> fragments;
        private FragmentManager fm;
        private JSONArray items;

        public MobPagerAdapter(FragmentManager fm) {
            super(fm);
            this.fragments = new ArrayList();
            this.fm = fm;
        }

        public void setItems(JSONArray items) {
            this.releaseFragments();
            this.items = items;
            this.fragments = new ArrayList();
            for (int i = 0; i < items.length(); ++i) {
                try {
                    JSONObject item = items.getJSONObject(i);
                    String url = item.getString("action");
                    MobGameWebFragment2 frag = new MobGameWebFragment2(url);
                    frag.setEventListener(MobGameLoginActivity.this.mWebEventListener);
                    frag.setWebViewTag(i + "");
                    this.fragments.add(frag);
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Log.d((String)TAG, (String)"crash on function setItems");
                }
            }
        }

        public MobGameWebFragment2 getItem(int position) {
            try {
                return this.fragments.get(position);
            }
            catch (Exception e) {
                return null;
            }
        }

        public long getItemId(int position) {
            try {
                return this.items.getJSONObject(position).getInt("id");
            }
            catch (Exception e) {
                return -1L;
            }
        }

        public int getCount() {
            try {
                return this.fragments.size();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public int getItemPosition(Object item) {
            return -2;
        }

        public CharSequence getPageTitle(int position) {
            try {
                JSONObject item = this.items.getJSONObject(position);
                int id2 = item.getInt("id");
                if (item.has("title")) {
                    String title = item.getString("title").toUpperCase(Locale.ENGLISH);
                    if (NotificationUtils.hasNtf((Context)MobGameLoginActivity.this, id2)) {
                        Drawable image = Res.drawable((Context)MobGameLoginActivity.this, R.drawable.ic_notification_tab_strip);
                        image.setBounds(0, 0, image.getIntrinsicWidth(), image.getIntrinsicHeight());
                        SpannableString sb = new SpannableString((CharSequence)(title + "  "));
                        ImageSpan imageSpan = new ImageSpan(image, 1);
                        sb.setSpan((Object)imageSpan, title.length() + 1, title.length() + 2, 18);
                        return sb;
                    }
                    return title;
                }
                return "Tab " + position;
            }
            catch (Exception e) {
                return "Tab " + position;
            }
        }

        private void releaseFragments() {
            try {
                if (this.fragments != null) {
                    for (MobGameWebFragment2 frag : this.fragments) {
                        frag.stopLoading();
                        this.fm.beginTransaction().remove((Fragment)frag).commit();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class SideMenuAdapter
    extends ArrayAdapter<SideMenuModel> {
        private Activity context;
        private List<SideMenuModel> items;

        public SideMenuAdapter(Activity activity, List<SideMenuModel> items) {
            super((Context)activity, R.layout.sidemenu_item);
            this.context = activity;
            this.items = items;
        }

        public SideMenuModel getItem(int position) {
            return this.items.get(position);
        }

        public int getCount() {
            return this.items.size();
        }

        @SuppressLint(value={"InflateParams"})
        public View getView(int position, View convertView, ViewGroup parent) {
            LayoutInflater inflator = this.context.getLayoutInflater();
            View v = inflator.inflate(R.layout.sidemenu_item, null);
            ImageView imageView = (ImageView)v.findViewById(R.id.image);
            imageView.setScaleType(ImageView.ScaleType.FIT_XY);
            TextView textView = (TextView)v.findViewById(R.id.label);
            ImageView imageView2 = (ImageView)v.findViewById(R.id.image2);
            textView.setText((CharSequence)this.items.get(position).label);
            Glide.with((Context)MobGameLoginActivity.this.getApplicationContext()).load(this.items.get(position).iconUrl).into(imageView);
            switch (this.items.get((int)position).type) {
                case 1: {
                    imageView2.setImageResource(R.drawable.ic_external_sm);
                    imageView2.setVisibility(0);
                    break;
                }
                default: {
                    imageView2.setVisibility(8);
                }
            }
            try {
                for (int i = 0; i < this.items.get(position).getIds().length; ++i) {
                    if (!NotificationUtils.hasNtf((Context)this.context, this.items.get(position).getIds()[i])) continue;
                    imageView2.setImageResource(R.drawable.ic_notification);
                    imageView2.setVisibility(0);
                }
                if (NotificationUtils.hasNtf((Context)this.context, this.items.get(position).getId())) {
                    imageView2.setImageResource(R.drawable.ic_notification);
                    imageView2.setVisibility(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return v;
        }
    }

    private class SideMenuModel {
        private int id;
        private int[] ids;
        private String iconUrl;
        private String label;
        private String command;
        private String params;
        private JSONArray items;
        int type = 0;
        static final int DEFAULT = 0;
        static final int EXTERNAL = 1;

        public int[] getIds() {
            return this.ids;
        }

        public void setIds(int[] ids) {
            this.ids = ids;
        }

        public SideMenuModel(int id2, String imageUrl, String label) {
            this(id2, imageUrl, label, 0);
        }

        public SideMenuModel(int id2, String imageUrl, String label, int type) {
            this.id = id2;
            this.iconUrl = imageUrl;
            this.label = label;
            this.type = type;
        }

        public int getId() {
            return this.id;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setItems(JSONArray items) {
            this.items = items;
        }

        public void setAction(String command, String params) {
            this.command = command;
            this.params = params;
        }

        public String getCommand() {
            return this.command;
        }

        public String getParams() {
            return this.params;
        }

        public boolean isTabbed() {
            return this.items != null && this.items.length() > 1;
        }

        public boolean hasNtf() {
            if (NotificationUtils.hasNtf((Context)MobGameLoginActivity.this, this.id)) {
                return true;
            }
            if (this.isTabbed()) {
                for (int i = 0; i < this.items.length(); ++i) {
                    try {
                        JSONObject item = this.items.getJSONObject(i);
                        int id2 = item.getInt("id");
                        if (NotificationUtils.hasNtf((Context)MobGameLoginActivity.this, id2)) {
                            return true;
                        }
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
            return false;
        }

        public JSONArray getItems() {
            return this.items;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

