/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.component;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.tasks.Task;
import java.io.IOException;

public final class GoogleAuthManager {
    private static final String TAG = GoogleAuthManager.class.getSimpleName();
    private static GoogleAuthManager INSTANCE;
    private static final int REQUEST_GOOGLE_PLAY_SERVICES = 412;
    private GoogleSignInClient mGoogleSignInClient;
    private boolean mResolvingError = false;
    private GooglePlusResultCallback googlePlusResultCallback;
    private Activity activity;
    private String SCOPE = "oauth2:https://www.googleapis.com/auth/userinfo.profile";

    public static GoogleAuthManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GoogleAuthManager();
        }
        return INSTANCE;
    }

    private GoogleAuthManager() {
    }

    void init(Activity activity) {
        try {
            this.activity = activity;
            GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail().build();
            this.mGoogleSignInClient = GoogleSignIn.getClient((Activity)activity, (GoogleSignInOptions)gso);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        block11: {
            try {
                if (requestCode != 0) break block11;
                try {
                    Task signinTask = GoogleSignIn.getSignedInAccountFromIntent((Intent)data);
                    GoogleSignInAccount account = (GoogleSignInAccount)signinTask.getResult(ApiException.class);
                    if (account != null) {
                        String str = account.getIdToken();
                        Log.d((String)"TAG ", (String)("GGOOOOOOO : " + str));
                        if (this.googlePlusResultCallback != null) {
                            Log.d((String)"TAG ", (String)"GGOOOOOOO");
                            new GetToken(this.activity, this.SCOPE, account.getEmail(), account, this.googlePlusResultCallback).execute(new Void[0]);
                        }
                    } else if (this.googlePlusResultCallback != null) {
                        this.googlePlusResultCallback.onLoginError("Google Signin Error", -1);
                    }
                }
                catch (ApiException e) {
                    Log.w((String)TAG, (String)("signInResult:failed code=" + e.getStatusCode()));
                    if (e.getStatusCode() == 12502) {
                        if (this.googlePlusResultCallback != null) {
                            this.googlePlusResultCallback.onLoginError("Google Signin Error", 12502);
                        }
                        break block11;
                    }
                    if (this.googlePlusResultCallback != null) {
                        this.googlePlusResultCallback.onLoginError("Google Signin Error", -1);
                    }
                    Log.d((String)TAG, (String)"onActivityResult: Google Signin Error, account = null");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void login(Activity activity, GooglePlusResultCallback googlePlusResultCallback) {
        try {
            this.googlePlusResultCallback = googlePlusResultCallback;
            Intent signInIntent = this.mGoogleSignInClient.getSignInIntent();
            activity.startActivityForResult(signInIntent, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void logout() {
        try {
            GoogleSignInAccount account = GoogleSignIn.getLastSignedInAccount((Context)this.activity);
            if (account != null && this.mGoogleSignInClient != null) {
                this.mGoogleSignInClient.signOut();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getToken(Activity activity, String email, String scope) throws IOException, GoogleAuthException {
        return GoogleAuthUtil.getToken((Context)activity, (String)email, (String)scope);
    }

    public boolean isGoogleServiceAvailable(Activity activity) {
        try {
            GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
            int result = googleAPI.isGooglePlayServicesAvailable((Context)activity);
            if (result != 0) {
                if (googleAPI.isUserResolvableError(result)) {
                    googleAPI.getErrorDialog(activity, result, 412).show();
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    class GetToken
    extends AsyncTask<Void, Void, String> {
        Activity mActivity;
        String mScope;
        String mEmail;
        GooglePlusResultCallback mCallback;
        GoogleSignInAccount mGogleSignin;

        public GetToken(Activity activity, String scope, String email, GoogleSignInAccount googleSignInAccount, GooglePlusResultCallback callback) {
            this.mActivity = activity;
            this.mScope = scope;
            this.mEmail = email;
            this.mCallback = callback;
            this.mGogleSignin = googleSignInAccount;
        }

        protected String doInBackground(Void ... params) {
            try {
                return GoogleAuthManager.this.getToken(GoogleAuthManager.this.activity, this.mEmail, this.mScope);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (GoogleAuthException e) {
                e.printStackTrace();
            }
            return "";
        }

        protected void onPostExecute(String aVoid) {
            super.onPostExecute((Object)aVoid);
            try {
                if (!TextUtils.isEmpty((CharSequence)aVoid)) {
                    this.mCallback.onLoginSuccess(this.mGogleSignin, aVoid);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface GooglePlusResultCallback {
        public void onLoginSuccess(GoogleSignInAccount var1, String var2);

        public void onLoginError(String var1, int var2);
    }
}

