/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.component;

import android.content.Context;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;
import java.util.ArrayList;

public final class GoogleAnalyticsManager {
    private static GoogleAnalyticsManager INSTANCE;
    private GoogleAnalytics analytics;
    private ArrayList<Tracker> trackers = new ArrayList();

    public static GoogleAnalyticsManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GoogleAnalyticsManager();
        }
        return INSTANCE;
    }

    private GoogleAnalyticsManager() {
    }

    void init(Context applicationContext) {
        try {
            this.analytics = GoogleAnalytics.getInstance((Context)applicationContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addTracker(String gaId) {
        try {
            Tracker t = this.analytics.newTracker(gaId);
            t.send(((HitBuilders.EventBuilder)new HitBuilders.EventBuilder().setCategory("UX").setAction("appstart").setNewSession()).build());
            this.trackers.add(t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeTrackers() {
        this.trackers = new ArrayList();
    }

    public void trackEvent(String category, String action, String label, long value) {
        try {
            if (this.trackers != null) {
                for (Tracker t : this.trackers) {
                    t.send(new HitBuilders.EventBuilder().setCategory(category).setAction(action).setLabel(label).setValue(value).build());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackScreen(String screenName) {
        try {
            if (this.trackers != null) {
                for (Tracker t : this.trackers) {
                    t.setScreenName(screenName);
                    t.send(new HitBuilders.ScreenViewBuilder().build());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

