package com.mobgame.js;

import android.app.Activity;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.webkit.JavascriptInterface;

import com.mobgame.MobGameHelper;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.MobGameWebFragment2;
import com.mobgame.gui.dialog.MobGameDialogStartWebFragment;
import com.mobgame.gui.dialog.MobGameDialogWebviewFragment;
import com.mobgame.gui.dialog.MobGameHaveBackButtonFragment;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.model.Game;
import com.mobgame.utils.Constants;

public class JsHandler {

    private static String TAG = JsHandler.class.getSimpleName();

    private Activity activity;
    private MobGameWebFragment webFragment;
    private MobGameWebFragment2 webFragment2;
    private MobGameHaveBackButtonFragment webDialogHaveBackButton;
    private MobGameDialogWebviewFragment dialogWebviewFragment;
    private MobGameDialogStartWebFragment dialogStartWebFragment;

    private enum switchCommandJS {
        mobLoginSuccess, // Login thanh cong
        mobLoginStartFb, // login FB
        mobFacebookForUpdate,
        mobLoginGuest,
        mobLoginGooglePlay,
        mobLoginStartGg,
        mobOpenFanPage,
        mobOpenGroup,
        mobOpenContact,
        mobPaymentStartIAP,
        mobPaymentStartPayPal,
        mobPaymentSuccess,
        mobOpenBrowser,
        mobOpenModal,
        mobSendEmail,
        mobSendSMS,
        mobAppInvite,
        mobMakePhoneCall,
        mobActionShareFB,
        mobCopyToClipboard,
        loadImageUpload,
        mobGetIssue,
        deleteImageData,
        mobGetError,
        mobCloseVC,
        mobCloseWindow,
        mobChooseFriend,
        openLink,
        mobDisplayGC,
        mobOpenLink,
        mobTrackData,
        track,
        calendar,
        closeWebViewPopup,
        closePopupStart
    }

    public JsHandler(Activity activity) {
        this.activity = activity;
    }

    public JsHandler(Activity activity, MobGameDialogWebviewFragment dialogWebviewFragment) {
        this.activity = activity;
        this.dialogWebviewFragment = dialogWebviewFragment;
    }
    public JsHandler(Activity activity, MobGameDialogStartWebFragment dialogStartWebFragment) {
        this.activity = activity;
        this.dialogStartWebFragment = dialogStartWebFragment;
    }

    public JsHandler(Activity activity, MobGameWebFragment webFragment) {
        this.activity = activity;
        this.webFragment = webFragment;
    }

    public JsHandler(Activity activity, MobGameWebFragment2 webFragment2) {
        this.activity = activity;
        this.webFragment2 = webFragment2;
    }

    public JsHandler(Activity activity, MobGameHaveBackButtonFragment webDialogHaveBackButton) {
        this.activity = activity;
        this.webDialogHaveBackButton = webDialogHaveBackButton;
    }

    @JavascriptInterface
    public void mobAppSDKexecute(String command, String params) {
        try {
            Log.i(TAG, "mobAppSDKexecute: command = " + command + "; params = " + params);

            switch (switchCommandJS.valueOf(command)) {

                /**********  LOGIN  **********/
                case mobLoginStartFb:
                    CmdLogin.getInstance().mobLoginFacebook(activity, webFragment2, params);
                    break;
                case mobFacebookForUpdate:
                    CmdLogin.getInstance().mobUpgradeFacebook(activity, webFragment2 ,dialogWebviewFragment, dialogStartWebFragment, params);
                    break;
                case mobLoginStartGg:
                    CmdLogin.getInstance().mobLoginGoogleAccount(activity, webFragment2, params);
                    break;
                case mobLoginGooglePlay:
                    CmdLogin.getInstance().mobLoginGooglePlay(activity, webFragment2, params);
                    break;
                case mobLoginGuest:
                    CmdLogin.getInstance().mobLoginGuest(activity, webFragment2, params);
                    break;
                case mobLoginSuccess:
                    CmdLogin.getInstance().mobLoginSuccess(activity, webFragment2, dialogWebviewFragment , params);
                    break;
                // END LOGIN

                /**********  PAYMENT  **********/
                case mobPaymentStartIAP:
                    CmdPayment.getInstance().mobPaymentStartIAP(activity, params);
                    break;
                case mobPaymentStartPayPal:
                    CmdPayment.getInstance().mobPaymentStartPaypal(activity, params);
                    break;
                case mobPaymentSuccess:
                    CmdPayment.getInstance().mobPaymentSuccess(activity, params);
                    break;
                // END PAYMENT

                /**********  DASHBOARD  **********/
                case mobOpenContact:
                    CmdDashboard.getInstance().mobOpenContact(activity, params);
                    break;
                case mobAppInvite:
                    CmdDashboard.getInstance().mobAppInvite(activity, params);
                    break;
                case mobActionShareFB:
                    CmdDashboard.getInstance().mobAppShare(activity, params);
                    break;
                case mobSendEmail:
                    CmdDashboard.getInstance().mobSendEmail(activity, params);
                    break;
                case mobSendSMS:
                    CmdDashboard.getInstance().mobSendSMS(activity, params);
                    break;
                case mobOpenBrowser:
                    CmdDashboard.getInstance().mobOpenBrowser(activity, params);
                    break;
                case mobOpenFanPage:
                    CmdDashboard.getInstance().mobOpenFBFanpage(activity, params);
                    break;
                case mobOpenGroup:
                    CmdDashboard.getInstance().mobOpenFBGroup(activity, params);
                    break;
                case mobOpenModal:
                    CmdDashboard.getInstance().mobOpenModal(activity, params);
                    break;
                case mobMakePhoneCall:
                    CmdDashboard.getInstance().mobMakePhoneCall(activity, params);
                    break;
                case mobCopyToClipboard:
                    CmdDashboard.getInstance().mobCopyToClipboard(activity, params);
                    break;
                case loadImageUpload:
                    CmdDashboard.getInstance().mobSelectImage2(activity, dialogWebviewFragment, params);
                    break;
                case mobGetIssue:
                    CmdDashboard.getInstance().mobGetIssue(activity, dialogWebviewFragment, params);
                    break;
                case deleteImageData:
                    CmdDashboard.getInstance().deleteImageData(activity, webFragment, params);
                    break;

                case mobGetError:
                    CmdDashboard.getInstance().clearImageData(activity);
                    break;
                case mobCloseVC:
//                    dialogWebviewFragment.dismiss();
                    CmdDashboard.getInstance().mobRefreshBugForm(activity , params , dialogWebviewFragment);
                    break;
                case mobCloseWindow:
                    break;
                case mobChooseFriend:
                    CmdDashboard.getInstance().mobChooseFriend(activity, params);
                    break;
                case openLink:
                    CmdDashboard.getInstance().mobOpenDialogWebView(activity, params);
                    break;
                case mobOpenLink:
                    CmdDashboard.getInstance().mobOpenDialogWebView(activity, params);
                    Log.d("chieuhv","Param"+params);                    break;
                case mobDisplayGC:
                    CmdDashboard.getInstance().showFormGiftCode(activity, params);
                    break;
                case mobTrackData:
                    // tracking GA
                    CmdDashboard.getInstance().trackingDetailWeb(activity, params);
                    break;
                case track:
                    CmdDashboard.getInstance().trackingFromWeb(activity , params);
                    break;
                // END DASHBOARD
                case calendar:
                    Log.d(TAG , "Goooo here");
                    CmdDashboard.getInstance().setUpReminder(activity , params);
                    break;
                case closeWebViewPopup:
                    dialogWebviewFragment.dismiss();
                    break;
                case closePopupStart:
                    Intent intent = new Intent(Constants.INTENT_FILTER);
                    intent.putExtra("category", "float_button");
                    LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    dialogStartWebFragment.dismiss();
                    break;
                default:
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}