package com.mobgame.api;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;

import com.mobgame.MobGameSDK;
import com.mobgame.model.EncodedResponse;
import com.mobgame.model.IngameNoti;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.EncryptionUtils;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Objects;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
public class GetIngameNotificationTask extends AsyncTask<Void, Void, Void> {
    private static final String TAG = GetIngameNotificationTask.class.getSimpleName();
    private Listener callback;
    private Activity mActivity;

    public GetIngameNotificationTask(Activity activity, Listener callback) {
        this.callback = callback;
        this.mActivity = activity;
    }

    @Override
    protected Void doInBackground(Void... voids) {
        try {
            Context c = MobGameSDK.getApplicationContext();
            String sign = EncryptionUtils.getSignedString(c);
            RestfulApi.removeInstance();
            RestfulApi api = RestfulApi.getInstance();
            int tablet = 0;
            if(DeviceUtils.isTablet(c)){
                tablet = 1;
            }else{
                tablet = 0;
            }
            Call<EncodedResponse> call = api.getIngameNotiList(tablet);
            call.enqueue(new Callback<EncodedResponse>() {
                @Override
                public void onResponse(@NotNull Call<EncodedResponse> call, @NotNull Response<EncodedResponse> response) {
                    try {

                        if (response.isSuccessful()) {
                            String responseBody = Objects.requireNonNull(response.body()).getDecodedData();
                            Log.e(TAG, "response :" + responseBody);
                            ArrayList<IngameNoti> listNoti = IngameNoti.parse(responseBody);
                            if (callback != null) {
                                callback.onSuccess(listNoti);
                            }
                        } else {
                            if (callback != null) {
                                callback.onFailure(new Exception());
                            }
                        }
                    } catch (Exception e) {
                        if (callback != null) {
                            callback.onFailure(e);
                        }
                    }
                }

                @Override
                public void onFailure(@NotNull Call<EncodedResponse> call, @NotNull Throwable t) {
//                    Log.e("TAG", "failed :" + t.getMessage());
                    try {
                        if (callback != null) {
                            callback.onFailure(t);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public interface Listener {
        public void onSuccess(ArrayList<IngameNoti> listItem);

        public void onFailure(Throwable t);
    }
}
