package com.mobgame.api;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;

import com.mobgame.MobGameSDK;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.EncodedResponse;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.EncryptionUtils;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.Utils;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;

import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class PostTask extends AsyncTask<Void, Void, Void> {

    private String url;
    private Map<String, String> postParams;
    private boolean isEncrypted;
    private Callback callback;
    private boolean isInviteFriend = false;
    private String accountId;
    private Activity mActivity;

    public PostTask(String url) {
        this.url = url;
    }

    public PostTask(String url, boolean isEncrypted) {
        this.url = url;
        this.isEncrypted = isEncrypted;
    }

    public PostTask(String url, Map<String, String> postParams, boolean isEncrypted) {
        this.url = url;
        this.postParams = postParams;
        this.isEncrypted = isEncrypted;
    }

    public PostTask(Activity activity, String url, Map<String, String> postParams, boolean isEncrypted, Callback callback) {
        this.mActivity = activity;
        this.url = url;
        this.postParams = postParams;
        this.isEncrypted = isEncrypted;
        this.callback = callback;
    }

    public PostTask(String url, Map<String, String> postParams, boolean isEncrypted, Callback callback) {
        this.url = url;
        this.postParams = postParams;
        this.isEncrypted = isEncrypted;
        this.callback = callback;
    }

    public PostTask(String url, Map<String, String> postParams, boolean isEncrypted, boolean isInviteFriend,
                    String accountId, Callback callback) {
        this.url = url;
        this.postParams = postParams;
        this.isEncrypted = isEncrypted;
        this.callback = callback;
        this.isInviteFriend = isInviteFriend;
        this.accountId = accountId;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    @Override
    protected Void doInBackground(Void... params) {
        try {
            Context c = MobGameSDK.getApplicationContext();
            OkHttpClient client = RestfulApi.getCommonClient();
            Log.d("PostTask", "doInBackground: " + c.toString() + client);
            RequestBody formBody;
            if (postParams == null) {
                formBody = RequestBody.create(null, new byte[0]);
                Log.d("PostTask", "doInBackground: 1 " + formBody );
            } else {
                FormBody.Builder builder = new FormBody.Builder();
                for (String key : postParams.keySet()) {
                    builder.add(key, Objects.requireNonNull(postParams.get(key)));
                }
                formBody = builder.build();
                Log.d("PostTask", "doInBackground: 2 " + formBody );

            }
            GameConfigManager config = GameConfigManager.getInstance();
            Log.d("PostTask", "doInBackground: 3 " + isEncrypted );
            if (isEncrypted) {
                try {
                    Uri uri = Uri.parse(url);
                    if (uri.getQueryParameter("sign") == null) {
                        if (isInviteFriend) {
                            Log.d("PostTask", "doInBackground: 4 " + isInviteFriend );
                            url = uri
                                    .buildUpon()
                                    .appendQueryParameter("sign", EncryptionUtils.getSignedString(c, accountId))
                                    .build()
                                    .toString();
                        } else {
                            url = uri
                                    .buildUpon()
                                    .appendQueryParameter("sign", EncryptionUtils.getSignedString(c))
                                    .build()
                                    .toString();
                        }

                    }
                    Log.d("PostTask", "doInBackground: 5 " + uri.getQueryParameter("sign") );
                    Request request = new Request.Builder()
                            .url(url)
                            .method("POST", formBody)
                            .addHeader(Constants.MOBGAME_DEVICE, Utils.stringNormalize(DeviceUtils.getDevice()))
                            .addHeader(Constants.MOBGAME_OS, Utils.stringNormalize(DeviceUtils.getOSInfo()))
                            .addHeader(Constants.MOBGAME_RESOLUTION, Utils.stringNormalize(DeviceUtils.getResolution(mActivity)))
                            .addHeader(Constants.MOBGAME_SDK_VERSION, Utils.stringNormalize(Utils.getSDKVersion(mActivity)))
                            .addHeader(Constants.MOBGAME_APPKEY, Utils.stringNormalize(config.getAppKey(c)))
                            .addHeader(Constants.MOBGAME_APP_VERSION, Utils.stringNormalize(Utils.getGameVersion(mActivity)))
                            .addHeader(Constants.MOBGAME_APP_VERSION_CODE, Utils.stringNormalize(Utils.getGameVersionCode(mActivity)))
                            .addHeader(Constants.MOBGAME_NETWORK, Utils.stringNormalize(Utils.getNetwork(mActivity)))
                            .addHeader(Constants.MOBGAME_TOKEN, Utils.stringNormalize(config.getAccessToken()))
                            .addHeader(Constants.MOBGAME_ROLEID, Utils.stringNormalize(config.getCharacterInfo().getRoleId()))
                            .addHeader(Constants.MOBGAME_AREAID, Utils.stringNormalize(config.getCharacterInfo().getAreaId()))
                            .addHeader(Constants.MOBGAME_ROLENAME, Utils.stringNormalize(config.getCharacterInfo().getRoleName()))
                            .addHeader(Constants.MOBGAME_AREANAME, Utils.stringNormalize(config.getCharacterInfo().getAreaName()))
                            .addHeader(Constants.MOBGAME_ORIENTATION, Utils.stringNormalize(DeviceUtils.getScreenOrientation(mActivity) + ""))
                            .addHeader(Constants.MOBGAME_LANG, Utils.stringNormalize(DeviceUtils.getLanguage()))
                            .addHeader(Constants.MOBGAME_REFERRER, Utils.stringNormalize(Utils.getReferrer(mActivity)))
                            .addHeader(Constants.MOBGAME_ADVERTISING_ID, Utils.stringNormalize(DeviceUtils.getAdvertisingID(mActivity)))
                            .addHeader(Constants.MOBGAME_APPSFLYER_ID, FunTrackingUtil.getInstance().getAppsflyerId(mActivity))
                            .build();
                    String result = Objects.requireNonNull(client.newCall(request).execute().body()).string();
                    if (isInviteFriend) {
                        if (callback != null) {
                            callback.onSuccess("success");
                            Log.d("PostTask", "doInBackground: 6 " );
                        }
                    } else {
                        EncodedResponse response = EncodedResponse.parse(result);
                        if (callback != null) {
                            callback.onSuccess(response.getDecodedData());
                            Log.d("PostTask", "doInBackground: 7 "  + response.getDecodedData());
                        }
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }

            } else {
                Request request = new Request.Builder()
                        .url(url)
                        .method("POST", formBody)
                        .addHeader(Constants.MOBGAME_DEVICE, Utils.stringNormalize(DeviceUtils.getDevice()))
                        .addHeader(Constants.MOBGAME_OS, Utils.stringNormalize(DeviceUtils.getOSInfo()))
                        .addHeader(Constants.MOBGAME_RESOLUTION, Utils.stringNormalize(DeviceUtils.getResolution(mActivity)))
                        .addHeader(Constants.MOBGAME_SDK_VERSION, Utils.stringNormalize(Utils.getSDKVersion(mActivity)))
                        .addHeader(Constants.MOBGAME_APPKEY, Utils.stringNormalize(config.getAppKey(c)))
                        .addHeader(Constants.MOBGAME_APP_VERSION, Utils.stringNormalize(Utils.getGameVersion(mActivity)))
                        .addHeader(Constants.MOBGAME_APP_VERSION_CODE, Utils.stringNormalize(Utils.getGameVersionCode(mActivity)))
                        .addHeader(Constants.MOBGAME_NETWORK, Utils.stringNormalize(Utils.getNetwork(mActivity)))
                        .addHeader(Constants.MOBGAME_TOKEN, Utils.stringNormalize(config.getAccessToken()))
                        .addHeader(Constants.MOBGAME_ROLEID, Utils.stringNormalize(config.getCharacterInfo().getRoleId()))
                        .addHeader(Constants.MOBGAME_AREAID, Utils.stringNormalize(config.getCharacterInfo().getAreaId()))
                        .addHeader(Constants.MOBGAME_ROLENAME, Utils.stringNormalize(config.getCharacterInfo().getRoleName()))
                        .addHeader(Constants.MOBGAME_AREANAME, Utils.stringNormalize(config.getCharacterInfo().getAreaName()))
                        .addHeader(Constants.MOBGAME_ORIENTATION, Utils.stringNormalize(DeviceUtils.getScreenOrientation(mActivity) + ""))
                        .addHeader(Constants.MOBGAME_LANG, Utils.stringNormalize(DeviceUtils.getLanguage()))
                        .addHeader(Constants.MOBGAME_REFERRER, Utils.stringNormalize(Utils.getReferrer(mActivity)))
                        .addHeader(Constants.MOBGAME_ADVERTISING_ID, Utils.stringNormalize(DeviceUtils.getAdvertisingID(mActivity)))
                        .addHeader(Constants.MOBGAME_APPSFLYER_ID, FunTrackingUtil.getInstance().getAppsflyerId(mActivity))
                        .build();
                String response = Objects.requireNonNull(client.newCall(request).execute().body()).string();
                Log.d("PostTask", "doInBackground: 8 " + response + callback.toString() );
                if (callback != null) {
                    callback.onSuccess(response);
                }
            }

        } catch (IOException e) {
            e.printStackTrace();
            if (callback != null) {
                callback.onFailure(e);
            }
        }
        return null;
    }


    public interface Callback {
        public void onSuccess(String response);

        public void onFailure(Throwable e);
    }

}