package com.mobgame.api;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;

import com.mobgame.MobGameSDK;
import com.mobgame.model.EncodedResponse;
import com.mobgame.model.Game;
import com.mobgame.utils.EncryptionUtils;
import com.mobgame.utils.FunTrackingUtil;

import org.jetbrains.annotations.NotNull;

import java.util.Objects;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class GetInfoBeforeAuthenTask extends AsyncTask<Void, Void, Void> {

	private Listener callback;

	public GetInfoBeforeAuthenTask(Listener callback) {
		Log.d("TAG" , "GO HERE");

		this.callback = callback;
	}

	@Override
	protected Void doInBackground(Void... params) {
		Context c = MobGameSDK.getApplicationContext();
		String sign = EncryptionUtils.getSignedString(c);
		RestfulApi.removeInstance();
		RestfulApi api = RestfulApi.getInstance();
		Call<EncodedResponse> call = api.getInfoBeforeAuthen(sign);
		call.enqueue(new Callback<EncodedResponse>() {

			@Override
			public void onResponse(@NotNull Call<EncodedResponse> call, @NotNull Response<EncodedResponse> response) {
				try {
					Log.d("TAG" , "response:" + response.body());
					if (response.isSuccessful()) {
						String responseBody = Objects.requireNonNull(response.body()).getDecodedData();
						Game game = Game.parse(responseBody);

						boolean isValidationMode = false;
						if(game.getEx().isShowLogo()){
							isValidationMode = game.getEx().isShowLogo();
						}

						if (callback != null) {
							callback.onSuccess(game, isValidationMode);
						}
					} else {
						if (callback != null) {
							callback.onFailure(new Exception());
						}
					}
				} catch (Exception e) {
					if (callback != null) {
						callback.onFailure(e);
					}
				}
			}

			@Override
			public void onFailure(@NotNull Call<EncodedResponse> call, @NotNull Throwable t) {
				if (callback != null) {
					callback.onFailure(t);
				}
			}
		});
		return null;
	}

	public interface Listener {
		public void onSuccess(Game game, boolean isValidationMode);
		public void onFailure(Throwable t);
	}

	
}