package com.mobgame.gui.view;

import android.content.Context;
import android.os.Handler;
import android.support.v4.widget.SwipeRefreshLayout;
import android.util.AttributeSet;

/**
 * Created by nguye on 4/28/2017.
 */

public class MobSwipRefreshLayout extends SwipeRefreshLayout {
    private long refreshTimeout = 15000;
    private Handler handler;
    public Object setColorSchemeResources;

    public MobSwipRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void setRefreshing(boolean refreshing) {
        super.setRefreshing(refreshing);
        if (refreshing) {
            if (handler == null) {
                handler = new Handler();
                handler.postDelayed(swipeTimeoutRunner, refreshTimeout);
            }
            return;
        }
        if (handler != null) {
            handler.removeCallbacks(swipeTimeoutRunner);
            super.setRefreshing(false);
        }
    }

    Runnable swipeTimeoutRunner = new Runnable() {
        @Override
        public void run() {
            MobSwipRefreshLayout.super.setRefreshing(false);
        }
    };

    public void setTimeout(long refreshTimeout) {
        this.refreshTimeout = refreshTimeout;
    }
}
