/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.component;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import android.widget.Toast;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.facebook.share.Sharer;
import com.facebook.share.model.AppInviteContent;
import com.facebook.share.model.GameRequestContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.widget.AppInviteDialog;
import com.facebook.share.widget.GameRequestDialog;
import com.facebook.share.widget.ShareDialog;
import com.mobgame.R;
import com.mobgame.utils.Utils;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class FacebookManager {
    private static FacebookManager INSTANCE;
    private CallbackManager callbackManager;

    public static FacebookManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FacebookManager();
        }
        return INSTANCE;
    }

    private FacebookManager() {
    }

    void init(Context applicationContext, String applicationId) {
        FacebookSdk.setApplicationId((String)applicationId);
        FacebookSdk.sdkInitialize((Context)applicationContext, (FacebookSdk.InitializeCallback)new FacebookSdk.InitializeCallback(){

            public void onInitialized() {
            }
        });
        this.callbackManager = CallbackManager.Factory.create();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if ((requestCode == 64206 || requestCode == 64207 || requestCode == 64213 || requestCode == 64210) && this.callbackManager != null) {
            this.callbackManager.onActivityResult(requestCode, resultCode, data);
        }
    }

    public String getHashkey(Context c) {
        try {
            String packagename = c.getPackageName();
            PackageInfo info = c.getPackageManager().getPackageInfo(packagename, 64);
            Signature[] signatureArray = info.signatures;
            int n = signatureArray.length;
            int n2 = 0;
            if (n2 < n) {
                Signature signature = signatureArray[n2];
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                return Base64.encodeToString((byte[])md.digest(), (int)0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void login(Activity activity, final LoginCallback callback) {
        try {
            LoginManager.getInstance().registerCallback(this.callbackManager, (FacebookCallback)new FacebookCallback<LoginResult>(){

                public void onSuccess(LoginResult result) {
                    if (callback != null) {
                        callback.onSuccess(result.getAccessToken(), result.getRecentlyGrantedPermissions(), result.getRecentlyDeniedPermissions());
                    }
                }

                public void onCancel() {
                    if (callback != null) {
                        callback.onCancel();
                    }
                }

                public void onError(FacebookException e) {
                    if (callback != null) {
                        callback.onError((Throwable)e);
                    }
                }
            });
            LoginManager.getInstance().logOut();
            LoginManager.getInstance().logInWithReadPermissions(activity, Arrays.asList("public_profile", "email"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void logout() {
        if (!FacebookSdk.isInitialized()) {
            return;
        }
        LoginManager.getInstance().logOut();
    }

    public void shareLink(Activity activity, ShareContent params) {
        this.shareLink(activity, params, null);
    }

    public void shareLink(final Activity activity, ShareContent params, final ShareCallback callback) {
        block15: {
            try {
                if (Utils.isOnline((Context)activity)) {
                    if (params == null) {
                        if (callback != null) {
                            callback.onError(new InvalidParameterException());
                        }
                        return;
                    }
                    if (!ShareDialog.canShow(ShareLinkContent.class) && !this.isFacebookInstalled((Context)activity)) {
                        LoginManager.getInstance().logInWithReadPermissions(activity, Arrays.asList("email"));
                    }
                    if (ShareDialog.canShow(ShareLinkContent.class)) {
                        ShareLinkContent.Builder builder = new ShareLinkContent.Builder();
                        if (!TextUtils.isEmpty((CharSequence)params.getContentDescription())) {
                            builder.setContentDescription(params.getContentDescription());
                        }
                        if (!TextUtils.isEmpty((CharSequence)params.getContentTitle())) {
                            builder.setContentTitle(params.getContentTitle());
                        }
                        if (!TextUtils.isEmpty((CharSequence)params.getContentUrl())) {
                            builder.setContentUrl(Uri.parse((String)params.getContentUrl()));
                        }
                        if (!TextUtils.isEmpty((CharSequence)params.getImageUrl())) {
                            builder.setImageUrl(Uri.parse((String)params.getImageUrl()));
                        }
                        if (params.getPeopleIds() != null) {
                            builder.setPeopleIds(params.getPeopleIds());
                        }
                        if (!TextUtils.isEmpty((CharSequence)params.getPlaceId())) {
                            builder.setPlaceId(params.getPlaceId());
                        }
                        if (!TextUtils.isEmpty((CharSequence)params.getRef())) {
                            builder.setRef(params.getRef());
                        }
                        ShareLinkContent linkContent = builder.build();
                        ShareDialog shareDialog = new ShareDialog(activity);
                        shareDialog.registerCallback(this.callbackManager, (FacebookCallback)new FacebookCallback<Sharer.Result>(){

                            public void onSuccess(Sharer.Result result) {
                                if (callback != null) {
                                    callback.onSuccess(result.getPostId());
                                    Toast.makeText((Context)activity, (CharSequence)"Success!!!", (int)1).show();
                                }
                            }

                            public void onCancel() {
                                if (callback != null) {
                                    callback.onCancel();
                                    Toast.makeText((Context)activity, (CharSequence)"Error!!!", (int)1).show();
                                }
                            }

                            public void onError(FacebookException e) {
                                if (callback != null) {
                                    callback.onError((Throwable)e);
                                    Toast.makeText((Context)activity, (CharSequence)"Cancel!!!", (int)1).show();
                                }
                            }
                        });
                        shareDialog.show((Object)linkContent);
                    }
                } else {
                    Toast.makeText((Context)activity, (CharSequence)activity.getResources().getString(R.string.error_network), (int)1).show();
                }
            }
            catch (Exception e) {
                if (callback == null) break block15;
                callback.onError(e);
            }
        }
    }

    public void sharePhoto(Activity activity, Bitmap bitmap, final ShareCallback callback) {
        block7: {
            try {
                if (Utils.isOnline((Context)activity)) {
                    if (bitmap == null) {
                        if (callback != null) {
                            callback.onError(new InvalidParameterException());
                        }
                        return;
                    }
                    if (!ShareDialog.canShow(SharePhotoContent.class) && !this.isFacebookInstalled((Context)activity)) {
                        LoginManager.getInstance().logInWithReadPermissions(activity, Arrays.asList("email"));
                    }
                    SharePhoto photo = new SharePhoto.Builder().setBitmap(bitmap).build();
                    SharePhotoContent content = new SharePhotoContent.Builder().addPhoto(photo).build();
                    ShareDialog shareDialog = new ShareDialog(activity);
                    shareDialog.registerCallback(this.callbackManager, (FacebookCallback)new FacebookCallback<Sharer.Result>(){

                        public void onSuccess(Sharer.Result result) {
                            if (callback != null) {
                                callback.onSuccess(result.getPostId());
                            }
                        }

                        public void onCancel() {
                            if (callback != null) {
                                callback.onCancel();
                            }
                        }

                        public void onError(FacebookException e) {
                            if (callback != null) {
                                callback.onError((Throwable)e);
                            }
                        }
                    });
                    shareDialog.show((com.facebook.share.model.ShareContent)content, ShareDialog.Mode.AUTOMATIC);
                } else {
                    Toast.makeText((Context)activity, (CharSequence)activity.getResources().getString(R.string.error_network), (int)1).show();
                }
            }
            catch (Exception e) {
                if (callback == null) break block7;
                callback.onError(e);
            }
        }
    }

    public void invite(Activity activity, InviteContent params) {
        this.invite(activity, params, null);
    }

    public void invite(final Activity activity, InviteContent params, final InviteCallback callback) {
        try {
            if (params == null) {
                if (callback != null) {
                    callback.onError(new InvalidParameterException());
                }
                return;
            }
            if (!AppInviteDialog.canShow() && !this.isFacebookInstalled((Context)activity)) {
                LoginManager.getInstance().logInWithReadPermissions(activity, Arrays.asList("email"));
            }
            if (AppInviteDialog.canShow()) {
                AppInviteContent.Builder builder = new AppInviteContent.Builder();
                if (!TextUtils.isEmpty((CharSequence)params.getApplinkUrl())) {
                    builder.setApplinkUrl(params.getApplinkUrl());
                }
                if (!TextUtils.isEmpty((CharSequence)params.getPreviewImageUrl())) {
                    builder.setPreviewImageUrl(params.getPreviewImageUrl());
                }
                AppInviteContent content = builder.build();
                AppInviteDialog appInviteDialog = new AppInviteDialog(activity);
                appInviteDialog.registerCallback(this.callbackManager, (FacebookCallback)new FacebookCallback<AppInviteDialog.Result>(){

                    public void onSuccess(AppInviteDialog.Result result) {
                        if (callback != null) {
                            callback.onSuccess(result.getData());
                            Toast.makeText((Context)activity, (CharSequence)"Invite success", (int)1).show();
                        }
                    }

                    public void onCancel() {
                        if (callback != null) {
                            callback.onCancel();
                            Toast.makeText((Context)activity, (CharSequence)"Invite cancel", (int)1).show();
                        }
                    }

                    public void onError(FacebookException e) {
                        if (callback != null) {
                            callback.onError((Throwable)e);
                            Toast.makeText((Context)activity, (CharSequence)"Invite error", (int)1).show();
                        }
                    }
                });
                appInviteDialog.show(content);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void inviteGameRequest(final Activity activity, InviteGameContent params, final InviteGameCallback callback) {
        try {
            if (params == null && callback != null) {
                callback.onError(new InvalidParameterException());
            }
            if (!AppInviteDialog.canShow() && !this.isFacebookInstalled((Context)activity)) {
                LoginManager.getInstance().logInWithReadPermissions(activity, Arrays.asList("email"));
                return;
            }
            if (!GameRequestDialog.canShow()) {
                if (callback != null) {
                    callback.onError(new Exception("Game Request Dialog can't show"));
                }
                return;
            }
            GameRequestContent.Builder contentBuilder = new GameRequestContent.Builder().setTitle(params.getTitle());
            if (params.getActionType() != null) {
                contentBuilder.setActionType(params.getActionType());
            }
            if (!TextUtils.isEmpty((CharSequence)params.getData())) {
                contentBuilder.setData(params.getData());
            }
            if (params.getFilters() != null) {
                contentBuilder.setFilters(params.getFilters());
            }
            if (!TextUtils.isEmpty((CharSequence)params.getMessage())) {
                contentBuilder.setMessage(params.getMessage());
            }
            if (!TextUtils.isEmpty((CharSequence)params.getObjectId())) {
                contentBuilder.setObjectId(params.getObjectId());
            }
            if (params.getRecipients() != null) {
                contentBuilder.setRecipients(params.getRecipients());
            }
            if (params.getSuggestions() != null) {
                contentBuilder.setSuggestions(params.getSuggestions());
            }
            if (!TextUtils.isEmpty((CharSequence)params.getTitle())) {
                contentBuilder.setTitle(params.getTitle());
            }
            if (!TextUtils.isEmpty((CharSequence)params.getTo())) {
                contentBuilder.setTo(params.getTo());
            }
            GameRequestContent dialogContent = contentBuilder.build();
            GameRequestDialog gameDialog = new GameRequestDialog(activity);
            gameDialog.registerCallback(this.callbackManager, (FacebookCallback)new FacebookCallback<GameRequestDialog.Result>(){

                public void onSuccess(GameRequestDialog.Result result) {
                    if (callback != null) {
                        callback.onSuccess(result);
                        Toast.makeText((Context)activity, (CharSequence)"invite success", (int)1).show();
                    }
                }

                public void onError(FacebookException error) {
                    if (callback != null) {
                        callback.onError((Throwable)error);
                        Toast.makeText((Context)activity, (CharSequence)"invite error", (int)1).show();
                    }
                }

                public void onCancel() {
                    if (callback != null) {
                        callback.onCancel();
                        Toast.makeText((Context)activity, (CharSequence)"invite cancel", (int)1).show();
                    }
                }
            });
            gameDialog.show((Object)dialogContent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isFacebookInstalled(Context c) {
        try {
            c.getPackageManager().getApplicationInfo("com.facebook.katana", 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static class InviteGameContent {
        private String message;
        private List<String> recipients;
        private String data;
        private String title;
        private GameRequestContent.ActionType actionType;
        private GameRequestContent.Filters filters;
        private String objectId;
        private List<String> suggestions;
        private String to;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<String> getRecipients() {
            return this.recipients;
        }

        public void setRecipients(List<String> recipients) {
            this.recipients = recipients;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public GameRequestContent.ActionType getActionType() {
            return this.actionType;
        }

        public void setActionType(GameRequestContent.ActionType actionType) {
            this.actionType = actionType;
        }

        public GameRequestContent.Filters getFilters() {
            return this.filters;
        }

        public void setFilters(GameRequestContent.Filters filters) {
            this.filters = filters;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public List<String> getSuggestions() {
            return this.suggestions;
        }

        public void setSuggestions(List<String> suggestions) {
            this.suggestions = suggestions;
        }

        public String getTo() {
            return this.to;
        }

        @Deprecated
        public void setTo(String to) {
            this.to = to;
        }
    }

    public static class InviteContent {
        private String applinkUrl;
        private String previewImageUrl;

        public String getApplinkUrl() {
            return this.applinkUrl;
        }

        public InviteContent setApplinkUrl(String applinkUrl) {
            this.applinkUrl = applinkUrl;
            return this;
        }

        public String getPreviewImageUrl() {
            return this.previewImageUrl;
        }

        public InviteContent setPreviewImageUrl(String previewImageUrl) {
            this.previewImageUrl = previewImageUrl;
            return this;
        }
    }

    public static class ShareContent {
        private String contentUrl;
        private String contentTitle;
        private String contentDescription;
        private String imageUrl;
        private List<String> peopleIds;
        private String placeId;
        private String ref;

        public String getContentUrl() {
            return this.contentUrl;
        }

        public ShareContent setContentUrl(String url) {
            this.contentUrl = url;
            return this;
        }

        public String getContentTitle() {
            return this.contentTitle;
        }

        public ShareContent setContentTitle(String title) {
            this.contentTitle = title;
            return this;
        }

        public String getContentDescription() {
            return this.contentDescription;
        }

        public ShareContent setContentDescription(String content) {
            this.contentDescription = content;
            return this;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public ShareContent setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public List<String> getPeopleIds() {
            return this.peopleIds;
        }

        public ShareContent setPeopleIds(List<String> peopleIds) {
            this.peopleIds = peopleIds;
            return this;
        }

        public String getPlaceId() {
            return this.placeId;
        }

        public ShareContent setPlaceId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public String getRef() {
            return this.ref;
        }

        public ShareContent setRef(String ref) {
            this.ref = ref;
            return this;
        }
    }

    public static interface ShareCallback {
        public void onSuccess(String var1);

        public void onCancel();

        public void onError(Throwable var1);
    }

    public static interface LoginCallback {
        public void onSuccess(AccessToken var1, Set<String> var2, Set<String> var3);

        public void onCancel();

        public void onError(Throwable var1);
    }

    public static interface BaseInviteCallback<T> {
        public void onSuccess(T var1);

        public void onCancel();

        public void onError(Throwable var1);
    }

    public static interface InviteCallback
    extends BaseInviteCallback<Bundle> {
    }

    public static interface InviteGameCallback
    extends BaseInviteCallback<GameRequestDialog.Result> {
    }
}

