/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.utils;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerLib;
import com.mobgame.MobGameSDK;
import com.mobgame.component.EventClientManager;
import com.mobgame.component.FirebaseAnalyticsManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FunTrackingUtil {
    private static FunTrackingUtil instance;
    private String appsflyerDevkey = "cfgYFoj97okaEbzqp8q5w5";
    private String gcmSenderId = "461098885975";
    private String TAG = "FunTrackingUtil";
    private Map<String, Object> conversionDataLoaded;
    private ArrayList<String> listTrackEventQueue = new ArrayList();
    private boolean initted;
    public static final String STR_EVENT_LAUNCHER = "ft_app_launch";
    public static final String FT_URL_STRING = "ft_url_string";
    public static final String FIREBASE_SCREEN_NAME = "firebase_screen_name";
    public static final String FIREBASE_SCREEN_CLASS = "firebase_screen_class";
    public static final String FT_LOAD_PAGE = "ft_load_page";
    private static final String TRACK_FIRST_LAUNCH = "ft_first_launch";
    private static final String TRACK_FIRST_LAUNCH_XX = "ft_app_launch_";
    private static final String TRACK_EXTRACT_STARTED = "ft_extract_started";
    private static final String TRACK_EXTRACT_FINISHED = "ft_extract_finished";
    private static final String TRACK_DOWNLOAD_RES_STARTED = "ft_resource_started";
    private static final String TRACK_DOWNLOAD_RES_FAILED = "ft_resource_failed";
    private static final String TRACK_DOWNLOAD_RES_FINISHED = "ft_resource_finished";
    private static final String TRACK_DOWNLOAD_RES_FIRST_BYTE = "ft_resource_first_byte";
    private static final String TRACK_DOWNLOAD_RES_PERCENT = "ft_resource_percent";
    private static final String TRACK_SHOW_START_GAME_SCREEN = "ft_show_startgame";
    private static final String TRACK_SCREEN_SDK = "ft_screen_webview_sdk";
    private static final String TRACK_CHARACTOR_CREATED = "ft_character_created";
    private static final String TRACK_START_TUTORIAL = "af_tutorial_started";
    private static final String TRACK_FINISH_TUTORIAL = "af_tutorial_completed";
    private static final String TRACK_REACH_A_LEVEL = "af_level_achieved";
    private static final String TRACK_VIP_LEVEL = "VIPlevel";
    private static final String TRACK_LEVEL_PLATFORM = "ft_level_platform";
    private static final String TRACK_LEVEL_ACHIEVED_A = "ft_level_achieved_A";
    private static final String TRACK_LEVEL_ACHIEVED_B = "ft_level_achieved_B";
    private static final String TRACK_LEVEL_ACHIEVED_C = "ft_level_achieved_C";
    private static final String TRACK_REGISTER_SUCCESS = "ft_register_success";
    public static final String TRACK_PAYMENT_CLICK = "ft_payment_clicked";
    public static final String TRACK_LOGIN_SUCCESS = "ft_login_success";
    public static final String TRACK_LOGIN_SUCCESS_AFTER_AUTH = "ft_login_success_after_auth";
    public static final String TRACK_AUTO_LOGIN_SUCCESS = "ft_auto_login_success";
    public static final String TRACK_AUTO_LOGIN_FAILS = "ft_auto_login_fails";
    public static final String TRACK_PAYMENT_OPEN = "ft_payment_opened";
    public static final String TRACK_PAYMENT_CLOSE = "ft_payment_closed";
    public static final String TRACK_FT_PAYMENT_SUCCESS = "ft_purchase";
    public static final String TRACK_FORM_LOGIN_OPENED = "ft_form_login_opened";
    public static final String TRACK_AUTO_LOGIN = "ft_auto_login";
    public static final String TRACK_LOGIN_CLICKED = "ft_login_clicked";
    public static final String TRACK_LOGIN_CLOSED = "ft_login_closed";
    public static final String TRACK_EVENT_LOGOUT = "ft_logout";
    public static final String TRACK_START_LOAD_WEBVIEW = "ft_start_load_webview";
    public static final String TRACK_END_LOAD_WEBVIEW = "ft_finish_load_webview";
    public static final String TRACK_ERROR_LOAD_WEBVIEW = "ft_error_load_webview";
    public static final String TRACK_FT_SESSION = "ft_session";
    public static final String TRACK_FT_LOADTIME = "ft_loadtime";
    public static final String SESSION_VALUE = "session_value";
    public static final String DELTA_LOAD_PAGE_UPDATE_INFO_START_GAME = "page_load";
    long applauncherTime;

    private FunTrackingUtil() {
    }

    public static synchronized FunTrackingUtil getInstance() {
        if (instance == null) {
            instance = new FunTrackingUtil();
        }
        return instance;
    }

    public void init(final Application context) {
        try {
            Log.i((String)this.TAG, (String)"initAppsFlyer");
            AppsFlyerLib.getInstance().enableUninstallTracking(this.gcmSenderId);
            MobGameSDK.applicationContext = context;
            AppsFlyerLib.getInstance().setCollectIMEI(false);
            AppsFlyerLib.getInstance().setCollectAndroidID(false);
            AppsFlyerLib.getInstance().setDebugLog(true);
            AppsFlyerConversionListener conversionDataListener = new AppsFlyerConversionListener(){

                public void onInstallConversionDataLoaded(Map<String, String> conversionData) {
                    try {
                        HashMap<String, Object> map = new HashMap<String, Object>(conversionData);
                        FunTrackingUtil.this.conversionDataLoaded = map;
                        if (!FunTrackingUtil.this.initted) {
                            FunTrackingUtil.this.applauncherTime = System.currentTimeMillis();
                            map.put("time_app_launcher", (String)((Object)Long.valueOf(FunTrackingUtil.this.applauncherTime)));
                            FunTrackingUtil.this.trackEvent((Context)context, FunTrackingUtil.TRACK_FIRST_LAUNCH_XX + Utils.getGameVersion((Context)context), map);
                            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)context, FunTrackingUtil.STR_EVENT_LAUNCHER, null);
                            FunTrackingUtil.this.initted = true;
                        }
                        for (String attrName : conversionData.keySet()) {
                            Log.d((String)FunTrackingUtil.this.TAG, (String)("onInstallConversionDataLoaded attribute: " + attrName + " = " + conversionData.get(attrName)));
                            if (!attrName.equals("is_first_launch") || !conversionData.get(attrName).equals("true")) continue;
                            FunTrackingUtil.this.applauncherTime = System.currentTimeMillis();
                            map.put("time_first_launcher", FunTrackingUtil.this.applauncherTime);
                            FunTrackingUtil.this.trackEvent((Context)context, FunTrackingUtil.TRACK_FIRST_LAUNCH, map);
                            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)context, FunTrackingUtil.TRACK_FIRST_LAUNCH, null);
                            if (!Preference.getBoolean((Context)context, FunTrackingUtil.TRACK_FIRST_LAUNCH, true)) continue;
                            AppsFlyerLib.getInstance().trackEvent((Context)context, "ft_first_launch_unique", map);
                            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)context, "ft_first_launch_unique", null);
                            Preference.save((Context)context, FunTrackingUtil.TRACK_FIRST_LAUNCH, false);
                        }
                        if (FunTrackingUtil.this.listTrackEventQueue != null) {
                            map.put("Resend", "when inited");
                            for (String eventName : FunTrackingUtil.this.listTrackEventQueue) {
                                FunTrackingUtil.this.trackEvent((Context)context, eventName, map);
                            }
                            FunTrackingUtil.this.listTrackEventQueue.clear();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onInstallConversionFailure(String errorMessage) {
                    FunTrackingUtil.this.initted = false;
                    Log.d((String)FunTrackingUtil.this.TAG, (String)(" onInstallConversionFailure error getting conversion data: " + errorMessage));
                }

                public void onAppOpenAttribution(Map<String, String> conversionData) {
                    for (String attrName : conversionData.keySet()) {
                        Log.d((String)FunTrackingUtil.this.TAG, (String)("onAppOpenAttribution attribute: " + attrName + " = " + conversionData.get(attrName)));
                    }
                }

                public void onAttributionFailure(String errorMessage) {
                    Log.d((String)FunTrackingUtil.this.TAG, (String)(" onAttributionFailure error onAttributionFailure : " + errorMessage));
                }
            };
            AppsFlyerLib.getInstance().init(this.appsflyerDevkey, conversionDataListener, (Context)context);
            AppsFlyerLib.getInstance().startTracking(context);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (MobGameSDK.getInstance().isLoggedIn()) {
                        EventClientManager.getInstance((Context)context).saveEventClient("start", FunTrackingUtil.STR_EVENT_LAUNCHER, null);
                    } else {
                        EventClientManager.getInstance((Context)context).saveEventClient("normal", FunTrackingUtil.STR_EVENT_LAUNCHER, null);
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startExtractData(Context context) {
        try {
            Log.d((String)this.TAG, (String)"event name : ft_extract_started");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_extract_start", currentTime);
            hashMap.put("delta_extract_start", delta);
            AppsFlyerLib.getInstance().trackEvent(context, "ft_extract_started_" + Utils.getGameVersion(context), hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_EXTRACT_STARTED, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finishExtractData(Context context) {
        try {
            Log.d((String)this.TAG, (String)"event name : ft_extract_finished");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_extract_finish", currentTime);
            hashMap.put("delta_extract_finish", delta);
            AppsFlyerLib.getInstance().trackEvent(context, "ft_extract_finished_" + Utils.getGameVersion(context), hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_EXTRACT_FINISHED, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void trackLoyalUser(Context context, String eventName) {
        try {
            Log.d((String)this.TAG, (String)("event name : " + eventName));
            AppsFlyerLib.getInstance().trackEvent(context, eventName, null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, eventName, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackEvent(Context context, String eventName, Map<String, Object> eventValues) {
        try {
            if (this.initted) {
                HashMap<String, Object> map = new HashMap<String, Object>(this.conversionDataLoaded);
                if (eventValues != null) {
                    map.putAll(eventValues);
                }
                AppsFlyerLib.getInstance().trackEvent(context, eventName, map);
                Log.d((String)this.TAG, (String)("trackEvent: " + eventName + " eventValue: " + map));
                if (Preference.getBoolean(context, eventName, true)) {
                    AppsFlyerLib.getInstance().trackEvent(context, eventName + "_unique", map);
                    FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, eventName + "_unique", map);
                    Preference.save(context, eventName, false);
                }
            } else {
                Log.d((String)this.TAG, (String)("trackEvent " + eventName + " fail cause of AppsflyerLib is not inited successful"));
                this.listTrackEventQueue.add(eventName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackOpenFormLogin(Activity activity) {
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FORM_LOGIN_OPENED, null);
            FunTrackingUtil.getInstance().trackEvent((Context)activity, TRACK_FORM_LOGIN_OPENED, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackAutoLogin(Activity activity) {
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_AUTO_LOGIN, null);
            FunTrackingUtil.getInstance().trackEvent((Context)activity, "ft_auto_login_" + Utils.getGameVersion((Context)activity), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackStartLoadWebView(Activity activity, String labelUrl, long startTime) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("LabelUrl", labelUrl);
            hashMap.put("startTime", startTime);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_START_LOAD_WEBVIEW, hashMap);
            FunTrackingUtil.getInstance().trackEvent((Context)activity, "ft_start_load_webview_" + Utils.getGameVersion((Context)activity), hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackFinishLoadWebView(Activity activity, String labelUrl, long delta) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("LabelUrl", labelUrl);
            hashMap.put("deltaTime", delta);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_END_LOAD_WEBVIEW, hashMap);
            FunTrackingUtil.getInstance().trackEvent((Context)activity, "ft_finish_load_webview_" + Utils.getGameVersion((Context)activity), hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackErrorLoadWebView(Activity activity, String labelUrl) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("LabelUrl", labelUrl);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_ERROR_LOAD_WEBVIEW, hashMap);
            FunTrackingUtil.getInstance().trackEvent((Context)activity, "ft_error_load_webview_" + Utils.getGameVersion((Context)activity), hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackOpenFormPayment(Activity activity) {
        try {
            FunTrackingUtil.getInstance().trackEvent((Context)activity, TRACK_PAYMENT_OPEN, null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_PAYMENT_OPEN, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginSuccess(Activity activity) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_login_success", currentTime);
            hashMap.put("delta_login_success", delta);
            AppsFlyerLib.getInstance().trackEvent((Context)activity, "af_login_" + Utils.getGameVersion((Context)activity), null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_LOGIN_SUCCESS_AFTER_AUTH, null);
            if (Preference.getBoolean((Context)activity, "af_login", true)) {
                AppsFlyerLib.getInstance().trackEvent((Context)activity, "af_login_unique", hashMap);
                Preference.save((Context)activity, "af_login", false);
            }
            if (Preference.getBoolean((Context)activity, TRACK_LOGIN_SUCCESS_AFTER_AUTH, true)) {
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, "ft_login_success_after_auth_unique", hashMap);
                Preference.save((Context)activity, TRACK_LOGIN_SUCCESS_AFTER_AUTH, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackAutoLoginSuccess(Activity activity) {
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_AUTO_LOGIN_SUCCESS, null);
            AppsFlyerLib.getInstance().trackEvent((Context)activity, "ft_auto_login_success_" + Utils.getGameVersion((Context)activity), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackAutoLoginFails(Activity activity) {
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_AUTO_LOGIN_FAILS, null);
            AppsFlyerLib.getInstance().trackEvent((Context)activity, TRACK_AUTO_LOGIN_FAILS, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackRegisterSuccess(Activity activity, String typeRegister) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("type_register", typeRegister);
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_register_success", currentTime);
            hashMap.put("delta_register_success", delta);
            hashMap.put("VALUE", typeRegister);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_REGISTER_SUCCESS, hashMap);
            AppsFlyerLib.getInstance().trackEvent((Context)activity, TRACK_REGISTER_SUCCESS, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginSuccessFromWeb(Activity activity, String typeLogin) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_login_success_from_web", currentTime);
            hashMap.put("delta_login_success_from_web", delta);
            hashMap.put("VALUE", typeLogin);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_LOGIN_SUCCESS, hashMap);
            AppsFlyerLib.getInstance().trackEvent((Context)activity, "ft_login_success_" + Utils.getGameVersion((Context)activity), hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginClick(Activity activity, String label, HashMap<String, Object> typeLoginClick) {
        try {
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            typeLoginClick.put("current_login_click", currentTime);
            typeLoginClick.put("delta_login_click", delta);
            AppsFlyerLib.getInstance().trackEvent((Context)activity, label, typeLoginClick);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, label, typeLoginClick);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackPayment_LoginFormClick(Activity activity, String label, String value) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("VALUE", value);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, label, map);
            AppsFlyerLib.getInstance().trackEvent((Context)activity, label, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackPaymentSuccess(Activity activity, HashMap<String, Object> eventValue) {
        try {
            AppsFlyerLib.getInstance().trackEvent((Context)activity, "af_purchase", eventValue);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FT_PAYMENT_SUCCESS, eventValue);
            if (Preference.getBoolean((Context)activity, "af_purchase", true)) {
                AppsFlyerLib.getInstance().trackEvent((Context)activity, "af_purchase_unique", null);
                Preference.save((Context)activity, "af_purchase", false);
            }
            if (Preference.getBoolean((Context)activity, TRACK_FT_PAYMENT_SUCCESS, true)) {
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, "ft_purchase_unique", null);
                Preference.save((Context)activity, TRACK_FT_PAYMENT_SUCCESS, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackSession(Activity activity, long deltaSession) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(SESSION_VALUE, String.valueOf(deltaSession));
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FT_SESSION, hashMap);
            if (Preference.getBoolean((Context)activity, TRACK_FT_SESSION, true)) {
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, "ft_session_unique", null);
                Preference.save((Context)activity, TRACK_FT_SESSION, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackingLogout(Activity activity) {
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_EVENT_LOGOUT, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceStarted(Activity activity) {
        try {
            String gameVersionName = Utils.getGameVersion((Context)activity);
            String gameVersionCode = Utils.getGameVersionCode((Context)activity);
            String versionsave = Preference.getString((Context)activity, "GAME_VERSION");
            if (!versionsave.equals(gameVersionCode)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("version name", gameVersionName);
                map.put("version code", gameVersionCode);
                long currentTime = System.currentTimeMillis();
                long delta = currentTime - this.applauncherTime;
                map.put("current_start_download_res", currentTime);
                map.put("delta_start_download_resource", delta);
                this.trackEvent((Context)activity, "ft_resource_started_" + Utils.getGameVersion((Context)activity), map);
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_DOWNLOAD_RES_STARTED, map);
            } else {
                Log.d((String)this.TAG, (String)"trackDownloadResourceStarted dont call because it is same version");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceFinished(Activity activity) {
        String gameVersionName = Utils.getGameVersion((Context)activity);
        String gameVersionCode = Utils.getGameVersionCode((Context)activity);
        String versionsave = Preference.getString((Context)activity, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            map.put("current_finish_download_res", currentTime);
            map.put("delta_finish_download_resource", delta);
            this.trackEvent((Context)activity, "ft_resource_finished_" + Utils.getGameVersion((Context)activity), map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_DOWNLOAD_RES_FINISHED, map);
        } else {
            Log.d((String)this.TAG, (String)"trackDownloadResourceFinished dont call because it is same version");
        }
        Preference.save((Context)activity, "GAME_VERSION", gameVersionCode);
    }

    public void trackDownloadResourceFailed(Context context) {
        String gameVersionName = Utils.getGameVersion(context);
        String gameVersionCode = Utils.getGameVersionCode(context);
        String versionsave = Preference.getString(context, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            map.put("current_fails_download_res", currentTime);
            map.put("delta_fails_download_resource", delta);
            this.trackEvent(context, "ft_resource_failed_" + Utils.getGameVersion(context), map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_DOWNLOAD_RES_FAILED, map);
        } else {
            Log.d((String)this.TAG, (String)"trackDownloadResourceFailed dont call because it is same version");
        }
    }

    public void firstByteDownloadResource(Context context) {
        try {
            Log.d((String)this.TAG, (String)"event name : ft_resource_first_byte");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_download_res_first_byte", currentTime);
            hashMap.put("delta_download_res_first_byte", delta);
            AppsFlyerLib.getInstance().trackEvent(context, TRACK_DOWNLOAD_RES_FIRST_BYTE, hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_DOWNLOAD_RES_FIRST_BYTE, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void downloadResourceByPercent(Context context, String percent) {
        try {
            Log.d((String)this.TAG, (String)("event name : ft_resource_percent_" + percent));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_download_res_first_byte", currentTime);
            hashMap.put("delta_download_res_first_byte", delta);
            hashMap.put("delta_download_res_percent", percent);
            AppsFlyerLib.getInstance().trackEvent(context, ("ft_resource_percent_" + percent).toString(), hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, ("ft_resource_percent_" + percent).toString(), hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showStartGameScreen(Context context) {
        try {
            Log.d((String)this.TAG, (String)"event name : ft_show_startgame");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_start_game_screen", currentTime);
            hashMap.put("delta_start_game_screen", delta);
            AppsFlyerLib.getInstance().trackEvent(context, "ft_show_startgame_" + Utils.getGameVersion(context), hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_SHOW_START_GAME_SCREEN, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackScreenFromWebview(Context context, String url, String type) {
        try {
            Log.d((String)this.TAG, (String)"event name : ft_screen_webview_sdk");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("TYPE", type);
            hashMap.put("VALUE", url);
            AppsFlyerLib.getInstance().trackEvent(context, "ft_screen_webview_sdk_" + Utils.getGameVersion(context), hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_SCREEN_SDK, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackStartTutorial(Activity activity) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.applauncherTime;
        hashMap.put("current_StartTutorial", currentTime);
        hashMap.put("delta_StartTutorial", delta);
        this.trackEvent((Context)activity, "af_tutorial_started_" + Utils.getGameVersion((Context)activity), hashMap);
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_START_TUTORIAL, hashMap);
    }

    public void trackFinishTutorial(Activity activity) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.applauncherTime;
        hashMap.put("current_FinishTutorial", currentTime);
        hashMap.put("delta_FinishTutorial", delta);
        this.trackEvent((Context)activity, "af_tutorial_completed_" + Utils.getGameVersion((Context)activity), hashMap);
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FINISH_TUTORIAL, hashMap);
    }

    public void trackCreateCharactor(Activity activity, String roleID, String areaID) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            this.trackEvent((Context)activity, "ft_character_created_" + Utils.getGameVersion((Context)activity), map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_CHARACTOR_CREATED, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoadPageUpdateInfoUser(Activity activity, long deltaLoadPage) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("delta_load_page", deltaLoadPage);
            this.trackEvent((Context)activity, "page_load_" + Utils.getGameVersion((Context)activity), map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, DELTA_LOAD_PAGE_UPDATE_INFO_START_GAME, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackVipLevel(Activity activity, String roleID, String areaID, String vipLevel) {
        Log.d((String)this.TAG, (String)"trackVipLevel: ");
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            map.put("vip_level", vipLevel);
            this.trackEvent((Context)activity, TRACK_VIP_LEVEL, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_VIP_LEVEL, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackReachALevel(Activity activity, String roleID, String areaID, String level) {
        Log.d((String)this.TAG, (String)"trackReachALevel: ");
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            map.put("level", level);
            this.trackEvent((Context)activity, "af_level_achieved_" + Utils.getGameVersion((Context)activity), map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_REACH_A_LEVEL, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String levelTracking = null;
        try {
            if (GameConfigManager.getInstance() != null && GameConfigManager.getInstance().getGameConfig() != null && GameConfigManager.getInstance().getGameConfig().getLevel() != null) {
                levelTracking = GameConfigManager.getInstance().getGameConfig().getLevel();
            }
            Log.d((String)this.TAG, (String)("trackLevelPlatform: " + levelTracking));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (levelTracking != null) {
            String[] arrLevel = levelTracking.split(",");
            for (int i = 0; i < arrLevel.length; ++i) {
                try {
                    String anLevel = arrLevel[i];
                    if (Preference.getBoolean((Context)activity, TRACK_LEVEL_PLATFORM + anLevel, false) || Integer.parseInt(level) < Integer.parseInt(anLevel)) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("LEVEL", anLevel + "");
                    this.trackEvent((Context)activity, TRACK_LEVEL_PLATFORM, map);
                    if (Integer.parseInt(level) >= Integer.parseInt(arrLevel[2])) {
                        FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_LEVEL_ACHIEVED_C, map);
                    } else if (Integer.parseInt(level) >= Integer.parseInt(arrLevel[1])) {
                        FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_LEVEL_ACHIEVED_B, map);
                    } else if (Integer.parseInt(level) >= Integer.parseInt(arrLevel[0])) {
                        FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_LEVEL_ACHIEVED_A, map);
                    } else {
                        Log.d((String)this.TAG, (String)"Do something");
                    }
                    map.clear();
                    Preference.save((Context)activity, TRACK_LEVEL_PLATFORM + anLevel, true);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getAppsflyerDevkey() {
        return this.appsflyerDevkey;
    }

    public void setAppsflyerDevkey(String appsflyerDevkey) {
        this.appsflyerDevkey = appsflyerDevkey;
    }

    public String getGcmSenderId() {
        return this.gcmSenderId;
    }

    public void setGcmSenderId(String gcmSenderId) {
        this.gcmSenderId = gcmSenderId;
    }

    public String getAppsflyerId(Context context) {
        return AppsFlyerLib.getInstance().getAppsFlyerUID(context);
    }

    public void startSession(Application application) {
        long startSession = System.currentTimeMillis();
        Preference.save((Context)application, "start_session", startSession);
    }

    public void trackLoadTime(Activity activity, long deltaTime) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("TIME_VALUE", String.valueOf(deltaTime));
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FT_LOADTIME, map);
            Preference.remove((Context)activity, "start_session");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackPaymentClose(Context context, String label) {
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, label, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

