/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.model;

import com.google.gson.annotations.SerializedName;
import com.mobgame.model.MobMenuItem;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MobMenu {
    @SerializedName(value="menu")
    ArrayList<MobMenuItem> menuItems;

    public static MobMenu parse(String json) {
        try {
            ArrayList<MobMenuItem> arrayList = new ArrayList<MobMenuItem>();
            JSONArray jSONArray = new JSONArray(json);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                try {
                    MobMenuItem mobMenuItem = new MobMenuItem();
                    JSONObject jSONObject = jSONArray.getJSONObject(i2);
                    if (jSONObject.has("id")) {
                        mobMenuItem.setId(jSONObject.getInt("id"));
                    }
                    if (jSONObject.has("sub_menu")) {
                        mobMenuItem.setSubMenu(jSONObject.getString("sub_menu"));
                    }
                    if (jSONObject.has("priority")) {
                        mobMenuItem.setPriority(jSONObject.getInt("priority"));
                    }
                    if (jSONObject.has("icon")) {
                        mobMenuItem.setIcon(jSONObject.getString("icon"));
                    }
                    if (jSONObject.has("icon_active")) {
                        mobMenuItem.setIconActive(jSONObject.getString("icon_active"));
                    }
                    if (jSONObject.has("show")) {
                        mobMenuItem.setShow(jSONObject.getBoolean("show"));
                    }
                    if (jSONObject.has("open_type")) {
                        mobMenuItem.setOpenType(jSONObject.getInt("open_type"));
                    }
                    if (jSONObject.has("open_link")) {
                        mobMenuItem.setOpenLink(jSONObject.getString("open_link"));
                    }
                    arrayList.add(mobMenuItem);
                    continue;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            MobMenu mobMenu = new MobMenu();
            mobMenu.setMenuItems(arrayList);
            return mobMenu;
        }
        catch (JSONException jSONException) {
            return new MobMenu();
        }
    }

    public ArrayList<MobMenuItem> getMenuItems() {
        if (this.menuItems == null) {
            this.menuItems = new ArrayList();
        }
        return this.menuItems;
    }

    public void setMenuItems(ArrayList<MobMenuItem> menuItems) {
        this.menuItems = menuItems;
    }
}

