/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gcm;

import android.app.AlarmManager;
import android.app.IntentService;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gcm.GCMRegistrar;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public abstract class GCMBaseIntentService
extends IntentService {
    public static final String TAG = "GCMBaseIntentService";
    private static final String WAKELOCK_KEY = "GCM_LIB";
    private static PowerManager.WakeLock sWakeLock;
    private static final Object LOCK;
    private final String[] mSenderIds;
    private static int sCounter;
    private static final Random sRandom;
    private static final int MAX_BACKOFF_MS;
    private static final String TOKEN;
    private static final String EXTRA_TOKEN = "token";

    protected GCMBaseIntentService() {
        this(GCMBaseIntentService.getName("DynamicSenderIds"), (String[])null);
    }

    protected GCMBaseIntentService(String ... senderIds) {
        this(GCMBaseIntentService.getName(senderIds), senderIds);
    }

    private GCMBaseIntentService(String name, String[] senderIds) {
        super(name);
        this.mSenderIds = senderIds;
    }

    private static String getName(String senderId) {
        String string = "GCMIntentService-" + senderId + "-" + ++sCounter;
        Log.v((String)TAG, (String)("Intent service name: " + string));
        return string;
    }

    private static String getName(String[] senderIds) {
        String string = GCMRegistrar.getFlatSenderIds(senderIds);
        return GCMBaseIntentService.getName(string);
    }

    protected String[] getSenderIds(Context context) {
        if (this.mSenderIds == null) {
            throw new IllegalStateException("sender id not set on constructor");
        }
        return this.mSenderIds;
    }

    protected abstract void onMessage(Context var1, Intent var2);

    protected void onDeletedMessages(Context context, int total) {
    }

    protected boolean onRecoverableError(Context context, String errorId) {
        return true;
    }

    protected abstract void onError(Context var1, String var2);

    protected abstract void onRegistered(Context var1, String var2);

    protected abstract void onUnregistered(Context var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onHandleIntent(Intent intent) {
        Object object;
        try {
            object = this.getApplicationContext();
            String string = intent.getAction();
            if (string.equals("com.google.android.c2dm.intent.REGISTRATION")) {
                GCMRegistrar.setRetryBroadcastReceiver(object);
                this.handleRegistration((Context)object, intent);
            } else if (string.equals("com.google.android.c2dm.intent.RECEIVE")) {
                String string2 = intent.getStringExtra("message_type");
                if (string2 != null) {
                    if (string2.equals("deleted_messages")) {
                        String string3 = intent.getStringExtra("total_deleted");
                        if (string3 != null) {
                            try {
                                int n2 = Integer.parseInt(string3);
                                Log.v((String)TAG, (String)("Received deleted messages notification: " + n2));
                                this.onDeletedMessages((Context)object, n2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                Log.e((String)TAG, (String)("GCM returned invalid number of deleted messages: " + string3));
                            }
                        }
                    } else {
                        Log.e((String)TAG, (String)("Received unknown special message: " + string2));
                    }
                } else {
                    this.onMessage((Context)object, intent);
                }
            } else if (string.equals("com.google.android.gcm.intent.RETRY")) {
                String string4 = intent.getStringExtra(EXTRA_TOKEN);
                if (!TOKEN.equals(string4)) {
                    Log.e((String)TAG, (String)("Received invalid token: " + string4));
                    return;
                }
                if (GCMRegistrar.isRegistered(object)) {
                    GCMRegistrar.internalUnregister(object);
                } else {
                    String[] stringArray = this.getSenderIds((Context)object);
                    GCMRegistrar.internalRegister(object, stringArray);
                }
            }
        }
        finally {
            object = LOCK;
            synchronized (object) {
                if (sWakeLock != null) {
                    sWakeLock.release();
                } else {
                    Log.e((String)TAG, (String)"Wakelock reference is null");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runIntentInService(Context context, Intent intent, String className) {
        Object object = LOCK;
        synchronized (object) {
            if (sWakeLock == null) {
                PowerManager powerManager = (PowerManager)context.getSystemService("power");
                sWakeLock = powerManager.newWakeLock(1, WAKELOCK_KEY);
            }
        }
        sWakeLock.acquire();
        intent.setClassName(context, className);
        context.startService(intent);
    }

    private void handleRegistration(Context context, Intent intent) {
        GCMRegistrar.cancelAppPendingIntent();
        String string = intent.getStringExtra("registration_id");
        String string2 = intent.getStringExtra("error");
        String string3 = intent.getStringExtra("unregistered");
        Log.d((String)TAG, (String)("handleRegistration: registrationId = " + string + ", error = " + string2 + ", unregistered = " + string3));
        if (string != null) {
            GCMRegistrar.resetBackoff(context);
            GCMRegistrar.setRegistrationId(context, string);
            this.onRegistered(context, string);
            return;
        }
        if (string3 != null) {
            GCMRegistrar.resetBackoff(context);
            String string4 = GCMRegistrar.clearRegistrationId(context);
            this.onUnregistered(context, string4);
            return;
        }
        Log.d((String)TAG, (String)("Registration error: " + string2));
        if ("SERVICE_NOT_AVAILABLE".equals(string2)) {
            boolean bl = this.onRecoverableError(context, string2);
            if (bl) {
                int n2 = GCMRegistrar.getBackoff(context);
                int n3 = n2 / 2 + sRandom.nextInt(n2);
                Log.d((String)TAG, (String)("Scheduling registration retry, backoff = " + n3 + " (" + n2 + ")"));
                Intent intent2 = new Intent("com.google.android.gcm.intent.RETRY");
                intent2.putExtra(EXTRA_TOKEN, TOKEN);
                PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
                AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
                alarmManager.set(3, SystemClock.elapsedRealtime() + (long)n3, pendingIntent);
                if (n2 < MAX_BACKOFF_MS) {
                    GCMRegistrar.setBackoff(context, n2 * 2);
                }
            } else {
                Log.d((String)TAG, (String)"Not retrying failed operation");
            }
        } else {
            this.onError(context, string2);
        }
    }

    static {
        LOCK = GCMBaseIntentService.class;
        sCounter = 0;
        sRandom = new Random();
        MAX_BACKOFF_MS = (int)TimeUnit.SECONDS.toMillis(3600L);
        TOKEN = Long.toBinaryString(sRandom.nextLong());
    }
}

