/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.model.giftimage;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.mobgame.model.giftimage.ImageData;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class GifData {
    private final String TAG = "GifData";
    private int numberImageLoaded = 0;
    private ArrayList<ImageData> images;
    private int secondsToRun;
    private long milisecondsToRefesh;
    private long startTime;

    public static GifData parse(String jsonDataString) throws Exception {
        GifData gifData = new GifData();
        JSONObject jSONObject = new JSONObject(jsonDataString);
        ArrayList<ImageData> arrayList = new ArrayList<ImageData>();
        JSONArray jSONArray = jSONObject.optJSONArray("images");
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            arrayList.add(new ImageData(jSONArray.optString(i2)));
        }
        gifData.setImages(arrayList);
        gifData.setMilisecondsToRefesh(jSONObject.optLong("millisecondsToRefresh"));
        gifData.setSecondsToRun(jSONObject.optInt("secondsToRun"));
        return gifData;
    }

    private void increeNumberImageLoaded() {
        ++this.numberImageLoaded;
    }

    private void resetNumberImageLoaded() {
        this.numberImageLoaded = 0;
    }

    public void fetchFrameImages(Context context, final FetchDataListener fetchDataListener) {
        if (this.images == null) {
            return;
        }
        final int n2 = this.images.size();
        int n3 = 0;
        while (n3 < n2) {
            final int n4 = n3++;
            Glide.with((Context)context).asBitmap().load(this.images.get(n4).getUrl()).into((Target)new SimpleTarget<Bitmap>(){

                public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                    try {
                        GifData.this.increeNumberImageLoaded();
                        if (GifData.this.numberImageLoaded == n2) {
                            GifData.this.resetNumberImageLoaded();
                            if (fetchDataListener != null) {
                                fetchDataListener.done(GifData.this);
                            }
                        }
                    }
                    catch (Exception exception) {
                        fetchDataListener.fail(exception.getMessage());
                    }
                }

                public void onLoadFailed(@Nullable Drawable errorDrawable) {
                    if (fetchDataListener != null) {
                        String string2 = "Load image fail!  - " + ((ImageData)GifData.this.images.get(n4)).getUrl();
                        fetchDataListener.fail(string2);
                    }
                }
            });
        }
    }

    public ArrayList<ImageData> getImages() {
        return this.images;
    }

    public void setImages(ArrayList<ImageData> images) {
        this.images = images;
    }

    public int getSecondsToRun() {
        return this.secondsToRun;
    }

    public void setSecondsToRun(int secondsToRun) {
        this.secondsToRun = secondsToRun;
    }

    public long getMilisecondsToRefesh() {
        return this.milisecondsToRefesh;
    }

    public void setMilisecondsToRefesh(long milisecondsToRefesh) {
        this.milisecondsToRefesh = milisecondsToRefesh;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public static interface FetchDataListener {
        public void done(GifData var1);

        public void fail(String var1);
    }
}

