/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.model;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.google.gson.Gson;
import com.mobgame.model.TimerObject;
import com.mobgame.utils.e;
import com.mobgame.utils.n;
import java.util.ArrayList;
import java.util.Calendar;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TimerData {
    public static final String TAG = TimerData.class.getSimpleName();
    private ArrayList<TimerObject> listTimerObject;

    public static TimerData parse(JSONArray timerObjs) throws JSONException {
        Log.d((String)TAG, (String)("TimerData::parse: " + timerObjs));
        if (timerObjs == null) {
            return new TimerData();
        }
        ArrayList<TimerObject> arrayList = new ArrayList<TimerObject>();
        long l2 = Calendar.getInstance().getTimeInMillis();
        for (int i2 = 0; i2 < timerObjs.length(); ++i2) {
            try {
                JSONObject jSONObject = timerObjs.optJSONObject(i2);
                long l3 = n.a(jSONObject.optLong("start"));
                long l4 = n.a(jSONObject.optLong("end"));
                int n2 = jSONObject.getInt("id");
                if (l3 <= 0L || l4 <= 0L) {
                    Log.d((String)TAG, (String)String.format("Time value <= 0. Skip!", new Object[0]));
                    continue;
                }
                if (l4 < l2) {
                    Log.d((String)TAG, (String)String.format("EndTime(%s) < Now(%s) => Expired!", l4, l2));
                    continue;
                }
                TimerObject timerObject = new TimerObject();
                timerObject.setId(n2);
                timerObject.setStartTime(l3);
                timerObject.setEndTime(l4);
                arrayList.add(timerObject);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        TimerData timerData = new TimerData();
        timerData.setListTimerObject(arrayList);
        return timerData;
    }

    public void removeData(Activity activity, TimerObject timer, ArrayList<TimerObject> listTimers) {
        for (int i2 = 0; i2 < listTimers.size(); ++i2) {
            if (listTimers.get(i2).getId() != timer.getId()) continue;
            listTimers.remove(i2);
        }
        TimerData timerData = new TimerData();
        timerData.setListTimerObject(listTimers);
        this.saveData((Context)activity, timerData);
    }

    public void saveData(Context context, TimerData timerData) {
        Log.i((String)TAG, (String)("saveData: " + new Gson().toJson((Object)timerData)));
        e.a(context, new Gson().toJson((Object)timerData));
    }

    public ArrayList<TimerObject> getListTimerObject() {
        return this.listTimerObject;
    }

    public void setListTimerObject(ArrayList<TimerObject> listTimerObject) {
        this.listTimerObject = listTimerObject;
    }
}

