/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gcm;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gcm.GCMBroadcastReceiver;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GCMRegistrar {
    public static final long DEFAULT_ON_SERVER_LIFESPAN_MS = 604800000L;
    private static final String TAG = "GCMRegistrar";
    private static final String BACKOFF_MS = "backoff_ms";
    private static final String GSF_PACKAGE = "com.google.android.gsf";
    private static final String PREFERENCES = "com.google.android.gcm";
    private static final int DEFAULT_BACKOFF_MS = 3000;
    private static final String PROPERTY_REG_ID = "regId";
    private static final String PROPERTY_APP_VERSION = "appVersion";
    private static final String PROPERTY_ON_SERVER = "onServer";
    private static final String PROPERTY_ON_SERVER_EXPIRATION_TIME = "onServerExpirationTime";
    private static final String PROPERTY_ON_SERVER_LIFESPAN = "onServerLifeSpan";
    private static GCMBroadcastReceiver sRetryReceiver;
    private static Context sRetryReceiverContext;
    private static String sRetryReceiverClassName;
    private static PendingIntent sAppPendingIntent;

    public static void checkDevice(Context context) {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 < 8) {
            throw new UnsupportedOperationException("Device must be at least API Level 8 (instead of " + n2 + ")");
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            packageManager.getPackageInfo(GSF_PACKAGE, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new UnsupportedOperationException("Device does not have package com.google.android.gsf");
        }
    }

    public static void checkManifest(Context context) {
        PackageInfo packageInfo;
        PackageManager packageManager = context.getPackageManager();
        String string = context.getPackageName();
        String string2 = string + ".permission.C2D_MESSAGE";
        try {
            packageManager.getPermissionInfo(string2, 4096);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Application does not define permission " + string2);
        }
        try {
            packageInfo = packageManager.getPackageInfo(string, 2);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Could not get receivers for package " + string);
        }
        ActivityInfo[] activityInfoArray = packageInfo.receivers;
        if (activityInfoArray == null || activityInfoArray.length == 0) {
            throw new IllegalStateException("No receiver for package " + string);
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("number of receivers for " + string + ": " + activityInfoArray.length));
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (ActivityInfo activityInfo : activityInfoArray) {
            if (!"com.google.android.c2dm.permission.SEND".equals(activityInfo.permission)) continue;
            hashSet.add(activityInfo.name);
        }
        if (hashSet.isEmpty()) {
            throw new IllegalStateException("No receiver allowed to receive com.google.android.c2dm.permission.SEND");
        }
        GCMRegistrar.checkReceiver(context, hashSet, "com.google.android.c2dm.intent.REGISTRATION");
        GCMRegistrar.checkReceiver(context, hashSet, "com.google.android.c2dm.intent.RECEIVE");
    }

    private static void checkReceiver(Context context, Set<String> allowedReceivers, String action) {
        PackageManager packageManager = context.getPackageManager();
        String string = context.getPackageName();
        Intent intent = new Intent(action);
        intent.setPackage(string);
        List list = packageManager.queryBroadcastReceivers(intent, 32);
        if (list.isEmpty()) {
            throw new IllegalStateException("No receivers for action " + action);
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Found " + list.size() + " receivers for action " + action));
        }
        for (ResolveInfo resolveInfo : list) {
            String string2 = resolveInfo.activityInfo.name;
            if (allowedReceivers.contains(string2)) continue;
            throw new IllegalStateException("Receiver " + string2 + " is not set with permission " + "com.google.android.c2dm.permission.SEND");
        }
    }

    public static void register(Context context, String ... senderIds) {
        GCMRegistrar.resetBackoff(context);
        GCMRegistrar.internalRegister(context, senderIds);
    }

    static void internalRegister(Context context, String ... senderIds) {
        String string = GCMRegistrar.getFlatSenderIds(senderIds);
        Log.v((String)TAG, (String)("Registering app " + context.getPackageName() + " of senders " + string));
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(GSF_PACKAGE);
        GCMRegistrar.setPackageNameExtra(context, intent);
        intent.putExtra("sender", string);
        context.startService(intent);
    }

    public static void unregister(Context context) {
        GCMRegistrar.resetBackoff(context);
        GCMRegistrar.internalUnregister(context);
    }

    static void internalUnregister(Context context) {
        Log.v((String)TAG, (String)("Unregistering app " + context.getPackageName()));
        Intent intent = new Intent("com.google.android.c2dm.intent.UNREGISTER");
        intent.setPackage(GSF_PACKAGE);
        GCMRegistrar.setPackageNameExtra(context, intent);
        context.startService(intent);
    }

    static String getFlatSenderIds(String ... senderIds) {
        if (senderIds == null || senderIds.length == 0) {
            throw new IllegalArgumentException("No senderIds");
        }
        StringBuilder stringBuilder = new StringBuilder(senderIds[0]);
        for (int i2 = 1; i2 < senderIds.length; ++i2) {
            stringBuilder.append(',').append(senderIds[i2]);
        }
        return stringBuilder.toString();
    }

    public static synchronized void onDestroy(Context context) {
        if (sRetryReceiver != null) {
            Log.v((String)TAG, (String)"Unregistering retry receiver");
            sRetryReceiverContext.unregisterReceiver((BroadcastReceiver)sRetryReceiver);
            sRetryReceiver = null;
            sRetryReceiverContext = null;
        }
    }

    static synchronized void cancelAppPendingIntent() {
        if (sAppPendingIntent != null) {
            sAppPendingIntent.cancel();
            sAppPendingIntent = null;
        }
    }

    private static synchronized void setPackageNameExtra(Context context, Intent intent) {
        if (sAppPendingIntent == null) {
            Log.v((String)TAG, (String)"Creating pending intent to get package name");
            sAppPendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(), (int)0);
        }
        intent.putExtra("app", (Parcelable)sAppPendingIntent);
    }

    static synchronized void setRetryBroadcastReceiver(Context context) {
        if (sRetryReceiver == null) {
            Object object;
            if (sRetryReceiverClassName == null) {
                Log.e((String)TAG, (String)"internal error: retry receiver class not set yet");
                sRetryReceiver = new GCMBroadcastReceiver();
            } else {
                try {
                    object = Class.forName(sRetryReceiverClassName);
                    sRetryReceiver = (GCMBroadcastReceiver)((Object)((Class)object).newInstance());
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)("Could not create instance of " + sRetryReceiverClassName + ". Using " + GCMBroadcastReceiver.class.getName() + " directly."));
                    sRetryReceiver = new GCMBroadcastReceiver();
                }
            }
            object = context.getPackageName();
            IntentFilter intentFilter = new IntentFilter("com.google.android.gcm.intent.RETRY");
            intentFilter.addCategory((String)object);
            String string = (String)object + ".permission.C2D_MESSAGE";
            Log.v((String)TAG, (String)"Registering retry receiver");
            sRetryReceiverContext = context;
            sRetryReceiverContext.registerReceiver((BroadcastReceiver)sRetryReceiver, intentFilter, string, null);
        }
    }

    static synchronized void setRetryReceiverClassName(String className) {
        Log.v((String)TAG, (String)("Setting the name of retry receiver class to " + className));
        sRetryReceiverClassName = className;
    }

    public static String getRegistrationId(Context context) {
        SharedPreferences sharedPreferences = GCMRegistrar.getGCMPreferences(context);
        String string = sharedPreferences.getString(PROPERTY_REG_ID, "");
        int n2 = sharedPreferences.getInt(PROPERTY_APP_VERSION, Integer.MIN_VALUE);
        int n3 = GCMRegistrar.getAppVersion(context);
        if (n2 != Integer.MIN_VALUE && n2 != n3) {
            Log.v((String)TAG, (String)("App version changed from " + n2 + " to " + n3 + "; resetting registration id"));
            GCMRegistrar.clearRegistrationId(context);
            string = "";
        }
        return string;
    }

    public static boolean isRegistered(Context context) {
        return GCMRegistrar.getRegistrationId(context).length() > 0;
    }

    static String clearRegistrationId(Context context) {
        return GCMRegistrar.setRegistrationId(context, "");
    }

    static String setRegistrationId(Context context, String regId) {
        SharedPreferences sharedPreferences = GCMRegistrar.getGCMPreferences(context);
        String string = sharedPreferences.getString(PROPERTY_REG_ID, "");
        int n2 = GCMRegistrar.getAppVersion(context);
        Log.v((String)TAG, (String)("Saving regId on app version " + n2));
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(PROPERTY_REG_ID, regId);
        editor.putInt(PROPERTY_APP_VERSION, n2);
        editor.commit();
        return string;
    }

    public static void setRegisteredOnServer(Context context, boolean flag) {
        SharedPreferences sharedPreferences = GCMRegistrar.getGCMPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(PROPERTY_ON_SERVER, flag);
        long l2 = GCMRegistrar.getRegisterOnServerLifespan(context);
        long l3 = System.currentTimeMillis() + l2;
        Log.v((String)TAG, (String)("Setting registeredOnServer status as " + flag + " until " + new Timestamp(l3)));
        editor.putLong(PROPERTY_ON_SERVER_EXPIRATION_TIME, l3);
        editor.commit();
    }

    public static boolean isRegisteredOnServer(Context context) {
        SharedPreferences sharedPreferences = GCMRegistrar.getGCMPreferences(context);
        boolean bl = sharedPreferences.getBoolean(PROPERTY_ON_SERVER, false);
        Log.v((String)TAG, (String)("Is registered on server: " + bl));
        if (bl) {
            long l2 = sharedPreferences.getLong(PROPERTY_ON_SERVER_EXPIRATION_TIME, -1L);
            if (System.currentTimeMillis() > l2) {
                Log.v((String)TAG, (String)("flag expired on: " + new Timestamp(l2)));
                return false;
            }
        }
        return bl;
    }

    public static long getRegisterOnServerLifespan(Context context) {
        SharedPreferences sharedPreferences = GCMRegistrar.getGCMPreferences(context);
        long l2 = sharedPreferences.getLong(PROPERTY_ON_SERVER_LIFESPAN, 604800000L);
        return l2;
    }

    public static void setRegisterOnServerLifespan(Context context, long lifespan) {
        SharedPreferences sharedPreferences = GCMRegistrar.getGCMPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(PROPERTY_ON_SERVER_LIFESPAN, lifespan);
        editor.commit();
    }

    private static int getAppVersion(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new RuntimeException("Coult not get package name: " + (Object)((Object)nameNotFoundException));
        }
    }

    static void resetBackoff(Context context) {
        Log.d((String)TAG, (String)("Resetting backoff for " + context.getPackageName()));
        GCMRegistrar.setBackoff(context, 3000);
    }

    static int getBackoff(Context context) {
        SharedPreferences sharedPreferences = GCMRegistrar.getGCMPreferences(context);
        return sharedPreferences.getInt(BACKOFF_MS, 3000);
    }

    static void setBackoff(Context context, int backoff) {
        SharedPreferences sharedPreferences = GCMRegistrar.getGCMPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(BACKOFF_MS, backoff);
        editor.commit();
    }

    private static SharedPreferences getGCMPreferences(Context context) {
        return context.getSharedPreferences(PREFERENCES, 0);
    }

    private GCMRegistrar() {
        throw new UnsupportedOperationException();
    }
}

