package com.mobgame.gui.floatbutton;

import android.animation.Animator;
import android.animation.Animator.AnimatorListener;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.PixelFormat;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver.OnGlobalLayoutListener;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.OvershootInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.RelativeLayout.LayoutParams;
import android.widget.TextView;

import com.google.gson.Gson;
import com.mobgame.MobGameHelper;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.CountdownChronometer;
import com.mobgame.gui.dialog.MobGameDashboardDialog;
import com.mobgame.gui.dialog.MobGameFloatConfirmDialog;
import com.mobgame.model.Game;
import com.mobgame.model.MobMenuItem;
import com.mobgame.model.NtfModel;
import com.mobgame.model.TimerData;
import com.mobgame.model.TimerObject;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;

import java.util.ArrayList;
import java.util.Calendar;

@SuppressLint({"InflateParams", "ClickableViewAccessibility"})
public class MobGameOverlayView {
    private static final String TAG = MobGameOverlayView.class.getSimpleName();
    private static final int ANIMAION_TIME_FADE_OUT = 300;
    private static final int ANIMAION_TIME_FADE_IN = 200;
    private static final int IDLE_TIME = 3000;
    private static final int IDLE_TIME2 = 1000;

    private static Activity activity;
    private View rootView, layoutBottom, layoutFloat;
    private TextView txtDismiss;
    //	FloatMenu smartMenu;
    private Handler idleHandler = new Handler();
    private MobGameFloatGestureView floatArea;
    private ImageView floatButton;
    private static ImageView floatButtonNtf;
    private View animationLayout;
    private View timerLayoutBottom;
    private CountdownChronometer countdownTimer;
    private boolean isHideFloatButton = false;
    private MobGameDashboardDialog dialogDashboard;

    private boolean isInit;
    private boolean isShowingMenu;
    private boolean isOutsideBottomArea;
    // Screen
    private int boundWidth, boundHeight;
    private int relativePositionOnScreen;
    private int statusBarHeight;
    private float density;

    private boolean fadeOuted;

    private boolean isShowingDashboard = false;
    private boolean isScrolling = false;

    public MobGameOverlayView(Activity a) {
        activity = a;
        enableTimer();

        floatArea = new MobGameFloatGestureView(activity);
        density = DeviceUtils.getDensity(a);
        statusBarHeight = DeviceUtils.getStatusBarHeightInPixels(activity);

        attachView();
        initView();
        hide();
    }

    public void enableTimer() {
        TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData(activity);
        if (timerData != null) {
            long now = Calendar.getInstance().getTimeInMillis();
            ArrayList<TimerObject> listTimerObj = new ArrayList<>();
            listTimerObj = timerData.getListTimerObject();

            for (int i = 0; i < listTimerObj.size(); i++) {
                TimerObject timerObject = new TimerObject();
                timerObject = listTimerObj.get(i);
                if (timerObject.getStartTime() <= now && timerObject.getEndTime() > now) {
                    FloatButtonTimerHelper.setisRuningTimer(true);
                    break;
                } else {
                    FloatButtonTimerHelper.setisRuningTimer(false);
                }

            }
        } else {
            FloatButtonTimerHelper.setisRuningTimer(false);
        }

    }

    public void attachView() {
        try {
            rootView = LayoutInflater.from(activity).inflate(R.layout.float_overlay_view, null);
            WindowManager windowManager = (WindowManager) activity.getApplicationContext()
                    .getSystemService(Activity.WINDOW_SERVICE);
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
                WindowManager.LayoutParams params = new WindowManager.LayoutParams(
                        WindowManager.LayoutParams.MATCH_PARENT,
                        WindowManager.LayoutParams.MATCH_PARENT,
                        WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY,
                        WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE,
                        PixelFormat.TRANSPARENT);
                params.gravity = Gravity.LEFT | Gravity.TOP;
                params.flags = WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE
                        | WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL
                        | WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE
                        | WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN;
                windowManager.addView(rootView, params);
            } else {
                WindowManager.LayoutParams params = new WindowManager.LayoutParams(
                        WindowManager.LayoutParams.MATCH_PARENT,
                        WindowManager.LayoutParams.MATCH_PARENT,
                        WindowManager.LayoutParams.TYPE_PHONE,
                        WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE,
                        PixelFormat.TRANSPARENT);
                params.gravity = Gravity.LEFT | Gravity.TOP;
                params.flags = WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE
                        | WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL
                        | WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE
                        | WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN;
                windowManager.addView(rootView, params);
            }
            //add bottom layout .
            rootView.getViewTreeObserver().addOnGlobalLayoutListener(new OnGlobalLayoutListener() {

                @SuppressLint("NewApi")
                public void onGlobalLayout() {

                    if (rootView != null) {
                        int[] locations = new int[2];
                        rootView.getLocationOnScreen(locations);
                        relativePositionOnScreen = locations[1];

                        if (relativePositionOnScreen == 0) {
                            boundHeight = rootView.getHeight();
                        } else {
                            boundHeight = rootView.getHeight() + relativePositionOnScreen;
                        }
//                        Log.d(TAG, "vao day roi em ah " + relativePositionOnScreen + " , " + boundHeight);
                        boundWidth = rootView.getWidth();
                        floatArea.setMovableWidth(boundWidth);
                        floatArea.setMovableHeight(boundHeight);

                        if (!isInit) {
//                            Log.d(TAG, "vao day roi em ah " + (boundHeight / 2 - 50));
                            isInit = true;
                            int x = Preference.getInt(activity , Constants.SAVE_FLOAT_AREA_X , 0);
                            int y = Preference.getInt(activity , Constants.SAVE_FLOAT_AREA_Y , (boundHeight/2 - 50));
                            floatArea.moveTo(x, y);
                            floatArea.setIsLeft(true);

                        }
                        if (Build.VERSION.SDK_INT < 16) {
                            rootView.getViewTreeObserver().removeGlobalOnLayoutListener(this);
                        } else {
                            rootView.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                        }
                    }
                }
            });

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initView() {
        try {
            Log.d(TAG, "initView");
            layoutBottom = rootView.findViewById(R.id.layout_bottom);
            layoutFloat = rootView.findViewById(R.id.layout_float);
            txtDismiss = (TextView) rootView.findViewById(R.id.txt_dismiss);
            floatButton = (ImageView) rootView.findViewById(R.id.img_float);
            floatButtonNtf = (ImageView) rootView.findViewById(R.id.img_float_ntf);
            animationLayout = rootView.findViewById(R.id.animation_layout);

            timerLayoutBottom = rootView.findViewById(R.id.timer_layouts_bottom);

            int imgRes = Res.drawableResource(activity, R.drawable.float_button);
            floatButton.setImageResource(imgRes);

            floatArea.setEventListener(mButtonEventListener);
            int x = Preference.getInt(activity , Constants.SAVE_FLOAT_AREA_X , 0);
            int y = Preference.getInt(activity , Constants.SAVE_FLOAT_AREA_Y , (boundHeight/2 - 50));

            floatArea.moveTo(x, y);

            txtDismiss.setText(Res.string(activity, R.string.dismiss));

            layoutBottom.setY(boundHeight + statusBarHeight - relativePositionOnScreen - 125 * density);
            countdownTimer = (CountdownChronometer) rootView.findViewById(R.id.countdown_timer);
            if (FloatButtonTimerHelper.isRuningTimer() == false) {
                timerLayoutBottom.setVisibility(View.GONE);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fadeOut(boolean isAnimated) {
        Log.d(TAG, "fadeOut 1");
        Log.e(TAG, "------------------------------------------------------");
        try {
            final int newX = updateFloatButtonNotf();

            if (isAnimated) {
                Log.d(TAG, "GO HERE 1 ");
                animationLayout.clearAnimation();
                animationLayout.animate()
                        .setDuration(ANIMAION_TIME_FADE_OUT)
                        .setInterpolator(new OvershootInterpolator(1f))
                        .x(newX).setListener(new AnimatorListener() {

                    @Override
                    public void onAnimationStart(Animator arg0) {

                    }

                    @Override
                    public void onAnimationRepeat(Animator arg0) {

                    }

                    @Override
                    public void onAnimationEnd(Animator arg0) {
                        Log.d(TAG, "AnimationLayout X: " + animationLayout.getX());
                        Log.d(TAG, String.format("float layout: %sx%s - animate: %sx%s", layoutFloat.getX(), layoutFloat.getY()
                                , animationLayout.getX(), animationLayout.getY()));
                        layoutFloat.clearAnimation();
                        animationLayout.clearAnimation();
                        layoutFloat.refreshDrawableState();
                    }

                    @Override
                    public void onAnimationCancel(Animator arg0) {

                    }
                }).alpha(0.5f);
                timerLayoutBottom.setAlpha(0.5f);
                floatButtonNtf.setAlpha(0.5f);
            } else {
                Log.d(TAG, "GO HERE 2 ");
                animationLayout.setX(newX);
            }
            fadeOuted = true;
            idleHandler.postDelayed(mIdleRunnable2, IDLE_TIME2);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int updateFloatButtonNotf() {
        int newX = 0;
        try {
            int buttonSize = floatArea.getSizeInPixels();
            newX = boundWidth - buttonSize / 2;

            float currentX = layoutFloat.getX();

            if (currentX <= boundWidth / 2) {
                RelativeLayout.LayoutParams lp = (LayoutParams) floatButtonNtf.getLayoutParams();
                lp.addRule(RelativeLayout.ALIGN_PARENT_LEFT, 0);
                lp.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, RelativeLayout.TRUE);
                if(DeviceUtils.isTablet(activity)){
                    lp.setMargins(0 , 1 , 8 , 0);
                }else{
                    lp.setMargins(0 , 0 , 20 , 0);
                }
                floatButtonNtf.setLayoutParams(lp);
                newX = 0;
            } else {
                RelativeLayout.LayoutParams lp = (LayoutParams) floatButtonNtf.getLayoutParams();
                lp.addRule(RelativeLayout.ALIGN_PARENT_LEFT, RelativeLayout.TRUE);
                lp.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, 0);
                if(DeviceUtils.isTablet(activity)){
                    lp.setMargins(8 , 1 , 2 , 0);
                }else{
                    lp.setMargins(20 , 0 , 0 , 0);
                }
                floatButtonNtf.setLayoutParams(lp);
                newX = 0;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        Log.d(TAG, "newX : " + newX);
        return newX;
    }

    private int updateFloatButtonNotf2() {
        int newX = 0;
        try {
            int buttonSize = floatArea.getSizeInPixels();
            newX = boundWidth - buttonSize / 2;

            float currentX = layoutFloat.getX();
            //left screen
            if (currentX <= boundWidth / 2) {
                Log.d(TAG, "Goooo 1");
                newX = -buttonSize / 2;
            } else {
                //right screen
                Log.d(TAG, "Goooo 2");
                newX = buttonSize / 2;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        Log.d(TAG, "newX 2: " + newX);
        return newX;
    }


    public void fadeIn(boolean isAnimated) {
        try {
            idleHandler.removeCallbacksAndMessages(null);
            int newX = updateFloatButtonNotf();
            if (isAnimated) {
                animationLayout.animate()
                        .setDuration(ANIMAION_TIME_FADE_IN)
                        .setInterpolator(new OvershootInterpolator(1f))
                        .x(newX)
                        .alpha(1f);
                timerLayoutBottom.setAlpha(1f);
                floatButtonNtf.setAlpha(1f);
            } else {
                animationLayout.setAlpha(1f);
                timerLayoutBottom.setAlpha(1f);
                floatButtonNtf.setAlpha(1f);
            }
            Log.d(TAG, "fadeIn :" + GameConfigManager.getInstance().getUserInfo().isEnableTimer());
            if (GameConfigManager.getInstance().getUserInfo().isEnableTimer()) {
                final TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData(activity);
                final long now = Calendar.getInstance().getTimeInMillis();
                boolean doShowTimer = conditionShowTimer(timerData, now);
                if (doShowTimer) {
                    startTimer();
                    timerLayoutBottom.setVisibility(View.VISIBLE);
                } else {
                    timerLayoutBottom.setVisibility(View.GONE);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Runnable mIdleRunnable = new Runnable() {

        @Override
        public void run() {
            try {
                if (!isScrolling) {
                    fadeOut(true);
                    showCountdownTimer(View.VISIBLE);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private Runnable mIdleRunnable2 = new Runnable() {

        @Override
        public void run() {
            fadeOut2(true);
        }
    };

    public void fadeOut2(boolean isAnimated) {
        Log.d(TAG, "fadeOut 2");
        try {
            if (!isHideFloatButton) {
                final int newX = updateFloatButtonNotf2();
                if (isAnimated) {
                    animationLayout.animate()
                            .setDuration(ANIMAION_TIME_FADE_OUT)
                            .setInterpolator(new OvershootInterpolator(1f))
                            .x(newX)
                            .alpha(0.5f);
                    timerLayoutBottom.setAlpha(0.5f);
                    floatButtonNtf.setAlpha(0.5f);
                } else {
                    animationLayout.setAlpha(0.5f);
                    timerLayoutBottom.setAlpha(0.5f);
                    floatButtonNtf.setAlpha(0.5f);

                }

                if (layoutFloat.getVisibility() != View.GONE) {
                    if (GameConfigManager.getInstance().getUserInfo().isEnableTimer()) {
                        final TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData(activity);
                        final long now = Calendar.getInstance().getTimeInMillis();
                        boolean doShowTimer = conditionShowTimer(timerData, now);
                        if (doShowTimer) {
                            if (floatArea.isLeft()) {
                                Log.d(TAG, "Go here left");

                                floatArea.fadeOutLeft();
                            } else {
                                Log.d(TAG, "Go here 2");
                                floatArea.fadeOutRight();

                            }
                        } else {
                            timerLayoutBottom.setVisibility(View.GONE);
                        }
                    }

                }
                timerLayoutBottom.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean doTouchDown = false;
    private MobGameFloatGestureView.EventListener mButtonEventListener = new MobGameFloatGestureView.EventListener() {
        int x = 0, y = (int) boundHeight / 2;
        boolean onTouchMove = false;

        @Override
        public void onTouchDown(MotionEvent event) {
//			Log.e(TAG , "onTouchDown");
            isOutsideBottomArea = true;
            fadeIn(true);
            x = floatArea.getX();
            y = floatArea.getY();
            doTouchDown = true;
        }

        @Override
        public void onTouchMove(MotionEvent event) {
            try {
//				Log.e(TAG , "onTouchMove");
                onTouchMove = true;
                if (isOutsideBottomArea) {
                    showLayoutBottom();
                }
                isOutsideBottomArea = false;
                if (isInDismissArea(event.getRawX(), event.getRawY())) {
                    txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_active, 0, 0);
                    txtDismiss.setTextColor(Color.rgb(194, 39, 45));
                } else {

                    txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_normal, 0, 0);
                    txtDismiss.setTextColor(Color.rgb(255, 255, 255));
                }

                haveShowNotification = false;
                sizeListNtf = 1;
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onTouchUp(MotionEvent event) {
            try {

                doTouchDown = false;
                onTouchMove = false;
                idleHandler.removeCallbacksAndMessages(null);
                if (haveShowNotification) {
                    Log.e(TAG, "HAVAHVAHVAHVAH");
                    handlerFadeOut();
                    haveShowNotification = false;
                    sizeListNtf = 1;
                } else {
                    Log.e(TAG, "HAVAHVAHVAHVAH 2");
                    handlerFadeOut();
                }

                hideLayoutBottom();
                isOutsideBottomArea = true;

                floatArea.moveToEdge(true);

                if (event != null) {
                    if (isInDismissArea(event.getRawX(), event.getRawY())) {

                        showConfirmDialog(x, y);

                        layoutFloat.setVisibility(View.GONE);
                        floatArea.hide();

                        long dismissTime = Calendar.getInstance().getTimeInMillis();
                        Preference.save(activity,
                                Constants.SHARED_PREF_FLOAT_BUTTON_DISMISS_TIME, dismissTime);
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }


        @Override
        public void onClick(MotionEvent event) {
            try {
                //Click float button
                Log.e(TAG , "onClick : " + onTouchMove);
                if (!onTouchMove) {
					Log.e(TAG , "onClick");
                    showDashboard();
                }
            } catch (Exception e) {
                e.printStackTrace();
                isShowingDashboard = false;
            }

        }

        @Override
        public void onMove(int x, int y) {
            try {
//				Log.d(TAG , "onMove");
                x = Math.max(0, Math.min(boundWidth - floatArea.getSizeInPixels(), x));
                y = Math.max(0, Math.min(boundHeight - floatButton.getHeight(), y));
                if (countdownTimer != null && countdownTimer.getVisibility() == View.VISIBLE) {
                    y = Math.max(0, Math.min(boundHeight - floatButton.getHeight() - timerLayoutBottom.getHeight(), y));
                } else {
                    y = Math.max(0, Math.min(boundHeight - floatButton.getHeight(), y));
                }
                layoutFloat.setX(x);
                layoutFloat.setY(y);
                if (animationLayout != null && fadeOuted) {
                    animationLayout.setX(0);
                    fadeOuted = false;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    };

    private void handlerFadeOut() {
        Log.d(TAG, "handlerFadeOut: ");
        if (idleHandler == null)
            idleHandler = new Handler();
        idleHandler.removeCallbacksAndMessages(null);
        updateFloatButtonNotf();
        idleHandler.postDelayed(mIdleRunnable, IDLE_TIME);
    }

    public void showDashboard() {
        try {

            dialogDashboard = new MobGameDashboardDialog();
            FragmentManager fm = activity.getFragmentManager();
            Bundle bundle = new Bundle();
            ArrayList<MobMenuItem> listMenuItem = new ArrayList<>();
            listMenuItem = GameConfigManager.getInstance().getMobMenu().getMenuItems();
            String data = "";
            MobMenuItem menuItem = new MobMenuItem();
            menuItem = getItemByPriority(listMenuItem);
            switch (menuItem.getId()) {
                case 1:
                    Gson gson1 = new Gson();
                    data = gson1.toJson(menuItem.getSubMenu());
                    break;
                case 4:
                    Gson gson4 = new Gson();
                    data = gson4.toJson(menuItem.getSubMenu());
                    break;
                case 6:
                    Gson gson6 = new Gson();
                    data = gson6.toJson(menuItem.getSubMenu());
                    break;
                case 8:
                    Gson gson8 = new Gson();
                    data = gson8.toJson(menuItem.getSubMenu());
                    break;
            }
            Log.d(TAG, "data : " + data);
            bundle.putString(MobGameDashboardDialog.KEY_DATA, data);
            bundle.putString(MobGameDashboardDialog.KEY_ICON, menuItem.getIconActive());
            bundle.putInt(MobGameDashboardDialog.KEY_ID, menuItem.getId());
            bundle.putBoolean(MobGameDashboardDialog.KEY_SHOW, menuItem.isShow());
            if (endTime != 0) {
                bundle.putLong(MobGameDashboardDialog.KEY_TIMER, endTime);// Can truyen them id_menu sang
            }
            dialogDashboard.setArguments(bundle);
            fm.beginTransaction().addToBackStack("stack").commitAllowingStateLoss();
            dialogDashboard.show(fm, "Dashboard Fragment");
            isShowingDashboard = true;
            Log.d(TAG, "onclick floatbutton: isShowingDashboard=" + isShowingDashboard);
            dialogDashboard.setEventListener(new MobGameDashboardDialog.EventListener() {
                @Override
                public void onDismissDashboard() {
                    isShowingDashboard = false;
                    Log.d(TAG, "onDismiss: isShowingDashboard=" + isShowingDashboard);
                }
            });

            MobGameSDK.getInstance().unRegisterSensor();
            Game game = GameConfigManager.getInstance().getGameConfig();
            boolean isShowLogo = game.getEx().isShowLogo();
            if(isShowLogo){
                MobGameHelper.hideNotiFloatButton();
            }
            MobGameHelper.hideFloatButton();
        } catch (Exception e) {
            Log.e(TAG , "onClick Error");
            e.printStackTrace();
        }
    }

    public void hideDashboard(){
        try{
            if(dialogDashboard!=null){
                dialogDashboard.dismiss();
                isShowingDashboard = false;
            }
        }catch (Exception e){
            e.printStackTrace();
            isShowingDashboard = false;
        }
    }

    @SuppressLint("NewApi")
    private void showCountdownTimer(int visibility) {
        try {
            if (countdownTimer == null) {
                return;
            }
            if (!countdownTimer.isRunning()) {
                if (countdownTimer.getVisibility() == View.VISIBLE) {
                    countdownTimer.setVisibility(View.GONE);
                    timerLayoutBottom.setVisibility(View.GONE);
                }
                return;
            }
            TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData(activity);
            if (timerData.getListTimerObject().isEmpty()) {
                return;
            }
            countdownTimer.setVisibility(visibility);
            timerLayoutBottom.setVisibility(visibility);
            if (rootView != null) {
                rootView.postInvalidateOnAnimation();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MobMenuItem getItemByPriority(ArrayList<MobMenuItem> mobMenuItems) {
        try {
            int min = 0;
            MobMenuItem menuItem = new MobMenuItem();
            // khoi tao
            for (int i = 0; i < mobMenuItems.size(); i++) {
                if (mobMenuItems.get(i).isShow()) {
                    min = mobMenuItems.get(i).getPriority();
                    menuItem = mobMenuItems.get(i);
                    break;
                }
            }
            for (int i = 0; i < mobMenuItems.size(); i++) {
                if (mobMenuItems.get(i).isShow() && mobMenuItems.get(i).getPriority() < min) {
                    min = mobMenuItems.get(i).getPriority();
                    menuItem = mobMenuItems.get(i);
                }
            }
            return menuItem;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private BroadcastReceiver receiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            Log.d(TAG, "BroadcastReceiver::onReceive");
            try {
                String category = intent.getStringExtra("category");
                Log.e(TAG, "category:" + category);
                if (category != null) {
                    if ("dashboard".equalsIgnoreCase(category)) {

                        String data = intent.getStringExtra("data");
                        if (!TextUtils.isEmpty(data)) {

                        } else {
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    };

    public static void setNtf(boolean isHide) {
        try {
            if (!FloatButtonTimerHelper.isRuningTimer() && NotificationUtils.hasNtf(activity)) {
                floatButtonNtf.setVisibility(View.VISIBLE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isInBottomArea(float left, float top) {
        try {
            int dY = (int) (boundHeight - 150 * density);
            return top >= dY || isInDismissArea(left, top);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isInDismissArea(float left, float top) {
        try {
            int dX = boundWidth / 2;
            int dY = (int) (boundHeight - 30 * density);
            double distance = Math.sqrt(Math.pow(left - dX, 2) + Math.pow(top - dY, 2));
            double maxDistance = Math.min(120 * density, boundWidth / 5);

            return distance <= maxDistance
                    || (top >= dY && left >= dX - maxDistance && left <= dX + maxDistance);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void showLayoutBottom() {
        try {
            layoutBottom.setVisibility(View.VISIBLE);
            if (relativePositionOnScreen != 0) {
                layoutBottom.animate()
                        .setDuration(200)
                        .y(boundHeight + statusBarHeight - relativePositionOnScreen - 100 * density);
            } else {
                layoutBottom.animate()
                        .setDuration(200)
                        .y(boundHeight + statusBarHeight - relativePositionOnScreen - 125 * density);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideLayoutBottom() {
        try {
            layoutBottom.animate()
                    .setDuration(200)
                    .y(boundHeight + statusBarHeight - relativePositionOnScreen);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    DialogFragment dialog = null;

    public void showConfirmDialog(final int x, final int y) {
        try {

            Preference.save(activity, Constants.SHARED_PREF_SHOW_CONFIRM_DIALOG_HIDE_FLOAT, true);
            dialog = new MobGameFloatConfirmDialog(activity, new MobGameFloatConfirmDialog.EventListener() {

                @Override
                public void onConfirmClick(View v) {
                    Preference.save(activity,
                            Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, false);
                    // vao day thi moi ghi nhan su kien hide floatbutton .
                    layoutFloat.setVisibility(View.GONE);
                    floatArea.hide();
                    hideConfirmDialog();
                    Preference.save(activity, Constants.SHARED_PREF_SHOW_CONFIRM_DIALOG_HIDE_FLOAT, false);
                    Preference.remove(activity , Constants.SHARED_PREF_SHOW_DASHBOARD);
                }

                @Override
                public void onCancelClick(View v) {
                    hideConfirmDialog();
                    floatArea.moveTo(x, y);
                    MobGameHelper.showFloatButton();

                    Preference.save(activity, Constants.SHARED_PREF_SHOW_CONFIRM_DIALOG_HIDE_FLOAT, false);
                    Preference.remove(activity , Constants.SHARED_PREF_SHOW_DASHBOARD);
                }

            });

            MobGameSDK.getInstance().registerSensor();

            dialog.show(activity.getFragmentManager(), "tag_fragment_confirm");
        } catch (Exception e) {
            hideConfirmDialog();
        }
    }

    public void hideConfirmDialog() {
        try {
            if (dialog != null && dialog.isAdded()) {
                dialog.dismiss();
                dialog = null;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show(boolean isShowTimer) {
        try {
            isHideFloatButton = false;
            layoutFloat.setVisibility(View.VISIBLE);
            layoutBottom.setVisibility(View.GONE);
            floatArea.show();
            Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
            floatArea.moveToEdge(true);
            hideConfirmDialog();
            idleHandler.removeCallbacksAndMessages(null);
            fadeIn(false);

            if (NotificationUtils.getListNtfFromAfterAuth().size() > 0) {
                haveShowNotification = true;
                sizeListNtf = NotificationUtils.getListNtfFromAfterAuth().size();
            } else {
                haveShowNotification = false;
                sizeListNtf = 1;
            }
            if (haveNotiGCM) {
                haveShowNotification = true;
            }
            if (haveShowNotification) {
                Log.e(TAG, "HAVAHVAHVAHVAH 3");
                handlerFadeOut();
                haveShowNotification = false;
                haveNotiGCM = false;
                sizeListNtf = 1;
            } else {
                Log.e(TAG, "HAVAHVAHVAHVAH 4");
                handlerFadeOut();
            }
            MobGameSDK.getInstance().unRegisterSensor();
            if (NotificationUtils.hasNtf(activity)) {
                Log.d(TAG, "Vao day 5");
                floatButtonNtf.setVisibility(View.VISIBLE);
                return;
            }
            Log.d(TAG, "Vao day 4");
            floatButtonNtf.setVisibility(View.GONE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showFloatButtonToCenter() {
        try {
            floatArea.moveTo(0, boundHeight / 2 - 50);
            MobGameHelper.showFloatButton();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hide() {
        try {
            idleHandler.removeCallbacksAndMessages(null);
            layoutFloat.setVisibility(View.GONE);
            layoutBottom.setVisibility(View.GONE);
            floatArea.hide();
            isHideFloatButton = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean haveShowNotification = false;
    private boolean haveNotiGCM = false;
    private int sizeListNtf = 1;

    public synchronized void viberateGCM(final ArrayList<NtfModel> listNtf) {
        try {
            haveShowNotification = true;
            sizeListNtf = listNtf.size();
            haveNotiGCM = true;
            viberate(listNtf);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void viberate(final ArrayList<NtfModel> listNtf) {
        try {
            if (!Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, false)) {
                Log.d(TAG, "GOOOOOOO HEREEEEE");
                timerLayoutBottom.setAlpha(1f);
                floatButtonNtf.setAlpha(1f);
                show(FloatButtonTimerHelper.isRuningTimer());

            }
            final Animation viberate = AnimationUtils.loadAnimation(activity, R.anim.viberate);
            viberate.setAnimationListener(new Animation.AnimationListener() {
                @Override
                public void onAnimationStart(Animation animation) {
                    timerLayoutBottom.setAlpha(1f);
                    floatButtonNtf.setAlpha(1f);
                }

                @Override
                public void onAnimationEnd(Animation animation) {
                    if (listNtf != null && listNtf.size() > 0) {
                        Log.d(TAG, "GOOOOOOO HEREEEEE  " + !doTouchDown);
                        if (!doTouchDown) {
                            floatArea.showMsg(listNtf);
                        }
                        isScrolling = true;
                        floatArea.setOnScrollFinishedListener(new MobGameFloatGestureView.OnScrollFinishedListener() {
                            @Override
                            public void onScrollFinished() {
                                isScrolling = false;
                                idleHandler.removeCallbacksAndMessages(null);
                                idleHandler.postDelayed(mIdleRunnable, 300);
                            }
                        });
                        haveShowNotification = true;
                        sizeListNtf = listNtf.size();
                    }
                }

                @Override
                public void onAnimationRepeat(Animation animation) {

                }
            });
            floatButton.startAnimation(viberate);
            if (NotificationUtils.hasNtf(activity)) {
                floatButtonNtf.startAnimation(viberate);
            }
            //check neu co timer
            if (GameConfigManager.getInstance().getUserInfo().isEnableTimer()) {
                final TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData(activity);
                final long now = Calendar.getInstance().getTimeInMillis();
                boolean doShowTimer = conditionShowTimer(timerData, now);
                if (doShowTimer) {
                    timerLayoutBottom.startAnimation(viberate);
                } else {
                    timerLayoutBottom.setVisibility(View.GONE);
                }
            } else {
                timerLayoutBottom.setVisibility(View.GONE);
            }

            GameConfigManager.getInstance().setHasUnreadNotifications(false);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isShowing() {
        try {
            return layoutFloat.getVisibility() == View.VISIBLE;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isShowingConfirmDialog() {
        try {
            return dialog != null && dialog.isVisible();
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void dismiss() {
        try {
            rootView.setVisibility(View.GONE);
            WindowManager windowManager = (WindowManager) activity.getApplicationContext().getSystemService(
                    Activity.WINDOW_SERVICE);
            windowManager.removeView(rootView);
            if (floatArea != null) {
                floatArea.dismiss();
            }
            rootView = null;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    long startTime, endTime;
    int id;
    ArrayList<TimerObject> listTimers = new ArrayList<>();

    public void startTimer() {
        Log.d(TAG, "startTimer");
        try {
            final long now = Calendar.getInstance().getTimeInMillis();
            final TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData(activity);
            if (timerData != null) {
                listTimers = timerData.getListTimerObject();

                Log.i(TAG, "Now: ");
                if (listTimers.isEmpty()) {
                    Log.d(TAG, "Queue timer is empty!");
                    return;
                }

                if (countdownTimer != null) {
                    countdownTimer.setVisibility(countdownTimer.isRunning() ? View.VISIBLE : View.GONE);
                }
                startTime = listTimers.get(0).getStartTime();
                endTime = listTimers.get(0).getEndTime();
                id = listTimers.get(0).getId();
                Log.i(TAG, "start: " + startTime);

                //su kien chua toi thoi gian
                for (int i = 0; i < listTimers.size(); i++) {
                    if (listTimers.get(i).getStartTime() < now) {
                        startTime = listTimers.get(i).getStartTime();
                        endTime = listTimers.get(i).getEndTime();
                        id = listTimers.get(i).getId();
                        break;
                    }
                }

                //su kien da qua - thi clear su kien do di
                if (endTime < now) {
                    Log.d(TAG, "End time < Now, restart timer :endTime " + endTime + " , now:" + now);
                    try {
                        TimerObject timerObject = new TimerObject(id, startTime, endTime);
                        timerData.removeData(activity, timerObject, listTimers);
                        if (listTimers.isEmpty()) {
                            return;
                        }
                        startTimer();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }

                //Check hien thi timer
                Log.i(TAG, "Countdown time: " + startTime + " ," + endTime);
                if (startTime <= now && endTime > now) {

                    final long countDownTime = endTime - now;
                    //Thoi code
                    FloatButtonTimerHelper.setisRuningTimer(true);

                    countdownTimer.setVisibility(View.VISIBLE);

                    floatArea.setEndTimer(endTime);
                    countdownTimer.setBase(Calendar.getInstance().getTime().getTime() + countDownTime);
                    Log.d(TAG, "can loi : " + (Calendar.getInstance().getTime().getTime() + countDownTime));
                    countdownTimer.setCountdownListener(new CountdownChronometer.CountdownListener() {

                        @Override
                        public void done() {
                            Log.d(TAG, "Countdown done!");

                            try {

                                if (countdownTimer != null) {
                                    countdownTimer.setVisibility(View.GONE);
                                    FloatButtonTimerHelper.setcanRunTimer(false);
                                    FloatButtonTimerHelper.setisRuningTimer(false);
                                    countdownTimer.clearComposingText();
                                    countdownTimer.clearFocus();
                                }
                                if (NotificationUtils.hasNtf(activity)) {
                                    floatButtonNtf.setVisibility(View.VISIBLE);
                                }

                                new Handler().postDelayed(new Runnable() {
                                    @Override
                                    public void run() {
                                        startTimer();
                                    }
                                }, 1500);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    countdownTimer.start();
                    Log.d(TAG, "Start countdown");
                    return;
                }

                Log.d(TAG, "Events have not started yet!");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean conditionShowTimer(final TimerData timerData, long now) {
        try {
            ArrayList<TimerObject> listTimers = new ArrayList<>();
            if (timerData != null)
                listTimers = timerData.getListTimerObject();

            Log.i(TAG, "Now: ");
            if (listTimers.isEmpty()) {
                Log.d(TAG, "Queue timer is empty!");
                return false;
            }

            if (countdownTimer != null) {
                countdownTimer.setVisibility(countdownTimer.isRunning() ? View.VISIBLE : View.GONE);
            }
            long startTime = listTimers.get(0).getStartTime();
            long endTime = listTimers.get(0).getEndTime();
            id = listTimers.get(0).getId();
            Log.i(TAG, "start: " + startTime);

            //su kien chua toi thoi gian
            for (int i = 0; i < listTimers.size(); i++) {
                if (listTimers.get(i).getStartTime() < now) {
                    startTime = listTimers.get(i).getStartTime();
                    endTime = listTimers.get(i).getEndTime();
                    id = listTimers.get(i).getId();
                    break;
                }
            }

            //su kien da qua - thi clear su kien do di
            if (endTime < now) {
                Log.d(TAG, "End time < Now, restart timer :endTime " + endTime + " , now:" + now);
                try {
                    TimerObject timerObject = new TimerObject(id, startTime, endTime);
                    timerData.removeData(activity, timerObject, listTimers);
                    if (listTimers.isEmpty()) {
                        return false;
                    }
                    startTimer();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
            if (startTime <= now && endTime > now) {
                return true;
            }
            return false;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isShowingDashboard() {
        return isShowingDashboard;
    }
}
