package com.mobgame.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;

import com.mobgame.R;
import com.mobgame.component.GameConfigManager;

public class Res {
	
	public static String string(Context context, int key) {
		try{
			String currentLang = Constants.LANG_EN;
			if (GameConfigManager.getInstance().getGameConfig() != null) {
				currentLang = GameConfigManager.getInstance().getGameConfig().getLang();
			}
			if (Constants.LANG_VI.equalsIgnoreCase(currentLang)) {

				if (R.string.hello == key) return "Chào";
				if (R.string.reload == key) return "Tải lại";
				if (R.string.connection_lost == key) return "Mất kết nối";
				if (R.string.something_went_wrong == key) return "Có lỗi xảy ra";
				if (R.string.connection_error == key) return "Lỗi kết nối";
				if (R.string.unable_to_connect == key) return "Không thể kết nối tới server";
				if (R.string.dialog_tips_title == key) return "Bạn có thể hiển thị nút điều khiển như sau";
				if (R.string.dont_ask_again == key) return "Không hiển thị lại";
				if (R.string.dismiss == key) return "Kéo vào đây để ẩn";
				if (R.string.remind_me == key) return "Bỏ qua";
				if (R.string.retry == key) return "Thử lại";
				if (R.string.exit == key) return "Thoát";
				if (R.string.please_wait == key) return "Xin đợi";
				if (R.string.logging_in == key) return "Đang đăng nhập";
				if (R.string.connecting_facebook == key) return "Đang kết nối tới Facebook của bạn";
				if (R.string.connecting_google == key) return "Đang kết nối tới tài khoản Google của bạn";
				if (R.string.connecting_google_play == key) return "Đang kết nối tới Google Play";
				if (R.string.connecting_server == key) return "Đang kết nối tới server";
				if (R.string.copied == key) return "Đã copy!";
				if (R.string.copy == key) return "Copy";
				if (R.string.complete_now == key) return "Hoàn thành ngay";
				if (R.string.notice == key) return "Thông báo";
				if (R.string.bind_account == key) return "Nối tài khoản ngay";
				if (R.string.attention_overlay == key) return "Chú ý";
				if (R.string.attention_permission == key) return "Chú ý";
				if (R.string.attention_message == key) return "Bạn cần quyền truy cập bộ nhớ để giải nén tài nguyên game.";
				if (R.string.draw_over_apps_message == key) return "Bạn cần cấp thêm quyền để game hoạt động tốt nhất";
				if (R.string.hide == key) return "Ẩn";
				if (R.string.cancel == key) return "Hủy";
				if (R.string.warning == key) return "Chú ý";
				if (R.string.message_warning == key) return "Bạn cần cấp quyền để có thể trải nghiệm ứng dụng tốt nhất";
				if (R.string.do_you_want_close == key) return "Bạn có muốn đóng không ?";
				if (R.string.message_exit == key) return "Bạn có muốn thoát không ?";
				if (R.string.close == key) return "Đóng";
				if (R.string.alert_image_validate == key) return "Chỉ được chọn tối đa 3 ảnh";
				if (R.string.images_selected == key) return "Ảnh đã chọn";

				if (R.string.logout == key) return "Đăng xuất";
			} else if (Constants.LANG_CN.equalsIgnoreCase(currentLang)) {

				if (R.string.hello == key) return "您好";
				if (R.string.reload == key) return "重装";
				if (R.string.connection_lost == key) return "不好意思！网路连接不佳。";
				if (R.string.something_went_wrong == key) return "不好意思！出现错误问题！";
				if (R.string.connection_error == key) return "连接问题";
				if (R.string.unable_to_connect == key) return "无法连接服务器";
				if (R.string.dialog_tips_title == key) return "您可以以下动作而复现管制按钮";
				if (R.string.dont_ask_again == key) return "不再访问";
				if (R.string.dismiss == key) return "屏蔽区";
				if (R.string.remind_me == key) return "提醒我";
				if (R.string.retry == key) return "重试";
				if (R.string.exit == key) return "闪退";
				if (R.string.please_wait == key) return "请稍等";
				if (R.string.logging_in == key) return "登陆中";
				if (R.string.connecting_facebook == key) return "Facebook账号登陆中";
				if (R.string.connecting_google == key) return "Google账号登陆中";
				if (R.string.connecting_google_play == key) return "Google Play账号登陆中";
				if (R.string.connecting_server == key) return "连接服务器中";
				if (R.string.copied == key) return "已复制";
				if (R.string.copy == key) return "复制";
				if (R.string.complete_now == key) return "已完成";
				if (R.string.notice == key) return "注意";
				if (R.string.bind_account == key) return "连接账号";
				if (R.string.attention_overlay == key) return "注意";
				if (R.string.attention_permission == key) return "注意";
				if (R.string.attention_message == key) return "为了解压游戏资源，请接应读写权限.";
				if (R.string.draw_over_apps_message == key) return "为了打开游戏的特征，请打开Draw Over Apps权限";
				if (R.string.hide == key) return "屏蔽";
				if (R.string.cancel == key) return "取消";
				if (R.string.warning == key) return "注意";
				if (R.string.message_warning == key) return "为了服务及提高游戏体验，游戏需要您打开权限";
				if (R.string.do_you_want_close == key) return "您想关闭";
				if (R.string.message_exit == key) return "您想关闭";
				if (R.string.close == key) return "关闭";
				if (R.string.alert_image_validate == key) return "您可选择最多三张图";
				if (R.string.images_selected == key) return "已选图片";

				if (R.string.logout == key) return "登出";

			} else if (Constants.LANG_ID.equalsIgnoreCase(currentLang)) {

				if (R.string.hello == key) return "Halo";
				if (R.string.reload == key) return "Memuat ulang";
				if (R.string.something_went_wrong == key) return "Oops! Terjadi kesalahan";
				if (R.string.connection_error == key) return "Koneksi error";
				if (R.string.unable_to_connect == key) return "Tidak dapat terhubung ke server";
				if (R.string.dialog_tips_title == key) return "Tampilkan tombol";
				if (R.string.dont_ask_again == key) return "Jangan tanya lagi";
				if (R.string.dismiss == key) return "Abaikan";
				if (R.string.remind_me == key) return "Ingatkan";
				if (R.string.retry == key) return "Coba lagi";
				if (R.string.exit == key) return "Keluar";
				if (R.string.please_wait == key) return "Harap tunggu";
				if (R.string.logging_in == key) return "Masuk";
				if (R.string.connecting_facebook == key) return "Terhubung ke akun Facebook";
				if (R.string.connecting_google == key) return "Terhubung ke akun Google";
				if (R.string.connecting_google_play == key) return "Terhubung ke akun Google Play";
				if (R.string.connecting_server == key) return "Terhubung ke server";
				if (R.string.copied == key) return "Disalin!";
				if (R.string.copy == key) return "Disalin";
				if (R.string.complete_now == key) return "Selesai";
				if (R.string.notice == key) return "Pemberitahuan";
				if (R.string.bind_account == key) return "Ikat akun";
				if (R.string.attention_overlay == key) return "Notice";
				if (R.string.attention_permission == key) return "Attention";
				if (R.string.attention_message == key) return "We need read and write permission to extract game resource.";
				if (R.string.draw_over_apps_message == key) return "We need to grant Draw Over Apps permission to enable game to perform its full features";
				if (R.string.hide == key) return "Hide";
				if (R.string.cancel == key) return "Cancel";
				if (R.string.warning == key) return "Attention";
				if (R.string.message_warning == key) return "We need more permission to deliver the best experience";
				if (R.string.do_you_want_close == key) return "Do you want close ?";
				if (R.string.message_exit == key) return "Do you want exit ?";
				if (R.string.close == key) return "Close";
				if (R.string.alert_image_validate == key) return "You can only select upto 3 photos";
				if (R.string.images_selected == key) return "Images selected";

				if (R.string.logout == key) return "Logout";
			} else {
				if (R.string.hello == key) return "Hello";
				if (R.string.reload == key) return "Reload";
				if (R.string.connection_lost == key) return "Oops! Connection lost";
				if (R.string.something_went_wrong == key) return "Oops! Something went wrong";
				if (R.string.connection_error == key) return "Connection error";
				if (R.string.unable_to_connect == key) return "Cannot connect to server";
				if (R.string.dialog_tips_title == key) return "You can show up the control button as following";
				if (R.string.dont_ask_again == key) return "Don't ask again";
				if (R.string.dismiss == key) return "Drop here to hide";
				if (R.string.remind_me == key) return "Remind me";
				if (R.string.retry == key) return "Retry";
				if (R.string.exit == key) return "Exit";
				if (R.string.please_wait == key) return "Please wait";
				if (R.string.logging_in == key) return "Logging in";
				if (R.string.connecting_facebook == key) return "Connecting to your Facebook account";
				if (R.string.connecting_google == key) return "Connecting to your Google account";
				if (R.string.connecting_google_play == key) return "Connecting to your Google Play account";
				if (R.string.connecting_server == key) return "Connecting to server";
				if (R.string.copied == key) return "Copied!";
				if (R.string.copy == key) return "Copy";
				if (R.string.complete_now == key) return "Complete now";
				if (R.string.notice == key) return "Notice";
				if (R.string.bind_account == key) return "Bind account";
				if (R.string.attention_overlay == key) return "Notice";
				if (R.string.attention_permission == key) return "Attention";
				if (R.string.attention_message == key) return "We need read and write permissions to extract game resource.";
				if (R.string.draw_over_apps_message == key) return "We need to grant Draw Over Apps permission to enable game to perform its full features";
				if (R.string.hide == key) return "Hide";
				if (R.string.cancel == key) return "Cancel";
				if (R.string.warning == key) return "Attention";
				if (R.string.message_warning == key) return "We need more permission to deliver the best experience";
				if (R.string.do_you_want_close == key) return "Do you want close ?";
				if (R.string.message_exit == key) return "Do you want to exit ?";
				if (R.string.close == key) return "Close";
				if (R.string.alert_image_validate == key) return "You can only select upto 3 photos";
				if (R.string.images_selected == key) return "Images selected";

				if (R.string.logout == key) return "Logout";
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return "";
	}
	
	public static int drawableResource(Context context, int id) {
		String currentLang = Constants.LANG_EN;
		if (GameConfigManager.getInstance().getGameConfig() != null) {
			currentLang = GameConfigManager.getInstance().getGameConfig().getLang();
		}
		if (Constants.LANG_VI.equalsIgnoreCase(currentLang)) {
			
			if (R.drawable.float_button == id) return R.drawable.float_button;
			if (R.drawable.logo_sm == id) return R.drawable.logo_sm_vn;
			if (R.drawable.gcm_sm == id) return R.drawable.gcm_sm_vn;
			if (R.drawable.bar_header == id) return R.drawable.bar_header_vn;
			if (R.drawable.float_hide_tips_animation == id) return R.drawable.float_hide_tips_animation_vn;

		}
		return id;
	}
	
	public static Drawable drawable(Context context, int id) {
		return ContextCompat.getDrawable(context, drawableResource(context, id));
	}

}
