package com.mobgame.api;

import android.os.AsyncTask;
import android.util.Log;

import java.io.IOException;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by khaitran on 9/13/17.
 */

public class SaveEventClientTask extends AsyncTask<Void, Void, Void> {
    private String data;
    private static String TAG = SaveEventClientTask.class.getSimpleName();

    public SaveEventClientTask(String data) {
        this.data = data;
    }

    @Override
    protected Void doInBackground(Void... voids) {
        try {
            RestfulApi api = RestfulApi.getInstance();
            Call<ResponseBody> call = api.saveEventClient(data);
//            call.execute();
            call.enqueue(new Callback<ResponseBody>() {
                @Override
                public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                    try{
                        Log.d(TAG, "onResponse save Event Client: "+response.body().toString());
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailure(Call<ResponseBody> call, Throwable t) {
                    Log.d(TAG, "onFailure save Event Client");
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
