/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.component;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.mobgame.MobGameSDK;

public final class GoogleAuthManager {
    private static final String TAG = GoogleAuthManager.class.getSimpleName();
    private static GoogleAuthManager INSTANCE;
    private GoogleApiClient mGoogleApiClient;
    private boolean mResolvingError = false;
    private GoogleApiClient.ConnectionCallbacks mConnectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

        public void onConnected(Bundle bundle) {
        }

        public void onConnectionSuspended(int arg0) {
        }
    };
    private GoogleApiClient.OnConnectionFailedListener mOnConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

        public void onConnectionFailed(ConnectionResult result) {
            Log.i((String)TAG, (String)("onConnectionFailed:" + result));
            if (GoogleAuthManager.this.mResolvingError) {
                return;
            }
            if (result.hasResolution()) {
                try {
                    GoogleAuthManager.this.mResolvingError = true;
                    result.startResolutionForResult(MobGameSDK.activity, 123);
                }
                catch (IntentSender.SendIntentException e) {
                    GoogleAuthManager.this.mGoogleApiClient.connect();
                }
            } else {
                GoogleAuthManager.this.mResolvingError = true;
            }
        }
    };

    public static GoogleAuthManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GoogleAuthManager();
        }
        return INSTANCE;
    }

    private GoogleAuthManager() {
    }

    void init(Activity activity) {
        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail().build();
        this.mGoogleApiClient = new GoogleApiClient.Builder((Context)activity).addConnectionCallbacks(this.mConnectionCallbacks).addOnConnectionFailedListener(this.mOnConnectionFailedListener).addApi(Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions.HasOptions)gso).build();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        GoogleSignInResult result;
        if (requestCode == 123) {
            this.mResolvingError = false;
            if (resultCode == 0 && !this.mGoogleApiClient.isConnecting() && !this.mGoogleApiClient.isConnected()) {
                this.mGoogleApiClient.connect();
            }
        }
        if (requestCode != 0 || (result = Auth.GoogleSignInApi.getSignInResultFromIntent(data)).isSuccess()) {
            // empty if block
        }
    }

    public void login(Activity activity) {
        Intent signInIntent = Auth.GoogleSignInApi.getSignInIntent(this.mGoogleApiClient);
        activity.startActivityForResult(signInIntent, 0);
    }

    public void logout() {
        if (this.mGoogleApiClient != null && this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.disconnect();
        }
    }
}

