package com.mobgame.js;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import okhttp3.ResponseBody;

import org.json.JSONObject;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import android.app.Activity;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;

import com.mobgame.MobGameSDK;
import com.mobgame.api.ProcessIABReceiptTask;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.Game.GoogleIABConfig;
import com.mobgame.utils.Constants;
import com.mobgame.utils.iab.IabHelper;
import com.mobgame.utils.iab.IabHelper.OnConsumeFinishedListener;
import com.mobgame.utils.iab.IabHelper.OnConsumeMultiFinishedListener;
import com.mobgame.utils.iab.IabHelper.OnIabPurchaseFinishedListener;
import com.mobgame.utils.iab.IabHelper.OnIabSetupFinishedListener;
import com.mobgame.utils.iab.IabHelper.QueryInventoryFinishedListener;
import com.mobgame.utils.iab.IabResult;
import com.mobgame.utils.iab.Inventory;
import com.mobgame.utils.iab.Purchase;

public final class CmdPayment {

	private static String TAG = CmdPayment.class.getSimpleName();
	private static CmdPayment INSTANCE;
	private static final int TYPE_UNKNOWN = 0;
	private static final int TYPE_IAB = 1;
	private static final int TYPE_PAYPAL = 2;

	// iab
	private IabHelper mIabHelper;
	private ArrayList<String> listPendingPurchases = new ArrayList<String>();
	private Activity activity;

	private CmdPayment() {}

	public static CmdPayment getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new CmdPayment();
		}
		return INSTANCE;
	}

	public void handleResult(Activity activity, int requestCode, int resultCode, Intent data) {
		this.activity = activity;
		switch (requestCode) {

			case Constants.REQUEST_CODE_GOOGLE_IN_APP_BILLING:
				mIabHelper.handleActivityResult(requestCode, resultCode, data);
				break;

//			case Constants.REQUEST_CODE_PAYPAL_PAYMENT:
//				if (resultCode == Activity.RESULT_OK) {
//					PaymentConfirmation confirm = data
//							.getParcelableExtra(PaymentActivity.EXTRA_RESULT_CONFIRMATION);
//					if (confirm != null) {
//						try {
//							Log.i(TAG, "PayPalPayment:" + confirm.toJSONObject().toString(4));
//					        sendPayPalConfirmToPlf(activity, confirm.toJSONObject().toString());
//						} catch (Exception e) {
//							Intent intent = new Intent(Constants.INTENT_FILTER);
//							intent.putExtra("category", "payment");
//							intent.putExtra("status", false);
//							intent.putExtra("message", e.getMessage());
//							LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
//						}
//					}
//				} else if (resultCode == Activity.RESULT_CANCELED) {
//					Log.i(TAG, "The user canceled.");
//				} else if (resultCode == PaymentActivity.RESULT_EXTRAS_INVALID) {
//					Log.w(TAG, "An invalid Payment or PayPalConfiguration was submitted. Please see the docs.");
//				}
//				break;
//
//			case Constants.REQUEST_CODE_PAYPAL_FUTURE_PAYMENT:
//			case Constants.REQUEST_CODE_PAYPAL_PROFILE_SHARING:
//				// Do nothing
//				break;

		}
	}

//	void mobPaymentStartPaypal(Activity activity, String params) {
//		Log.i(TAG, "mobPaymentStartPaypal:" + params);
//		this.activity = activity;
//		try {
//			initPaypal(activity);
//			JSONObject obj = new JSONObject(params);
//			double amount = obj.getDouble("amount");
//			String currency = obj.getString("currency");
//			String description = obj.getString("description");
//			Log.i(TAG, "amount:" + amount);
//			Log.i(TAG, "currency" + currency);
//			Log.i(TAG, "description" + description);
//
//			PayPalPayment thingToBuy = new PayPalPayment(
//					new BigDecimal(amount), 
//					currency, 
//					description,
//					PayPalPayment.PAYMENT_INTENT_SALE);
//
//			Intent intent = new Intent(activity, PaymentActivity.class);
//			intent.putExtra(PaymentActivity.EXTRA_PAYMENT, thingToBuy);
//			activity.startActivityForResult(intent, Constants.REQUEST_CODE_PAYPAL_PAYMENT);
//
//		} catch (JSONException e) {
//			e.printStackTrace();
//		}
//	}

//	private void initPaypal(Activity activity) {
//		Log.i(TAG, "initPaypal");
//		try {
//			// "paypal":{"client_id_production":"11111","client_id_sandbox":"111111_sanbox","client_secret":"111_secret",
//			// "merchant_name":"onepiece merchant","privacy_url":"http:\/\/example.com","user_agreement_url":"http:\/\/example.com",
//			// "accept_credit_cards":true}
//			
//			PaypalConfig config = GameConfigManager.getInstance().getGameConfig().getPaypal();
//			if (config.getClientId() != null) {
//				PayPalConfiguration paypalConfig = new PayPalConfiguration()
//						.environment(PayPalConfiguration.ENVIRONMENT_PRODUCTION)
//						.clientId(config.getClientId())
//						// The following are only used in
//						// PayPalFuturePaymentActivity.
//						.merchantName(config.getMerchantName())
//						.merchantPrivacyPolicyUri(Uri.parse(config.getPrivacyUrl()))
//						.merchantUserAgreementUri(Uri.parse(config.getUserAgreementUrl()))
//						.acceptCreditCards(config.isAcceptCreditCard());
//
//				Intent intent = new Intent(activity, PayPalService.class);
//				intent.putExtra(PayPalService.EXTRA_PAYPAL_CONFIGURATION, paypalConfig);
//				activity.startService(intent);
//			}
//		} catch (Exception e) {
//			Intent intent = new Intent(Constants.INTENT_FILTER);
//			intent.putExtra("category", "payment");
//			intent.putExtra("status", false);
//			intent.putExtra("message", e.getMessage());
//			LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
//		}
//	}
	
//	private void sendPayPalConfirmToPlf(final Activity activity, String data) {
//
//		new ProcessPaypalReceiptTask(data, new Callback<ResponseBody>() {
//			
//			@Override
//			public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
//				try {
//					String responseBody = response.body().string();
//					mobPaymentSuccess(activity, responseBody, TYPE_PAYPAL);
//				} catch (IOException e) {
//					e.printStackTrace();
//				}
//			}
//			
//			@Override
//			public void onFailure(Call<ResponseBody> call, Throwable e) {
//				
//			}
//		});
//	}

	void mobPaymentStartIAP(final Activity activity, String params) {
		Log.i(TAG, "paymentStartIAP:" + params);
		this.activity = activity;
		initIAB(activity);
		try {
			JSONObject obj = new JSONObject(params);
			String product_id = obj.getString("product_id");
			listPendingPurchases.add(product_id);
			if (mIabHelper != null && mIabHelper.isSetupDone()) {
				mIabHelper.queryInventoryAsync(mQueryInventoryFinishedListener);
//				mIabHelper.launchPurchaseFlowWithRetry(
//						product_id, Constants.REQUEST_CODE_GOOGLE_IN_APP_BILLING, 
//						mOnIabPurchaseFinishedListener);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	};

	private void initIAB(Activity activity) {
		Log.i(TAG, "initIAB");
		try {
			// init IAB
			if (mIabHelper == null || !mIabHelper.getActivity().equals(activity)) {
				GoogleIABConfig config = GameConfigManager.getInstance().getGameConfig().getGoogleIAB();

				if (!TextUtils.isEmpty(config.getHashkey())) {
					mIabHelper = new IabHelper(activity, config.getHashkey());
					mIabHelper.startSetup(mOnIabSetupFinishedListener);
				} else {
					Log.i(TAG, "No hashkey found, skip setup IAB");
				}
			}
			Log.i(TAG, "init done");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private OnIabSetupFinishedListener mOnIabSetupFinishedListener = new OnIabSetupFinishedListener() {

		@Override
		public void onIabSetupFinished(IabResult result) {
			Log.i(TAG, "onIabSetupFinished");
			if (!result.isSuccess()) {
				Log.i(TAG, "Problem setting up In-app Billing: " + result);
				Intent intent = new Intent(Constants.INTENT_FILTER);
				intent.putExtra("category", "payment");
				intent.putExtra("status", false);
				intent.putExtra("message", "Problem setting up In-app Billing: " + result);
				LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
				return;
			}
			// Hooray, IAB is fully set up!
			mIabHelper.queryInventoryAsync(mQueryInventoryFinishedListener);
		}
	};

	private QueryInventoryFinishedListener mQueryInventoryFinishedListener = new QueryInventoryFinishedListener() {
		//Query purchased Items 
		@Override
		public void onQueryInventoryFinished(IabResult result, Inventory inv) {
			Log.i(TAG, "onQueryInventoryFinished");
			if (!result.isSuccess()) {
				Log.i(TAG, "Problem setting up In-App-Billing" + result);
				Intent intent = new Intent(Constants.INTENT_FILTER);
				intent.putExtra("category", "payment");
				intent.putExtra("status", false);
				intent.putExtra("message", "Problem setting up In-app Billing: " + result);
				LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
				return;
			}
			// thanh toan thanh cong
			if (inv.getAllPurchases().size() > 0) {
				mIabHelper.consumeAsync(inv.getAllPurchases(), mOnIabConsumeMultiFinishedListener);
			} else {
				if (listPendingPurchases.size() > 0) {
					String sku = listPendingPurchases.get(listPendingPurchases.size() - 1);
					listPendingPurchases.clear();
					mIabHelper.launchPurchaseFlowWithRetry(
							sku, Constants.REQUEST_CODE_GOOGLE_IN_APP_BILLING,
							mOnIabPurchaseFinishedListener);
				} else {
					MobGameSDK.getInstance().close();
				}
			}
		}
	};
	
	private OnConsumeFinishedListener mOnIabConsumeFinishedListener = new IabHelper.OnConsumeFinishedListener() {
		
		@Override
		public void onConsumeFinished(Purchase purchase, IabResult result) {

			handleConsume(purchase, result);
		}
	};

	private OnConsumeMultiFinishedListener mOnIabConsumeMultiFinishedListener = new OnConsumeMultiFinishedListener() {
		
		@Override
		public void onConsumeMultiFinished(List<Purchase> purchases,
				List<IabResult> results) {

			for (int i = 0; i < purchases.size(); i++) {
				handleConsume(purchases.get(i), results.get(i));
			}
		}
	};
	
	private OnIabPurchaseFinishedListener mOnIabPurchaseFinishedListener = new OnIabPurchaseFinishedListener() {
		
		@Override
		public void onIabPurchaseFinished(IabResult result, Purchase purchase) {
			Log.i(TAG, "onIabPurchaseFinished");
			if (result.isFailure()) {
				if (result.getResponse() != IabHelper.IABHELPER_USER_CANCELLED) {
					Log.i(TAG, "Error purchasing: " + result);
					Intent intent = new Intent(Constants.INTENT_FILTER);
					intent.putExtra("category", "payment");
					intent.putExtra("status", false);
					intent.putExtra("message", "Error IAB purchasing: " + result);
					LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
				}
				return;
			}		

			mIabHelper.consumeAsync(purchase, mOnIabConsumeFinishedListener);
		}
	};

	private void handleConsume(Purchase purchase, IabResult result) {
		Log.i(TAG, "onConsumeFinished");
		if (result.isFailure()) {
			if (result.getResponse() != IabHelper.IABHELPER_USER_CANCELLED) {
				Log.i(TAG, "Error purchasing: " + result);
				Intent intent = new Intent(Constants.INTENT_FILTER);
				intent.putExtra("category", "payment");
				intent.putExtra("status", false);
				intent.putExtra("message", "Error IAB purchasing: " + result);
				LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
			}
			return;
		}
		Log.i(TAG, "purchase successful .");
		try {

			new ProcessIABReceiptTask(
					purchase.getItemType(), 
					purchase.getSignature(),
					purchase.getOriginalJson(),
					new Callback<ResponseBody>() {
						
						@Override
						public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
							try {
								String responseBody = response.body().string();
								mobPaymentSuccess(activity, responseBody, TYPE_IAB);
							} catch (IOException e) {
								// TODO Handle error
								e.printStackTrace();
							}
						}
						
						@Override
						public void onFailure(Call<ResponseBody> call, Throwable e) {
							
						}
					}
				).execute();

			mIabHelper.queryInventoryAsync(mQueryInventoryFinishedListener);
			
		} catch (Exception e) {
			Intent intent = new Intent(Constants.INTENT_FILTER);
			intent.putExtra("category", "payment");
			intent.putExtra("status", false);
			intent.putExtra("message", e.getMessage());
			LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
		}
	}
	
	void mobPaymentSuccess(final Activity activity, String params) {
		mobPaymentSuccess(activity, params, TYPE_UNKNOWN);
	}

	void mobPaymentSuccess(final Activity activity, String params, int type) {
		Log.i(TAG, "mobPaymentSuccess");
		// {"order_id":"42711482507","user_id":"774763","status":0,"order_product":"47","platform_price":"47","game_price":47,"details":"","state":"","time":1423447983,"game_role_id":"test_role_id","game_area_id":"test_area_id"}
		try {
			final JSONObject order = new JSONObject(params);
			if (order != null && order.getString("status").equals("0")) {
				String userId = order.getString("user_id");
				String orderId = order.getString("order_id");
				String orderProduct = order.getString("order_product");
				String orderInfo = order.getString("details");
				String orderTime = order.getString("time");
				String platformPrice = order.getString("platform_price");
				String gamePrice = order.getString("game_price");
				String state = "";
				String game_role_id = "";
				String game_area_id = "";
				String is_sandbox = "";
				if (order.has("state")) {
					state = order.getString("state");
				}
				if (order.has("game_role_id")) {
					game_role_id = order.getString("game_role_id");
				}
				if (order.has("game_area_id")) {
					game_area_id = order.getString("game_area_id");
				}
				if (order.has("is_sandbox")) {
					is_sandbox = order.getString("is_sandbox");
				}

				Intent intent = new Intent(Constants.INTENT_FILTER);
				intent.putExtra("category", "payment");
				intent.putExtra("status", true);
				intent.putExtra("user_id", userId);
				intent.putExtra("order_id", orderId);
				intent.putExtra("order_product", orderProduct);
				intent.putExtra("order_info", orderInfo);
				intent.putExtra("order_time", orderTime);
				intent.putExtra("platform_price", platformPrice);
				intent.putExtra("game_price", gamePrice);
				intent.putExtra("state", state);
				intent.putExtra("game_role_id", game_role_id);
				intent.putExtra("game_area_id", game_area_id);
				intent.putExtra("is_sandbox", is_sandbox);
				LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
			} else {
				Log.i(TAG, "on pay failed");
				Intent intent = new Intent(Constants.INTENT_FILTER);
				intent.putExtra("category", "payment");
				intent.putExtra("status", false);
				intent.putExtra("message", "Error purchasing");
				LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
			}
		} catch (Exception e) {
			Intent intent = new Intent(Constants.INTENT_FILTER);
			intent.putExtra("category", "payment");
			intent.putExtra("status", false);
			intent.putExtra("message", e.getMessage());
			LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
		} finally {
			switch (type) {
				case TYPE_UNKNOWN:
				case TYPE_PAYPAL:
					MobGameSDK.getInstance().close();
					break;
				case TYPE_IAB:
					break;
			}
		}
	}

}