/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.appsflyer.a;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AppsFlyerProperties {
    public static final String APP_USER_ID = "AppUserId";
    public static final String APP_ID = "appid";
    public static final String CURRENCY_CODE = "currencyCode";
    public static final String IS_UPDATE = "IS_UPDATE";
    public static final String AF_KEY = "AppsFlyerKey";
    public static final String USE_HTTP_FALLBACK = "useHttpFallback";
    public static final String COLLECT_ANDROID_ID = "collectAndroidId";
    public static final String COLLECT_IMEI = "collectIMEI";
    public static final String COLLECT_FINGER_PRINT = "collectFingerPrint";
    public static final String CHANNEL = "channel";
    public static final String EXTENSION = "sdkExtension";
    public static final String COLLECT_MAC = "collectMAC";
    public static final String DEVICE_TRACKING_DISABLED = "deviceTrackingDisabled";
    public static final String IS_MONITOR = "shouldMonitor";
    public static final String USER_EMAIL = "userEmail";
    public static final String USER_EMAILS = "userEmails";
    public static final String EMAIL_CRYPT_TYPE = "userEmailsCryptType";
    public static final String ADDITIONAL_CUSTOM_DATA = "additionalCustomData";
    public static final String COLLECT_FACEBOOK_ATTR_ID = "collectFacebookAttrId";
    public static final String DISABLE_LOGS_COMPLETELY = "disableLogs";
    public static final String ENABLE_GPS_FALLBACK = "enableGpsFallback";
    public static final String DISABLE_OTHER_SDK = "disableOtherSdk";
    public static final String GCM_PROJECT_NUMBER = "gcmProjectNumber";
    public static final String PUSH_PAYLOAD_MAX_AGING = "pushPayloadMaxAging";
    public static final String PUSH_PAYLOAD_HISTORY_SIZE = "pushPayloadHistorySize";
    private static AppsFlyerProperties instance = new AppsFlyerProperties();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean isOnReceiveCalled;
    private boolean isLaunchCalled;
    private String referrer;
    private boolean propertiesLoadedFlag = false;

    private AppsFlyerProperties() {
    }

    public static AppsFlyerProperties getInstance() {
        return instance;
    }

    public void set(String key, String value) {
        this.properties.put(key, value);
    }

    public void set(String key, String[] value) {
        this.properties.put(key, value);
    }

    public void set(String key, int value) {
        this.properties.put(key, Integer.toString(value));
    }

    public void set(String key, long value) {
        this.properties.put(key, Long.toString(value));
    }

    public void set(String key, boolean value) {
        this.properties.put(key, Boolean.toString(value));
    }

    public void setCustomData(String customData) {
        this.properties.put(ADDITIONAL_CUSTOM_DATA, customData);
    }

    public void setUserEmails(String emails) {
        this.properties.put(USER_EMAILS, emails);
    }

    public String[] getStringArray(String key) {
        return (String[])this.properties.get(key);
    }

    public String getString(String key) {
        return (String)this.properties.get(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String string = this.getString(key);
        if (string == null) {
            return defaultValue;
        }
        return Boolean.valueOf(string);
    }

    public int getInt(String key, int defaultValue) {
        String string = this.getString(key);
        if (string == null) {
            return defaultValue;
        }
        return Integer.valueOf(string);
    }

    public long getLong(String key, long defaultValue) {
        String string = this.getString(key);
        if (string == null) {
            return defaultValue;
        }
        return Long.valueOf(string);
    }

    protected boolean isOnReceiveCalled() {
        return this.isOnReceiveCalled;
    }

    protected void setOnReceiveCalled() {
        this.isOnReceiveCalled = true;
    }

    protected boolean isFirstLaunchCalled() {
        return this.isLaunchCalled;
    }

    protected void setFirstLaunchCalled(boolean val) {
        this.isLaunchCalled = val;
    }

    protected void setFirstLaunchCalled() {
        this.isLaunchCalled = true;
    }

    protected void setReferrer(String referrer) {
        this.set("AF_REFERRER", referrer);
        this.referrer = referrer;
    }

    public String getReferrer(Context context) {
        if (this.referrer != null) {
            return this.referrer;
        }
        if (this.getString("AF_REFERRER") != null) {
            return this.getString("AF_REFERRER");
        }
        if (context == null) {
            return null;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        return sharedPreferences.getString("referrer", null);
    }

    public void enableLogOutput(boolean shouldEnable) {
        this.set("shouldLog", shouldEnable);
    }

    public boolean isEnableLog() {
        boolean bl = this.getBoolean("shouldLog", true);
        return bl;
    }

    public boolean isLogsDisabledCompletely() {
        return this.getBoolean(DISABLE_LOGS_COMPLETELY, false);
    }

    public boolean isOtherSdkStringDisabled() {
        return this.getBoolean(DISABLE_OTHER_SDK, false);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public void saveProperties(SharedPreferences sharedPreferences) {
        String string = new JSONObject(this.properties).toString();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("savedProperties", string);
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
        } else {
            editor.commit();
        }
    }

    public void loadProperties(Context context) {
        if (this.isPropertiesLoaded()) {
            return;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        String string = sharedPreferences.getString("savedProperties", null);
        if (string != null) {
            a.afDebugLog("Loading properties..");
            try {
                JSONObject jSONObject = new JSONObject(string);
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (this.properties.get(string2) != null) continue;
                    this.properties.put(string2, jSONObject.getString(string2));
                }
                this.propertiesLoadedFlag = true;
            }
            catch (JSONException jSONException) {
                a.afLogE("Failed loading properties", jSONException);
            }
            a.afDebugLog("Done loading properties: " + this.propertiesLoadedFlag);
        }
    }

    private boolean isPropertiesLoaded() {
        return this.propertiesLoadedFlag;
    }

    public static enum EmailsCryptType {
        NONE(0),
        SHA1(1),
        MD5(2);

        private final int value;

        private EmailsCryptType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

