/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.ws;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.p2p.solanaj.rpc.types.RpcRequest;
import org.p2p.solanaj.rpc.types.config.Commitment;
import org.p2p.solanaj.ws.SignatureNotification;
import org.p2p.solanaj.ws.listeners.NotificationEventListener;

public class SubscriptionWebSocketClient {
    private static final Logger LOGGER = Logger.getLogger(SubscriptionWebSocketClient.class.getName());
    private static final int MAX_RECONNECT_DELAY = 30000;
    private static final int INITIAL_RECONNECT_DELAY = 1000;
    private static final int CONNECTION_TIMEOUT = 10;
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String endpoint;
    private WebSocket webSocket;
    private final AtomicBoolean isConnected = new AtomicBoolean(false);
    private final AtomicBoolean isConnecting = new AtomicBoolean(false);
    private final AtomicBoolean shouldReconnect = new AtomicBoolean(true);
    private final Map<String, SubscriptionInfo> subscriptions = new ConcurrentHashMap<String, SubscriptionInfo>();
    private final Map<Long, NotificationEventListener> subscriptionListeners = new ConcurrentHashMap<Long, NotificationEventListener>();
    private final Map<Long, String> subscriptionToAccount = new ConcurrentHashMap<Long, String>();
    private final AtomicLong requestIdCounter = new AtomicLong(1L);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    private final CountDownLatch connectLatch = new CountDownLatch(1);
    private int reconnectDelay = 1000;

    public static SubscriptionWebSocketClient getExactPathInstance(String endpoint) {
        return new SubscriptionWebSocketClient(endpoint);
    }

    public static SubscriptionWebSocketClient getInstance(String endpoint) {
        try {
            URI endpointURI = new URI(endpoint);
            String scheme = "https".equals(endpointURI.getScheme()) ? "wss" : "ws";
            String wsEndpoint = scheme + "://" + endpointURI.getHost();
            return new SubscriptionWebSocketClient(wsEndpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint URI", e);
        }
    }

    public SubscriptionWebSocketClient(String endpoint) {
        this.endpoint = endpoint;
        this.httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).build();
        this.connect();
    }

    public void connect() {
        if (this.isConnecting.get() || this.isConnected.get()) {
            return;
        }
        this.isConnecting.set(true);
        LOGGER.info("Connecting to WebSocket endpoint: " + this.endpoint);
        Request request = new Request.Builder().url(this.endpoint).build();
        this.webSocket = this.httpClient.newWebSocket(request, new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                LOGGER.info("WebSocket connection opened");
                SubscriptionWebSocketClient.this.isConnected.set(true);
                SubscriptionWebSocketClient.this.isConnecting.set(false);
                SubscriptionWebSocketClient.this.reconnectDelay = 1000;
                SubscriptionWebSocketClient.this.connectLatch.countDown();
                SubscriptionWebSocketClient.this.startHeartbeat();
                SubscriptionWebSocketClient.this.resubscribeAll();
            }

            public void onMessage(WebSocket webSocket, String text) {
                SubscriptionWebSocketClient.this.handleMessage(text);
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                LOGGER.info("WebSocket closing: " + code + " - " + reason);
                SubscriptionWebSocketClient.this.isConnected.set(false);
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                LOGGER.info("WebSocket closed: " + code + " - " + reason);
                SubscriptionWebSocketClient.this.isConnected.set(false);
                SubscriptionWebSocketClient.this.stopHeartbeat();
                if (SubscriptionWebSocketClient.this.shouldReconnect.get()) {
                    SubscriptionWebSocketClient.this.scheduleReconnect();
                }
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                LOGGER.log(Level.SEVERE, "WebSocket connection failed", t);
                SubscriptionWebSocketClient.this.isConnected.set(false);
                SubscriptionWebSocketClient.this.isConnecting.set(false);
                SubscriptionWebSocketClient.this.stopHeartbeat();
                if (SubscriptionWebSocketClient.this.shouldReconnect.get()) {
                    SubscriptionWebSocketClient.this.scheduleReconnect();
                }
            }
        });
    }

    private void handleMessage(String message) {
        try {
            JsonNode messageNode = this.objectMapper.readTree(message);
            if (messageNode.has("result") && messageNode.get("result").isInt()) {
                SubscriptionInfo info;
                String requestId;
                int subscriptionId = messageNode.get("result").asInt();
                String string = requestId = messageNode.has("id") ? messageNode.get("id").asText() : null;
                if (requestId != null && (info = this.subscriptions.get(requestId)) != null) {
                    this.subscriptionListeners.put(Long.valueOf(subscriptionId), info.listener);
                    this.subscriptions.remove(requestId);
                    String account = this.extractAccountFromRequest((CustomRpcRequest)info.request);
                    if (account != null) {
                        this.subscriptionToAccount.put(Long.valueOf(subscriptionId), account);
                    }
                    info.subscriptionFuture.complete(Long.valueOf(subscriptionId));
                    LOGGER.info("Subscription established with ID: " + subscriptionId + " for account: " + account);
                }
                return;
            }
            if (messageNode.has("error")) {
                JsonNode error = messageNode.get("error");
                LOGGER.severe("RPC Error: " + String.valueOf(error));
                return;
            }
            if (messageNode.has("method")) {
                this.handleNotification(messageNode);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Error processing message", ex);
        }
    }

    private String extractAccountFromRequest(CustomRpcRequest request) {
        try {
            String method = request.getMethod();
            List<Object> params = request.getParams();
            if (params == null || params.isEmpty()) {
                return null;
            }
            switch (method) {
                case "accountSubscribe": {
                    return (String)params.get(0);
                }
                case "logsSubscribe": {
                    Map mentionsMap;
                    if (params.get(0) instanceof Map && (mentionsMap = (Map)params.get(0)).containsKey("mentions")) {
                        List mentions = (List)mentionsMap.get("mentions");
                        return mentions.isEmpty() ? null : (String)mentions.get(0);
                    }
                    return null;
                }
                case "signatureSubscribe": {
                    return (String)params.get(0);
                }
                case "programSubscribe": {
                    return (String)params.get(0);
                }
            }
            return null;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Error extracting account from request", ex);
            return null;
        }
    }

    private void handleNotification(JsonNode messageNode) {
        block20: {
            try {
                String method = messageNode.get("method").asText();
                JsonNode params = messageNode.get("params");
                if (params == null || !params.has("subscription")) break block20;
                Long subscriptionId = params.get("subscription").asLong();
                NotificationEventListener listener = this.subscriptionListeners.get(subscriptionId);
                if (listener != null) {
                    JsonNode result = params.get("result");
                    switch (method) {
                        case "signatureNotification": {
                            if (result != null && result.has("value")) {
                                JsonNode value = result.get("value");
                                JsonNode err = value.has("err") ? value.get("err") : null;
                                listener.onNotificationEvent(new SignatureNotification(err));
                                break;
                            }
                            break block20;
                        }
                        case "accountNotification": 
                        case "logsNotification": 
                        case "blockNotification": 
                        case "programNotification": 
                        case "rootNotification": 
                        case "slotNotification": 
                        case "slotsUpdatesNotification": 
                        case "voteNotification": {
                            if (result != null && result.has("value")) {
                                JsonNode value = result.get("value");
                                Map valueMap = (Map)this.objectMapper.convertValue((Object)value, Map.class);
                                listener.onNotificationEvent(valueMap);
                                break;
                            }
                            break block20;
                        }
                        default: {
                            LOGGER.warning("Unknown notification method: " + method);
                            break;
                        }
                    }
                    break block20;
                }
                LOGGER.warning("No listener found for subscription ID: " + subscriptionId);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Error handling notification", ex);
            }
        }
    }

    public CompletableFuture<Long> accountSubscribe(String key, NotificationEventListener listener, Commitment commitment, String encoding) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(Map.of("encoding", encoding, "commitment", commitment.getValue()));
        CustomRpcRequest rpcRequest = new CustomRpcRequest("accountSubscribe", params);
        return this.addSubscription(rpcRequest, listener, "accountSubscribe", "accountUnsubscribe");
    }

    public CompletableFuture<Long> accountSubscribe(String key, NotificationEventListener listener, Commitment commitment) {
        return this.accountSubscribe(key, listener, commitment, "jsonParsed");
    }

    public CompletableFuture<Long> accountSubscribe(String key, NotificationEventListener listener) {
        return this.accountSubscribe(key, listener, Commitment.FINALIZED, "jsonParsed");
    }

    public CompletableFuture<Long> signatureSubscribe(String signature, NotificationEventListener listener) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(signature);
        CustomRpcRequest rpcRequest = new CustomRpcRequest("signatureSubscribe", params);
        return this.addSubscription(rpcRequest, listener, "signatureSubscribe", "signatureUnsubscribe");
    }

    public CompletableFuture<Long> logsSubscribe(String mention, NotificationEventListener listener) {
        return this.logsSubscribe(List.of(mention), listener);
    }

    public CompletableFuture<Long> logsSubscribe(List<String> mentions, NotificationEventListener listener) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Map.of("mentions", mentions));
        params.add(Map.of("commitment", "processed"));
        CustomRpcRequest rpcRequest = new CustomRpcRequest("logsSubscribe", params);
        return this.addSubscription(rpcRequest, listener, "logsSubscribe", "logsUnsubscribe");
    }

    public CompletableFuture<Long> blockSubscribe(NotificationEventListener listener, Commitment commitment, String encoding) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Map.of("encoding", encoding, "commitment", commitment.getValue()));
        CustomRpcRequest rpcRequest = new CustomRpcRequest("blockSubscribe", params);
        return this.addSubscription(rpcRequest, listener, "blockSubscribe", "blockUnsubscribe");
    }

    public CompletableFuture<Long> blockSubscribe(NotificationEventListener listener, Commitment commitment) {
        return this.blockSubscribe(listener, commitment, "json");
    }

    public CompletableFuture<Long> blockSubscribe(NotificationEventListener listener) {
        return this.blockSubscribe(listener, Commitment.FINALIZED, "json");
    }

    public CompletableFuture<Long> programSubscribe(String programId, NotificationEventListener listener, Commitment commitment, String encoding) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(programId);
        params.add(Map.of("encoding", encoding, "commitment", commitment.getValue()));
        CustomRpcRequest rpcRequest = new CustomRpcRequest("programSubscribe", params);
        return this.addSubscription(rpcRequest, listener, "programSubscribe", "programUnsubscribe");
    }

    public CompletableFuture<Long> programSubscribe(String programId, NotificationEventListener listener, Commitment commitment) {
        return this.programSubscribe(programId, listener, commitment, "base64");
    }

    public CompletableFuture<Long> programSubscribe(String programId, NotificationEventListener listener) {
        return this.programSubscribe(programId, listener, Commitment.FINALIZED, "base64");
    }

    public CompletableFuture<Long> rootSubscribe(NotificationEventListener listener) {
        CustomRpcRequest rpcRequest = new CustomRpcRequest("rootSubscribe", new ArrayList<Object>());
        return this.addSubscription(rpcRequest, listener, "rootSubscribe", "rootUnsubscribe");
    }

    public CompletableFuture<Long> slotSubscribe(NotificationEventListener listener) {
        CustomRpcRequest rpcRequest = new CustomRpcRequest("slotSubscribe", new ArrayList<Object>());
        return this.addSubscription(rpcRequest, listener, "slotSubscribe", "slotUnsubscribe");
    }

    public CompletableFuture<Long> slotsUpdatesSubscribe(NotificationEventListener listener) {
        CustomRpcRequest rpcRequest = new CustomRpcRequest("slotsUpdatesSubscribe", new ArrayList<Object>());
        return this.addSubscription(rpcRequest, listener, "slotsUpdatesSubscribe", "slotsUpdatesUnsubscribe");
    }

    public CompletableFuture<Long> voteSubscribe(NotificationEventListener listener) {
        CustomRpcRequest rpcRequest = new CustomRpcRequest("voteSubscribe", new ArrayList<Object>());
        return this.addSubscription(rpcRequest, listener, "voteSubscribe", "voteUnsubscribe");
    }

    private CompletableFuture<Long> addSubscription(CustomRpcRequest rpcRequest, NotificationEventListener listener, String method, String unsubscribeMethod) {
        String requestId = String.valueOf(this.requestIdCounter.getAndIncrement());
        rpcRequest.setId(requestId);
        CompletableFuture<Long> subscriptionFuture = new CompletableFuture<Long>();
        SubscriptionInfo info = new SubscriptionInfo(rpcRequest, listener, method, unsubscribeMethod, subscriptionFuture);
        this.subscriptions.put(requestId, info);
        if (this.isConnected.get()) {
            this.sendRequest(rpcRequest);
        }
        return subscriptionFuture;
    }

    private void sendRequest(CustomRpcRequest request) {
        if (this.webSocket != null && this.isConnected.get()) {
            try {
                String json = this.objectMapper.writeValueAsString((Object)request);
                LOGGER.info("Sending WebSocket request: " + json);
                this.webSocket.send(json);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Error sending WebSocket request", ex);
            }
        }
    }

    public void unsubscribe(Long subscriptionId) {
        NotificationEventListener listener = this.subscriptionListeners.remove(subscriptionId);
        String account = this.subscriptionToAccount.remove(subscriptionId);
        if (listener != null) {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(subscriptionId);
            String unsubscribeMethod = "accountUnsubscribe";
            for (SubscriptionInfo info : this.subscriptions.values()) {
                if (info.listener != listener) continue;
                unsubscribeMethod = info.unsubscribeMethod;
                break;
            }
            CustomRpcRequest unsubRequest = new CustomRpcRequest(unsubscribeMethod, params);
            unsubRequest.setId(String.valueOf(this.requestIdCounter.getAndIncrement()));
            this.sendRequest(unsubRequest);
            LOGGER.info("Unsubscribed from subscription: " + subscriptionId + " for account: " + account);
        } else {
            LOGGER.warning("Attempted to unsubscribe from non-existent subscription: " + subscriptionId);
        }
    }

    public Long getSubscriptionId(String account) {
        for (Map.Entry<Long, String> entry : this.subscriptionToAccount.entrySet()) {
            if (!account.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private void startHeartbeat() {
        LOGGER.info("Heartbeat started (using OkHttp's built-in keep-alive)");
    }

    private void stopHeartbeat() {
    }

    private void scheduleReconnect() {
        this.scheduler.schedule(() -> {
            if (this.shouldReconnect.get() && !this.isConnected.get()) {
                LOGGER.info("Attempting to reconnect...");
                this.connect();
                this.reconnectDelay = Math.min(this.reconnectDelay * 2, 30000);
            }
        }, (long)this.reconnectDelay, TimeUnit.MILLISECONDS);
    }

    private void resubscribeAll() {
        LOGGER.info("Resubscribing to all active subscriptions");
        ConcurrentHashMap<String, SubscriptionInfo> currentSubscriptions = new ConcurrentHashMap<String, SubscriptionInfo>(this.subscriptions);
        this.subscriptions.clear();
        for (SubscriptionInfo info : currentSubscriptions.values()) {
            String requestId = String.valueOf(this.requestIdCounter.getAndIncrement());
            CustomRpcRequest newRequest = new CustomRpcRequest(info.request.getMethod(), info.request.getParams());
            newRequest.setId(requestId);
            CompletableFuture<Long> newFuture = new CompletableFuture<Long>();
            SubscriptionInfo newInfo = new SubscriptionInfo(newRequest, info.listener, info.method, info.unsubscribeMethod, newFuture);
            this.subscriptions.put(requestId, newInfo);
            this.sendRequest(newRequest);
        }
    }

    public void reconnect() {
        this.shouldReconnect.set(true);
        if (this.webSocket != null) {
            this.webSocket.close(1000, "Reconnecting");
        }
        this.connect();
    }

    public boolean waitForConnection(long timeout, TimeUnit unit) throws InterruptedException {
        return this.connectLatch.await(timeout, unit);
    }

    public boolean isOpen() {
        return this.isConnected.get();
    }

    public void close() {
        this.shouldReconnect.set(false);
        this.isConnected.set(false);
        if (this.webSocket != null) {
            this.webSocket.close(1000, "Client closing");
            this.webSocket = null;
        }
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
                if (!this.scheduler.awaitTermination(2L, TimeUnit.SECONDS)) {
                    LOGGER.warning("Scheduler did not terminate gracefully");
                }
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.httpClient.dispatcher().executorService().shutdown();
        try {
            if (!this.httpClient.dispatcher().executorService().awaitTermination(5L, TimeUnit.SECONDS)) {
                this.httpClient.dispatcher().executorService().shutdownNow();
                if (!this.httpClient.dispatcher().executorService().awaitTermination(2L, TimeUnit.SECONDS)) {
                    LOGGER.warning("OkHttp dispatcher executor did not terminate gracefully");
                }
            }
        }
        catch (InterruptedException e) {
            this.httpClient.dispatcher().executorService().shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.httpClient.dispatcher().cancelAll();
        this.httpClient.connectionPool().evictAll();
    }

    private static class SubscriptionInfo {
        final RpcRequest request;
        final NotificationEventListener listener;
        final String method;
        final String unsubscribeMethod;
        final CompletableFuture<Long> subscriptionFuture;

        SubscriptionInfo(RpcRequest request, NotificationEventListener listener, String method, String unsubscribeMethod, CompletableFuture<Long> subscriptionFuture) {
            this.request = request;
            this.listener = listener;
            this.method = method;
            this.unsubscribeMethod = unsubscribeMethod;
            this.subscriptionFuture = subscriptionFuture;
        }
    }

    private static class CustomRpcRequest
    extends RpcRequest {
        private String id;

        public CustomRpcRequest(String method, List<Object> params) {
            super(method, params);
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id != null ? this.id : super.getId();
        }
    }
}

