/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.rpc.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.List;
import lombok.Generated;
import org.p2p.solanaj.core.PublicKey;
import org.p2p.solanaj.rpc.types.config.RpcSendTransactionConfig;
import org.p2p.solanaj.utils.Base58;

public class ProgramAccount {
    @JsonProperty(value="account")
    private Account account;
    @JsonProperty(value="pubkey")
    private String pubkey;

    public PublicKey getPublicKey() {
        return new PublicKey(this.pubkey);
    }

    public ProgramAccount(AbstractMap pa) {
        this.account = new Account(pa.get("account"));
        this.pubkey = (String)pa.get("pubkey");
    }

    @Generated
    public Account getAccount() {
        return this.account;
    }

    @Generated
    public String getPubkey() {
        return this.pubkey;
    }

    @Generated
    public String toString() {
        return "ProgramAccount(account=" + String.valueOf(this.getAccount()) + ", pubkey=" + this.getPubkey() + ")";
    }

    public static class Account {
        @JsonProperty(value="data")
        private String data;
        @JsonProperty(value="executable")
        private boolean executable;
        @JsonProperty(value="lamports")
        private double lamports;
        @JsonProperty(value="owner")
        private String owner;
        @JsonProperty(value="rentEpoch")
        private double rentEpoch;
        private String encoding;

        public Account(Object acc) {
            AbstractMap account = (AbstractMap)acc;
            Object rawData = account.get("data");
            if (rawData instanceof List) {
                List dataList = (List)rawData;
                this.data = (String)dataList.get(0);
                this.encoding = (String)dataList.get(1);
            } else if (rawData instanceof String) {
                this.data = (String)rawData;
            }
            this.executable = (Boolean)account.get("executable");
            this.lamports = ((Number)account.get("lamports")).doubleValue();
            this.owner = (String)account.get("owner");
            this.rentEpoch = ((Number)account.get("rentEpoch")).doubleValue();
        }

        public byte[] getDecodedData() {
            if (this.encoding != null && this.encoding.equals(RpcSendTransactionConfig.Encoding.base64.toString())) {
                return Base64.getDecoder().decode(this.data);
            }
            return Base58.decode(this.data);
        }

        @Generated
        public String getData() {
            return this.data;
        }

        @Generated
        public boolean isExecutable() {
            return this.executable;
        }

        @Generated
        public double getLamports() {
            return this.lamports;
        }

        @Generated
        public String getOwner() {
            return this.owner;
        }

        @Generated
        public double getRentEpoch() {
            return this.rentEpoch;
        }

        @Generated
        public String getEncoding() {
            return this.encoding;
        }

        @Generated
        public String toString() {
            return "ProgramAccount.Account(data=" + this.getData() + ", executable=" + this.isExecutable() + ", lamports=" + this.getLamports() + ", owner=" + this.getOwner() + ", rentEpoch=" + this.getRentEpoch() + ", encoding=" + this.getEncoding() + ")";
        }
    }
}

