/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.p2p.solanaj.core.AccountMeta;
import org.p2p.solanaj.core.PublicKey;

public class TransactionInstruction {
    private final PublicKey programId;
    private final List<AccountMeta> keys;
    private final byte[] data;

    public TransactionInstruction(PublicKey programId, List<AccountMeta> keys, byte[] data) {
        this.programId = Objects.requireNonNull(programId, "Program ID cannot be null");
        this.keys = Collections.unmodifiableList(Objects.requireNonNull(keys, "Keys cannot be null"));
        this.data = Arrays.copyOf(Objects.requireNonNull(data, "Data cannot be null"), data.length);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionInstruction that = (TransactionInstruction)o;
        return Objects.equals(this.programId, that.programId) && Objects.equals(this.keys, that.keys) && Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        int result = Objects.hash(this.programId, this.keys);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public String toString() {
        return "TransactionInstruction{programId=" + String.valueOf(this.programId) + ", keys=" + String.valueOf(this.keys) + ", data=" + Arrays.toString(this.data) + "}";
    }

    @Generated
    public PublicKey getProgramId() {
        return this.programId;
    }

    @Generated
    public List<AccountMeta> getKeys() {
        return this.keys;
    }

    @Generated
    public byte[] getData() {
        return this.data;
    }

    public static class Builder {
        private PublicKey programId;
        private List<AccountMeta> keys;
        private byte[] data;

        public Builder programId(PublicKey programId) {
            this.programId = programId;
            return this;
        }

        public Builder keys(List<AccountMeta> keys) {
            this.keys = keys;
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public TransactionInstruction build() {
            return new TransactionInstruction(this.programId, this.keys, this.data);
        }
    }
}

