/*
 * Decompiled with CFR 0.152.
 */
package com.mks.connect;

import com.mks.api.CmdRunner;
import com.mks.api.IntegrationPoint;
import com.mks.api.IntegrationPointFactory;
import com.mks.api.Session;
import com.mks.api.VersionNumber;
import com.mks.api.common.BlimpLib;
import com.mks.api.response.APIConnectionException;
import com.mks.api.response.APIException;
import com.mks.api.response.APIInternalError;
import com.mks.api.response.fedsso.InvalidTokenConnectFailedException;
import com.mks.api.util.Base64;
import com.mks.api.util.MKSLogger;
import com.mks.connect.BlimpException;
import com.mks.connect.ClientCmdRunnerImpl;
import com.mks.connect.CmdRunnerCreatorImpl;
import com.mks.connect.HttpCmdRunnerImpl;
import com.mks.connect.IntegrationPointImpl;
import com.mks.connect.InvalidSessionException;
import com.mks.connect.InvalidTokenException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.TimeZone;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

final class UserApplicationSessionImpl
extends CmdRunnerCreatorImpl
implements Session {
    private static URI API_URI = null;
    private static URI API_SSO_URI = null;
    private int timeout = 300000;
    private boolean autoReconnect;
    private static final String INVALID_API_URI_MSG = "API URI not initialized.";
    private static final String SET_TIMEOUT_MSG = "Setting connection timeout to: {0,number,#}";
    private static final String REDIRECT_FAILED_MSG = "Failed to establish a session: {0}";
    private static final String HEADER_NOT_FOUND_MSG = "Cannot get session ID.";
    private static final String BAD_STATUS_LINE_MSG = "Bad status line: {0}";
    private static final String AUTHENTICATION_FAILED_MSG = "Session not authenticated/authorized.";
    static final String API_COMMUNICATION_LOCALE = "UTF-8";
    protected static final Header OUT_OF_BAND_MESSAGE = new BasicHeader("OutOfBandMessage", "1");
    private static final Header SESSION_RELEASE = new BasicHeader("AppConnection", "close");
    private static final Header CODEPAGE = new BasicHeader("CodePage", "UTF-8");
    private static final Header NEW_SESSION = new BasicHeader("AppSession", "new");
    private static final Header TIMEZONE = new BasicHeader("TimeZone", TimeZone.getDefault().getID());
    private MKSLogger apiLogger;
    private URI url;
    private boolean anonymous;
    private IntegrationPoint ip;
    private HttpClient httpClient;
    private String integrationID;
    private final CookieStore cookieStore = new BasicCookieStore();
    private String sessionUser;
    private String sessionPass;
    private Header sadCookie = null;
    private VersionNumber apiVersion;
    private volatile boolean isSSO;

    UserApplicationSessionImpl(IntegrationPoint ip, HttpClient httpClient, String integrationID, VersionNumber apiRequestVersion, String username, String password, boolean anonymous) {
        String ipHostname;
        if (API_URI == null || API_SSO_URI == null) {
            throw new APIInternalError(INVALID_API_URI_MSG);
        }
        this.ip = ip;
        this.httpClient = httpClient;
        this.integrationID = integrationID;
        this.apiVersion = apiRequestVersion;
        this.anonymous = anonymous;
        this.sessionUser = username;
        this.sessionPass = password;
        this.apiLogger = IntegrationPointFactory.getLogger();
        if (!(ip.isClientIntegrationPoint() || "localhost".equalsIgnoreCase(ipHostname = ip.getHostname()) || "127.0.0.1".equalsIgnoreCase(ipHostname))) {
            this.setDefaultHostname(ipHostname);
            this.setDefaultPort(ip.getPort());
        }
        if (this.sessionUser != null) {
            this.setDefaultUsername(this.sessionUser);
        }
        if (this.sessionPass != null) {
            this.setDefaultPassword(this.sessionPass);
        }
    }

    protected HttpResponse handleHTTPResponse(HttpRequest request) throws IOException {
        HttpHost host = new HttpHost(this.ip.getHostname(), this.ip.getPort(), this.ip.isSecure() ? "https" : "http");
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore(this.cookieStore);
        return this.httpClient.execute(host, request, (HttpContext)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized URI getSession(URI apiURL, String token) throws IOException {
        HttpHead request = new HttpHead(apiURL);
        this.setupRequest(request, token);
        if (!this.anonymous) {
            request.addHeader(NEW_SESSION);
        }
        String msg = MessageFormat.format(SET_TIMEOUT_MSG, new Integer(this.timeout));
        this.apiLogger.message(this, "API", 10, msg);
        RequestConfig requestConfig = ((Configurable)((Object)this.httpClient)).getConfig();
        requestConfig = RequestConfig.copy(requestConfig).setSocketTimeout(this.timeout).build();
        request.setConfig(requestConfig);
        HttpResponse response = this.handleHTTPResponse(request);
        Header red = null;
        try {
            StatusLine statusLine = response.getStatusLine();
            int code = statusLine.getStatusCode();
            if (code == 410) {
                this.invalidateURI();
                throw new InvalidSessionException();
            }
            if (this.isSSO() && code == 401) {
                throw new InvalidTokenException(statusLine.getReasonPhrase());
            }
            if (code != 302) {
                String errDetails = statusLine.getReasonPhrase();
                if (code == 403) {
                    errDetails = AUTHENTICATION_FAILED_MSG;
                }
                String errMsg = MessageFormat.format(REDIRECT_FAILED_MSG, errDetails);
                throw new BlimpException(errMsg);
            }
            red = response.getFirstHeader("Location");
        }
        finally {
            EntityUtils.consume(response.getEntity());
        }
        if (red == null) {
            String errMsg = HEADER_NOT_FOUND_MSG;
            throw new IOException(errMsg);
        }
        try {
            URI absoluteUri = new URI(red.getValue());
            return new URI(null, null, null, 0, absoluteUri.getPath(), absoluteUri.getQuery(), null);
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public int getTimeout() {
        return this.timeout / 1000;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout * 1000;
    }

    protected void removeConnection(CmdRunner c) {
        this.removeCmdRunner(c);
    }

    protected synchronized URI getSessionURI(String token) throws IOException {
        if (this.url == null) {
            if (this.isSSO) {
                return this.getSSOSessionURI(token);
            }
            this.url = this.getSession(API_URI, null);
        }
        return this.url;
    }

    protected synchronized URI getSSOSessionURI(String token) throws IOException {
        if (this.url == null) {
            this.url = this.getSession(API_SSO_URI, token);
        }
        return this.url;
    }

    protected synchronized void invalidateURI() {
        this.url = null;
    }

    @Override
    public IntegrationPoint getIntegrationPoint() {
        return this.ip;
    }

    @Override
    public String getIntegrationID() {
        return this.integrationID;
    }

    @Override
    public synchronized VersionNumber getAPIRequestVersion() {
        return this.apiVersion == null ? this.ip.getAPIRequestVersion() : this.apiVersion;
    }

    synchronized void setAPINegotiatedVersion(VersionNumber apiVersion) {
        this.apiVersion = apiVersion;
    }

    protected void setupRequest(HttpRequest request, String token) {
        String apiVersion;
        VersionNumber apiReqVN = this.getAPIRequestVersion();
        String protocol = System.getProperty("IntegrityAPI.protocol.version");
        if (protocol == null) {
            protocol = BlimpLib.getDefaultProtocolVersion(apiReqVN);
        }
        request.addHeader("Protocol-version", protocol);
        request.addHeader(CODEPAGE);
        if (Boolean.getBoolean("IntegrityAPI.useXML1.1")) {
            request.addHeader("EncodeXMLChars", "true");
        }
        request.addHeader(TIMEZONE);
        if (this.sadCookie != null) {
            request.addHeader(this.sadCookie);
        }
        if (token != null) {
            request.addHeader("Authorization", "Bearer" + token);
        } else if (this.sessionUser != null) {
            request.addHeader("Authorization", "Basic " + Base64.encode(this.sessionUser + ":" + this.sessionPass));
        }
        String string = apiVersion = apiReqVN == null ? null : apiReqVN.toVersionString();
        if (apiVersion != null) {
            request.addHeader("APIVersion", apiVersion);
        } else {
            this.apiLogger.message(this, "ERROR", 0, "API version not available!");
        }
        if (this.integrationID != null) {
            request.addHeader("integrationID", this.integrationID);
        }
    }

    @Override
    public final void release(boolean force) throws IOException, APIException {
        this.release(force, true);
    }

    protected void release(boolean force, boolean removeParent) throws IOException, APIException {
        this.release(force, removeParent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release(boolean force, boolean removeParent, String token) throws IOException, APIException {
        UserApplicationSessionImpl userApplicationSessionImpl = this;
        synchronized (userApplicationSessionImpl) {
            block17: {
                int code = 0;
                try {
                    super.release(force);
                    URI session = this.url;
                    if (session == null) break block17;
                    HttpHead request = new HttpHead(session);
                    if (this.isSSO) {
                        this.setupRequest(request, token);
                    } else {
                        this.setupRequest(request, null);
                    }
                    request.addHeader(SESSION_RELEASE);
                    HttpResponse response = this.handleHTTPResponse(request);
                    try {
                        StatusLine statusLine = response.getStatusLine();
                        code = statusLine.getStatusCode();
                        if (this.isSSO() && code == 401) {
                            String msg = MessageFormat.format(AUTHENTICATION_FAILED_MSG, statusLine);
                            InvalidTokenConnectFailedException ace = new InvalidTokenConnectFailedException(msg);
                            throw ace;
                        }
                        if (code != 200 && code != 302 && code != 410) {
                            String msg = MessageFormat.format(BAD_STATUS_LINE_MSG, statusLine);
                            throw new BlimpException(msg);
                        }
                    }
                    finally {
                        EntityUtils.consume(response.getEntity());
                    }
                }
                catch (ConnectException ce) {
                }
                finally {
                    if (!this.isSSO() || code != 401) {
                        this.invalidateURI();
                        if (removeParent) {
                            ((IntegrationPointImpl)this.ip).removeSession(this);
                        }
                    }
                }
            }
        }
    }

    @Override
    protected CmdRunner _createCmdRunner() throws APIException {
        HttpCmdRunnerImpl cr = null;
        try {
            cr = this.ip.isClientIntegrationPoint() ? new ClientCmdRunnerImpl(this) : new HttpCmdRunnerImpl(this);
            cr.setDefaultUsername(this.sessionUser);
            cr.setDefaultPassword(this.sessionPass);
        }
        catch (UnsatisfiedLinkError err) {
            this.apiLogger.exception(this, "API", 0, (Throwable)err);
            if (System.getProperty("os.name").startsWith("Windows")) {
                ((IntegrationPointImpl)this.ip).setPort(31000);
                cr = new HttpCmdRunnerImpl(this);
            }
            throw new APIConnectionException(err);
        }
        return cr;
    }

    @Override
    public boolean isCommon() {
        return this.anonymous;
    }

    protected void setAuthenticationCookie(String cookie) {
        this.sadCookie = null;
        if (cookie != null) {
            this.sadCookie = new BasicHeader("SadCookie", cookie);
        }
    }

    @Override
    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    @Override
    public boolean getAutoReconnect() {
        return this.autoReconnect;
    }

    protected void setSSO(boolean isSSO) {
        this.isSSO = isSSO;
    }

    protected boolean isSSO() {
        return this.isSSO;
    }

    static {
        try {
            API_URI = new URI("/icapi");
            API_SSO_URI = new URI("/icapisso");
        }
        catch (URISyntaxException ue) {
            IntegrationPointFactory.getLogger().exception(UserApplicationSessionImpl.class, "API", 0, (Throwable)ue);
            ue.printStackTrace();
        }
    }
}

