/*
 * Decompiled with CFR 0.152.
 */
package com.mks.connect;

import com.mks.api.response.APIException;
import com.mks.connect.AbstractCmdRunner;
import com.mks.connect.BlimpInputStream;
import com.mks.connect.HttpBlimpInputStream;
import com.mks.connect.UserApplicationSessionImpl;
import java.io.IOException;
import java.net.URI;

class HttpCmdRunnerImpl
extends AbstractCmdRunner {
    protected UserApplicationSessionImpl uas;
    protected URI url;
    protected boolean autoReconnect;

    HttpCmdRunnerImpl(UserApplicationSessionImpl uas) {
        super(uas);
        this.uas = uas;
        this.autoReconnect = uas.getAutoReconnect();
    }

    @Override
    protected BlimpInputStream createBlimpStream(String[] cmd, boolean generateSubRtns, String vendor) {
        HttpBlimpInputStream bis = new HttpBlimpInputStream(this, cmd, this.uas, vendor);
        bis.setCodePage("UTF-8");
        bis.setGenerateSubRoutines(generateSubRtns);
        bis.setInvocationID(this.getInvocationID());
        return bis;
    }

    protected synchronized URI getSessionURI() throws IOException {
        if (this.url == null) {
            this.url = this.uas.getSession(this.uas.getSessionURI(this.getToken()), this.getToken());
        }
        return this.url;
    }

    protected synchronized void invalidateURI() {
        this.uas.invalidateURI();
        this.url = null;
    }

    protected boolean getAutoReconnect() {
        return this.autoReconnect;
    }

    @Override
    public void release() throws APIException {
        if (this.isFinished()) {
            this.uas.removeConnection(this);
        }
        super.release();
    }
}

