/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.util;

import com.mks.api.VersionNumber;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public final class APIVersion
implements VersionNumber {
    public static APIVersion API_4_9 = new APIVersion(4, 9);
    public static APIVersion API_4_10 = new APIVersion(4, 10);
    public static APIVersion API_4_11 = new APIVersion(4, 11);
    public static APIVersion API_4_12 = new APIVersion(4, 12);
    public static APIVersion API_4_13 = new APIVersion(4, 13);
    public static APIVersion API_4_14 = new APIVersion(4, 14);
    public static APIVersion API_4_15 = new APIVersion(4, 15);
    public static APIVersion API_4_16 = new APIVersion(4, 16);
    private static String apiReleaseVersion;
    public static final int MAJOR_VERSION_GREATER = 1;
    public static final int MAJOR_VERSION_LESSER = -1;
    public static final int MINOR_VERSION_GREATER = 2;
    public static final int MINOR_VERSION_LESSER = -2;
    private int majorVersion;
    private int minorVersion;

    public static String getAPIReleaseVersion() {
        if (apiReleaseVersion == null) {
            try {
                ResourceBundle rb = ResourceBundle.getBundle("com.mks.api.version");
                apiReleaseVersion = rb.getString("MKS_API_VERSION");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return apiReleaseVersion;
    }

    public static String format(int majorVersion, int minorVersion) {
        if (majorVersion <= 0) {
            return APIVersion.getAPIReleaseVersion();
        }
        return MessageFormat.format("{0,number,#}.{1,number,#} 000-00 0", new Integer(majorVersion), new Integer(minorVersion));
    }

    public APIVersion(int major, int minor) {
        this.majorVersion = major;
        this.minorVersion = minor;
    }

    public APIVersion(String version) {
        StringTokenizer versionParts = new StringTokenizer(new StringTokenizer(version).nextToken(), ".");
        this.majorVersion = Integer.parseInt(versionParts.nextToken());
        this.minorVersion = Integer.parseInt(versionParts.nextToken());
    }

    @Override
    public int getMajor() {
        return this.majorVersion;
    }

    @Override
    public int getMinor() {
        return this.minorVersion;
    }

    @Override
    public String toVersionString() {
        return APIVersion.format(this.majorVersion, this.minorVersion);
    }

    public String toString() {
        return this.toVersionString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof APIVersion)) {
            return false;
        }
        APIVersion that = (APIVersion)o;
        return this.majorVersion == that.majorVersion && this.minorVersion == that.minorVersion;
    }

    public int hashCode() {
        return this.toVersionString().hashCode();
    }

    public int compare(VersionNumber apiReqVN) {
        int vn_major = apiReqVN.getMajor();
        int vn_minor = apiReqVN.getMinor();
        if (this.majorVersion < vn_major) {
            return -1;
        }
        if (this.majorVersion > vn_major) {
            return 1;
        }
        if (this.minorVersion < vn_minor) {
            return -2;
        }
        if (this.minorVersion > vn_minor) {
            return 2;
        }
        return 0;
    }
}

