/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.response.impl;

import com.mks.api.response.APIException;
import com.mks.api.response.InterruptedException;
import com.mks.api.response.Result;
import com.mks.api.response.SubRoutine;
import com.mks.api.response.SubRoutineIterator;
import com.mks.api.response.WorkItem;
import com.mks.api.response.WorkItemIterator;
import com.mks.api.response.impl.SubRoutineIteratorImpl;
import com.mks.api.response.impl.WorkItemIteratorImpl;
import com.mks.api.response.modifiable.ModifiableAPIExceptionContainer;
import com.mks.api.response.modifiable.ModifiableResultContainer;
import com.mks.api.response.modifiable.ModifiableSubRoutineContainer;
import com.mks.api.response.modifiable.ModifiableWorkItemContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

class ResponseContainer
implements ModifiableSubRoutineContainer,
ModifiableWorkItemContainer,
ModifiableAPIExceptionContainer,
ModifiableResultContainer {
    protected Result result;
    protected APIException apiException;
    protected int exitCode;
    protected List workItemList = new ArrayList();
    protected List subRoutineList = new ArrayList();
    protected String wiSelectionType;
    protected boolean interimResults;
    protected boolean cacheResults;
    private String hostname;
    private int port = -1;
    private String username;

    protected ResponseContainer() {
        this.exitCode = Integer.MIN_VALUE;
    }

    public void setWorkItemSelectionType(String workItemSelectionType) {
        this.wiSelectionType = workItemSelectionType;
    }

    public String getWorkItemSelectionType() {
        return this.wiSelectionType;
    }

    public boolean getUseInterim() {
        return this.interimResults;
    }

    public void setUseInterim(boolean flag) {
        this.interimResults = flag;
    }

    public boolean getCacheContents() {
        return this.cacheResults;
    }

    public void setCacheContents(boolean flag) {
        this.cacheResults = flag;
    }

    @Override
    public void add(WorkItem wi) {
        this.workItemList.add(wi);
        if (this.wiSelectionType == null) {
            this.setWorkItemSelectionType(wi.getModelType());
        }
    }

    @Override
    public WorkItem getWorkItem(String id) {
        for (WorkItem wi : this.workItemList) {
            if (!wi.getId().equals(id)) continue;
            return wi;
        }
        throw new NoSuchElementException(id);
    }

    @Override
    public WorkItem getWorkItem(String id, String context) {
        for (WorkItem wi : this.workItemList) {
            if (!wi.getId().equals(id) || !wi.getContext().equals(context)) continue;
            return wi;
        }
        throw new NoSuchElementException(id);
    }

    @Override
    public boolean containsWorkItem(String id) {
        try {
            return this.getWorkItem(id) != null;
        }
        catch (NoSuchElementException nsee) {
            return false;
        }
    }

    @Override
    public boolean containsWorkItem(String id, String context) {
        try {
            return this.getWorkItem(id, context) != null;
        }
        catch (NoSuchElementException nsee) {
            return false;
        }
    }

    @Override
    public int getWorkItemListSize() {
        return this.workItemList.size();
    }

    @Override
    public WorkItemIterator getWorkItems() {
        return new WorkItemIteratorImpl(this.workItemList.iterator());
    }

    @Override
    public void setAPIException(APIException ae) {
        this.apiException = ae;
    }

    public APIException getAPIException() throws InterruptedException {
        return this.apiException;
    }

    @Override
    public void add(SubRoutine sr) {
        this.subRoutineList.add(sr);
    }

    @Override
    public boolean containsSubRoutine(String name) {
        try {
            return this.getSubRoutine(name) != null;
        }
        catch (NoSuchElementException nsee) {
            return false;
        }
    }

    @Override
    public SubRoutine getSubRoutine(String name) {
        for (SubRoutine sr : this.subRoutineList) {
            if (!name.equals(sr.getRoutine())) continue;
            return sr;
        }
        throw new NoSuchElementException(name);
    }

    @Override
    public int getSubRoutineListSize() {
        return this.subRoutineList.size();
    }

    @Override
    public SubRoutineIterator getSubRoutines() {
        return new SubRoutineIteratorImpl(this.subRoutineList.iterator());
    }

    public Result getResult() throws InterruptedException {
        return this.result;
    }

    @Override
    public void setResult(Result res) {
        this.result = res;
    }

    public int getExitCode() throws InterruptedException {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public void setConnectionHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getConnectionHostname() {
        return this.hostname;
    }

    public void setConnectionPort(int port) {
        this.port = port;
    }

    public int getConnectionPort() {
        return this.port;
    }

    public void setConnectionUsername(String username) {
        this.username = username;
    }

    public String getConnectionUsername() {
        return this.username;
    }
}

