/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.response.impl;

import com.mks.api.common.XMLResponseDef;
import com.mks.api.response.APIError;
import com.mks.api.response.Item;
import com.mks.api.response.modifiable.ModifiableField;
import com.mks.api.util.BinaryContents;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.ImageIcon;

public class FieldImpl
implements ModifiableField {
    private String name;
    private String displayName;
    private Object value;
    private String displayValue;
    private String dataType;
    private String modelType;
    private Object internalValue;
    private String contentType;
    private static final String INVALID_DATATYPE = "Resultant field must have a \"com.mks.api.response.Item\" datatype.";

    protected FieldImpl(String name) {
        this(name, name);
    }

    protected FieldImpl(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
        this.displayValue = null;
    }

    @Override
    public String getModelType() {
        return this.modelType;
    }

    @Override
    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    @Override
    public void setDataType(String dataType) {
        if (this.name.equalsIgnoreCase(XMLResponseDef.XML_RESULT_FIELD) && !dataType.equals("com.mks.api.response.Item")) {
            throw new APIError(INVALID_DATATYPE);
        }
        this.dataType = dataType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    public String getDataTypeDef() {
        if (this.dataType == null) {
            Object dataValue = this.value;
            if (dataValue instanceof Collection) {
                try {
                    dataValue = ((Collection)dataValue).iterator().next();
                }
                catch (NoSuchElementException ex) {
                    dataValue = null;
                }
            }
            if (dataValue instanceof Item) {
                this.dataType = "com.mks.api.response.Item";
                this.modelType = ((Item)dataValue).getModelType();
            } else if (dataValue instanceof Integer) {
                this.dataType = "java.lang.Integer";
            } else if (dataValue instanceof Boolean) {
                this.dataType = "java.lang.Boolean";
            } else if (dataValue instanceof Double) {
                this.dataType = "java.lang.Double";
            } else if (dataValue instanceof Float) {
                this.dataType = "java.lang.Float";
            } else if (dataValue instanceof Long) {
                this.dataType = "java.lang.Long";
            } else if (dataValue instanceof Date) {
                this.dataType = "java.util.Date";
            } else if (dataValue instanceof String) {
                this.dataType = "java.lang.String";
            } else if (dataValue instanceof byte[]) {
                this.dataType = "[B";
            } else if (dataValue != null) {
                this.dataType = "java.lang.String";
            }
        }
        return this.dataType;
    }

    @Override
    public String getDataType() {
        return this.value == null ? null : this.getDataTypeDef();
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        if (this.getDataTypeDef() == null) {
            return null;
        }
        if (this.getDataTypeDef().equals("[B")) {
            return this.contentType;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean getBoolean() {
        if (this.getDataTypeDef() == null) {
            return null;
        }
        if (this.getDataTypeDef().equals("java.lang.Boolean")) {
            return (Boolean)this.value;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDateTime() {
        if (this.getDataTypeDef() == null) {
            return null;
        }
        if (this.getDataTypeDef().equals("java.util.Date")) {
            return (Date)this.value;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Double getDouble() {
        if (this.getDataTypeDef() == null) {
            return null;
        }
        if (this.getDataTypeDef().equals("java.lang.Double")) {
            return (Double)this.value;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Float getFloat() {
        if (this.value == null || this.getDataTypeDef() == null) {
            return null;
        }
        if (this.getDataTypeDef().equals("java.lang.Float")) {
            return (Float)this.value;
        }
        if (this.getDataTypeDef().equals("java.lang.Double")) {
            return new Float(((Double)this.value).floatValue());
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer getInteger() {
        if (this.getDataTypeDef() == null) {
            return null;
        }
        if (this.getDataTypeDef().equals("java.lang.Integer")) {
            return (Integer)this.value;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getLong() {
        if (this.getDataTypeDef() == null) {
            return null;
        }
        if (this.getDataTypeDef().equals("java.lang.Long")) {
            return (Long)this.value;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString() {
        if (this.getDataTypeDef() == null) {
            return null;
        }
        if (this.getDataTypeDef().equals("java.lang.String")) {
            return (String)this.value;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String getValueAsString() {
        if (this.displayValue != null) {
            return this.displayValue;
        }
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Item) {
            return ((Item)this.value).getDisplayId();
        }
        if (this.value instanceof List) {
            StringBuffer sb = new StringBuffer();
            Iterator it = ((List)this.value).iterator();
            while (it.hasNext()) {
                Object valueObj;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append((valueObj = it.next()) instanceof Item ? ((Item)valueObj).getDisplayId() : valueObj.toString());
            }
            return sb.toString();
        }
        return this.value.toString();
    }

    @Override
    public List getList() {
        if (this.getDataTypeDef() == null) {
            return null;
        }
        if (this.getDataTypeDef().equals("com.mks.api.response.ItemList") || this.getDataTypeDef().equals("com.mks.api.response.ValueList")) {
            return (List)this.value;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Item getItem() {
        if (this.getDataTypeDef() == null) {
            return null;
        }
        if (this.getDataTypeDef().equals("com.mks.api.response.Item")) {
            return (Item)this.value;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes() throws IOException {
        if (this.getDataTypeDef() == null) {
            return null;
        }
        if (this.getDataTypeDef().equals("[B")) {
            return (byte[])this.value;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ImageIcon getImage() throws IOException {
        String contentType;
        if (this.getDataTypeDef() == null) {
            return null;
        }
        if (this.getDataTypeDef().equals("[B") && (contentType = this.getContentType()) != null && contentType.equals("image-png")) {
            ImageIcon imageIcon = BinaryContents.toImageIcon((byte[])this.value);
            return imageIcon;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDisplayValue(String value) {
        this.displayValue = value;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean hasDisplayValue() {
        return this.displayValue != null;
    }

    public Object getInternalValue() {
        if (null == this.internalValue) {
            return this.value;
        }
        return this.internalValue;
    }

    public void setInternalValue(Object value) {
        this.internalValue = value;
    }
}

