/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.response;

import com.mks.api.response.Field;
import com.mks.api.response.FieldContainer;
import com.mks.api.response.Response;
import com.mks.api.response.impl.SimpleResponseFactory;
import com.mks.api.response.modifiable.ModifiableField;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class APIException
extends Exception
implements FieldContainer {
    protected String message;
    protected transient List fields;
    protected transient Response response;
    protected boolean showStackTrace;
    private transient SimpleResponseFactory factory;
    protected Throwable cause;

    public APIException() {
        this((Throwable)null);
    }

    public APIException(String msg) {
        this((Throwable)null);
        this.setMessage(msg);
    }

    public APIException(Throwable cause) {
        this.cause = cause;
        this.fields = new ArrayList();
        this.showStackTrace = true;
    }

    public String getExceptionId() {
        if (this.contains("exception-name")) {
            return this.getField("exception-name").getValueAsString();
        }
        return null;
    }

    @Override
    public String getMessage() {
        if (this.cause != null) {
            return this.cause.getMessage();
        }
        return this.message;
    }

    public void setMessage(String message) {
        if (this.cause != null && this.cause instanceof APIException) {
            ((APIException)this.cause).setMessage(message);
        } else {
            this.message = message;
        }
    }

    public Response getResponse() {
        return this.response;
    }

    protected void setResponse(Response response) {
        this.response = response;
    }

    public void add(Field field) {
        this.fields.add(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(String fieldname, String fieldvalue) {
        APIException aPIException = this;
        synchronized (aPIException) {
            if (this.factory == null) {
                this.factory = SimpleResponseFactory.getResponseFactory();
            }
        }
        ModifiableField field = this.factory.createField(fieldname);
        field.setDataType("java.lang.String");
        field.setValue(fieldvalue);
        this.add(field);
    }

    @Override
    public Field getField(String name) {
        for (Field f : this.fields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        throw new NoSuchElementException(name);
    }

    public Field getField(int idx) {
        return (Field)this.fields.get(idx);
    }

    @Override
    public Iterator getFields() {
        return this.fields.iterator();
    }

    @Override
    public int getFieldListSize() {
        return this.fields.size();
    }

    @Override
    public boolean contains(String id) {
        for (Field f : this.fields) {
            if (!f.getName().equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void printStackTrace() {
        if (this.cause != null) {
            if (this.cause instanceof APIException || this.showStackTrace) {
                this.cause.printStackTrace();
            }
        } else if (this.showStackTrace) {
            super.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.cause != null) {
            if (this.cause instanceof APIException || this.showStackTrace) {
                this.cause.printStackTrace(s);
            }
        } else if (this.showStackTrace) {
            super.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.cause != null) {
            if (this.cause instanceof APIException || this.showStackTrace) {
                this.cause.printStackTrace(s);
            }
        } else if (this.showStackTrace) {
            super.printStackTrace(s);
        }
    }

    protected void setShowStackTrace(boolean showStackTrace) {
        if (this.cause != null && this.cause instanceof APIException) {
            ((APIException)this.cause).setShowStackTrace(showStackTrace);
        } else {
            this.showStackTrace = showStackTrace;
        }
    }
}

