/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands;

import com.mks.api.CmdRunnerCreator;
import com.mks.api.Command;
import com.mks.api.Option;
import com.mks.api.OptionList;
import com.mks.api.commands.GenericWFCommandRunner;
import com.mks.api.commands.IDECommands;
import com.mks.api.commands.SICheckOutCommand;
import com.mks.api.commands.SIResyncCommand;
import com.mks.api.commands.SIRevertCommand;
import com.mks.api.commands.WFSubmitTrackedChanges;
import com.mks.api.commands.WFTrackDeletedFile;
import com.mks.api.commands.WFTrackMoveToChangePackage;
import com.mks.api.commands.WFTrackMovedFile;
import com.mks.api.commands.WFTrackNewFile;
import com.mks.api.commands.ide.WorkingFileList;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import java.io.File;

public class WFCommands
extends IDECommands {
    public WFCommands(CmdRunnerCreator session, boolean isInteractive) throws APIException {
        super(session, isInteractive);
    }

    public Response resync(WorkingFileList wfList, boolean overwriteChanged, boolean overwriteDeferred, boolean overwritePending, boolean merge, String mergeType, String mergeConflict, boolean downgradeOnConflict, boolean byCP) throws APIException {
        SIResyncCommand siResync = new SIResyncCommand(this.getCmdRunnerCreator());
        siResync.setOverwrite(overwriteChanged);
        siResync.setOverwriteDeferred(overwriteDeferred);
        siResync.setOverwritePending(overwritePending);
        if (byCP) {
            siResync.setByCP(byCP);
        }
        if (mergeType != null) {
            siResync.setMerge(merge);
        }
        if (merge) {
            siResync.setMergeType(mergeType);
            siResync.setMergeConflict(mergeConflict);
        }
        siResync.setDowngradeOnLockConflict(downgradeOnConflict);
        GenericWFCommandRunner runner = new GenericWFCommandRunner(this.getCmdRunnerCreator(), siResync);
        return runner.execute(wfList, this.isInteractive);
    }

    public Response checkOut(WorkingFileList wfList, boolean overwriteChanged, boolean overwriteDeferred, boolean lock, boolean merge, String mergeType, String mergeConflict) throws APIException {
        SICheckOutCommand siCO = new SICheckOutCommand(this.getCmdRunnerCreator());
        siCO.setOverwrite(overwriteChanged);
        siCO.setOverwriteDeferred(overwriteDeferred);
        siCO.setMerge(merge);
        siCO.setMergeConflict("launchtool");
        siCO.setMergeType("automatic");
        siCO.setLock(lock);
        GenericWFCommandRunner runner = new GenericWFCommandRunner(this.getCmdRunnerCreator(), siCO);
        return runner.execute(wfList, this.isInteractive);
    }

    public Response revert(WorkingFileList wfList, boolean overwriteDeferred, boolean overwriteChanged) throws APIException {
        SIRevertCommand siRevert = new SIRevertCommand(this.getCmdRunnerCreator());
        siRevert.setOverwriteIfChanged(overwriteChanged);
        siRevert.setOverwriteIfDeferred(overwriteDeferred);
        GenericWFCommandRunner runner = new GenericWFCommandRunner(this.getCmdRunnerCreator(), siRevert);
        return runner.execute(wfList, this.isInteractive);
    }

    public Response revert(WorkingFileList wfList) throws APIException {
        SIRevertCommand siRevert = new SIRevertCommand(this.getCmdRunnerCreator());
        GenericWFCommandRunner runner = new GenericWFCommandRunner(this.getCmdRunnerCreator(), siRevert);
        return runner.execute(wfList, this.isInteractive);
    }

    public Response newFiles(String[] workingFiles, String cpid, File sandboxRoot, boolean binary) throws APIException {
        OptionList options = new OptionList();
        options.add(new Option("cpid", cpid));
        if (sandboxRoot != null) {
            options.add(new Option("sandboxRoot", sandboxRoot.getAbsolutePath()));
        }
        if (binary) {
            options.add(new Option("binary"));
        }
        return this.executeWFCommand("tracknew", options, workingFiles);
    }

    public Response newFilesInternal(String[] workingFiles, String cpid, File sandboxRoot, boolean binary) throws APIException {
        WFTrackNewFile trackNewFile = new WFTrackNewFile(this.getCmdRunnerCreator(), binary);
        trackNewFile.setCpid(cpid);
        trackNewFile.setPreferredRoot(sandboxRoot);
        return trackNewFile.execute(workingFiles, this.isInteractive);
    }

    public Response deletedFilesInternal(String[] workingFiles, String cpid) throws APIException {
        WFTrackDeletedFile trackDeletedFile = new WFTrackDeletedFile(this.getCmdRunnerCreator());
        trackDeletedFile.setCpid(cpid);
        return trackDeletedFile.execute(workingFiles, this.isInteractive);
    }

    public Response deletedFiles(String[] workingFiles, String cpid) throws APIException {
        OptionList options = new OptionList();
        options.add(new Option("cpid", cpid));
        return this.executeWFCommand("trackdeleted", options, workingFiles);
    }

    public Response moveToCP(String[] workingFiles, String destinationCpid, File sandboxRoot) throws APIException {
        OptionList options = new OptionList();
        options.add(new Option("cpid", destinationCpid));
        if (sandboxRoot != null) {
            options.add(new Option("sandboxRoot", sandboxRoot.getAbsolutePath()));
        }
        return this.executeWFCommand("trackaddtocp", options, workingFiles);
    }

    public Response moveToCPInternal(String[] workingFiles, String destinationCpid, File sandboxRoot) throws APIException {
        WFTrackMoveToChangePackage command = new WFTrackMoveToChangePackage(this.getCmdRunnerCreator());
        command.setCpid(destinationCpid);
        command.setPreferredRoot(sandboxRoot);
        return command.execute(workingFiles, this.isInteractive);
    }

    public Response submitChangesInternal(String[] workingFile, String cpid) throws APIException {
        WFSubmitTrackedChanges wfSubmit = new WFSubmitTrackedChanges(this.getCmdRunnerCreator());
        wfSubmit.setCpid(cpid);
        return wfSubmit.execute(workingFile, this.isInteractive);
    }

    public Response submitChanges(String[] workingFile) throws APIException {
        OptionList options = new OptionList();
        return this.executeWFCommand("submit", options, workingFile);
    }

    public Response movedFileInternal(String selection, String newName, String cpid, File sandboxRoot) throws APIException {
        WFTrackMovedFile trackMovedFile = new WFTrackMovedFile(this.getCmdRunnerCreator());
        trackMovedFile.setCpid(cpid);
        trackMovedFile.setPreferredRoot(sandboxRoot);
        trackMovedFile.setNewName(newName);
        trackMovedFile.setAllowCreateSubs(true);
        return trackMovedFile.execute(new String[]{selection}, this.isInteractive);
    }

    public Response movedFile(String selection, String newName, String cpid, File sandboxRoot) throws APIException {
        OptionList options = new OptionList();
        options.add(new Option("cpid", cpid));
        options.add(new Option("newName", newName));
        if (sandboxRoot != null) {
            options.add(new Option("sandboxRoot", sandboxRoot.getAbsolutePath()));
        }
        return this.executeWFCommand("trackmoved", options, new String[]{selection});
    }

    private Response executeWFCommand(String commandName, OptionList options, String[] selection) throws APIException {
        Command command = new Command("wf", commandName);
        command.getOptionList().add(options);
        if (this.isInteractive) {
            command.addOption(new Option("interactive"));
        }
        for (String file : selection) {
            command.addSelection(file);
        }
        return this.runAPICommand(command);
    }
}

