/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands;

import com.mks.api.CmdRunnerCreator;
import com.mks.api.Command;
import com.mks.api.Option;
import com.mks.api.OptionList;
import com.mks.api.SelectionList;
import com.mks.api.commands.CommandBase;
import com.mks.api.commands.IHasChangePackage;
import com.mks.api.commands.IWorkingFileCompatibleCommand;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;

class SISubmitCommand
extends CommandBase
implements IHasChangePackage,
IWorkingFileCompatibleCommand {
    String sandbox = null;
    String cwd = null;
    Boolean closeCP = null;
    String cpid = null;
    boolean guiStatus = false;

    SISubmitCommand(CmdRunnerCreator session) throws APIException {
        super(session);
    }

    @Override
    protected Response execute(SelectionList selection) throws APIException {
        Command cmd = new Command("si", "submit");
        OptionList options = this.getBaseOptions();
        if (this.interactive) {
            options.add(new Option("gui"));
        } else {
            options.add(new Option("yes"));
        }
        if (this.sandbox != null) {
            options.add("sandbox", this.sandbox);
        }
        if (this.cwd != null) {
            options.add("cwd", this.cwd);
        }
        if (this.closeCP != null) {
            options.add(this.createBinaryOption("closeCP", this.closeCP));
        }
        if (this.cpid != null) {
            options.add("cpid", this.cpid);
        }
        if (this.guiStatus) {
            options.add("status", "gui");
        }
        if (selection != null && selection.size() > 0) {
            options.add(new Option("recurse"));
        }
        cmd.setOptionList(options);
        cmd.setSelectionList(selection);
        return this.runAPICommand(cmd);
    }

    @Override
    public boolean isCloseCPOverridden() {
        return this.closeCP != null;
    }

    @Override
    public void resetCloseCP() {
        this.closeCP = null;
    }

    @Override
    public void setCloseCP(boolean closeCP) {
        this.closeCP = new Boolean(closeCP);
    }

    @Override
    public void setCpid(String cpid) {
        this.cpid = cpid;
    }

    @Override
    public void setSandbox(String sandbox) {
        this.sandbox = sandbox;
    }

    @Override
    public void setCwd(String cwd) {
        this.cwd = cwd;
    }

    public void setGuiStatus(boolean guiStatus) {
        this.guiStatus = guiStatus;
    }
}

