/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api;

import com.mks.api.Option;
import com.mks.api.OptionList;
import com.mks.api.SelectionList;
import java.util.ArrayList;
import java.util.Iterator;

public class Command {
    public static final String NONE_CP_ID = ":none";
    public static final String AA = "aa";
    public static final String IM = "im";
    public static final String INTEGRITY = "integrity";
    public static final String SI = "si";
    public static final String SD = "sd";
    public static final String TM = "tm";
    public static final String RQ = "rq";
    public static final String WF = "wf";
    protected OptionList optionList;
    protected SelectionList selectionList;
    protected String command;
    protected String app;
    protected String vendor;
    protected boolean generateSubRtns;

    public Command() {
        this("", "");
    }

    public Command(String app) {
        this(app, "");
    }

    public Command(String app, String commandName) {
        this.app = app;
        this.command = commandName;
        this.optionList = new OptionList();
        this.selectionList = new SelectionList();
    }

    public Command(String vendorName, String app, String commandName) {
        this(app, commandName);
        this.vendor = vendorName;
    }

    public void addOption(Option option) {
        this.optionList.add(option);
    }

    public void clearOptionList() {
        this.optionList.clear();
    }

    public OptionList getOptionList() {
        return this.optionList;
    }

    public void setOptionList(OptionList optionList) {
        this.optionList = optionList;
    }

    public void clearSelectionList() {
        this.selectionList.clear();
    }

    public SelectionList getSelectionList() {
        return this.selectionList;
    }

    public void setSelectionList(SelectionList selectionList) {
        this.selectionList = selectionList;
    }

    public void addSelection(String selection) {
        this.selectionList.add(selection);
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getCommandName() {
        return this.command;
    }

    public void setCommandName(String commandName) {
        this.command = commandName;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendorName(String vendorName) {
        this.vendor = vendorName;
    }

    public boolean getGenerateSubRoutines() {
        return this.generateSubRtns;
    }

    public void setGenerateSubRoutines(boolean generateSubRtns) {
        this.generateSubRtns = generateSubRtns;
    }

    public String[] toStringArray() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getApp());
        list.add(this.getCommandName());
        Iterator it = this.getOptionList().getOptions();
        while (it.hasNext()) {
            String s = it.next().toString();
            if (s.length() > 2 && s.charAt(2) == ' ') {
                list.add(s.substring(0, 2));
                list.add(s.substring(3));
                continue;
            }
            list.add(s);
        }
        list.add("--");
        it = this.getSelectionList().getSelections();
        while (it.hasNext()) {
            list.add(it.next().toString());
        }
        return list.toArray(new String[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command other = (Command)o;
        return (this.app == other.app || this.app != null && this.app.equals(other.app)) && (this.command == other.command || this.command != null && this.command.equals(other.command)) && (this.optionList == other.optionList || this.optionList != null && this.optionList.equals(other.optionList)) && (this.selectionList == other.selectionList || this.selectionList != null && this.selectionList.equals(other.selectionList));
    }

    public int hashCode() {
        return this.app.hashCode() ^ this.command.hashCode() ^ this.optionList.hashCode() ^ this.selectionList.hashCode();
    }
}

