/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi.featureflags.model;

import com.mixpanel.mixpanelapi.featureflags.model.Rollout;
import com.mixpanel.mixpanelapi.featureflags.model.Variant;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class RuleSet {
    private final List<Variant> variants;
    private final List<Rollout> rollouts;
    private final Map<String, String> testUserOverrides;

    public RuleSet(List<Variant> variants, List<Rollout> rollouts, Map<String, String> testUserOverrides) {
        this.variants = variants != null ? Collections.unmodifiableList(variants) : Collections.emptyList();
        this.rollouts = rollouts != null ? Collections.unmodifiableList(rollouts) : Collections.emptyList();
        this.testUserOverrides = testUserOverrides != null ? Collections.unmodifiableMap(testUserOverrides) : null;
    }

    public RuleSet(List<Variant> variants, List<Rollout> rollouts) {
        this(variants, rollouts, null);
    }

    public List<Variant> getVariants() {
        return this.variants;
    }

    public List<Rollout> getRollouts() {
        return this.rollouts;
    }

    public Map<String, String> getTestUserOverrides() {
        return this.testUserOverrides;
    }

    public boolean hasTestUserOverrides() {
        return this.testUserOverrides != null && !this.testUserOverrides.isEmpty();
    }

    public String toString() {
        return "RuleSet{variants=" + this.variants + ", rollouts=" + this.rollouts + ", testUserOverrides=" + this.testUserOverrides + '}';
    }
}

