/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi.featureflags.model;

import java.util.UUID;

public final class SelectedVariant<T> {
    private final String variantKey;
    private final T variantValue;
    private final UUID experimentId;
    private final Boolean isExperimentActive;
    private final Boolean isQaTester;

    public SelectedVariant(T variantValue) {
        this(null, variantValue, null, null, null);
    }

    public SelectedVariant(String variantKey, T variantValue, UUID experimentId, Boolean isExperimentActive, Boolean isQaTester) {
        this.variantKey = variantKey;
        this.variantValue = variantValue;
        this.experimentId = experimentId;
        this.isExperimentActive = isExperimentActive;
        this.isQaTester = isQaTester;
    }

    public String getVariantKey() {
        return this.variantKey;
    }

    public T getVariantValue() {
        return this.variantValue;
    }

    public UUID getExperimentId() {
        return this.experimentId;
    }

    public Boolean getIsExperimentActive() {
        return this.isExperimentActive;
    }

    public Boolean getIsQaTester() {
        return this.isQaTester;
    }

    public boolean isSuccess() {
        return this.variantKey != null;
    }

    public boolean isFallback() {
        return this.variantKey == null;
    }

    public String toString() {
        return "SelectedVariant{variantKey='" + this.variantKey + '\'' + ", variantValue=" + this.variantValue + ", experimentId=" + this.experimentId + ", isExperimentActive=" + this.isExperimentActive + ", isQaTester=" + this.isQaTester + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectedVariant that = (SelectedVariant)o;
        if (this.variantKey != null ? !this.variantKey.equals(that.variantKey) : that.variantKey != null) {
            return false;
        }
        if (this.variantValue != null ? !this.variantValue.equals(that.variantValue) : that.variantValue != null) {
            return false;
        }
        if (this.experimentId != null ? !this.experimentId.equals(that.experimentId) : that.experimentId != null) {
            return false;
        }
        if (this.isExperimentActive != null ? !this.isExperimentActive.equals(that.isExperimentActive) : that.isExperimentActive != null) {
            return false;
        }
        return this.isQaTester != null ? this.isQaTester.equals(that.isQaTester) : that.isQaTester == null;
    }
}

