/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.mixpanel.mixpanelapi.internal.JsonSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JacksonSerializer
implements JsonSerializer {
    private final JsonFactory jsonFactory = new JsonFactory();

    public String serializeArray(List<JSONObject> messages) throws IOException {
        if (messages == null || messages.isEmpty()) {
            return "[]";
        }
        StringWriter writer = new StringWriter();
        try (JsonGenerator generator = this.jsonFactory.createGenerator((Writer)writer);){
            this.writeJsonArray(generator, messages);
        }
        return writer.toString();
    }

    private void writeJsonArray(JsonGenerator generator, List<JSONObject> messages) throws IOException {
        generator.writeStartArray();
        for (JSONObject message : messages) {
            this.writeJsonObject(generator, message);
        }
        generator.writeEndArray();
    }

    private void writeJsonObject(JsonGenerator generator, JSONObject jsonObject) throws IOException {
        generator.writeStartObject();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = jsonObject.opt(key);
            if (value == null || value == JSONObject.NULL) {
                generator.writeNullField(key);
                continue;
            }
            if (value instanceof String) {
                generator.writeStringField(key, (String)value);
                continue;
            }
            if (value instanceof Number) {
                if (value instanceof Integer) {
                    generator.writeNumberField(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Long) {
                    generator.writeNumberField(key, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Double) {
                    generator.writeNumberField(key, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Float) {
                    generator.writeNumberField(key, ((Float)value).floatValue());
                    continue;
                }
                generator.writeNumberField(key, ((Number)value).doubleValue());
                continue;
            }
            if (value instanceof Boolean) {
                generator.writeBooleanField(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof JSONObject) {
                generator.writeFieldName(key);
                this.writeJsonObject(generator, (JSONObject)value);
                continue;
            }
            if (value instanceof JSONArray) {
                generator.writeFieldName(key);
                this.writeJsonArray(generator, (JSONArray)value);
                continue;
            }
            generator.writeStringField(key, value.toString());
        }
        generator.writeEndObject();
    }

    private void writeJsonArray(JsonGenerator generator, JSONArray jsonArray) throws IOException {
        generator.writeStartArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object value = jsonArray.opt(i);
            if (value == null || value == JSONObject.NULL) {
                generator.writeNull();
                continue;
            }
            if (value instanceof String) {
                generator.writeString((String)value);
                continue;
            }
            if (value instanceof Number) {
                if (value instanceof Integer) {
                    generator.writeNumber(((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Long) {
                    generator.writeNumber(((Long)value).longValue());
                    continue;
                }
                if (value instanceof Double) {
                    generator.writeNumber(((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Float) {
                    generator.writeNumber(((Float)value).floatValue());
                    continue;
                }
                generator.writeNumber(((Number)value).doubleValue());
                continue;
            }
            if (value instanceof Boolean) {
                generator.writeBoolean(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof JSONObject) {
                this.writeJsonObject(generator, (JSONObject)value);
                continue;
            }
            if (value instanceof JSONArray) {
                this.writeJsonArray(generator, (JSONArray)value);
                continue;
            }
            generator.writeString(value.toString());
        }
        generator.writeEndArray();
    }
}

