/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.util;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mixpanel.android.mpmetrics.MixpanelFlagVariant;
import com.mixpanel.android.util.MPLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    private static final String LOGTAG = "MixpanelAPI.JsonUtils";

    @Nullable
    public static Object parseJsonValue(@Nullable Object jsonValue) throws JSONException {
        if (jsonValue == null || jsonValue == JSONObject.NULL) {
            return null;
        }
        if (jsonValue instanceof Boolean || jsonValue instanceof String || jsonValue instanceof Integer || jsonValue instanceof Long || jsonValue instanceof Double || jsonValue instanceof Float) {
            return jsonValue;
        }
        if (jsonValue instanceof Number) {
            return jsonValue;
        }
        if (jsonValue instanceof JSONObject) {
            return JsonUtils.jsonObjectToMap((JSONObject)jsonValue);
        }
        if (jsonValue instanceof JSONArray) {
            return JsonUtils.jsonArrayToList((JSONArray)jsonValue);
        }
        MPLog.w(LOGTAG, "Could not parse JSON value of type: " + jsonValue.getClass().getSimpleName());
        throw new JSONException("Unsupported JSON type encountered: " + jsonValue.getClass().getSimpleName());
    }

    @NonNull
    private static Map<String, Object> jsonObjectToMap(@NonNull JSONObject jsonObject) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = jsonObject.get(key);
            map.put(key, JsonUtils.parseJsonValue(value));
        }
        return map;
    }

    @NonNull
    private static List<Object> jsonArrayToList(@NonNull JSONArray jsonArray) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object value = jsonArray.get(i);
            list.add(JsonUtils.parseJsonValue(value));
        }
        return list;
    }

    @NonNull
    public static Map<String, MixpanelFlagVariant> parseFlagsResponse(@Nullable JSONObject responseJson) {
        HashMap<String, MixpanelFlagVariant> flagsMap = new HashMap<String, MixpanelFlagVariant>();
        if (responseJson == null) {
            MPLog.e(LOGTAG, "Cannot parse null flags response");
            return flagsMap;
        }
        JSONObject flagsObject = null;
        try {
            if (!responseJson.has("flags") || responseJson.isNull("flags")) {
                MPLog.w(LOGTAG, "Flags response JSON does not contain 'flags' key or it's null.");
                return flagsMap;
            }
            flagsObject = responseJson.getJSONObject("flags");
            Iterator keys = flagsObject.keys();
            while (keys.hasNext()) {
                String featureName = (String)keys.next();
                try {
                    if (flagsObject.isNull(featureName)) {
                        MPLog.w(LOGTAG, "Flag definition is null for key: " + featureName);
                        continue;
                    }
                    JSONObject flagDefinition = flagsObject.getJSONObject(featureName);
                    String variantKey = null;
                    if (!flagDefinition.has("variant_key") || flagDefinition.isNull("variant_key")) {
                        MPLog.w(LOGTAG, "Flag definition missing 'variant_key' for key: " + featureName);
                        continue;
                    }
                    variantKey = flagDefinition.getString("variant_key");
                    Object variantValue = null;
                    if (flagDefinition.has("variant_value")) {
                        Object rawValue = flagDefinition.get("variant_value");
                        variantValue = JsonUtils.parseJsonValue(rawValue);
                    } else {
                        MPLog.w(LOGTAG, "Flag definition missing 'variant_value' for key: " + featureName + ". Assuming null value.");
                    }
                    String experimentID = null;
                    if (flagDefinition.has("experiment_id") && !flagDefinition.isNull("experiment_id")) {
                        experimentID = flagDefinition.getString("experiment_id");
                    }
                    Boolean isExperimentActive = null;
                    if (flagDefinition.has("is_experiment_active") && !flagDefinition.isNull("is_experiment_active")) {
                        isExperimentActive = flagDefinition.getBoolean("is_experiment_active");
                    }
                    Boolean isQATester = null;
                    if (flagDefinition.has("is_qa_tester") && !flagDefinition.isNull("is_qa_tester")) {
                        isQATester = flagDefinition.getBoolean("is_qa_tester");
                    }
                    MixpanelFlagVariant flagData = new MixpanelFlagVariant(variantKey, variantValue, experimentID, isExperimentActive, isQATester);
                    flagsMap.put(featureName, flagData);
                }
                catch (JSONException e) {
                    MPLog.e(LOGTAG, "Error parsing individual flag definition for key: " + featureName, e);
                }
            }
        }
        catch (JSONException e) {
            MPLog.e(LOGTAG, "Error parsing outer 'flags' object in response", e);
        }
        return flagsMap;
    }
}

