/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.MixpanelNetworkErrorListener;
import com.mixpanel.android.util.OfflineMode;
import com.mixpanel.android.util.ProxyServerInteractor;
import com.mixpanel.android.util.RemoteService;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpService
implements RemoteService {
    private final boolean shouldGzipRequestPayload;
    private final MixpanelNetworkErrorListener networkErrorListener;
    private static boolean sIsMixpanelBlocked;
    private static final int MIN_UNAVAILABLE_HTTP_RESPONSE_CODE = 500;
    private static final int MAX_UNAVAILABLE_HTTP_RESPONSE_CODE = 599;
    private static final String LOGTAG = "MixpanelAPI.Message";
    private static final int HTTP_OUTPUT_STREAM_BUFFER_SIZE = 8192;
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String GZIP_CONTENT_TYPE_HEADER = "gzip";

    public HttpService(boolean shouldGzipRequestPayload, MixpanelNetworkErrorListener networkErrorListener) {
        this.shouldGzipRequestPayload = shouldGzipRequestPayload;
        this.networkErrorListener = networkErrorListener;
    }

    public HttpService() {
        this(false, null);
    }

    @Override
    public void checkIsMixpanelBlocked() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    long startTimeNanos = System.nanoTime();
                    String host = "api.mixpanel.com";
                    InetAddress apiMixpanelInet = InetAddress.getByName(host);
                    boolean bl = sIsMixpanelBlocked = apiMixpanelInet.isLoopbackAddress() || apiMixpanelInet.isAnyLocalAddress();
                    if (sIsMixpanelBlocked) {
                        MPLog.v(HttpService.LOGTAG, "AdBlocker is enabled. Won't be able to use Mixpanel services.");
                        HttpService.this.onNetworkError(null, host, apiMixpanelInet.getHostAddress(), startTimeNanos, -1L, -1L, new IOException(host + " is blocked"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public boolean isOnline(Context context, OfflineMode offlineMode) {
        boolean isOnline;
        if (sIsMixpanelBlocked) {
            return false;
        }
        if (this.onOfflineMode(offlineMode)) {
            return false;
        }
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            if (netInfo == null) {
                isOnline = true;
                MPLog.v(LOGTAG, "A default network has not been set so we cannot be certain whether we are offline");
            } else {
                isOnline = netInfo.isConnectedOrConnecting();
                MPLog.v(LOGTAG, "ConnectivityManager says we " + (isOnline ? "are" : "are not") + " online");
            }
        }
        catch (SecurityException e) {
            isOnline = true;
            MPLog.v(LOGTAG, "Don't have permission to check connectivity, will assume we are online");
        }
        return isOnline;
    }

    private boolean onOfflineMode(OfflineMode offlineMode) {
        boolean onOfflineMode;
        try {
            onOfflineMode = offlineMode != null && offlineMode.isOffline();
        }
        catch (Exception e) {
            onOfflineMode = false;
            MPLog.v(LOGTAG, "Client State should not throw exception, will assume is not on offline mode", e);
        }
        return onOfflineMode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] performRequest(@NonNull String endpointUrl, @Nullable ProxyServerInteractor interactor, @Nullable Map<String, Object> params, @Nullable Map<String, String> headers, @Nullable byte[] requestBodyBytes, @Nullable SSLSocketFactory socketFactory) throws RemoteService.ServiceUnavailableException, IOException {
        MPLog.v(LOGTAG, "Attempting request to " + endpointUrl + (requestBodyBytes == null ? " (URL params)" : " (Raw Body)"));
        byte[] response = null;
        int retries = 0;
        boolean succeeded = false;
        while (retries < 3 && !succeeded) {
            InputStream in = null;
            OutputStream out = null;
            HttpURLConnection connection = null;
            String targetIpAddress = null;
            long startTimeNanos = System.nanoTime();
            long uncompressedBodySize = -1L;
            long compressedBodySize = -1L;
            try {
                void var25_41;
                byte[] bytesToWrite;
                Map<String, String> proxyHeaders;
                String contentType;
                URL url = new URL(endpointUrl);
                try {
                    InetAddress inetAddress = InetAddress.getByName(url.getHost());
                    targetIpAddress = inetAddress.getHostAddress();
                }
                catch (Exception e) {
                    MPLog.v(LOGTAG, "Could not resolve IP address for " + url.getHost(), e);
                    targetIpAddress = "N/A";
                }
                connection = (HttpURLConnection)url.openConnection();
                if (null != socketFactory && connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(socketFactory);
                }
                connection.setConnectTimeout(2000);
                connection.setReadTimeout(30000);
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                String string = contentType = requestBodyBytes != null ? "application/json; charset=utf-8" : "application/x-www-form-urlencoded; charset=utf-8";
                if (headers != null) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        connection.setRequestProperty(entry.getKey(), entry.getValue());
                        if (!entry.getKey().equalsIgnoreCase("Content-Type")) continue;
                        contentType = entry.getValue();
                    }
                }
                connection.setRequestProperty("Content-Type", contentType);
                if (interactor != null && HttpService.isProxyRequest(endpointUrl) && (proxyHeaders = interactor.getProxyRequestHeaders()) != null) {
                    for (Object entry2 : proxyHeaders.entrySet()) {
                        connection.setRequestProperty((String)entry2.getKey(), (String)entry2.getValue());
                    }
                }
                connection.setConnectTimeout(15000);
                connection.setReadTimeout(60000);
                if (requestBodyBytes != null) {
                    bytesToWrite = requestBodyBytes;
                    uncompressedBodySize = bytesToWrite.length;
                    connection.setFixedLengthStreamingMode(uncompressedBodySize);
                    MPLog.v(LOGTAG, "Sending raw body of size: " + uncompressedBodySize);
                } else if (params != null) {
                    Object entry2;
                    Uri.Builder builder = new Uri.Builder();
                    entry2 = params.entrySet().iterator();
                    while (entry2.hasNext()) {
                        Map.Entry entry = (Map.Entry)entry2.next();
                        builder.appendQueryParameter((String)entry.getKey(), entry.getValue().toString());
                    }
                    String query = builder.build().getEncodedQuery();
                    byte[] byArray = Objects.requireNonNull(query).getBytes(StandardCharsets.UTF_8);
                    uncompressedBodySize = byArray.length;
                    MPLog.v(LOGTAG, "Sending URL params (raw size): " + uncompressedBodySize);
                    if (this.shouldGzipRequestPayload) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try (GZIPOutputStream gzipOut = new GZIPOutputStream(baos);){
                            gzipOut.write(byArray);
                        }
                        bytesToWrite = baos.toByteArray();
                        compressedBodySize = bytesToWrite.length;
                        connection.setRequestProperty(CONTENT_ENCODING_HEADER, GZIP_CONTENT_TYPE_HEADER);
                        connection.setFixedLengthStreamingMode(compressedBodySize);
                        MPLog.v(LOGTAG, "Gzipping params, compressed size: " + compressedBodySize);
                    } else {
                        bytesToWrite = byArray;
                        connection.setFixedLengthStreamingMode(uncompressedBodySize);
                    }
                } else {
                    bytesToWrite = new byte[]{};
                    uncompressedBodySize = 0L;
                    connection.setFixedLengthStreamingMode(0);
                    MPLog.v(LOGTAG, "Sending POST request with empty body.");
                }
                out = new BufferedOutputStream(connection.getOutputStream());
                out.write(bytesToWrite);
                out.flush();
                out.close();
                out = null;
                int n = connection.getResponseCode();
                String responseMessage = connection.getResponseMessage();
                MPLog.v(LOGTAG, "Response Code: " + n);
                if (interactor != null && HttpService.isProxyRequest(endpointUrl)) {
                    interactor.onProxyResponse(endpointUrl, n);
                }
                if (n >= 200 && n < 300) {
                    in = connection.getInputStream();
                    response = HttpService.slurp(in);
                    succeeded = true;
                    continue;
                }
                if (n >= 500 && n <= 599) {
                    this.onNetworkError(connection, endpointUrl, targetIpAddress, startTimeNanos, uncompressedBodySize, compressedBodySize, new RemoteService.ServiceUnavailableException("Service Unavailable: " + n, connection.getHeaderField("Retry-After")));
                    throw new RemoteService.ServiceUnavailableException("Service Unavailable: " + n, connection.getHeaderField("Retry-After"));
                }
                MPLog.w(LOGTAG, "HTTP error " + n + " (" + responseMessage + ") for URL: " + endpointUrl);
                Object var25_39 = null;
                try {
                    in = connection.getErrorStream();
                    if (in != null) {
                        byte[] errorBytes = HttpService.slurp(in);
                        String string2 = new String(errorBytes, StandardCharsets.UTF_8);
                        MPLog.w(LOGTAG, "Error Body: " + string2);
                    }
                }
                catch (Exception e) {
                    MPLog.w(LOGTAG, "Could not read error stream.", e);
                }
                this.onNetworkError(connection, endpointUrl, targetIpAddress, startTimeNanos, uncompressedBodySize, compressedBodySize, new IOException("HTTP error response: " + n + " " + responseMessage + (var25_41 != null ? " - Body: " + (String)var25_41 : "")));
                response = null;
                succeeded = true;
            }
            catch (EOFException e) {
                this.onNetworkError(connection, endpointUrl, targetIpAddress, startTimeNanos, uncompressedBodySize, compressedBodySize, e);
                MPLog.d(LOGTAG, "EOFException, likely network issue. Retrying request to " + endpointUrl);
                ++retries;
            }
            catch (IOException e) {
                this.onNetworkError(connection, endpointUrl, targetIpAddress, startTimeNanos, uncompressedBodySize, compressedBodySize, e);
                throw e;
            }
            catch (Exception e) {
                this.onNetworkError(connection, endpointUrl, targetIpAddress, startTimeNanos, uncompressedBodySize, compressedBodySize, e);
                throw new IOException("Unexpected exception during network request", e);
            }
            finally {
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                if (null == connection) continue;
                connection.disconnect();
            }
        }
        if (!succeeded) {
            MPLog.e(LOGTAG, "Could not complete request to " + endpointUrl + " after " + retries + " retries.");
            throw new IOException("Request failed after multiple retries.");
        }
        return response;
    }

    private void onNetworkError(HttpURLConnection connection, String endpointUrl, String targetIpAddress, long startTimeNanos, long uncompressedBodySize, long compressedBodySize, Exception e) {
        if (this.networkErrorListener != null) {
            long endTimeNanos = System.nanoTime();
            long durationNanos = Math.max(0L, endTimeNanos - startTimeNanos);
            long durationMillis = TimeUnit.NANOSECONDS.toMillis(durationNanos);
            int responseCode = -1;
            String responseMessage = "";
            if (connection != null) {
                try {
                    responseCode = connection.getResponseCode();
                    responseMessage = connection.getResponseMessage();
                }
                catch (Exception respExc) {
                    MPLog.w(LOGTAG, "Could not retrieve response code/message after error", respExc);
                }
            }
            String ip = targetIpAddress == null ? "N/A" : targetIpAddress;
            long finalUncompressedSize = Math.max(-1L, uncompressedBodySize);
            long finalCompressedSize = Math.max(-1L, compressedBodySize);
            try {
                this.networkErrorListener.onNetworkError(endpointUrl, ip, durationMillis, finalUncompressedSize, finalCompressedSize, responseCode, responseMessage, e);
            }
            catch (Exception listenerException) {
                MPLog.e(LOGTAG, "Network error listener threw an exception", listenerException);
            }
        }
    }

    private OutputStream getBufferedOutputStream(OutputStream out) throws IOException {
        if (this.shouldGzipRequestPayload) {
            return new GZIPOutputStream((OutputStream)new BufferedOutputStream(out), 8192);
        }
        return new BufferedOutputStream(out);
    }

    private static boolean isProxyRequest(String endpointUrl) {
        return !endpointUrl.toLowerCase().contains("https://api.mixpanel.com".toLowerCase());
    }

    private static byte[] slurp(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

