/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.mixpanel.android.util.MPLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class SystemInformation {
    private final Context mContext;
    private final Boolean mHasNFC;
    private final Boolean mHasTelephony;
    private final DisplayMetrics mDisplayMetrics;
    private final String mAppVersionName;
    private final Integer mAppVersionCode;
    private final String mAppName;
    private static SystemInformation sInstance;
    private static final Object sInstanceLock;
    private static final String LOGTAG = "MixpanelAPI.SysInfo";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SystemInformation getInstance(Context context) {
        Object object = sInstanceLock;
        synchronized (object) {
            if (null == sInstance) {
                Context appContext = context.getApplicationContext();
                sInstance = new SystemInformation(appContext);
            }
        }
        return sInstance;
    }

    private SystemInformation(Context context) {
        this.mContext = context;
        PackageManager packageManager = this.mContext.getPackageManager();
        String foundAppVersionName = null;
        Integer foundAppVersionCode = null;
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
            foundAppVersionName = packageInfo.versionName;
            foundAppVersionCode = packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            MPLog.w(LOGTAG, "System information constructed with a context that apparently doesn't exist.");
        }
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        int appNameStringId = applicationInfo.labelRes;
        this.mAppVersionName = foundAppVersionName;
        this.mAppVersionCode = foundAppVersionCode;
        this.mAppName = appNameStringId == 0 ? (applicationInfo.nonLocalizedLabel == null ? "Misc" : applicationInfo.nonLocalizedLabel.toString()) : context.getString(appNameStringId);
        Class<?> packageManagerClass = packageManager.getClass();
        Method hasSystemFeatureMethod = null;
        try {
            hasSystemFeatureMethod = packageManagerClass.getMethod("hasSystemFeature", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Boolean foundNFC = null;
        Boolean foundTelephony = null;
        if (null != hasSystemFeatureMethod) {
            try {
                foundNFC = (Boolean)hasSystemFeatureMethod.invoke((Object)packageManager, "android.hardware.nfc");
                foundTelephony = (Boolean)hasSystemFeatureMethod.invoke((Object)packageManager, "android.hardware.telephony");
            }
            catch (InvocationTargetException e) {
                MPLog.w(LOGTAG, "System version appeared to support PackageManager.hasSystemFeature, but we were unable to call it.");
            }
            catch (IllegalAccessException e) {
                MPLog.w(LOGTAG, "System version appeared to support PackageManager.hasSystemFeature, but we were unable to call it.");
            }
        }
        this.mHasNFC = foundNFC;
        this.mHasTelephony = foundTelephony;
        this.mDisplayMetrics = new DisplayMetrics();
        Display display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay();
        display.getMetrics(this.mDisplayMetrics);
    }

    public String getAppVersionName() {
        return this.mAppVersionName;
    }

    public Integer getAppVersionCode() {
        return this.mAppVersionCode;
    }

    public String getAppName() {
        return this.mAppName;
    }

    public boolean hasNFC() {
        return this.mHasNFC;
    }

    public boolean hasTelephony() {
        return this.mHasTelephony;
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.mDisplayMetrics;
    }

    public String getCurrentNetworkOperator() {
        String ret = null;
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        if (null != telephonyManager) {
            ret = telephonyManager.getNetworkOperatorName();
        }
        return ret;
    }

    @SuppressLint(value={"MissingPermission"})
    public Boolean isWifiConnected() {
        Boolean ret = null;
        if (0 == this.mContext.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE")) {
            ConnectivityManager connManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
            ret = networkInfo != null && networkInfo.getType() == 1 && networkInfo.isConnected();
        }
        return ret;
    }

    @SuppressLint(value={"MissingPermission"})
    public Boolean isBluetoothEnabled() {
        Boolean isBluetoothEnabled = null;
        try {
            BluetoothAdapter bluetoothAdapter;
            PackageManager pm = this.mContext.getPackageManager();
            int hasBluetoothPermission = pm.checkPermission("android.permission.BLUETOOTH", this.mContext.getPackageName());
            if (hasBluetoothPermission == 0 && (bluetoothAdapter = BluetoothAdapter.getDefaultAdapter()) != null) {
                isBluetoothEnabled = bluetoothAdapter.isEnabled();
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return isBluetoothEnabled;
    }

    public String getBluetoothVersion() {
        String bluetoothVersion = "none";
        if (Build.VERSION.SDK_INT >= 18 && this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            bluetoothVersion = "ble";
        } else if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
            bluetoothVersion = "classic";
        }
        return bluetoothVersion;
    }

    static {
        sInstanceLock = new Object();
    }
}

