/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.JsonWriter;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.OnMixpanelTweaksUpdatedListener;
import com.mixpanel.android.mpmetrics.ResourceIds;
import com.mixpanel.android.mpmetrics.ResourceReader;
import com.mixpanel.android.mpmetrics.SuperPropertyUpdate;
import com.mixpanel.android.mpmetrics.Tweaks;
import com.mixpanel.android.util.ImageStore;
import com.mixpanel.android.util.JSONUtils;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.MPPair;
import com.mixpanel.android.viewcrawler.DynamicEventTracker;
import com.mixpanel.android.viewcrawler.EditProtocol;
import com.mixpanel.android.viewcrawler.EditState;
import com.mixpanel.android.viewcrawler.EditorConnection;
import com.mixpanel.android.viewcrawler.FlipGesture;
import com.mixpanel.android.viewcrawler.TrackingDebug;
import com.mixpanel.android.viewcrawler.UpdatesFromMixpanel;
import com.mixpanel.android.viewcrawler.ViewSnapshot;
import com.mixpanel.android.viewcrawler.ViewVisitor;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=16)
public class ViewCrawler
implements UpdatesFromMixpanel,
TrackingDebug,
ViewVisitor.OnLayoutErrorListener {
    private final MPConfig mConfig;
    private final Context mContext;
    private final MixpanelAPI mMixpanel;
    private final DynamicEventTracker mDynamicEventTracker;
    private final EditState mEditState;
    private final Tweaks mTweaks;
    private final Map<String, String> mDeviceInfo;
    private final ViewCrawlerHandler mMessageThreadHandler;
    private final float mScaledDensity;
    private final Set<OnMixpanelTweaksUpdatedListener> mTweaksUpdatedListeners;
    private static final String SHARED_PREF_EDITS_FILE = "mixpanel.viewcrawler.changes";
    private static final String SHARED_PREF_CHANGES_KEY = "mixpanel.viewcrawler.changes";
    private static final String SHARED_PREF_BINDINGS_KEY = "mixpanel.viewcrawler.bindings";
    private static final int MESSAGE_INITIALIZE_CHANGES = 0;
    private static final int MESSAGE_CONNECT_TO_EDITOR = 1;
    private static final int MESSAGE_SEND_STATE_FOR_EDITING = 2;
    private static final int MESSAGE_HANDLE_EDITOR_CHANGES_RECEIVED = 3;
    private static final int MESSAGE_SEND_DEVICE_INFO = 4;
    private static final int MESSAGE_EVENT_BINDINGS_RECEIVED = 5;
    private static final int MESSAGE_HANDLE_EDITOR_BINDINGS_RECEIVED = 6;
    private static final int MESSAGE_SEND_EVENT_TRACKED = 7;
    private static final int MESSAGE_HANDLE_EDITOR_CLOSED = 8;
    private static final int MESSAGE_VARIANTS_RECEIVED = 9;
    private static final int MESSAGE_HANDLE_EDITOR_CHANGES_CLEARED = 10;
    private static final int MESSAGE_HANDLE_EDITOR_TWEAKS_RECEIVED = 11;
    private static final int MESSAGE_SEND_LAYOUT_ERROR = 12;
    private static final int MESSAGE_PERSIST_VARIANTS_RECEIVED = 13;
    private static final int EMULATOR_CONNECT_ATTEMPT_INTERVAL_MILLIS = 30000;
    private static final String LOGTAG = "MixpanelAPI.ViewCrawler";
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public ViewCrawler(Context context, String string, MixpanelAPI mixpanelAPI, Tweaks tweaks) {
        void app;
        void token;
        void thread;
        void mixpanel;
        void tweaks2;
        void context2;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        blArray[0] = true;
        this.mConfig = MPConfig.getInstance((Context)context2);
        this.mContext = context2;
        blArray[1] = true;
        this.mEditState = new EditState();
        this.mTweaks = tweaks2;
        blArray[2] = true;
        this.mDeviceInfo = mixpanel.getDeviceInfo();
        blArray[3] = true;
        this.mScaledDensity = Resources.getSystem().getDisplayMetrics().scaledDensity;
        blArray[4] = true;
        this.mTweaksUpdatedListeners = Collections.newSetFromMap(new ConcurrentHashMap());
        blArray[5] = true;
        HandlerThread handlerThread = new HandlerThread(ViewCrawler.class.getCanonicalName());
        blArray[6] = true;
        thread.setPriority(10);
        blArray[7] = true;
        thread.start();
        blArray[8] = true;
        this.mMessageThreadHandler = new ViewCrawlerHandler(this, (Context)context2, (String)token, thread.getLooper(), this);
        blArray[9] = true;
        this.mDynamicEventTracker = new DynamicEventTracker((MixpanelAPI)mixpanel, this.mMessageThreadHandler);
        this.mMixpanel = mixpanel;
        blArray[10] = true;
        Application application = (Application)context2.getApplicationContext();
        blArray[11] = true;
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new LifecycleCallbacks(this));
        blArray[12] = true;
        this.mTweaks.addOnTweakDeclaredListener(new Tweaks.OnTweakDeclaredListener(this){
            final /* synthetic */ ViewCrawler this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 1.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onTweakDeclared() {
                void msg;
                boolean[] blArray = 1.$jacocoInit();
                Message message = ViewCrawler.access$000(this.this$0).obtainMessage(4);
                blArray[1] = true;
                ViewCrawler.access$000(this.this$0).sendMessage((Message)msg);
                blArray[2] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-7325495113904708283L, (String)"com/mixpanel/android/viewcrawler/ViewCrawler$1", (int)3);
                }
                return blArray;
            }
        });
        blArray[13] = true;
    }

    @Override
    public void startUpdates() {
        boolean[] blArray = ViewCrawler.$jacocoInit();
        this.mMessageThreadHandler.start();
        blArray[14] = true;
        this.applyPersistedUpdates();
        blArray[15] = true;
    }

    @Override
    public void applyPersistedUpdates() {
        boolean[] blArray = ViewCrawler.$jacocoInit();
        this.mMessageThreadHandler.sendMessage(this.mMessageThreadHandler.obtainMessage(0));
        blArray[16] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void storeVariants(JSONArray jSONArray) {
        void variants;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        if (variants == null) {
            blArray[17] = true;
        } else {
            blArray[18] = true;
            Message msg = this.mMessageThreadHandler.obtainMessage(13);
            msg.obj = variants;
            blArray[19] = true;
            this.mMessageThreadHandler.sendMessage(msg);
            blArray[20] = true;
        }
        blArray[21] = true;
    }

    @Override
    public Tweaks getTweaks() {
        boolean[] blArray = ViewCrawler.$jacocoInit();
        blArray[22] = true;
        return this.mTweaks;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setEventBindings(JSONArray jSONArray) {
        void bindings;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        if (bindings == null) {
            blArray[23] = true;
        } else {
            blArray[24] = true;
            Message msg = this.mMessageThreadHandler.obtainMessage(5);
            msg.obj = bindings;
            blArray[25] = true;
            this.mMessageThreadHandler.sendMessage(msg);
            blArray[26] = true;
        }
        blArray[27] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setVariants(JSONArray jSONArray) {
        void variants;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        if (variants == null) {
            blArray[28] = true;
        } else {
            blArray[29] = true;
            Message msg = this.mMessageThreadHandler.obtainMessage(9);
            msg.obj = variants;
            blArray[30] = true;
            this.mMessageThreadHandler.sendMessage(msg);
            blArray[31] = true;
        }
        blArray[32] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addOnMixpanelTweaksUpdatedListener(OnMixpanelTweaksUpdatedListener onMixpanelTweaksUpdatedListener) {
        void listener;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        if (null == listener) {
            blArray[33] = true;
            blArray[34] = true;
            throw new NullPointerException("Listener cannot be null");
        }
        this.mTweaksUpdatedListeners.add((OnMixpanelTweaksUpdatedListener)listener);
        blArray[35] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeOnMixpanelTweaksUpdatedListener(OnMixpanelTweaksUpdatedListener onMixpanelTweaksUpdatedListener) {
        void listener;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        this.mTweaksUpdatedListeners.remove(listener);
        blArray[36] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportTrack(String string) {
        void eventName;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        Message m = this.mMessageThreadHandler.obtainMessage();
        m.what = 7;
        m.obj = eventName;
        blArray[37] = true;
        this.mMessageThreadHandler.sendMessage(m);
        blArray[38] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onLayoutError(ViewVisitor.LayoutErrorMessage layoutErrorMessage) {
        void e;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        Message m = this.mMessageThreadHandler.obtainMessage();
        m.what = 12;
        m.obj = e;
        blArray[39] = true;
        this.mMessageThreadHandler.sendMessage(m);
        blArray[40] = true;
    }

    static /* synthetic */ ViewCrawlerHandler access$000(ViewCrawler viewCrawler) {
        ViewCrawler x0;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        blArray[41] = true;
        return x0.mMessageThreadHandler;
    }

    static /* synthetic */ MixpanelAPI access$100(ViewCrawler viewCrawler) {
        ViewCrawler x0;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        blArray[42] = true;
        return x0.mMixpanel;
    }

    static /* synthetic */ EditState access$200(ViewCrawler viewCrawler) {
        ViewCrawler x0;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        blArray[43] = true;
        return x0.mEditState;
    }

    static /* synthetic */ MPConfig access$300(ViewCrawler viewCrawler) {
        ViewCrawler x0;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        blArray[44] = true;
        return x0.mConfig;
    }

    static /* synthetic */ Context access$400(ViewCrawler viewCrawler) {
        ViewCrawler x0;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        blArray[45] = true;
        return x0.mContext;
    }

    static /* synthetic */ float access$600(ViewCrawler viewCrawler) {
        ViewCrawler x0;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        blArray[46] = true;
        return x0.mScaledDensity;
    }

    static /* synthetic */ Map access$700(ViewCrawler viewCrawler) {
        ViewCrawler x0;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        blArray[47] = true;
        return x0.mDeviceInfo;
    }

    static /* synthetic */ Tweaks access$800(ViewCrawler viewCrawler) {
        ViewCrawler x0;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        blArray[48] = true;
        return x0.mTweaks;
    }

    static /* synthetic */ DynamicEventTracker access$900(ViewCrawler viewCrawler) {
        ViewCrawler x0;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        blArray[49] = true;
        return x0.mDynamicEventTracker;
    }

    static /* synthetic */ Set access$1000(ViewCrawler viewCrawler) {
        ViewCrawler x0;
        boolean[] blArray = ViewCrawler.$jacocoInit();
        blArray[50] = true;
        return x0.mTweaksUpdatedListeners;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-5940190054797633795L, (String)"com/mixpanel/android/viewcrawler/ViewCrawler", (int)51);
        }
        return blArray;
    }

    private static class VariantTweak {
        public final String tweakName;
        public final JSONObject tweak;
        public final MPPair<Integer, Integer> variantId;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public VariantTweak(String string, JSONObject jSONObject, MPPair<Integer, Integer> mPPair) {
            void aVariantId;
            void aTweak;
            void aTweakName;
            boolean[] blArray = VariantTweak.$jacocoInit();
            this.tweakName = aTweakName;
            this.tweak = aTweak;
            this.variantId = aVariantId;
            blArray[0] = true;
        }

        public int hashCode() {
            boolean[] blArray = VariantTweak.$jacocoInit();
            blArray[1] = true;
            return this.tweakName.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object object) {
            void obj;
            boolean[] blArray = VariantTweak.$jacocoInit();
            if (obj instanceof VariantTweak) {
                boolean bl;
                blArray[2] = true;
                if (obj.hashCode() == this.hashCode()) {
                    bl = blArray[3] = true;
                } else {
                    bl = false;
                    blArray[4] = true;
                }
                blArray[5] = true;
                return bl;
            }
            blArray[6] = true;
            return false;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-1093865149130817216L, (String)"com/mixpanel/android/viewcrawler/ViewCrawler$VariantTweak", (int)7);
            }
            return blArray;
        }
    }

    private static class VariantChange {
        public final String name;
        public final String activityName;
        public final JSONObject change;
        public final MPPair<Integer, Integer> variantId;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public VariantChange(String string, String string2, JSONObject jSONObject, MPPair<Integer, Integer> mPPair) {
            void aVariantId;
            void someChange;
            void anActivityName;
            void aName;
            boolean[] blArray = VariantChange.$jacocoInit();
            this.name = aName;
            this.activityName = anActivityName;
            this.change = someChange;
            this.variantId = aVariantId;
            blArray[0] = true;
        }

        public int hashCode() {
            boolean[] blArray = VariantChange.$jacocoInit();
            blArray[1] = true;
            return this.name.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object object) {
            void obj;
            boolean[] blArray = VariantChange.$jacocoInit();
            if (obj instanceof VariantChange) {
                boolean bl;
                blArray[2] = true;
                if (obj.hashCode() == this.hashCode()) {
                    bl = blArray[3] = true;
                } else {
                    bl = false;
                    blArray[4] = true;
                }
                blArray[5] = true;
                return bl;
            }
            blArray[6] = true;
            return false;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)4185034142281509763L, (String)"com/mixpanel/android/viewcrawler/ViewCrawler$VariantChange", (int)7);
            }
            return blArray;
        }
    }

    private class Editor
    implements EditorConnection.Editor {
        final /* synthetic */ ViewCrawler this$0;
        private static transient /* synthetic */ boolean[] $jacocoData;

        private Editor(ViewCrawler viewCrawler) {
            boolean[] blArray = Editor.$jacocoInit();
            this.this$0 = viewCrawler;
            blArray[0] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void sendSnapshot(JSONObject jSONObject) {
            void message;
            boolean[] blArray = Editor.$jacocoInit();
            Message msg = ViewCrawler.access$000(this.this$0).obtainMessage(2);
            msg.obj = message;
            blArray[1] = true;
            ViewCrawler.access$000(this.this$0).sendMessage(msg);
            blArray[2] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void performEdit(JSONObject jSONObject) {
            void message;
            boolean[] blArray = Editor.$jacocoInit();
            Message msg = ViewCrawler.access$000(this.this$0).obtainMessage(3);
            msg.obj = message;
            blArray[3] = true;
            ViewCrawler.access$000(this.this$0).sendMessage(msg);
            blArray[4] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void clearEdits(JSONObject jSONObject) {
            void message;
            boolean[] blArray = Editor.$jacocoInit();
            Message msg = ViewCrawler.access$000(this.this$0).obtainMessage(10);
            msg.obj = message;
            blArray[5] = true;
            ViewCrawler.access$000(this.this$0).sendMessage(msg);
            blArray[6] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setTweaks(JSONObject jSONObject) {
            void message;
            boolean[] blArray = Editor.$jacocoInit();
            Message msg = ViewCrawler.access$000(this.this$0).obtainMessage(11);
            msg.obj = message;
            blArray[7] = true;
            ViewCrawler.access$000(this.this$0).sendMessage(msg);
            blArray[8] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void bindEvents(JSONObject jSONObject) {
            void message;
            boolean[] blArray = Editor.$jacocoInit();
            Message msg = ViewCrawler.access$000(this.this$0).obtainMessage(6);
            msg.obj = message;
            blArray[9] = true;
            ViewCrawler.access$000(this.this$0).sendMessage(msg);
            blArray[10] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void sendDeviceInfo() {
            void msg;
            boolean[] blArray = Editor.$jacocoInit();
            Message message = ViewCrawler.access$000(this.this$0).obtainMessage(4);
            blArray[11] = true;
            ViewCrawler.access$000(this.this$0).sendMessage((Message)msg);
            blArray[12] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void cleanup() {
            void msg;
            boolean[] blArray = Editor.$jacocoInit();
            Message message = ViewCrawler.access$000(this.this$0).obtainMessage(8);
            blArray[13] = true;
            ViewCrawler.access$000(this.this$0).sendMessage((Message)msg);
            blArray[14] = true;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Editor(ViewCrawler viewCrawler, 1 var2_2) {
            void x0;
            boolean[] blArray = Editor.$jacocoInit();
            this((ViewCrawler)x0);
            blArray[15] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-2356240615631651778L, (String)"com/mixpanel/android/viewcrawler/ViewCrawler$Editor", (int)16);
            }
            return blArray;
        }
    }

    private class ViewCrawlerHandler
    extends Handler {
        private EditorConnection mEditorConnection;
        private ViewSnapshot mSnapshot;
        private final String mToken;
        private final Lock mStartLock;
        private final EditProtocol mProtocol;
        private final ImageStore mImageStore;
        private final Map<String, MPPair<String, JSONObject>> mEditorChanges;
        private final Map<String, MPPair<String, Object>> mEditorTweaks;
        private final List<String> mEditorAssetUrls;
        private final Map<String, MPPair<String, JSONObject>> mEditorEventBindings;
        private final Set<VariantChange> mAppliedVisualChanges;
        private final Set<VariantTweak> mAppliedTweaks;
        private final Set<MPPair<Integer, Integer>> mEmptyExperiments;
        private final Set<MPPair<String, JSONObject>> mPersistentEventBindings;
        private final Set<MPPair<String, JSONObject>> mOriginalEventBindings;
        private final Set<MPPair<Integer, Integer>> mSeenExperiments;
        final /* synthetic */ ViewCrawler this$0;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public ViewCrawlerHandler(ViewCrawler viewCrawler, Context context, String string, Looper looper, ViewVisitor.OnLayoutErrorListener onLayoutErrorListener) {
            void layoutErrorListener;
            void resourceIds;
            void context2;
            void token;
            void looper2;
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            this.this$0 = viewCrawler;
            blArray[0] = true;
            super((Looper)looper2);
            this.mToken = token;
            this.mSnapshot = null;
            blArray[1] = true;
            String resourcePackage = ViewCrawler.access$300(viewCrawler).getResourcePackageName();
            if (null != resourcePackage) {
                blArray[2] = true;
            } else {
                blArray[3] = true;
                resourcePackage = context2.getPackageName();
                blArray[4] = true;
            }
            ResourceReader.Ids ids = new ResourceReader.Ids(resourcePackage, (Context)context2);
            blArray[5] = true;
            this.mImageStore = new ImageStore((Context)context2, "ViewCrawler");
            blArray[6] = true;
            this.mProtocol = new EditProtocol((Context)context2, (ResourceIds)resourceIds, this.mImageStore, (ViewVisitor.OnLayoutErrorListener)layoutErrorListener);
            blArray[7] = true;
            this.mOriginalEventBindings = new HashSet<MPPair<String, JSONObject>>();
            blArray[8] = true;
            this.mEditorChanges = new HashMap<String, MPPair<String, JSONObject>>();
            blArray[9] = true;
            this.mEditorTweaks = new HashMap<String, MPPair<String, Object>>();
            blArray[10] = true;
            this.mEditorAssetUrls = new ArrayList<String>();
            blArray[11] = true;
            this.mEditorEventBindings = new HashMap<String, MPPair<String, JSONObject>>();
            blArray[12] = true;
            this.mAppliedVisualChanges = new HashSet<VariantChange>();
            blArray[13] = true;
            this.mAppliedTweaks = new HashSet<VariantTweak>();
            blArray[14] = true;
            this.mEmptyExperiments = new HashSet<MPPair<Integer, Integer>>();
            blArray[15] = true;
            this.mPersistentEventBindings = new HashSet<MPPair<String, JSONObject>>();
            blArray[16] = true;
            this.mSeenExperiments = new HashSet<MPPair<Integer, Integer>>();
            blArray[17] = true;
            this.mStartLock = new ReentrantLock();
            blArray[18] = true;
            this.mStartLock.lock();
            blArray[19] = true;
        }

        public void start() {
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            this.mStartLock.unlock();
            blArray[20] = true;
        }

        /*
         * WARNING - void declaration
         */
        public void handleMessage(Message message) {
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            this.mStartLock.lock();
            try {
                void msg;
                blArray[21] = true;
                int what = msg.what;
                switch (what) {
                    default: {
                        blArray[22] = true;
                        break;
                    }
                    case 0: {
                        this.loadKnownChanges();
                        blArray[23] = true;
                        break;
                    }
                    case 1: {
                        this.connectToEditor();
                        blArray[24] = true;
                        break;
                    }
                    case 4: {
                        this.sendDeviceInfo();
                        blArray[25] = true;
                        break;
                    }
                    case 2: {
                        this.sendSnapshot((JSONObject)msg.obj);
                        blArray[26] = true;
                        break;
                    }
                    case 7: {
                        this.sendReportTrackToEditor((String)msg.obj);
                        blArray[27] = true;
                        break;
                    }
                    case 12: {
                        this.sendLayoutError((ViewVisitor.LayoutErrorMessage)msg.obj);
                        blArray[28] = true;
                        break;
                    }
                    case 9: {
                        this.handleVariantsReceived((JSONArray)msg.obj);
                        blArray[29] = true;
                        break;
                    }
                    case 3: {
                        this.handleEditorChangeReceived((JSONObject)msg.obj);
                        blArray[30] = true;
                        break;
                    }
                    case 5: {
                        this.handleEventBindingsReceived((JSONArray)msg.obj);
                        blArray[31] = true;
                        break;
                    }
                    case 6: {
                        this.handleEditorBindingsReceived((JSONObject)msg.obj);
                        blArray[32] = true;
                        break;
                    }
                    case 10: {
                        this.handleEditorBindingsCleared((JSONObject)msg.obj);
                        blArray[33] = true;
                        break;
                    }
                    case 11: {
                        this.handleEditorTweaksReceived((JSONObject)msg.obj);
                        blArray[34] = true;
                        break;
                    }
                    case 8: {
                        this.handleEditorClosed();
                        blArray[35] = true;
                        break;
                    }
                    case 13: {
                        this.persistVariants((JSONArray)msg.obj);
                        blArray[36] = true;
                    }
                }
                this.mStartLock.unlock();
            }
            catch (Throwable throwable) {
                this.mStartLock.unlock();
                blArray[37] = true;
                throw throwable;
            }
            blArray[38] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void loadKnownChanges() {
            void storedBindings;
            void storedChanges;
            void preferences;
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            SharedPreferences sharedPreferences = this.getSharedPreferences();
            blArray[39] = true;
            String string = preferences.getString("mixpanel.viewcrawler.changes", null);
            blArray[40] = true;
            String string2 = preferences.getString(ViewCrawler.SHARED_PREF_BINDINGS_KEY, null);
            blArray[41] = true;
            this.mAppliedVisualChanges.clear();
            blArray[42] = true;
            this.mAppliedTweaks.clear();
            blArray[43] = true;
            this.mSeenExperiments.clear();
            blArray[44] = true;
            this.loadVariants((String)storedChanges, false);
            blArray[45] = true;
            this.mPersistentEventBindings.clear();
            blArray[46] = true;
            this.loadEventBindings((String)storedBindings);
            blArray[47] = true;
            this.applyVariantsAndEventBindings();
            blArray[48] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void persistVariants(JSONArray jSONArray) {
            void variants;
            void editor;
            void preferences;
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            SharedPreferences sharedPreferences = this.getSharedPreferences();
            blArray[49] = true;
            SharedPreferences.Editor editor2 = preferences.edit();
            blArray[50] = true;
            editor.putString("mixpanel.viewcrawler.changes", variants.toString());
            blArray[51] = true;
            editor.apply();
            blArray[52] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void loadVariants(String string, boolean bl) {
            void variants;
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            if (null == variants) {
                blArray[53] = true;
            } else {
                try {
                    void variantIx;
                    void variantsJson;
                    blArray[54] = true;
                    JSONArray jSONArray = new JSONArray((String)variants);
                    blArray[55] = true;
                    int variantsLength = variantsJson.length();
                    boolean bl2 = false;
                    blArray[56] = true;
                    while (variantIx < variantsLength) {
                        void newVariants;
                        void i;
                        void tweaks;
                        String variantChange;
                        void variantId;
                        JSONObject name;
                        void i22;
                        void actions;
                        void variantIdPart;
                        void experimentIdPart;
                        void nextVariant;
                        blArray[57] = true;
                        JSONObject jSONObject = variantsJson.getJSONObject((int)variantIx);
                        blArray[58] = true;
                        int n = nextVariant.getInt("id");
                        blArray[59] = true;
                        int n2 = nextVariant.getInt("experiment_id");
                        blArray[60] = true;
                        MPPair<Integer, Integer> mPPair = new MPPair<Integer, Integer>((int)experimentIdPart, (int)variantIdPart);
                        blArray[61] = true;
                        JSONArray jSONArray2 = nextVariant.getJSONArray("actions");
                        blArray[62] = true;
                        int actionsLength = actions.length();
                        boolean bl3 = false;
                        blArray[63] = true;
                        while (i22 < actionsLength) {
                            void targetActivity;
                            void change;
                            blArray[64] = true;
                            JSONObject jSONObject2 = actions.getJSONObject((int)i22);
                            blArray[65] = true;
                            String string2 = JSONUtils.optionalStringKey((JSONObject)change, "target_activity");
                            blArray[66] = true;
                            String string3 = change.getString("name");
                            blArray[67] = true;
                            VariantChange variantChange2 = new VariantChange((String)name, (String)targetActivity, (JSONObject)change, (MPPair<Integer, Integer>)variantId);
                            blArray[68] = true;
                            this.mAppliedVisualChanges.add((VariantChange)((Object)variantChange));
                            ++i22;
                            blArray[69] = true;
                        }
                        JSONArray i22 = nextVariant.getJSONArray("tweaks");
                        blArray[70] = true;
                        int tweaksLength = tweaks.length();
                        boolean targetActivity = false;
                        blArray[71] = true;
                        while (i < tweaksLength) {
                            void variantTweak;
                            void tweakName;
                            void tweakDesc;
                            blArray[72] = true;
                            name = tweaks.getJSONObject((int)i);
                            blArray[73] = true;
                            variantChange = tweakDesc.getString("name");
                            blArray[74] = true;
                            VariantTweak variantTweak2 = new VariantTweak((String)tweakName, (JSONObject)tweakDesc, (MPPair<Integer, Integer>)variantId);
                            blArray[75] = true;
                            this.mAppliedTweaks.add((VariantTweak)variantTweak);
                            ++i;
                            blArray[76] = true;
                        }
                        if (newVariants != false) {
                            blArray[77] = true;
                        } else {
                            blArray[78] = true;
                            this.mSeenExperiments.add((MPPair<Integer, Integer>)variantId);
                            blArray[79] = true;
                        }
                        if (tweaksLength != 0) {
                            blArray[80] = true;
                        } else if (actionsLength != 0) {
                            blArray[81] = true;
                        } else {
                            blArray[82] = true;
                            this.mEmptyExperiments.add((MPPair<Integer, Integer>)variantId);
                            blArray[83] = true;
                        }
                        ++variantIx;
                        blArray[84] = true;
                    }
                    blArray[85] = true;
                }
                catch (JSONException variantsJson) {
                    void editor;
                    void preferences;
                    void e;
                    blArray[86] = true;
                    MPLog.i(ViewCrawler.LOGTAG, "JSON error when loading ab tests / tweaks, clearing persistent memory", (Throwable)e);
                    blArray[87] = true;
                    SharedPreferences variantsLength = this.getSharedPreferences();
                    blArray[88] = true;
                    SharedPreferences.Editor variantIx = preferences.edit();
                    blArray[89] = true;
                    editor.remove("mixpanel.viewcrawler.changes");
                    blArray[90] = true;
                    editor.apply();
                    blArray[91] = true;
                }
            }
            blArray[92] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void loadEventBindings(String string) {
            void eventBindings;
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            if (null == eventBindings) {
                blArray[93] = true;
            } else {
                try {
                    void bindings;
                    void i;
                    blArray[94] = true;
                    JSONArray jSONArray = new JSONArray((String)eventBindings);
                    blArray[95] = true;
                    this.mPersistentEventBindings.clear();
                    blArray[96] = true;
                    boolean bl = false;
                    blArray[97] = true;
                    while (i < bindings.length()) {
                        void targetActivity;
                        void event;
                        blArray[98] = true;
                        JSONObject jSONObject = bindings.getJSONObject((int)i);
                        blArray[99] = true;
                        String string2 = JSONUtils.optionalStringKey((JSONObject)event, "target_activity");
                        blArray[100] = true;
                        this.mPersistentEventBindings.add(new MPPair<void, void>(targetActivity, event));
                        ++i;
                        blArray[101] = true;
                    }
                    blArray[102] = true;
                }
                catch (JSONException bindings) {
                    void editor;
                    void preferences;
                    void e;
                    blArray[103] = true;
                    MPLog.i(ViewCrawler.LOGTAG, "JSON error when loading event bindings, clearing persistent memory", (Throwable)e);
                    blArray[104] = true;
                    SharedPreferences i = this.getSharedPreferences();
                    blArray[105] = true;
                    SharedPreferences.Editor event = preferences.edit();
                    blArray[106] = true;
                    editor.remove(ViewCrawler.SHARED_PREF_BINDINGS_KEY);
                    blArray[107] = true;
                    editor.apply();
                    blArray[108] = true;
                }
            }
            blArray[109] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void connectToEditor() {
            void url;
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            MPLog.v(ViewCrawler.LOGTAG, "connecting to editor");
            blArray[110] = true;
            if (this.mEditorConnection == null) {
                blArray[111] = true;
            } else if (!this.mEditorConnection.isValid()) {
                blArray[112] = true;
            } else {
                blArray[113] = true;
                MPLog.v(ViewCrawler.LOGTAG, "There is already a valid connection to an events editor.");
                blArray[114] = true;
                return;
            }
            SSLSocketFactory socketFactory = ViewCrawler.access$300(this.this$0).getSSLSocketFactory();
            if (null == socketFactory) {
                blArray[115] = true;
                MPLog.v(ViewCrawler.LOGTAG, "SSL is not available on this device, no connection will be attempted to the events editor.");
                blArray[116] = true;
                return;
            }
            String string = MPConfig.getInstance(ViewCrawler.access$400(this.this$0)).getEditorUrl() + this.mToken;
            try {
                void sslSocket;
                blArray[117] = true;
                Socket socket = socketFactory.createSocket();
                blArray[118] = true;
                this.mEditorConnection = new EditorConnection(new URI((String)url), new Editor(this.this$0, null), (Socket)sslSocket);
                blArray[119] = true;
            }
            catch (URISyntaxException sslSocket) {
                void e;
                blArray[120] = true;
                MPLog.e(ViewCrawler.LOGTAG, "Error parsing URI " + (String)url + " for editor websocket", (Throwable)e);
                blArray[121] = true;
            }
            catch (EditorConnection.EditorConnectionException e) {
                blArray[122] = true;
                MPLog.e(ViewCrawler.LOGTAG, "Error connecting to URI " + (String)url, e);
                blArray[123] = true;
            }
            catch (IOException e) {
                blArray[124] = true;
                MPLog.i(ViewCrawler.LOGTAG, "Can't create SSL Socket to connect to editor service", e);
                blArray[125] = true;
            }
            blArray[126] = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendError(String string) {
            void writer;
            void errorObject;
            block19: {
                block17: {
                    block18: {
                        block16: {
                            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
                            if (this.mEditorConnection != null) break block16;
                            blArray[127] = true;
                            break block17;
                        }
                        if (this.mEditorConnection.isValid()) break block18;
                        blArray[128] = true;
                        break block17;
                    }
                    if (this.mEditorConnection.isConnected()) break block19;
                    blArray[129] = true;
                }
                blArray[130] = true;
                return;
            }
            JSONObject jSONObject = new JSONObject();
            try {
                void errorMessage;
                blArray[131] = true;
                errorObject.put("error_message", (Object)errorMessage);
                blArray[132] = true;
            }
            catch (JSONException jSONException) {
                void e;
                blArray[133] = true;
                MPLog.e(ViewCrawler.LOGTAG, "Apparently impossible JSONException", (Throwable)e);
                blArray[134] = true;
            }
            OutputStreamWriter e = new OutputStreamWriter(this.mEditorConnection.getBufferedOutputStream());
            try {
                blArray[135] = true;
                writer.write("{\"type\": \"error\", ");
                blArray[136] = true;
                writer.write("\"payload\": ");
                blArray[137] = true;
                writer.write(errorObject.toString());
                blArray[138] = true;
                writer.write("}");
                try {
                    blArray[139] = true;
                    writer.close();
                    blArray[140] = true;
                }
                catch (IOException iOException) {
                    void e2;
                    blArray[141] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Could not close output writer to editor", (Throwable)e2);
                    blArray[142] = true;
                }
            }
            catch (IOException e2) {
                try {
                    void e5332;
                    blArray[143] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Can't write error message to editor", (Throwable)e5332);
                    try {
                        blArray[144] = true;
                        writer.close();
                        blArray[145] = true;
                    }
                    catch (IOException e5332) {
                        void e3;
                        blArray[146] = true;
                        MPLog.e(ViewCrawler.LOGTAG, "Could not close output writer to editor", (Throwable)e3);
                        blArray[147] = true;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        blArray[148] = true;
                        writer.close();
                        blArray[149] = true;
                    }
                    catch (IOException iOException) {
                        void e4;
                        blArray[150] = true;
                        MPLog.e(ViewCrawler.LOGTAG, "Could not close output writer to editor", (Throwable)e4);
                        blArray[151] = true;
                    }
                    blArray[152] = true;
                    throw throwable;
                }
            }
            blArray[153] = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendDeviceInfo() {
            void j;
            void out;
            block25: {
                block23: {
                    block24: {
                        block22: {
                            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
                            if (this.mEditorConnection != null) break block22;
                            blArray[154] = true;
                            break block23;
                        }
                        if (this.mEditorConnection.isValid()) break block24;
                        blArray[155] = true;
                        break block23;
                    }
                    if (this.mEditorConnection.isConnected()) break block25;
                    blArray[156] = true;
                }
                blArray[157] = true;
                return;
            }
            BufferedOutputStream bufferedOutputStream = this.mEditorConnection.getBufferedOutputStream();
            blArray[158] = true;
            JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)out));
            try {
                void tweakDescs23332;
                Object object;
                blArray[159] = true;
                j.beginObject();
                blArray[160] = true;
                j.name("type").value("device_info_response");
                blArray[161] = true;
                j.name("payload").beginObject();
                blArray[162] = true;
                j.name("device_type").value("Android");
                blArray[163] = true;
                j.name("device_name").value(Build.BRAND + "/" + Build.MODEL);
                blArray[164] = true;
                j.name("scaled_density").value((double)ViewCrawler.access$600(this.this$0));
                blArray[165] = true;
                Object object2 = ViewCrawler.access$700(this.this$0).entrySet().iterator();
                blArray[166] = true;
                while (object2.hasNext()) {
                    void entry;
                    object = object2.next();
                    blArray[167] = true;
                    j.name((String)entry.getKey()).value((String)entry.getValue());
                    blArray[168] = true;
                }
                object2 = ViewCrawler.access$800(this.this$0).getAllValues();
                blArray[169] = true;
                j.name("tweaks").beginArray();
                blArray[170] = true;
                object = tweakDescs23332.entrySet().iterator();
                blArray[171] = true;
                while (object.hasNext()) {
                    void desc;
                    void tweakName;
                    void tweak;
                    Map.Entry entry = (Map.Entry)object.next();
                    blArray[172] = true;
                    Tweaks.TweakValue tweakValue = (Tweaks.TweakValue)tweak.getValue();
                    blArray[173] = true;
                    String string = (String)tweak.getKey();
                    blArray[174] = true;
                    j.beginObject();
                    blArray[175] = true;
                    j.name("name").value((String)tweakName);
                    blArray[176] = true;
                    j.name("minimum").value(desc.getMinimum());
                    blArray[177] = true;
                    j.name("maximum").value(desc.getMaximum());
                    switch (desc.type) {
                        case 1: {
                            j.name("type").value("boolean");
                            blArray[178] = true;
                            j.name("value").value(desc.getBooleanValue().booleanValue());
                            blArray[179] = true;
                            j.name("default").value(((Boolean)desc.getDefaultValue()).booleanValue());
                            blArray[180] = true;
                            break;
                        }
                        case 2: {
                            j.name("type").value("number");
                            blArray[181] = true;
                            j.name("encoding").value("d");
                            blArray[182] = true;
                            j.name("value").value(desc.getNumberValue().doubleValue());
                            blArray[183] = true;
                            j.name("default").value(((Number)desc.getDefaultValue()).doubleValue());
                            blArray[184] = true;
                            break;
                        }
                        case 3: {
                            j.name("type").value("number");
                            blArray[185] = true;
                            j.name("encoding").value("l");
                            blArray[186] = true;
                            j.name("value").value(desc.getNumberValue().longValue());
                            blArray[187] = true;
                            j.name("default").value(((Number)desc.getDefaultValue()).longValue());
                            blArray[188] = true;
                            break;
                        }
                        case 4: {
                            j.name("type").value("string");
                            blArray[189] = true;
                            j.name("value").value(desc.getStringValue());
                            blArray[190] = true;
                            j.name("default").value((String)desc.getDefaultValue());
                            blArray[191] = true;
                            break;
                        }
                        default: {
                            MPLog.wtf(ViewCrawler.LOGTAG, "Unrecognized Tweak Type " + desc.type + " encountered.");
                            blArray[192] = true;
                        }
                    }
                    j.endObject();
                    blArray[193] = true;
                }
                j.endArray();
                blArray[194] = true;
                j.endObject();
                blArray[195] = true;
                j.endObject();
                try {
                    blArray[196] = true;
                    j.close();
                    blArray[197] = true;
                }
                catch (IOException tweakDescs23332) {
                    void e;
                    blArray[198] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Can't close websocket writer", (Throwable)e);
                    blArray[199] = true;
                }
            }
            catch (IOException e) {
                try {
                    void e4332;
                    blArray[200] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Can't write device_info to server", (Throwable)e4332);
                    try {
                        blArray[201] = true;
                        j.close();
                        blArray[202] = true;
                    }
                    catch (IOException e4332) {
                        blArray[203] = true;
                        MPLog.e(ViewCrawler.LOGTAG, "Can't close websocket writer", (Throwable)e);
                        blArray[204] = true;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        blArray[205] = true;
                        j.close();
                        blArray[206] = true;
                    }
                    catch (IOException iOException) {
                        void e3;
                        blArray[207] = true;
                        MPLog.e(ViewCrawler.LOGTAG, "Can't close websocket writer", (Throwable)e3);
                        blArray[208] = true;
                    }
                    blArray[209] = true;
                    throw throwable;
                }
            }
            blArray[210] = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendSnapshot(JSONObject jSONObject) {
            void writer;
            void out;
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            long l = System.currentTimeMillis();
            try {
                void payload;
                void message;
                blArray[211] = true;
                JSONObject jSONObject2 = message.getJSONObject("payload");
                blArray[212] = true;
                if (!payload.has("config")) {
                    blArray[213] = true;
                } else {
                    blArray[214] = true;
                    this.mSnapshot = this.mProtocol.readSnapshotConfig((JSONObject)payload);
                    blArray[215] = true;
                    MPLog.v(ViewCrawler.LOGTAG, "Initializing snapshot with configuration");
                    blArray[216] = true;
                }
            }
            catch (JSONException payload) {
                void e;
                blArray[217] = true;
                MPLog.e(ViewCrawler.LOGTAG, "Payload with snapshot config required with snapshot request", (Throwable)e);
                blArray[218] = true;
                this.sendError("Payload with snapshot config required with snapshot request");
                blArray[219] = true;
                return;
            }
            catch (EditProtocol.BadInstructionsException e) {
                blArray[220] = true;
                MPLog.e(ViewCrawler.LOGTAG, "Editor sent malformed message with snapshot request", e);
                blArray[221] = true;
                this.sendError(e.getMessage());
                blArray[222] = true;
                return;
            }
            if (null == this.mSnapshot) {
                blArray[223] = true;
                this.sendError("No snapshot configuration (or a malformed snapshot configuration) was sent.");
                blArray[224] = true;
                MPLog.w(ViewCrawler.LOGTAG, "Mixpanel editor is misconfigured, sent a snapshot request without a valid configuration.");
                blArray[225] = true;
                return;
            }
            BufferedOutputStream e = this.mEditorConnection.getBufferedOutputStream();
            blArray[226] = true;
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)out);
            try {
                void snapshotTime23332;
                void startSnapshot;
                blArray[227] = true;
                writer.write("{");
                blArray[228] = true;
                writer.write("\"type\": \"snapshot_response\",");
                blArray[229] = true;
                writer.write("\"payload\": {");
                blArray[230] = true;
                writer.write("\"activities\":");
                blArray[231] = true;
                writer.flush();
                blArray[232] = true;
                this.mSnapshot.snapshots(ViewCrawler.access$200(this.this$0), (OutputStream)out);
                blArray[233] = true;
                long l2 = System.currentTimeMillis() - startSnapshot;
                blArray[234] = true;
                writer.write(",\"snapshot_time_millis\": ");
                blArray[235] = true;
                writer.write(Long.toString((long)snapshotTime23332));
                blArray[236] = true;
                writer.write("}");
                blArray[237] = true;
                writer.write("}");
                try {
                    blArray[238] = true;
                    writer.close();
                    blArray[239] = true;
                }
                catch (IOException snapshotTime23332) {
                    void e2;
                    blArray[240] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Can't close writer.", (Throwable)e2);
                    blArray[241] = true;
                }
            }
            catch (IOException e2) {
                try {
                    void e5332;
                    blArray[242] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Can't write snapshot request to server", (Throwable)e5332);
                    try {
                        blArray[243] = true;
                        writer.close();
                        blArray[244] = true;
                    }
                    catch (IOException e5332) {
                        void e3;
                        blArray[245] = true;
                        MPLog.e(ViewCrawler.LOGTAG, "Can't close writer.", (Throwable)e3);
                        blArray[246] = true;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        blArray[247] = true;
                        writer.close();
                        blArray[248] = true;
                    }
                    catch (IOException iOException) {
                        void e4;
                        blArray[249] = true;
                        MPLog.e(ViewCrawler.LOGTAG, "Can't close writer.", (Throwable)e4);
                        blArray[250] = true;
                    }
                    blArray[251] = true;
                    throw throwable;
                }
            }
            blArray[252] = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendReportTrackToEditor(String string) {
            void j;
            void writer;
            void out;
            block17: {
                block15: {
                    block16: {
                        block14: {
                            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
                            if (this.mEditorConnection != null) break block14;
                            blArray[253] = true;
                            break block15;
                        }
                        if (this.mEditorConnection.isValid()) break block16;
                        blArray[254] = true;
                        break block15;
                    }
                    if (this.mEditorConnection.isConnected()) break block17;
                    blArray[255] = true;
                }
                blArray[256] = true;
                return;
            }
            BufferedOutputStream bufferedOutputStream = this.mEditorConnection.getBufferedOutputStream();
            blArray[257] = true;
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)out);
            blArray[258] = true;
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            try {
                void eventName;
                blArray[259] = true;
                j.beginObject();
                blArray[260] = true;
                j.name("type").value("track_message");
                blArray[261] = true;
                j.name("payload");
                blArray[262] = true;
                j.beginObject();
                blArray[263] = true;
                j.name("event_name").value((String)eventName);
                blArray[264] = true;
                j.endObject();
                blArray[265] = true;
                j.endObject();
                blArray[266] = true;
                j.flush();
                try {
                    blArray[267] = true;
                    j.close();
                    blArray[268] = true;
                }
                catch (IOException iOException) {
                    void e;
                    blArray[269] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Can't close writer.", (Throwable)e);
                    blArray[270] = true;
                }
            }
            catch (IOException e) {
                try {
                    void e4332;
                    blArray[271] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Can't write track_message to server", (Throwable)e4332);
                    try {
                        blArray[272] = true;
                        j.close();
                        blArray[273] = true;
                    }
                    catch (IOException e4332) {
                        blArray[274] = true;
                        MPLog.e(ViewCrawler.LOGTAG, "Can't close writer.", (Throwable)e);
                        blArray[275] = true;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        blArray[276] = true;
                        j.close();
                        blArray[277] = true;
                    }
                    catch (IOException iOException) {
                        void e3;
                        blArray[278] = true;
                        MPLog.e(ViewCrawler.LOGTAG, "Can't close writer.", (Throwable)e3);
                        blArray[279] = true;
                    }
                    blArray[280] = true;
                    throw throwable;
                }
            }
            blArray[281] = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendLayoutError(ViewVisitor.LayoutErrorMessage layoutErrorMessage) {
            void j;
            void writer;
            void out;
            block17: {
                block15: {
                    block16: {
                        block14: {
                            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
                            if (this.mEditorConnection != null) break block14;
                            blArray[282] = true;
                            break block15;
                        }
                        if (this.mEditorConnection.isValid()) break block16;
                        blArray[283] = true;
                        break block15;
                    }
                    if (this.mEditorConnection.isConnected()) break block17;
                    blArray[284] = true;
                }
                blArray[285] = true;
                return;
            }
            BufferedOutputStream bufferedOutputStream = this.mEditorConnection.getBufferedOutputStream();
            blArray[286] = true;
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)out);
            blArray[287] = true;
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            try {
                void exception;
                blArray[288] = true;
                j.beginObject();
                blArray[289] = true;
                j.name("type").value("layout_error");
                blArray[290] = true;
                j.name("exception_type").value(exception.getErrorType());
                blArray[291] = true;
                j.name("cid").value(exception.getName());
                blArray[292] = true;
                j.endObject();
                try {
                    blArray[293] = true;
                    j.close();
                    blArray[294] = true;
                }
                catch (IOException iOException) {
                    void e;
                    blArray[295] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Can't close writer.", (Throwable)e);
                    blArray[296] = true;
                }
            }
            catch (IOException e) {
                try {
                    void e4332;
                    blArray[297] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Can't write track_message to server", (Throwable)e4332);
                    try {
                        blArray[298] = true;
                        j.close();
                        blArray[299] = true;
                    }
                    catch (IOException e4332) {
                        blArray[300] = true;
                        MPLog.e(ViewCrawler.LOGTAG, "Can't close writer.", (Throwable)e);
                        blArray[301] = true;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        blArray[302] = true;
                        j.close();
                        blArray[303] = true;
                    }
                    catch (IOException iOException) {
                        void e3;
                        blArray[304] = true;
                        MPLog.e(ViewCrawler.LOGTAG, "Can't close writer.", (Throwable)e3);
                        blArray[305] = true;
                    }
                    blArray[306] = true;
                    throw throwable;
                }
            }
            blArray[307] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void handleEditorChangeReceived(JSONObject jSONObject) {
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            try {
                void actions;
                void i;
                void payload;
                void changeMessage;
                JSONObject jSONObject2 = changeMessage.getJSONObject("payload");
                blArray[308] = true;
                JSONArray jSONArray = payload.getJSONArray("actions");
                blArray[309] = true;
                boolean bl = false;
                blArray[310] = true;
                while (i < actions.length()) {
                    void targetActivity;
                    void name;
                    void change;
                    blArray[311] = true;
                    JSONObject jSONObject3 = actions.getJSONObject((int)i);
                    blArray[312] = true;
                    String string = JSONUtils.optionalStringKey((JSONObject)change, "target_activity");
                    blArray[313] = true;
                    String string2 = change.getString("name");
                    blArray[314] = true;
                    this.mEditorChanges.put((String)name, new MPPair<void, void>(targetActivity, change));
                    ++i;
                    blArray[315] = true;
                }
                this.applyVariantsAndEventBindings();
                blArray[316] = true;
            }
            catch (JSONException payload) {
                void e;
                blArray[317] = true;
                MPLog.e(ViewCrawler.LOGTAG, "Bad change request received", (Throwable)e);
                blArray[318] = true;
            }
            blArray[319] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void handleEditorBindingsCleared(JSONObject jSONObject) {
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            try {
                void actions;
                void i;
                void payload;
                void clearMessage;
                JSONObject jSONObject2 = clearMessage.getJSONObject("payload");
                blArray[320] = true;
                JSONArray jSONArray = payload.getJSONArray("actions");
                blArray[321] = true;
                boolean bl = false;
                blArray[322] = true;
                while (i < actions.length()) {
                    void changeId;
                    blArray[323] = true;
                    String string = actions.getString((int)i);
                    blArray[324] = true;
                    this.mEditorChanges.remove(changeId);
                    ++i;
                    blArray[325] = true;
                }
                blArray[326] = true;
            }
            catch (JSONException payload) {
                void e;
                blArray[327] = true;
                MPLog.e(ViewCrawler.LOGTAG, "Bad clear request received", (Throwable)e);
                blArray[328] = true;
            }
            this.applyVariantsAndEventBindings();
            blArray[329] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void handleEditorTweaksReceived(JSONObject jSONObject) {
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            try {
                void i;
                void tweaks;
                void payload;
                void tweaksMessage;
                JSONObject jSONObject2 = tweaksMessage.getJSONObject("payload");
                blArray[330] = true;
                JSONArray jSONArray = payload.getJSONArray("tweaks");
                blArray[331] = true;
                int length = tweaks.length();
                boolean bl = false;
                blArray[332] = true;
                while (i < length) {
                    void tweak;
                    void tweakDesc;
                    blArray[333] = true;
                    JSONObject jSONObject3 = tweaks.getJSONObject((int)i);
                    blArray[334] = true;
                    MPPair<String, Object> mPPair = this.mProtocol.readTweak((JSONObject)tweakDesc);
                    blArray[335] = true;
                    this.mEditorTweaks.put((String)tweak.first, (MPPair<String, Object>)tweak);
                    ++i;
                    blArray[336] = true;
                }
                blArray[337] = true;
            }
            catch (JSONException payload) {
                void e;
                blArray[338] = true;
                MPLog.e(ViewCrawler.LOGTAG, "Bad tweaks received", (Throwable)e);
                blArray[339] = true;
            }
            catch (EditProtocol.BadInstructionsException e) {
                blArray[340] = true;
                MPLog.e(ViewCrawler.LOGTAG, "Bad tweaks received", e);
                blArray[341] = true;
            }
            this.applyVariantsAndEventBindings();
            blArray[342] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void handleVariantsReceived(JSONArray jSONArray) {
            void variants;
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            this.persistVariants((JSONArray)variants);
            blArray[343] = true;
            this.loadVariants(variants.toString(), true);
            blArray[344] = true;
            this.applyVariantsAndEventBindings();
            blArray[345] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void handleEventBindingsReceived(JSONArray jSONArray) {
            void eventBindings;
            void editor;
            void preferences;
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            SharedPreferences sharedPreferences = this.getSharedPreferences();
            blArray[346] = true;
            SharedPreferences.Editor editor2 = preferences.edit();
            blArray[347] = true;
            editor.putString(ViewCrawler.SHARED_PREF_BINDINGS_KEY, eventBindings.toString());
            blArray[348] = true;
            editor.apply();
            blArray[349] = true;
            this.loadEventBindings(eventBindings.toString());
            blArray[350] = true;
            this.applyVariantsAndEventBindings();
            blArray[351] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void handleEditorBindingsReceived(JSONObject jSONObject) {
            void eventCount;
            void i;
            JSONObject eventBinding;
            JSONArray eventBindings;
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            try {
                void payload;
                void message;
                JSONObject jSONObject2 = message.getJSONObject("payload");
                blArray[352] = true;
                eventBindings = payload.getJSONArray("events");
            }
            catch (JSONException payload) {
                void e;
                blArray[353] = true;
                MPLog.e(ViewCrawler.LOGTAG, "Bad event bindings received", (Throwable)e);
                blArray[354] = true;
                return;
            }
            int e = eventBindings.length();
            blArray[355] = true;
            this.mEditorEventBindings.clear();
            blArray[356] = true;
            if (this.mPersistentEventBindings.isEmpty()) {
                blArray[357] = true;
            } else if (!this.mOriginalEventBindings.isEmpty()) {
                blArray[358] = true;
            } else {
                blArray[359] = true;
                this.mOriginalEventBindings.addAll(this.mPersistentEventBindings);
                blArray[360] = true;
                Iterator<MPPair<String, JSONObject>> iterator = this.mPersistentEventBindings.iterator();
                blArray[361] = true;
                while (iterator.hasNext()) {
                    MPPair<String, JSONObject> mPPair = iterator.next();
                    try {
                        blArray[362] = true;
                        this.mEditorEventBindings.put(((JSONObject)eventBinding.second).get("path").toString(), (MPPair<String, JSONObject>)eventBinding);
                        blArray[363] = true;
                    }
                    catch (JSONException jSONException) {
                        void e2;
                        blArray[364] = true;
                        e2.printStackTrace();
                        blArray[365] = true;
                    }
                    blArray[366] = true;
                }
                this.mPersistentEventBindings.clear();
                blArray[367] = true;
            }
            boolean bl = false;
            blArray[368] = true;
            while (i < eventCount) {
                try {
                    void targetActivity;
                    void event;
                    blArray[369] = true;
                    eventBinding = eventBindings.getJSONObject((int)i);
                    blArray[370] = true;
                    String e2 = JSONUtils.optionalStringKey((JSONObject)event, "target_activity");
                    blArray[371] = true;
                    this.mEditorEventBindings.put(event.get("path").toString(), new MPPair<void, void>(targetActivity, event));
                    blArray[372] = true;
                }
                catch (JSONException event) {
                    void e3;
                    blArray[373] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Bad event binding received from editor in " + eventBindings.toString(), (Throwable)e3);
                    blArray[374] = true;
                }
                ++i;
                blArray[375] = true;
            }
            this.applyVariantsAndEventBindings();
            blArray[376] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void handleEditorClosed() {
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            this.mEditorChanges.clear();
            blArray[377] = true;
            this.mEditorEventBindings.clear();
            blArray[378] = true;
            this.mEditorTweaks.clear();
            blArray[379] = true;
            this.mPersistentEventBindings.addAll(this.mOriginalEventBindings);
            blArray[380] = true;
            this.mOriginalEventBindings.clear();
            this.mSnapshot = null;
            blArray[381] = true;
            MPLog.v(ViewCrawler.LOGTAG, "Editor closed- freeing snapshot");
            blArray[382] = true;
            this.applyVariantsAndEventBindings();
            blArray[383] = true;
            Iterator<String> iterator = this.mEditorAssetUrls.iterator();
            blArray[384] = true;
            while (iterator.hasNext()) {
                void assetUrl;
                String string = iterator.next();
                blArray[385] = true;
                this.mImageStore.deleteStorage((String)assetUrl);
                blArray[386] = true;
            }
            blArray[387] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void applyVariantsAndEventBindings() {
            OnMixpanelTweaksUpdatedListener emptyExperiment;
            MPPair<Integer, Integer> next;
            void editMap;
            void i;
            void visitor3;
            MPPair<String, Object> tweak;
            MPPair tweakValue;
            EditProtocol.Edit tweak2;
            Object tweakDefaults;
            Tweaks.TweakValue notDeclaredTweak;
            void updatedTweaks;
            Object e;
            Object tweakInfo;
            void toTrack;
            void edit3;
            void newVisitors;
            Object changeInfo;
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            ArrayList arrayList = new ArrayList();
            blArray[388] = true;
            HashSet hashSet = new HashSet();
            blArray[389] = true;
            HashSet hashSet2 = new HashSet();
            blArray[390] = true;
            Object object = this.mAppliedVisualChanges.iterator();
            blArray[391] = true;
            while (object.hasNext()) {
                VariantChange variantChange = object.next();
                try {
                    blArray[392] = true;
                    EditProtocol.Edit edit2 = this.mProtocol.readEdit(((VariantChange)changeInfo).change);
                    blArray[393] = true;
                    newVisitors.add(new MPPair<String, ViewVisitor>(((VariantChange)changeInfo).activityName, edit3.visitor));
                    blArray[394] = true;
                    if (this.mSeenExperiments.contains(((VariantChange)changeInfo).variantId)) {
                        blArray[395] = true;
                    } else {
                        blArray[396] = true;
                        toTrack.add(((VariantChange)changeInfo).variantId);
                        blArray[397] = true;
                    }
                    blArray[398] = true;
                }
                catch (EditProtocol.CantGetEditAssetsException edit3) {
                    void e2;
                    blArray[399] = true;
                    MPLog.v(ViewCrawler.LOGTAG, "Can't load assets for an edit, won't apply the change now", (Throwable)e2);
                    blArray[400] = true;
                }
                catch (EditProtocol.InapplicableInstructionsException e2) {
                    blArray[401] = true;
                    MPLog.i(ViewCrawler.LOGTAG, e2.getMessage());
                    blArray[402] = true;
                }
                catch (EditProtocol.BadInstructionsException e3) {
                    blArray[403] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Bad persistent change request cannot be applied.", e3);
                    blArray[404] = true;
                }
                blArray[405] = true;
            }
            object = this.mAppliedTweaks.iterator();
            blArray[406] = true;
            while (object.hasNext()) {
                changeInfo = (VariantTweak)object.next();
                try {
                    void tweakValue2;
                    blArray[407] = true;
                    e = this.mProtocol.readTweak(((VariantTweak)tweakInfo).tweak);
                    blArray[408] = true;
                    if (!this.mSeenExperiments.contains(((VariantTweak)tweakInfo).variantId)) {
                        blArray[409] = true;
                        toTrack.add(((VariantTweak)tweakInfo).variantId);
                        blArray[410] = true;
                        updatedTweaks.add(tweakValue2.first);
                        blArray[411] = true;
                    } else if (!ViewCrawler.access$800(this.this$0).isNewValue((String)tweakValue2.first, tweakValue2.second)) {
                        blArray[412] = true;
                    } else {
                        blArray[413] = true;
                        updatedTweaks.add(tweakValue2.first);
                        blArray[414] = true;
                    }
                    if (!ViewCrawler.access$800(this.this$0).getAllValues().containsKey(tweakValue2.first)) {
                        blArray[415] = true;
                        Tweaks.TweakValue tweakValue3 = Tweaks.TweakValue.fromJson(((VariantTweak)tweakInfo).tweak);
                        blArray[416] = true;
                        ViewCrawler.access$800(this.this$0).addUndeclaredTweak((String)tweakValue2.first, notDeclaredTweak);
                        blArray[417] = true;
                    } else {
                        ViewCrawler.access$800(this.this$0).set((String)tweakValue2.first, tweakValue2.second);
                        blArray[418] = true;
                    }
                    blArray[419] = true;
                }
                catch (EditProtocol.BadInstructionsException tweakValue2) {
                    void e4;
                    blArray[420] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Bad editor tweak cannot be applied.", (Throwable)e4);
                    blArray[421] = true;
                }
                blArray[422] = true;
            }
            if (this.mAppliedTweaks.size() != 0) {
                blArray[423] = true;
            } else {
                blArray[424] = true;
                object = ViewCrawler.access$800(this.this$0).getDefaultValues();
                blArray[425] = true;
                tweakInfo = tweakDefaults.entrySet().iterator();
                blArray[426] = true;
                while (true) {
                    void tweakName;
                    if (!tweakInfo.hasNext()) {
                        blArray[427] = true;
                        break;
                    }
                    e = (Map.Entry)tweakInfo.next();
                    blArray[428] = true;
                    notDeclaredTweak = (Tweaks.TweakValue)tweak2.getValue();
                    blArray[429] = true;
                    String string = (String)tweak2.getKey();
                    blArray[430] = true;
                    if (!ViewCrawler.access$800(this.this$0).isNewValue((String)tweakName, ((Tweaks.TweakValue)((Object)tweakValue)).getValue())) {
                        blArray[431] = true;
                    } else {
                        blArray[432] = true;
                        ViewCrawler.access$800(this.this$0).set((String)tweakName, ((Tweaks.TweakValue)((Object)tweakValue)).getValue());
                        blArray[433] = true;
                        updatedTweaks.add(tweakName);
                        blArray[434] = true;
                    }
                    blArray[435] = true;
                }
            }
            tweakDefaults = this.mEditorChanges.values().iterator();
            blArray[436] = true;
            while (tweakDefaults.hasNext()) {
                tweakInfo = tweakDefaults.next();
                try {
                    blArray[437] = true;
                    tweak2 = this.mProtocol.readEdit((JSONObject)((MPPair)((Object)changeInfo)).second);
                    blArray[438] = true;
                    newVisitors.add(new MPPair<Object, ViewVisitor>(((MPPair)((Object)changeInfo)).first, edit3.visitor));
                    blArray[439] = true;
                    this.mEditorAssetUrls.addAll(edit3.imageUrls);
                    blArray[440] = true;
                }
                catch (EditProtocol.CantGetEditAssetsException edit4) {
                    void e5;
                    blArray[441] = true;
                    MPLog.v(ViewCrawler.LOGTAG, "Can't load assets for an edit, won't apply the change now", (Throwable)e5);
                    blArray[442] = true;
                }
                catch (EditProtocol.InapplicableInstructionsException e5) {
                    blArray[443] = true;
                    MPLog.i(ViewCrawler.LOGTAG, e5.getMessage());
                    blArray[444] = true;
                }
                catch (EditProtocol.BadInstructionsException e6) {
                    blArray[445] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Bad editor change request cannot be applied.", e6);
                    blArray[446] = true;
                }
                blArray[447] = true;
            }
            tweakDefaults = this.mEditorTweaks.values().iterator();
            blArray[448] = true;
            while (tweakDefaults.hasNext()) {
                changeInfo = tweakDefaults.next();
                blArray[449] = true;
                if (!ViewCrawler.access$800(this.this$0).isNewValue((String)tweak.first, tweak.second)) {
                    blArray[450] = true;
                } else {
                    blArray[451] = true;
                    updatedTweaks.add(tweak.first);
                    blArray[452] = true;
                }
                ViewCrawler.access$800(this.this$0).set((String)tweak.first, tweak.second);
                blArray[453] = true;
            }
            if (this.mEditorEventBindings.size() != 0) {
                blArray[454] = true;
            } else if (this.mOriginalEventBindings.size() != 0) {
                blArray[455] = true;
            } else {
                blArray[456] = true;
                tweakDefaults = this.mPersistentEventBindings.iterator();
                blArray[457] = true;
                while (true) {
                    if (!tweakDefaults.hasNext()) {
                        blArray[458] = true;
                        break;
                    }
                    tweak = tweakDefaults.next();
                    try {
                        blArray[459] = true;
                        e = this.mProtocol.readEventBinding((JSONObject)((MPPair)((Object)changeInfo)).second, ViewCrawler.access$900(this.this$0));
                        blArray[460] = true;
                        newVisitors.add(new MPPair<Object, void>(((MPPair)((Object)changeInfo)).first, visitor3));
                        blArray[461] = true;
                    }
                    catch (EditProtocol.InapplicableInstructionsException visitor2) {
                        void e7;
                        blArray[462] = true;
                        MPLog.i(ViewCrawler.LOGTAG, e7.getMessage());
                        blArray[463] = true;
                    }
                    catch (EditProtocol.BadInstructionsException e7) {
                        blArray[464] = true;
                        MPLog.e(ViewCrawler.LOGTAG, "Bad persistent event binding cannot be applied.", e7);
                        blArray[465] = true;
                    }
                    blArray[466] = true;
                }
            }
            tweakDefaults = this.mEditorEventBindings.values().iterator();
            blArray[467] = true;
            while (tweakDefaults.hasNext()) {
                changeInfo = tweakDefaults.next();
                try {
                    blArray[468] = true;
                    e = this.mProtocol.readEventBinding((JSONObject)((MPPair)((Object)changeInfo)).second, ViewCrawler.access$900(this.this$0));
                    blArray[469] = true;
                    newVisitors.add(new MPPair<Object, void>(((MPPair)((Object)changeInfo)).first, visitor3));
                    blArray[470] = true;
                }
                catch (EditProtocol.InapplicableInstructionsException visitor3) {
                    void e8;
                    blArray[471] = true;
                    MPLog.i(ViewCrawler.LOGTAG, e8.getMessage());
                    blArray[472] = true;
                }
                catch (EditProtocol.BadInstructionsException e8) {
                    blArray[473] = true;
                    MPLog.e(ViewCrawler.LOGTAG, "Bad editor event binding cannot be applied.", e8);
                    blArray[474] = true;
                }
                blArray[475] = true;
            }
            tweakDefaults = new HashMap();
            blArray[476] = true;
            int totalEdits = newVisitors.size();
            boolean e9 = false;
            blArray[477] = true;
            while (i < totalEdits) {
                List<Object> mapElement;
                blArray[478] = true;
                tweakValue = (MPPair)((Object)newVisitors.get((int)i));
                blArray[479] = true;
                if (editMap.containsKey(next.first)) {
                    blArray[480] = true;
                    mapElement = (List)editMap.get(next.first);
                    blArray[481] = true;
                } else {
                    mapElement = new ArrayList();
                    blArray[482] = true;
                    editMap.put(next.first, mapElement);
                    blArray[483] = true;
                }
                mapElement.add(next.second);
                ++i;
                blArray[484] = true;
            }
            ViewCrawler.access$200(this.this$0).setEdits((Map<String, List<ViewVisitor>>)editMap);
            blArray[485] = true;
            Iterator<MPPair<Integer, Integer>> iterator = this.mEmptyExperiments.iterator();
            blArray[486] = true;
            while (iterator.hasNext()) {
                next = iterator.next();
                blArray[487] = true;
                if (this.mSeenExperiments.contains(emptyExperiment)) {
                    blArray[488] = true;
                } else {
                    blArray[489] = true;
                    toTrack.add(emptyExperiment);
                    blArray[490] = true;
                }
                blArray[491] = true;
            }
            this.mSeenExperiments.addAll((Collection<MPPair<Integer, Integer>>)toTrack);
            blArray[492] = true;
            this.trackSeenExperiments((Set<MPPair<Integer, Integer>>)toTrack);
            blArray[493] = true;
            this.mEmptyExperiments.clear();
            blArray[494] = true;
            if (updatedTweaks.size() <= 0) {
                blArray[495] = true;
            } else {
                blArray[496] = true;
                iterator = ViewCrawler.access$1000(this.this$0).iterator();
                blArray[497] = true;
                while (true) {
                    void listener;
                    if (!iterator.hasNext()) {
                        blArray[498] = true;
                        break;
                    }
                    emptyExperiment = (OnMixpanelTweaksUpdatedListener)((Object)iterator.next());
                    blArray[499] = true;
                    listener.onMixpanelTweakUpdated((Set<String>)updatedTweaks);
                    blArray[500] = true;
                }
            }
            blArray[501] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void trackSeenExperiments(Set<MPPair<Integer, Integer>> set) {
            void toTrack;
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            if (toTrack == null) {
                blArray[502] = true;
            } else if (toTrack.size() <= 0) {
                blArray[503] = true;
            } else {
                blArray[504] = true;
                JSONObject jSONObject = new JSONObject();
                try {
                    blArray[505] = true;
                    Iterator iterator = toTrack.iterator();
                    blArray[506] = true;
                    while (iterator.hasNext()) {
                        void variantObject;
                        void variantId;
                        void experimentId;
                        void trackProps;
                        void variant;
                        MPPair mPPair = (MPPair)((Object)iterator.next());
                        blArray[507] = true;
                        int n = (Integer)variant.first;
                        blArray[508] = true;
                        int n2 = (Integer)variant.second;
                        blArray[509] = true;
                        JSONObject jSONObject2 = new JSONObject();
                        blArray[510] = true;
                        trackProps.put("$experiment_id", (int)experimentId);
                        blArray[511] = true;
                        trackProps.put("$variant_id", (int)variantId);
                        blArray[512] = true;
                        variantObject.put(Integer.toString((int)experimentId), (int)variantId);
                        blArray[513] = true;
                        ViewCrawler.access$100(this.this$0).getPeople().merge("$experiments", (JSONObject)variantObject);
                        blArray[514] = true;
                        ViewCrawler.access$100(this.this$0).updateSuperProperties(new SuperPropertyUpdate(this, (JSONObject)variantObject){
                            final /* synthetic */ JSONObject val$variantObject;
                            final /* synthetic */ ViewCrawlerHandler this$1;
                            private static transient /* synthetic */ boolean[] $jacocoData;
                            {
                                void this$1;
                                boolean[] blArray = 1.$jacocoInit();
                                this.this$1 = this$1;
                                this.val$variantObject = jSONObject;
                                blArray[0] = true;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public JSONObject update(JSONObject jSONObject) {
                                void in;
                                boolean[] blArray = 1.$jacocoInit();
                                try {
                                    in.put("$experiments", (Object)this.val$variantObject);
                                    blArray[1] = true;
                                }
                                catch (JSONException jSONException) {
                                    void e;
                                    blArray[2] = true;
                                    MPLog.wtf(ViewCrawler.LOGTAG, "Can't write $experiments super property", (Throwable)e);
                                    blArray[3] = true;
                                }
                                blArray[4] = true;
                                return in;
                            }

                            private static /* synthetic */ boolean[] $jacocoInit() {
                                boolean[] blArray = $jacocoData;
                                if ($jacocoData == null) {
                                    blArray = $jacocoData = Offline.getProbes((long)-2212005645785093939L, (String)"com/mixpanel/android/viewcrawler/ViewCrawler$ViewCrawlerHandler$1", (int)5);
                                }
                                return blArray;
                            }
                        });
                        blArray[515] = true;
                        ViewCrawler.access$100(this.this$0).track("$experiment_started", (JSONObject)trackProps);
                        blArray[516] = true;
                    }
                    blArray[517] = true;
                }
                catch (JSONException jSONException) {
                    void e;
                    blArray[518] = true;
                    MPLog.wtf(ViewCrawler.LOGTAG, "Could not build JSON for reporting experiment start", (Throwable)e);
                    blArray[519] = true;
                }
            }
            blArray[520] = true;
        }

        /*
         * WARNING - void declaration
         */
        private SharedPreferences getSharedPreferences() {
            void sharedPrefsName;
            boolean[] blArray = ViewCrawlerHandler.$jacocoInit();
            String string = "mixpanel.viewcrawler.changes" + this.mToken;
            blArray[521] = true;
            blArray[522] = true;
            return ViewCrawler.access$400(this.this$0).getSharedPreferences((String)sharedPrefsName, 0);
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)6515396852626674546L, (String)"com/mixpanel/android/viewcrawler/ViewCrawler$ViewCrawlerHandler", (int)523);
            }
            return blArray;
        }
    }

    private class LifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks,
    FlipGesture.OnFlipGestureListener {
        private final FlipGesture mFlipGesture;
        private final EmulatorConnector mEmulatorConnector;
        final /* synthetic */ ViewCrawler this$0;
        private static transient /* synthetic */ boolean[] $jacocoData;

        public LifecycleCallbacks(ViewCrawler viewCrawler) {
            boolean[] blArray = LifecycleCallbacks.$jacocoInit();
            this.this$0 = viewCrawler;
            blArray[0] = true;
            this.mFlipGesture = new FlipGesture(this);
            blArray[1] = true;
            this.mEmulatorConnector = new EmulatorConnector(viewCrawler);
            blArray[2] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onFlipGesture() {
            void message;
            boolean[] blArray = LifecycleCallbacks.$jacocoInit();
            ViewCrawler.access$100(this.this$0).track("$ab_gesture3");
            blArray[3] = true;
            Message message2 = ViewCrawler.access$000(this.this$0).obtainMessage(1);
            blArray[4] = true;
            ViewCrawler.access$000(this.this$0).sendMessage((Message)message);
            blArray[5] = true;
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
            boolean[] blArray = LifecycleCallbacks.$jacocoInit();
            blArray[6] = true;
        }

        public void onActivityStarted(Activity activity) {
            boolean[] blArray = LifecycleCallbacks.$jacocoInit();
            blArray[7] = true;
        }

        /*
         * WARNING - void declaration
         */
        public void onActivityResumed(Activity activity) {
            void activity2;
            boolean[] blArray = LifecycleCallbacks.$jacocoInit();
            this.installConnectionSensor((Activity)activity2);
            blArray[8] = true;
            ViewCrawler.access$200(this.this$0).add((Activity)activity2);
            blArray[9] = true;
        }

        /*
         * WARNING - void declaration
         */
        public void onActivityPaused(Activity activity) {
            void activity2;
            boolean[] blArray = LifecycleCallbacks.$jacocoInit();
            ViewCrawler.access$200(this.this$0).remove((Activity)activity2);
            blArray[10] = true;
            this.uninstallConnectionSensor((Activity)activity2);
            blArray[11] = true;
        }

        public void onActivityStopped(Activity activity) {
            boolean[] blArray = LifecycleCallbacks.$jacocoInit();
            blArray[12] = true;
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            boolean[] blArray = LifecycleCallbacks.$jacocoInit();
            blArray[13] = true;
        }

        public void onActivityDestroyed(Activity activity) {
            boolean[] blArray = LifecycleCallbacks.$jacocoInit();
            blArray[14] = true;
        }

        /*
         * Unable to fully structure code
         */
        private void installConnectionSensor(Activity var1_1) {
            block4: {
                var2_2 = LifecycleCallbacks.$jacocoInit();
                if (this.isInEmulator()) break block4;
                var2_2[15] = true;
                ** GOTO lbl12
            }
            if (!ViewCrawler.access$300(this.this$0).getDisableEmulatorBindingUI()) {
                var2_2[17] = true;
                this.mEmulatorConnector.start();
                var2_2[18] = true;
            } else {
                var2_2[16] = true;
lbl12:
                // 2 sources

                if (ViewCrawler.access$300(this.this$0).getDisableGestureBindingUI()) {
                    var2_2[19] = true;
                } else {
                    var2_2[20] = true;
                    var3_3 = (SensorManager)activity.getSystemService("sensor");
                    var2_2[21] = true;
                    var4_4 = sensorManager.getDefaultSensor(1);
                    var2_2[22] = true;
                    sensorManager.registerListener((SensorEventListener)this.mFlipGesture, (Sensor)accelerometer, 3);
                    var2_2[23] = true;
                }
            }
            var2_2[24] = true;
        }

        /*
         * Unable to fully structure code
         */
        private void uninstallConnectionSensor(Activity var1_1) {
            block4: {
                var2_2 = LifecycleCallbacks.$jacocoInit();
                if (this.isInEmulator()) break block4;
                var2_2[25] = true;
                ** GOTO lbl12
            }
            if (!ViewCrawler.access$300(this.this$0).getDisableEmulatorBindingUI()) {
                var2_2[27] = true;
                this.mEmulatorConnector.stop();
                var2_2[28] = true;
            } else {
                var2_2[26] = true;
lbl12:
                // 2 sources

                if (ViewCrawler.access$300(this.this$0).getDisableGestureBindingUI()) {
                    var2_2[29] = true;
                } else {
                    var2_2[30] = true;
                    var3_3 = (SensorManager)activity.getSystemService("sensor");
                    var2_2[31] = true;
                    sensorManager.unregisterListener((SensorEventListener)this.mFlipGesture);
                    var2_2[32] = true;
                }
            }
            var2_2[33] = true;
        }

        private boolean isInEmulator() {
            boolean[] blArray = LifecycleCallbacks.$jacocoInit();
            if (Build.HARDWARE.toLowerCase().equals("goldfish")) {
                blArray[34] = true;
            } else if (Build.HARDWARE.toLowerCase().equals("ranchu")) {
                blArray[35] = true;
            } else {
                blArray[36] = true;
                return false;
            }
            if (Build.BRAND.toLowerCase().startsWith("generic")) {
                blArray[37] = true;
            } else if (Build.BRAND.toLowerCase().equals("android")) {
                blArray[38] = true;
            } else if (Build.BRAND.toLowerCase().equals("google")) {
                blArray[39] = true;
            } else {
                blArray[40] = true;
                return false;
            }
            if (!Build.DEVICE.toLowerCase().startsWith("generic")) {
                blArray[41] = true;
                return false;
            }
            if (!Build.PRODUCT.toLowerCase().contains("sdk")) {
                blArray[42] = true;
                return false;
            }
            if (!Build.MODEL.toLowerCase(Locale.US).contains("sdk")) {
                blArray[43] = true;
                return false;
            }
            blArray[44] = true;
            return true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)1831542109464556783L, (String)"com/mixpanel/android/viewcrawler/ViewCrawler$LifecycleCallbacks", (int)45);
            }
            return blArray;
        }
    }

    private class EmulatorConnector
    implements Runnable {
        private volatile boolean mStopped;
        final /* synthetic */ ViewCrawler this$0;
        private static transient /* synthetic */ boolean[] $jacocoData;

        public EmulatorConnector(ViewCrawler viewCrawler) {
            boolean[] blArray = EmulatorConnector.$jacocoInit();
            this.this$0 = viewCrawler;
            this.mStopped = true;
            blArray[0] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            boolean[] blArray = EmulatorConnector.$jacocoInit();
            if (this.mStopped) {
                blArray[1] = true;
            } else {
                void message;
                blArray[2] = true;
                Message message2 = ViewCrawler.access$000(this.this$0).obtainMessage(1);
                blArray[3] = true;
                ViewCrawler.access$000(this.this$0).sendMessage((Message)message);
                blArray[4] = true;
            }
            ViewCrawler.access$000(this.this$0).postDelayed(this, 30000L);
            blArray[5] = true;
        }

        public void start() {
            boolean[] blArray = EmulatorConnector.$jacocoInit();
            this.mStopped = false;
            blArray[6] = true;
            ViewCrawler.access$000(this.this$0).post(this);
            blArray[7] = true;
        }

        public void stop() {
            boolean[] blArray = EmulatorConnector.$jacocoInit();
            this.mStopped = true;
            blArray[8] = true;
            ViewCrawler.access$000(this.this$0).removeCallbacks(this);
            blArray[9] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-6363181545461580193L, (String)"com/mixpanel/android/viewcrawler/ViewCrawler$EmulatorConnector", (int)10);
            }
            return blArray;
        }
    }
}

